/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.viewer.datamodel;

import org.openscience.jmol.viewer.JmolViewer;
import org.openscience.jmol.viewer.datamodel.Atom;

public class Bond {
    public Atom atom1;
    public Atom atom2;
    short order;
    short mad;
    short colix;

    Bond(Atom atom1, Atom atom2, int order, short mad, short colix) {
        if (atom1 == null) {
            throw new NullPointerException();
        }
        if (atom2 == null) {
            throw new NullPointerException();
        }
        this.atom1 = atom1;
        this.atom2 = atom2;
        if (atom1.elementNumber == 16 && atom2.elementNumber == 16) {
            order |= 0x20;
        }
        if (order == 4) {
            order = 5;
        }
        this.order = (short)order;
        this.mad = mad;
        this.colix = colix;
    }

    Bond(Atom atom1, Atom atom2, int order, JmolViewer viewer) {
        this(atom1, atom2, order, viewer.getMadBond(), viewer.getColixBond(order));
    }

    boolean isCovalent() {
        return (this.order & 3) != 0;
    }

    boolean isStereo() {
        return (this.order & 0x18) != 0;
    }

    boolean isAromatic() {
        return (this.order & 4) != 0;
    }

    void deleteAtomReferences() {
        if (this.atom1 != null) {
            this.atom1.deleteBond(this);
        }
        if (this.atom2 != null) {
            this.atom2.deleteBond(this);
        }
        this.atom2 = null;
        this.atom1 = null;
    }

    void setMad(short mad) {
        this.mad = mad;
    }

    void setColix(short colix) {
        this.colix = colix;
    }

    public float getRadius() {
        return (float)this.mad / 2000.0f;
    }

    public short getOrder() {
        return this.order;
    }

    public short getColix1() {
        return this.colix != 0 ? this.colix : this.atom1.colixAtom;
    }

    public short getColix2() {
        return this.colix != 0 ? this.colix : this.atom2.colixAtom;
    }
}

