/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.viewer.datamodel;

import javax.vecmath.Point3i;
import org.openscience.jmol.viewer.datamodel.Axes;
import org.openscience.jmol.viewer.datamodel.ShapeRenderer;

class AxesRenderer
extends ShapeRenderer {
    String[] axisLabels = new String[]{"+X", "+Y", "+Z", null, null, null};
    final Point3i[] axisScreens = new Point3i[6];
    final Point3i originScreen;

    AxesRenderer() {
        int i = 6;
        while (--i >= 0) {
            this.axisScreens[i] = new Point3i();
        }
        this.originScreen = new Point3i();
    }

    void render() {
        Axes axes = (Axes)this.shape;
        short mad = axes.mad;
        if (mad == 0) {
            return;
        }
        this.viewer.transformPoint(axes.originPoint, this.originScreen);
        int i = 6;
        while (--i >= 0) {
            this.viewer.transformPoint(axes.axisPoints[i], this.axisScreens[i]);
        }
        short widthPixels = mad;
        if (mad >= 20) {
            widthPixels = this.viewer.scaleToScreen(this.originScreen.z, mad);
        }
        short colix = axes.colix;
        int i2 = 6;
        while (--i2 >= 0) {
            String label;
            if (mad < 0) {
                this.g3d.drawDottedLine(colix, this.originScreen, this.axisScreens[i2]);
            } else {
                this.g3d.fillCylinder(colix, (byte)2, widthPixels, this.originScreen, this.axisScreens[i2]);
            }
            if ((label = this.axisLabels[i2]) == null) continue;
            this.frameRenderer.renderStringOutside(label, colix, axes.font3d, this.axisScreens[i2], this.g3d);
        }
    }
}

