/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.viewer.datamodel;

import java.util.Hashtable;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Xyzd;
import org.openscience.jmol.viewer.JmolConstants;
import org.openscience.jmol.viewer.JmolViewer;
import org.openscience.jmol.viewer.Util;
import org.openscience.jmol.viewer.datamodel.Bond;
import org.openscience.jmol.viewer.datamodel.Bspt;
import org.openscience.jmol.viewer.datamodel.Chain;
import org.openscience.jmol.viewer.datamodel.Group;
import org.openscience.jmol.viewer.datamodel.Model;

public final class Atom
implements Bspt.Tuple {
    static final byte VISIBLE_FLAG = 1;
    Group group;
    public int atomIndex;
    public short modelIndex;
    public Point3f point3f;
    long xyzd;
    public byte elementNumber;
    byte formalChargeAndFlags;
    byte occupancy;
    Vector3f vibrationVector;
    short bfactor100;
    short madAtom;
    short colixAtom;
    Bond[] bonds;
    boolean isHetero;
    int atomSerial;
    public String atomName;
    byte specialAtomID;
    float partialCharge;
    static final int MIN_Z = 100;
    static final int MAX_Z = 14383;
    private static Hashtable htAtom = new Hashtable();

    Atom(JmolViewer viewer, int modelIndex, int atomIndex, byte elementNumber, String atomName, int formalCharge, float partialCharge, int occupancy, float bfactor, float x, float y, float z, boolean isHetero, int atomSerial, char chainID, float vibrationX, float vibrationY, float vibrationZ) {
        this.modelIndex = (short)modelIndex;
        this.atomIndex = atomIndex;
        this.elementNumber = elementNumber;
        if (formalCharge == Integer.MIN_VALUE) {
            formalCharge = 0;
        }
        this.formalChargeAndFlags = (byte)(formalCharge << 4);
        this.partialCharge = partialCharge;
        this.occupancy = (byte)(occupancy < 0 ? 0 : (byte)(occupancy > 100 ? 100 : (byte)occupancy));
        this.bfactor100 = (short)(Float.isNaN(bfactor) ? Short.MIN_VALUE : (short)(bfactor * 100.0f));
        this.atomSerial = atomSerial;
        this.atomName = atomName == null ? null : atomName.intern();
        this.specialAtomID = this.lookupSpecialAtomID(atomName);
        this.colixAtom = viewer.getColixAtom(this);
        this.setMadAtom(viewer.getMadAtom());
        this.point3f = new Point3f(x, y, z);
        this.isHetero = isHetero;
        if (!(Float.isNaN(vibrationX) || Float.isNaN(vibrationY) || Float.isNaN(vibrationZ))) {
            this.vibrationVector = new Vector3f(vibrationX, vibrationY, vibrationZ);
        }
    }

    void setGroup(Group group) {
        this.group = group;
    }

    boolean isBonded(Atom atomOther) {
        if (this.bonds != null) {
            int i = this.bonds.length;
            while (--i >= 0) {
                Bond bond = this.bonds[i];
                if (bond.atom1 != atomOther && bond.atom2 != atomOther) continue;
                return true;
            }
        }
        return false;
    }

    Bond bondMutually(Atom atomOther, int order, JmolViewer viewer) {
        if (this.isBonded(atomOther)) {
            return null;
        }
        Bond bond = new Bond(this, atomOther, order, viewer);
        this.addBond(bond);
        atomOther.addBond(bond);
        return bond;
    }

    private void addBond(Bond bond) {
        int i = 0;
        if (this.bonds == null) {
            this.bonds = new Bond[1];
        } else {
            i = this.bonds.length;
            this.bonds = (Bond[])Util.setLength(this.bonds, i + 1);
        }
        this.bonds[i] = bond;
    }

    void deleteBondedAtom(Atom atomToDelete) {
        if (this.bonds == null) {
            return;
        }
        int i = this.bonds.length;
        while (--i >= 0) {
            Bond bond = this.bonds[i];
            Atom atomBonded = bond.atom1 != this ? bond.atom1 : bond.atom2;
            if (atomBonded != atomToDelete) continue;
            this.deleteBond(i);
            return;
        }
    }

    void deleteAllBonds() {
        if (this.bonds == null) {
            return;
        }
        int i = this.bonds.length;
        while (--i >= 0) {
            this.group.chain.frame.deleteBond(this.bonds[i]);
        }
        if (this.bonds != null) {
            System.out.println("bond delete error");
            throw new NullPointerException();
        }
    }

    void deleteBond(Bond bond) {
        int i = this.bonds.length;
        while (--i >= 0) {
            if (this.bonds[i] != bond) continue;
            this.deleteBond(i);
            return;
        }
    }

    void deleteBond(int i) {
        int j;
        int newLength = this.bonds.length - 1;
        if (newLength == 0) {
            this.bonds = null;
            return;
        }
        Bond[] bondsNew = new Bond[newLength];
        for (j = 0; j < i; ++j) {
            bondsNew[j] = this.bonds[j];
        }
        while (j < newLength) {
            bondsNew[j] = this.bonds[j + 1];
            ++j;
        }
        this.bonds = bondsNew;
    }

    void clearBonds() {
        this.bonds = null;
    }

    int getBondedAtomIndex(int bondIndex) {
        Bond bond = this.bonds[bondIndex];
        return (bond.atom1 == this ? bond.atom2 : bond.atom1).atomIndex & 0xFFFF;
    }

    void setMadAtom(short madAtom) {
        if (this.madAtom == Short.MIN_VALUE) {
            return;
        }
        if (madAtom == -1000) {
            int diameter = this.bfactor100 * 10 * 2;
            if (diameter > 4000) {
                diameter = 4000;
            }
            madAtom = (short)diameter;
        } else if (madAtom == -1001) {
            madAtom = (short)(this.getBondingMar() * 2);
        } else if (madAtom < 0) {
            madAtom = (short)(-madAtom * this.getVanderwaalsMar() / 50);
        }
        this.madAtom = madAtom;
    }

    public int getRasMolRadius() {
        if (this.madAtom == Short.MIN_VALUE) {
            return 0;
        }
        return this.madAtom / 8;
    }

    public int getCovalentBondCount() {
        if (this.bonds == null) {
            return 0;
        }
        int n = 0;
        int i = this.bonds.length;
        while (--i >= 0) {
            if ((this.bonds[i].order & 3) == 0) continue;
            ++n;
        }
        return n;
    }

    Bond[] getBonds() {
        return this.bonds;
    }

    void setColixAtom(short colixAtom) {
        this.colixAtom = colixAtom;
    }

    void setLabel(String strLabel) {
        this.group.chain.frame.setLabel(strLabel, this.atomIndex);
    }

    void transform(JmolViewer viewer) {
        if (this.madAtom == Short.MIN_VALUE) {
            return;
        }
        Point3i screen = viewer.transformPoint(this.point3f, this.vibrationVector);
        int z = screen.z;
        z = z < 100 ? 100 : (z > 14383 ? 14383 : z);
        short diameter = viewer.scaleToScreen(z, this.madAtom);
        this.xyzd = Xyzd.getXyzd(screen.x, screen.y, z, diameter);
    }

    public int getElementNumber() {
        return this.elementNumber;
    }

    public String getElementSymbol() {
        return JmolConstants.elementSymbols[this.elementNumber];
    }

    public String getAtomName() {
        return this.atomName != null ? this.atomName : JmolConstants.elementSymbols[this.elementNumber];
    }

    String getPdbAtomName4() {
        return this.atomName == null ? "" : this.atomName;
    }

    String getGroup3() {
        return this.group.getGroup3();
    }

    public boolean isGroup3(String group3) {
        return this.group.isGroup3(group3);
    }

    public boolean isGroup3Match(String strWildcard) {
        return this.group.isGroup3Match(strWildcard);
    }

    public int getSeqcode() {
        return this.group.seqcode;
    }

    public boolean isAtomNameMatch(String strPattern) {
        int ich;
        int cchAtomName = this.atomName == null ? 0 : this.atomName.length();
        int cchPattern = strPattern.length();
        for (ich = 0; ich < cchPattern; ++ich) {
            char charWild = strPattern.charAt(ich);
            if (charWild == '?' || ich < cchAtomName && charWild == Character.toUpperCase(this.atomName.charAt(ich))) continue;
            return false;
        }
        return ich >= cchAtomName;
    }

    public int getAtomNumber() {
        if (this.atomSerial != Integer.MIN_VALUE) {
            return this.atomSerial;
        }
        if (this.group.chain.frame.modelTypeName == "xyz" && this.group.chain.frame.viewer.getZeroBasedXyzRasmol()) {
            return this.atomIndex;
        }
        return this.atomIndex + 1;
    }

    public boolean isHetero() {
        return this.isHetero;
    }

    public int getFormalCharge() {
        return this.formalChargeAndFlags >> 4;
    }

    boolean isVisible() {
        return (this.formalChargeAndFlags & 1) != 0;
    }

    public float getPartialCharge() {
        return this.partialCharge;
    }

    public Point3f getPoint3f() {
        return this.point3f;
    }

    public float getAtomX() {
        return this.point3f.x;
    }

    public float getAtomY() {
        return this.point3f.y;
    }

    public float getAtomZ() {
        return this.point3f.z;
    }

    public float getDimensionValue(int dimension) {
        return dimension == 0 ? this.point3f.x : (dimension == 1 ? this.point3f.y : this.point3f.z);
    }

    short getVanderwaalsMar() {
        return JmolConstants.vanderwaalsMars[this.elementNumber];
    }

    float getVanderwaalsRadiusFloat() {
        return (float)JmolConstants.vanderwaalsMars[this.elementNumber] / 1000.0f;
    }

    short getBondingMar() {
        return JmolConstants.getBondingMar(this.elementNumber, this.formalChargeAndFlags >> 4);
    }

    float getBondingRadiusFloat() {
        return (float)this.getBondingMar() / 1000.0f;
    }

    public short getColix() {
        return this.colixAtom;
    }

    public float getRadius() {
        if (this.madAtom == Short.MIN_VALUE) {
            return 0.0f;
        }
        return (float)this.madAtom / 2000.0f;
    }

    public char getChainID() {
        return this.group.chain.chainID;
    }

    public int getOccupancy() {
        return this.occupancy;
    }

    public int getBfactor100() {
        if (this.bfactor100 == Short.MIN_VALUE) {
            return 0;
        }
        return this.bfactor100;
    }

    public Group getGroup() {
        return this.group;
    }

    public int getPolymerLength() {
        return this.group.getPolymerLength();
    }

    public Chain getChain() {
        return this.group.chain;
    }

    Model getModel() {
        return this.group.chain.model;
    }

    String getClientAtomStringProperty(String propertyName) {
        Object[] clientAtomReferences = this.group.chain.frame.clientAtomReferences;
        return clientAtomReferences == null || clientAtomReferences.length <= this.atomIndex ? null : this.group.chain.frame.viewer.getClientAtomStringProperty(clientAtomReferences[this.atomIndex], propertyName);
    }

    boolean isDeleted() {
        return this.madAtom == Short.MIN_VALUE;
    }

    void markDeleted() {
        this.deleteAllBonds();
        this.madAtom = Short.MIN_VALUE;
        this.xyzd = Long.MIN_VALUE;
    }

    public byte getProteinStructureType() {
        return this.group.getProteinStructureType();
    }

    public short getGroupID() {
        return this.group.groupID;
    }

    String getSeqcodeString() {
        return this.group.getSeqcodeString();
    }

    public String getModelTag() {
        return this.group.chain.model.modelTag;
    }

    public int getModelTagNumber() {
        try {
            return Integer.parseInt(this.group.chain.model.modelTag);
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    public byte getSpecialAtomID() {
        return this.specialAtomID;
    }

    void demoteSpecialAtomImposter() {
        this.specialAtomID = (byte)-1;
    }

    static String generateStarredAtomName(String primedAtomName) {
        int primeIndex = primedAtomName.indexOf(39);
        if (primeIndex < 0) {
            return null;
        }
        return primedAtomName.replace('\'', '*');
    }

    static String generatePrimeAtomName(String starredAtomName) {
        int starIndex = starredAtomName.indexOf(42);
        if (starIndex < 0) {
            return starredAtomName;
        }
        return starredAtomName.replace('*', '\'');
    }

    byte lookupSpecialAtomID(String atomName) {
        Integer boxedAtomID;
        if (atomName != null && (boxedAtomID = (Integer)htAtom.get(atomName = Atom.generatePrimeAtomName(atomName))) != null) {
            return (byte)boxedAtomID.intValue();
        }
        return 0;
    }

    String formatLabel(String strFormat) {
        int ichPercent;
        if (strFormat == null || strFormat.equals("")) {
            return null;
        }
        String strLabel = "";
        int cch = strFormat.length();
        int ich = 0;
        while ((ichPercent = strFormat.indexOf(37, ich)) != -1) {
            if (ich != ichPercent) {
                strLabel = strLabel + strFormat.substring(ich, ichPercent);
            }
            if ((ich = ichPercent + 1) == cch) {
                --ich;
                break;
            }
            String strT = "";
            char ch = strFormat.charAt(ich++);
            switch (ch) {
                case 'i': {
                    strT = "" + this.getAtomNumber();
                    break;
                }
                case 'a': {
                    strT = this.getAtomName();
                    break;
                }
                case 'e': {
                    strT = JmolConstants.elementSymbols[this.elementNumber];
                    break;
                }
                case 'x': {
                    strT = "" + this.point3f.x;
                    break;
                }
                case 'y': {
                    strT = "" + this.point3f.y;
                    break;
                }
                case 'z': {
                    strT = "" + this.point3f.z;
                    break;
                }
                case 'X': {
                    strT = "" + this.atomIndex;
                    break;
                }
                case 'C': {
                    int formalCharge = this.getFormalCharge();
                    if (formalCharge > 0) {
                        strT = "" + formalCharge + "+";
                        break;
                    }
                    if (formalCharge < 0) {
                        strT = "" + -formalCharge + "-";
                        break;
                    }
                    strT = "0";
                    break;
                }
                case 'P': {
                    float partialCharge = this.getPartialCharge();
                    if (Float.isNaN(partialCharge)) {
                        strT = "?";
                        break;
                    }
                    strT = "" + partialCharge;
                    break;
                }
                case 'V': {
                    strT = "" + this.getVanderwaalsRadiusFloat();
                    break;
                }
                case 'I': {
                    strT = "" + this.getBondingRadiusFloat();
                    break;
                }
                case 'b': 
                case 't': {
                    strT = "" + (double)this.getBfactor100() / 100.0;
                    break;
                }
                case 'q': {
                    strT = "" + this.occupancy;
                    break;
                }
                case 'c': 
                case 's': {
                    strT = "" + this.getChainID();
                    break;
                }
                case 'L': {
                    strT = "" + this.getPolymerLength();
                    break;
                }
                case 'M': {
                    strT = "/" + this.getModelTag();
                    break;
                }
                case 'm': {
                    strT = "<X>";
                    break;
                }
                case 'n': {
                    strT = this.getGroup3();
                    break;
                }
                case 'r': {
                    strT = this.getSeqcodeString();
                    break;
                }
                case 'U': {
                    strT = this.getIdentity();
                    break;
                }
                case '{': {
                    int ichCloseBracket = strFormat.indexOf(125, ich);
                    if (ichCloseBracket > ich) {
                        String propertyName = strFormat.substring(ich, ichCloseBracket);
                        String value = this.getClientAtomStringProperty(propertyName);
                        if (value != null) {
                            strT = value;
                        }
                        ich = ichCloseBracket + 1;
                        break;
                    }
                }
                default: {
                    strT = "%" + ch;
                }
            }
            strLabel = strLabel + strT;
        }
        if ((strLabel = strLabel + strFormat.substring(ich)).length() == 0) {
            return null;
        }
        return strLabel.intern();
    }

    public String getInfo() {
        return this.getIdentity();
    }

    String getIdentity() {
        StringBuffer info = new StringBuffer();
        String group3 = this.getGroup3();
        String seqcodeString = this.getSeqcodeString();
        char chainID = this.getChainID();
        if (group3 != null && group3.length() > 0) {
            info.append("[");
            info.append(group3);
            info.append("]");
        }
        if (seqcodeString != null) {
            info.append(seqcodeString);
        }
        if (chainID != '\u0000' && chainID != ' ') {
            info.append(":");
            info.append(chainID);
        }
        if (this.atomName != null) {
            if (info.length() > 0) {
                info.append(".");
            }
            info.append(this.atomName);
        }
        if (info.length() == 0) {
            info.append(this.getElementSymbol());
            info.append(" ");
            info.append(this.getAtomNumber());
        }
        if (this.group.chain.frame.getModelCount() > 1) {
            info.append("/");
            info.append(this.getModelTag());
        }
        info.append(" #");
        info.append(this.getAtomNumber());
        return "" + info;
    }

    boolean isCursorOnTopOfVisibleAtom(int xCursor, int yCursor, int minRadius, Atom competitor) {
        return (this.formalChargeAndFlags & 1) != 0 && this.isCursorOnTop(xCursor, yCursor, minRadius, competitor);
    }

    boolean isCursorOnTop(int xCursor, int yCursor, int minRadius, Atom competitor) {
        int rCompetitor;
        int zCompetitor;
        int r = Xyzd.getD(this.xyzd) / 2;
        if (r < minRadius) {
            r = minRadius;
        }
        int r2 = r * r;
        int dx = Xyzd.getX(this.xyzd) - xCursor;
        int dx2 = dx * dx;
        if (dx2 > r2) {
            return false;
        }
        int dy = Xyzd.getY(this.xyzd) - yCursor;
        int dy2 = dy * dy;
        int dz2 = r2 - (dx2 + dy2);
        if (dz2 < 0) {
            return false;
        }
        if (competitor == null) {
            return true;
        }
        int z = Xyzd.getZ(this.xyzd);
        if (z < (zCompetitor = Xyzd.getZ(competitor.xyzd)) - (rCompetitor = Xyzd.getD(competitor.xyzd) / 2)) {
            return true;
        }
        int dxCompetitor = Xyzd.getX(competitor.xyzd) - xCursor;
        int dx2Competitor = dxCompetitor * dxCompetitor;
        int dyCompetitor = Xyzd.getY(competitor.xyzd) - yCursor;
        int dy2Competitor = dyCompetitor * dyCompetitor;
        int r2Competitor = rCompetitor * rCompetitor;
        int dz2Competitor = r2Competitor - (dx2Competitor + dy2Competitor);
        return (double)z - Math.sqrt(dz2) < (double)zCompetitor - Math.sqrt(dz2Competitor);
    }

    int getScreenX() {
        return Xyzd.getX(this.xyzd);
    }

    int getScreenY() {
        return Xyzd.getY(this.xyzd);
    }

    int getScreenZ() {
        return Xyzd.getZ(this.xyzd);
    }

    int getScreenD() {
        return Xyzd.getD(this.xyzd);
    }

    public boolean isProtein() {
        return this.group.isProtein();
    }

    public boolean isNucleic() {
        return this.group.isNucleic();
    }

    public boolean isDna() {
        return this.group.isDna();
    }

    public boolean isRna() {
        return this.group.isRna();
    }

    public boolean isPurine() {
        return this.group.isPurine();
    }

    public boolean isPyrimidine() {
        return this.group.isPyrimidine();
    }

    static {
        int i = JmolConstants.specialAtomNames.length;
        while (--i >= 0) {
            String specialAtomName = JmolConstants.specialAtomNames[i];
            if (specialAtomName == null) continue;
            Integer boxedI = new Integer(i);
            htAtom.put(specialAtomName, boxedI);
        }
    }
}

