/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.viewer.datamodel;

import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.openscience.jmol.viewer.datamodel.AlphaPolymer;
import org.openscience.jmol.viewer.datamodel.AminoMonomer;
import org.openscience.jmol.viewer.datamodel.Atom;
import org.openscience.jmol.viewer.datamodel.Frame;
import org.openscience.jmol.viewer.datamodel.Monomer;

public class AminoPolymer
extends AlphaPolymer {
    short[] mainchainHbondOffsets;
    boolean hbondsAlreadyCalculated;
    Vector3f vectorPreviousOC = new Vector3f();
    Point3f aminoHydrogenPoint = new Point3f();
    private static final float maxHbondAlphaDistance = 9.0f;
    private static final float maxHbondAlphaDistance2 = 81.0f;
    private static final float minimumHbondDistance2 = 0.5f;
    private static final double QConst = -27888.0;

    AminoPolymer(Monomer[] monomers) {
        super(monomers);
    }

    boolean hasWingPoints() {
        return true;
    }

    void calcHydrogenBonds() {
        if (!this.hbondsAlreadyCalculated) {
            this.calcProteinMainchainHydrogenBonds();
            this.hbondsAlreadyCalculated = true;
        }
    }

    void calcProteinMainchainHydrogenBonds() {
        if (this.mainchainHbondOffsets == null) {
            this.mainchainHbondOffsets = new short[this.count];
        }
        for (int i = 0; i < this.count; ++i) {
            AminoMonomer residue = (AminoMonomer)this.monomers[i];
            this.mainchainHbondOffsets[i] = 0;
            if (i > 0 && residue.getGroupID() != 15) {
                Point3f nitrogenPoint = residue.getNitrogenAtomPoint();
                this.aminoHydrogenPoint.add(nitrogenPoint, this.vectorPreviousOC);
                this.bondAminoHydrogen(i, this.aminoHydrogenPoint);
            }
            Point3f carbonPoint = residue.getCarbonylCarbonAtomPoint();
            Point3f oxygenPoint = residue.getCarbonylOxygenAtomPoint();
            this.vectorPreviousOC.sub(carbonPoint, oxygenPoint);
        }
    }

    void bondAminoHydrogen(int indexDonor, Point3f hydrogenPoint) {
        AminoMonomer source = (AminoMonomer)this.monomers[indexDonor];
        Point3f sourceAlphaPoint = source.getLeadAtomPoint();
        Point3f sourceNitrogenPoint = source.getNitrogenAtomPoint();
        int energyMin1 = 0;
        int energyMin2 = 0;
        int indexMin1 = -1;
        int indexMin2 = -1;
        int i = this.count;
        while (--i >= 0) {
            AminoMonomer target;
            Point3f targetAlphaPoint;
            float dist2;
            if (i == indexDonor || i + 1 == indexDonor || i - 1 == indexDonor || (dist2 = sourceAlphaPoint.distanceSquared(targetAlphaPoint = (target = (AminoMonomer)this.monomers[i]).getLeadAtomPoint())) > 81.0f) continue;
            int energy = this.calcHbondEnergy(sourceNitrogenPoint, hydrogenPoint, target);
            if (energy < energyMin1) {
                energyMin1 = energy;
                indexMin1 = i;
                continue;
            }
            if (energy >= energyMin2) continue;
            energyMin2 = energy;
            indexMin2 = i;
        }
        if (indexMin1 >= 0) {
            this.mainchainHbondOffsets[indexDonor] = (short)(indexDonor - indexMin1);
            this.createResidueHydrogenBond(indexDonor, indexMin1);
            if (indexMin2 >= 0) {
                this.createResidueHydrogenBond(indexDonor, indexMin2);
            }
        }
    }

    int calcHbondEnergy(Point3f nitrogenPoint, Point3f hydrogenPoint, AminoMonomer target) {
        double distON;
        double distCN;
        double distCH;
        Point3f targetOxygenPoint = target.getCarbonylOxygenAtomPoint();
        float distOH2 = targetOxygenPoint.distanceSquared(hydrogenPoint);
        if (distOH2 < 0.5f) {
            return -9900;
        }
        Point3f targetCarbonPoint = target.getCarbonylCarbonAtomPoint();
        float distCH2 = targetCarbonPoint.distanceSquared(hydrogenPoint);
        if (distCH2 < 0.5f) {
            return -9900;
        }
        float distCN2 = targetCarbonPoint.distanceSquared(nitrogenPoint);
        if (distCN2 < 0.5f) {
            return -9900;
        }
        float distON2 = targetOxygenPoint.distanceSquared(nitrogenPoint);
        if (distON2 < 0.5f) {
            return -9900;
        }
        double distOH = Math.sqrt(distOH2);
        int energy = (int)(-27888.0 / distOH - -27888.0 / (distCH = Math.sqrt(distCH2)) + -27888.0 / (distCN = Math.sqrt(distCN2)) - -27888.0 / (distON = Math.sqrt(distON2)));
        if (energy < -9900) {
            return -9900;
        }
        if (energy > -500) {
            return 0;
        }
        return energy;
    }

    void createResidueHydrogenBond(int indexAminoGroup, int indexCarbonylGroup) {
        int order;
        int aminoBackboneHbondOffset = indexAminoGroup - indexCarbonylGroup;
        switch (aminoBackboneHbondOffset) {
            case 2: {
                order = 128;
                break;
            }
            case 3: {
                order = 192;
                break;
            }
            case 4: {
                order = 256;
                break;
            }
            case 5: {
                order = 320;
                break;
            }
            case -3: {
                order = 384;
                break;
            }
            case -4: {
                order = 448;
                break;
            }
            default: {
                order = 64;
            }
        }
        AminoMonomer donor = (AminoMonomer)this.monomers[indexAminoGroup];
        Atom nitrogen = donor.getNitrogenAtom();
        AminoMonomer recipient = (AminoMonomer)this.monomers[indexCarbonylGroup];
        Atom oxygen = recipient.getCarbonylOxygenAtom();
        Frame frame = this.model.mmset.frame;
        frame.bondAtoms(nitrogen, oxygen, order);
    }
}

