/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import org.openscience.jmol.viewer.JmolViewer;

public class PovraySaver {
    BufferedWriter bw;
    JmolViewer viewer;
    Matrix4f transformMatrix;
    Point3f point1 = new Point3f();
    Point3f point2 = new Point3f();
    Point3f pointC = new Point3f();

    public PovraySaver(JmolViewer viewer, OutputStream out) {
        this.bw = new BufferedWriter(new OutputStreamWriter(out), 8192);
        this.viewer = viewer;
    }

    void out(String str) throws IOException {
        this.bw.write(str);
    }

    public void writeFrame() throws IOException {
        int i;
        int screenHeight;
        float zoom = this.viewer.getFrame().getRotationRadius() * 2.0f;
        zoom *= 1.1f;
        zoom /= (float)this.viewer.getZoomPercent() / 100.0f;
        this.transformMatrix = this.viewer.getUnscaledTransformMatrix();
        int screenWidth = this.viewer.getScreenWidth();
        int minScreenDimension = screenWidth < (screenHeight = this.viewer.getScreenHeight()) ? screenWidth : screenHeight;
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, MMMM dd, yyyy 'at' h:mm aaa");
        String now_st = sdf.format(now);
        this.out("//******************************************************\n");
        this.out("// Jmol generated povray script.\n");
        this.out("//\n");
        this.out("// This script was generated on :\n");
        this.out("// " + now_st + "\n");
        this.out("//******************************************************\n");
        this.out("\n");
        this.out("\n");
        this.out("//******************************************************\n");
        this.out("// Declare the resolution, camera, and light sources.\n");
        this.out("//******************************************************\n");
        this.out("\n");
        this.out("// NOTE: if you plan to render at a different resoltion,\n");
        this.out("// be sure to update the following two lines to maintain\n");
        this.out("// the correct aspect ratio.\n\n");
        this.out("#declare Width = " + screenWidth + ";\n");
        this.out("#declare Height = " + screenHeight + ";\n");
        this.out("#declare minScreenDimension = " + minScreenDimension + ";\n");
        this.out("#declare Ratio = Width / Height;\n");
        this.out("#declare zoom = " + zoom + ";\n");
        this.out("camera{\n");
        this.out("  location < 0, 0, zoom>\n\n");
        this.out("  // Ratio is negative to switch povray to\n");
        this.out("  // a right hand coordinate system.\n");
        this.out("\n");
        this.out("  right < -Ratio , 0, 0>\n");
        this.out("  look_at < 0, 0, 0 >\n");
        this.out("}\n");
        this.out("\n");
        this.out("background { color " + this.povrayColor(this.viewer.getColorBackground()) + " }\n");
        this.out("\n");
        this.out("light_source { < 0, 0, zoom>  rgb <1.0,1.0,1.0> }\n");
        this.out("light_source { < -zoom, zoom, zoom>  rgb <1.0,1.0,1.0> }\n");
        this.out("\n");
        this.out("\n");
        this.out("//***********************************************\n");
        this.out("// macros for common shapes\n");
        this.out("//***********************************************\n");
        this.out("\n");
        this.writeMacros();
        this.out("//***********************************************\n");
        this.out("// List of all of the atoms\n");
        this.out("//***********************************************\n");
        this.out("\n");
        for (i = 0; i < this.viewer.getAtomCount(); ++i) {
            this.writeAtom(i);
        }
        this.out("\n");
        this.out("//***********************************************\n");
        this.out("// The list of bonds\n");
        this.out("//***********************************************\n");
        this.out("\n");
        for (i = 0; i < this.viewer.getBondCount(); ++i) {
            this.writeBond(i);
        }
    }

    public synchronized void writeFile() {
        try {
            this.writeFrame();
            this.bw.close();
        }
        catch (IOException e) {
            System.out.println("Got IOException " + e + " trying to write frame.");
        }
    }

    protected String povrayColor(Color color) {
        return "rgb<" + (float)color.getRed() / 255.0f + "," + (float)color.getGreen() / 255.0f + "," + (float)color.getBlue() / 255.0f + ">";
    }

    void writeMacros() throws IOException {
        this.out("#default { finish {\n ambient .2 diffuse .6 specular 1 roughness .001 metallic}}\n\n");
        this.out("#macro atom(X,Y,Z,RADIUS,R,G,B)\n sphere{<X,Y,Z>,RADIUS\n  pigment{rgb<R,G,B>}}\n#end\n\n");
        this.out("#macro bond1(X1,Y1,Z1,X2,Y2,Z2,RADIUS,R,G,B)\n cylinder{<X1,Y1,Z1>,<X2,Y2,Z2>,RADIUS\n  pigment{rgb<R,G,B>}}\n  sphere{<X1,Y1,Z1>,RADIUS\n   pigment{rgb<R,G,B>}}\n  sphere{<X2,Y2,Z2>,RADIUS\n   pigment{rgb<R,G,B>}}\n#end\n\n");
        this.out("#macro bond2(X1,Y1,Z1,XC,YC,ZC,X2,Y2,Z2,RADIUS,R1,G1,B1,R2,G2,B2)\n cylinder{<X1, Y1, Z1>, <XC, YC, ZC>, RADIUS\n  pigment{rgb<R1, G1, B1>}}\n cylinder{<XC, YC, ZC>, <X2, Y2, Z2>, RADIUS\n  pigment{rgb<R2,G2,B2>}}\n  sphere{<X1,Y1,Z1>,RADIUS\n   pigment{rgb<R1,G1,B1>}}\n  sphere{<X2,Y2,Z2>,RADIUS\n   pigment{rgb<R2,G2,B2>}}\n#end\n\n");
        this.out("#macro dblbond1(X1,Y1,Z1,X2,Y2,Z2,RADIUS,R,G,B)\n#local dx = X2 - X1;\n#local dy = Y2 - Y1;\n#local mag2d = sqrt(dx*dx + dy*dy);\n#local separation = 3/2 * RADIUS;\n#if (dx + dy)\n #local offX = separation * dy / mag2d;\n #local offY = separation * -dx / mag2d;\n#else\n #local offX = 0;\n #local offY = separation;\n#end\nbond1(X1+offX,Y1+offY,Z1,X2+offX,Y2+offY,Z2,RADIUS,R,G,B)\nbond1(X1-offX,Y1-offY,Z1,X2-offX,Y2-offY,Z2,RADIUS,R,G,B)\n#end\n\n");
        this.out("#macro dblbond2(X1,Y1,Z1,XC,YC,ZC,X2,Y2,Z2,RADIUS,R1,G1,B1,R2,G2,B2)\n#local dx = X2 - X1;\n#local dy = Y2 - Y1;\n#local mag2d = sqrt(dx*dx + dy*dy);\n#local separation = 3/2 * RADIUS;\n#if (dx + dy)\n #local offX = separation * dy / mag2d;\n #local offY = separation * -dx / mag2d;\n#else\n #local offX = 0;\n #local offY = separation;\n#end\nbond2(X1+offX,Y1+offY,Z1,XC+offX,YC+offY,ZC,X2+offX,Y2+offY,Z2,\n      RADIUS,R1,G1,B1,R2,G2,B2)\nbond2(X1-offX,Y1-offY,Z1,XC-offX,YC-offY,ZC,X2-offX,Y2-offY,Z2,\n      RADIUS,R1,G1,B1,R2,G2,B2)\n#end\n\n");
        this.out("#macro trpbond1(X1,Y1,Z1,X2,Y2,Z2,RADIUS,R,G,B)\n#local dx = X2 - X1;\n#local dy = Y2 - Y1;\n#local mag2d = sqrt(dx*dx + dy*dy);\n#local separation = 5/2 * RADIUS;\n#if (dx + dy)\n #local offX = separation * dy / mag2d;\n #local offY = separation * -dx / mag2d;\n#else\n #local offX = 0;\n #local offY = separation;\n#end\nbond1(X1+offX,Y1+offY,Z1,X2+offX,Y2+offY,Z2,RADIUS,R,G,B)\nbond1(X1     ,Y1     ,Z1,X2     ,Y2     ,Z2,RADIUS,R,G,B)\nbond1(X1-offX,Y1-offY,Z1,X2-offX,Y2-offY,Z2,RADIUS,R,G,B)\n#end\n\n");
        this.out("#macro trpbond2(X1,Y1,Z1,XC,YC,ZC,X2,Y2,Z2,RADIUS,R1,G1,B1,R2,G2,B2)\n#local dx = X2 - X1;\n#local dy = Y2 - Y1;\n#local mag2d = sqrt(dx*dx + dy*dy);\n#local separation = 5/2 * RADIUS;\n#if (dx + dy)\n #local offX = separation * dy / mag2d;\n #local offY = separation * -dx / mag2d;\n#else\n #local offX = 0;\n #local offY = separation;\n#end\nbond2(X1+offX,Y1+offY,Z1,XC+offX,YC+offY,ZC,X2+offX,Y2+offY,Z2,\n      RADIUS,R1,G1,B1,R2,G2,B2)\nbond2(X1     ,Y1     ,Z1,XC     ,YC     ,ZC,X2     ,Y2     ,Z2,\n      RADIUS,R1,G1,B1,R2,G2,B2)\nbond2(X1-offX,Y1-offY,Z1,XC-offX,YC-offY,ZC,X2-offX,Y2-offY,Z2,\n      RADIUS,R1,G1,B1,R2,G2,B2)\n#end\n\n");
    }

    void writeAtom(int i) throws IOException {
        float radius = this.viewer.getAtomRadius(i);
        if (radius == 0.0f) {
            return;
        }
        this.transformMatrix.transform(this.viewer.getAtomPoint3f(i), this.point1);
        float x = this.point1.x;
        float y = this.point1.y;
        float z = this.point1.z;
        Color color = this.viewer.getAtomColor(i);
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        this.out("atom(" + x + "," + y + "," + z + "," + radius + "," + r + "," + g + "," + b + ")\n");
    }

    void writeBond(int i) throws IOException {
        float radius = this.viewer.getBondRadius(i);
        if (radius == 0.0f) {
            return;
        }
        this.transformMatrix.transform(this.viewer.getBondPoint3f1(i), this.point1);
        float x1 = this.point1.x;
        float y1 = this.point1.y;
        float z1 = this.point1.z;
        this.transformMatrix.transform(this.viewer.getBondPoint3f2(i), this.point2);
        float x2 = this.point2.x;
        float y2 = this.point2.y;
        float z2 = this.point2.z;
        Color color1 = this.viewer.getBondColor1(i);
        Color color2 = this.viewer.getBondColor2(i);
        float r1 = (float)color1.getRed() / 255.0f;
        float g1 = (float)color1.getGreen() / 255.0f;
        float b1 = (float)color1.getBlue() / 255.0f;
        int order = this.viewer.getBondOrder(i) & 3;
        if (order == 2) {
            this.out("dbl");
        } else if (order == 3) {
            this.out("trp");
        }
        this.out("bond");
        if (color1.equals(color2)) {
            this.out("1(" + x1 + "," + y1 + "," + z1 + "," + x2 + "," + y2 + "," + z2 + ",\n" + "      " + radius + "," + r1 + "," + g1 + "," + b1 + ")\n");
        } else {
            this.pointC.set(this.point1);
            this.pointC.add(this.point2);
            this.pointC.scale(0.5f);
            float xC = this.pointC.x;
            float yC = this.pointC.y;
            float zC = this.pointC.z;
            float r2 = (float)color2.getRed() / 255.0f;
            float g2 = (float)color2.getGreen() / 255.0f;
            float b2 = (float)color2.getBlue() / 255.0f;
            this.out("2(" + x1 + "," + y1 + "," + z1 + "," + xC + "," + yC + "," + zC + ",\n" + "      " + x2 + "," + y2 + "," + z2 + "," + radius + ",\n" + "      " + r1 + "," + g1 + "," + b1 + "," + r2 + "," + g2 + "," + b2 + ")\n");
        }
    }
}

