/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.util.LinkedList;

final class CommandHistory {
    private LinkedList commandList = new LinkedList();
    private int maxSize;
    private int pos = 0;

    CommandHistory(int maxSize) {
        this.maxSize = maxSize;
    }

    String getCommandUp() {
        --this.pos;
        return this.getCommand();
    }

    String getCommandDown() {
        ++this.pos;
        return this.getCommand();
    }

    private String getCommand() {
        if (this.pos == 0) {
            return "";
        }
        int size = this.commandList.size();
        if (size > 0) {
            if (this.pos > 0) {
                return (String)this.commandList.get((this.pos - 1) % size);
            }
            return (String)this.commandList.get(size - Math.abs(1 + this.pos) % size - 1);
        }
        return "";
    }

    void addCommand(String command) {
        this.pos = 0;
        this.commandList.addLast(command);
        if (this.commandList.size() > this.maxSize) {
            this.commandList.removeFirst();
        }
    }

    void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        while (maxSize < this.commandList.size()) {
            this.commandList.removeFirst();
        }
    }

    void reset(int maxSize) {
        this.maxSize = maxSize;
        this.commandList = new LinkedList();
    }

    public static void main(String[] args) throws Exception {
        CommandHistory h = new CommandHistory(4);
        h.addCommand("a");
        h.addCommand("b");
        h.addCommand("c");
        h.addCommand("d");
        System.out.println(h.getCommandUp());
        System.out.println(h.getCommandUp());
        System.out.println(h.getCommandUp());
        System.out.println(h.getCommandUp());
        System.out.println(h.getCommandUp());
        System.out.println(h.getCommandUp());
        System.out.println("******");
        System.out.println(h.getCommandDown());
        System.out.println(h.getCommandDown());
        System.out.println(h.getCommandDown());
        System.out.println(h.getCommandDown());
        System.out.println(h.getCommandDown());
        System.out.println(h.getCommandDown());
        System.out.println(h.getCommandDown());
        h.setMaxSize(2);
        System.out.println(h.getCommandUp());
        System.out.println(h.getCommandUp());
        System.out.println(h.getCommandUp());
        System.out.println(h.getCommandUp());
        System.out.println(h.getCommandUp());
        System.out.println(h.getCommandUp());
        System.out.println("******");
        System.out.println(h.getCommandDown());
        System.out.println(h.getCommandDown());
        System.out.println(h.getCommandDown());
        System.out.println(h.getCommandDown());
        System.out.println(h.getCommandDown());
        System.out.println(h.getCommandDown());
        System.out.println(h.getCommandDown());
    }
}

