/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.math;

public class FortranFormat {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double atof(String s) {
        int i;
        int sign = 1;
        double r = 0.0;
        double f = 0.0;
        double p = 1.0;
        boolean state = false;
        for (i = 0; i < s.length() && Character.isWhitespace(s.charAt(i)); ++i) {
        }
        if (i < s.length() && s.charAt(i) == '-') {
            sign = -1;
            ++i;
        } else if (i < s.length() && s.charAt(i) == '+') {
            ++i;
        }
        while (i < s.length()) {
            char ch = s.charAt(i);
            if ('0' <= ch && ch <= '9') {
                if (!state) {
                    r = r * 10.0 + (double)ch - 48.0;
                } else if (state) {
                    r += (p /= 10.0) * (double)(ch - 48);
                }
            } else if (ch == '.') {
                if (state) return (double)sign * r;
                state = true;
            } else {
                if (ch != 'e' && ch != 'E' && ch != 'd' && ch != 'D') return (double)sign * r;
                long e = (int)FortranFormat.parseLong(s.substring(i + 1), 10);
                return (double)sign * r * Math.pow(10.0, e);
            }
            ++i;
        }
        return (double)sign * r;
    }

    private static long parseLong(String s, int base) {
        int i;
        int sign = 1;
        long r = 0L;
        for (i = 0; i < s.length() && Character.isWhitespace(s.charAt(i)); ++i) {
        }
        if (i < s.length() && s.charAt(i) == '-') {
            sign = -1;
            ++i;
        } else if (i < s.length() && s.charAt(i) == '+') {
            ++i;
        }
        while (i < s.length()) {
            char ch = s.charAt(i);
            if ('0' <= ch && ch < 48 + base) {
                r = r * (long)base + (long)ch - 48L;
            } else if ('A' <= ch && ch < 65 + base - 10) {
                r = r * (long)base + (long)ch - 65L + 10L;
            } else if ('a' <= ch && ch < 97 + base - 10) {
                r = r * (long)base + (long)ch - 97L + 10L;
            } else {
                return r * (long)sign;
            }
            ++i;
        }
        return r * (long)sign;
    }
}

