/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.program;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import javax.vecmath.Point3d;
import org.openscience.cdk.Atom;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.io.DefaultChemObjectWriter;
import org.openscience.cdk.io.setting.BooleanIOSetting;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.io.setting.IntegerIOSetting;
import org.openscience.cdk.io.setting.OptionIOSetting;
import org.openscience.cdk.io.setting.StringIOSetting;

public class GaussianInputWriter
extends DefaultChemObjectWriter {
    static BufferedWriter writer;
    IOSetting method;
    IOSetting basis;
    IOSetting comment;
    IOSetting command;
    IOSetting memory;
    BooleanIOSetting shell;
    IntegerIOSetting proccount;
    BooleanIOSetting usecheckpoint;

    public GaussianInputWriter(Writer out) {
        this();
        writer = new BufferedWriter(out);
    }

    public GaussianInputWriter() {
        this.initIOSettings();
    }

    public String getFormatName() {
        return "Gaussian Input";
    }

    public void close() throws IOException {
        writer.close();
    }

    public void write(ChemObject object) throws CDKException {
        if (object instanceof Molecule) {
            try {
                this.writeMolecule((Molecule)object);
            }
            catch (Exception ex) {
                throw new CDKException("Error while writing Gaussian input file: " + ex.getMessage());
            }
        } else {
            throw new CDKException("GaussianInputWriter only supports output of Molecule classes.");
        }
    }

    public ChemObject highestSupportedChemObject() {
        return new Molecule();
    }

    public void writeMolecule(Molecule mol) throws IOException {
        this.customizeJob();
        if (this.proccount.getSettingValue() > 1) {
            writer.write("%nprocl=" + this.proccount.getSettingValue());
            writer.newLine();
        }
        if (!this.memory.getSetting().equals("unset")) {
            writer.write("%Mem=" + this.memory.getSetting());
            writer.newLine();
        }
        if (this.usecheckpoint.isSet()) {
            if (mol.getID() != null && mol.getID().length() > 0) {
                writer.write("%chk=" + mol.getID() + ".chk");
            } else {
                writer.write("%chk=" + System.currentTimeMillis() + ".chk");
            }
            writer.newLine();
        }
        writer.write("# " + this.method.getSetting() + "/" + this.basis.getSetting() + " ");
        String commandString = this.command.getSetting();
        if (!commandString.equals("energy calculation")) {
            if (commandString.equals("geometry optimization")) {
                writer.write("opt");
            } else if (commandString.equals("IR frequency calculation")) {
                writer.write("freq");
            } else if (commandString.equals("IR frequency calculation (with Raman)")) {
                writer.write("freq=noraman");
            }
        }
        writer.newLine();
        writer.newLine();
        writer.write(this.comment.getSetting() + "\n");
        writer.newLine();
        writer.write("0 ");
        if (this.shell.isSet()) {
            writer.write("0");
        } else {
            writer.write("1");
        }
        writer.newLine();
        Atom[] atoms = mol.getAtoms();
        for (int i = 0; i < atoms.length; ++i) {
            Atom a = atoms[i];
            String st = a.getSymbol();
            st = st + " 0 ";
            Point3d p3 = a.getPoint3d();
            if (p3 != null) {
                st = st + new Double(p3.x).toString() + " " + new Double(p3.y).toString() + " " + new Double(p3.z).toString();
            }
            writer.write(st, 0, st.length());
            writer.newLine();
        }
        writer.newLine();
    }

    private void initIOSettings() {
        Vector<String> basisOptions = new Vector<String>();
        basisOptions.add("6-31g");
        basisOptions.add("6-31g*");
        basisOptions.add("6-31g(d)");
        basisOptions.add("6-311g");
        basisOptions.add("6-311+g**");
        this.basis = new OptionIOSetting("Basis", 1, "Which basis set do you want to use?", basisOptions, "6-31g");
        Vector<String> methodOptions = new Vector<String>();
        methodOptions.add("rb3lyp");
        methodOptions.add("b3lyp");
        methodOptions.add("rhf");
        this.method = new OptionIOSetting("Method", 1, "Which method do you want to use?", methodOptions, "b3lyp");
        Vector<String> commandOptions = new Vector<String>();
        commandOptions.add("energy calculation");
        commandOptions.add("geometry optimization");
        commandOptions.add("IR frequency calculation");
        commandOptions.add("IR frequency calculation (with Raman)");
        this.command = new OptionIOSetting("Command", 0, "What kind of job do you want to perform?", commandOptions, "energy calculation");
        this.comment = new StringIOSetting("Comment", 2, "What comment should be put in the file?", "Created with CDK (http://cdk.sf.net/)");
        this.memory = new StringIOSetting("Memory", 2, "How much memory do you want to use?", "unset");
        this.shell = new BooleanIOSetting("OpenShell", 1, "Should the calculation be open shell?", "false");
        this.proccount = new IntegerIOSetting("ProcessorCount", 2, "How many processors should be used by Gaussian?", "1");
        this.usecheckpoint = new BooleanIOSetting("UseCheckPointFile", 2, "Should a check point file be saved?", "false");
    }

    private void customizeJob() {
        this.fireIOSettingQuestion(this.basis);
        this.fireIOSettingQuestion(this.method);
        this.fireIOSettingQuestion(this.command);
        this.fireIOSettingQuestion(this.comment);
        this.fireIOSettingQuestion(this.shell);
        this.fireIOSettingQuestion(this.proccount);
        this.fireIOSettingQuestion(this.memory);
        this.fireIOSettingQuestion(this.usecheckpoint);
    }

    public IOSetting[] getIOSettings() {
        IOSetting[] settings = new IOSetting[]{this.basis, this.method, this.command, this.comment, this.shell, this.proccount, this.usecheckpoint};
        settings[6] = this.memory;
        return settings;
    }
}

