/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.cml;

import java.util.Hashtable;
import org.openscience.cdk.io.cml.CMLCoreModule;
import org.openscience.cdk.io.cml.CMLReactionModule;
import org.openscience.cdk.io.cml.CMLStack;
import org.openscience.cdk.io.cml.ConventionInterface;
import org.openscience.cdk.io.cml.JMOLANIMATIONConvention;
import org.openscience.cdk.io.cml.MDLMolConvention;
import org.openscience.cdk.io.cml.ModuleInterface;
import org.openscience.cdk.io.cml.PDBConvention;
import org.openscience.cdk.io.cml.PMPConvention;
import org.openscience.cdk.io.cml.cdopi.CDOInterface;
import org.openscience.cdk.tools.LoggingTool;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class CMLHandler
extends DefaultHandler {
    private ModuleInterface conv;
    private LoggingTool logger = new LoggingTool(this);
    private boolean debug = true;
    private Hashtable userConventions;
    private CMLStack xpath;
    private CMLStack conventionStack;

    public CMLHandler(CDOInterface cdo) {
        this.conv = new CMLCoreModule(cdo);
        this.userConventions = new Hashtable();
        this.xpath = new CMLStack();
        this.conventionStack = new CMLStack();
    }

    public void registerConvention(String convention, ModuleInterface conv) {
        this.userConventions.put(convention, conv);
    }

    public void characters(char[] ch, int start, int length) {
        if (this.debug) {
            this.logger.debug(new String(ch, start, length));
        }
        this.conv.characterData(this.xpath, ch, start, length);
    }

    public void doctypeDecl(String name, String publicId, String systemId) throws Exception {
    }

    public void endDocument() {
        this.conv.endDocument();
    }

    public void endElement(String uri, String local, String raw) {
        if (this.debug) {
            this.logger.debug("</" + raw + ">");
        }
        this.conv.endElement(this.xpath, uri, local, raw);
        this.xpath.pop();
        this.conventionStack.pop();
    }

    public CDOInterface returnCDO() {
        return this.conv.returnCDO();
    }

    public void startDocument() {
        this.conv.startDocument();
        this.conventionStack.push("CML");
    }

    public void startElement(String uri, String local, String raw, Attributes atts) {
        this.xpath.push(local);
        if (this.debug) {
            this.logger.debug("<", raw, "> -> ", this.xpath);
        }
        if (local.startsWith("reaction")) {
            this.logger.info("Detected CRML module");
            this.conv = new CMLReactionModule(this.conv);
            this.conventionStack.push(this.conventionStack.current());
        } else {
            String convName = "";
            for (int i = 0; i < atts.getLength(); ++i) {
                if (!atts.getQName(i).equals("convention")) continue;
                convName = atts.getValue(i);
            }
            if (convName.length() > 0) {
                if (convName.equals(this.conventionStack.current())) {
                    this.logger.debug("Same convention as parent");
                } else {
                    this.logger.info((Object)"New Convention: ", convName);
                    if (!convName.equals("CML")) {
                        if (convName.equals("PDB")) {
                            this.conv = new PDBConvention(this.conv);
                        } else if (convName.equals("PMP")) {
                            this.conv = new PMPConvention(this.conv);
                        } else if (convName.equals("MDLMol")) {
                            if (this.debug) {
                                this.logger.debug("MDLMolConvention instantiated...");
                            }
                            this.conv = new MDLMolConvention(this.conv);
                        } else if (convName.equals("JMOL-ANIMATION")) {
                            this.conv = new JMOLANIMATIONConvention(this.conv);
                        } else if (this.userConventions.containsKey(convName)) {
                            ConventionInterface newconv = (ConventionInterface)this.userConventions.get(convName);
                            newconv.inherit(this.conv);
                            this.conv = newconv;
                        } else {
                            this.logger.warn((Object)"Detected unknown convention: ", convName);
                        }
                    }
                }
                this.conventionStack.push(convName);
            } else {
                this.conventionStack.push(this.conventionStack.current());
            }
        }
        if (this.debug) {
            this.logger.debug((Object)"ConventionStack: ", this.conventionStack);
        }
        this.conv.startElement(this.xpath, uri, local, raw, atts);
    }
}

