/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import freeware.PrintfFormat;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import javax.vecmath.Point3d;
import org.openscience.cdk.Atom;
import org.openscience.cdk.ChemFile;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.ChemSequence;
import org.openscience.cdk.Crystal;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.CrystalGeometryTools;
import org.openscience.cdk.io.DefaultChemObjectWriter;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;

public class PDBWriter
extends DefaultChemObjectWriter {
    static BufferedWriter writer;

    public PDBWriter(Writer out) {
        writer = new BufferedWriter(out);
    }

    public String getFormatName() {
        return "Protein Brookhaven Database";
    }

    public void write(ChemObject object) throws CDKException {
        if (object instanceof Molecule) {
            this.writeMolecule((Molecule)object);
        } else if (object instanceof Crystal) {
            this.writeCrystal((Crystal)object);
        } else if (object instanceof ChemFile) {
            ChemModel model;
            ChemFile chemFile = (ChemFile)object;
            ChemSequence sequence = chemFile.getChemSequence(0);
            if (sequence != null && (model = sequence.getChemModel(0)) != null) {
                Crystal crystal = model.getCrystal();
                if (crystal != null) {
                    this.write(crystal);
                } else {
                    this.writeMolecule(new Molecule(ChemModelManipulator.getAllInOneContainer(model)));
                }
            }
        } else {
            throw new CDKException("Only supported is writing of Molecule, Crystal and ChemFile objects.");
        }
    }

    public ChemObject highestSupportedChemObject() {
        return new ChemFile();
    }

    public void writeMolecule(Molecule molecule) throws CDKException {
        try {
            boolean na = false;
            int atomNumber = 1;
            String info = "";
            String st = "";
            String tab = "\t";
            boolean writecharge = false;
            boolean writevect = false;
            String hetatmRecordName = "HETATM";
            String terRecordName = "TER";
            PrintfFormat serialFormat = new PrintfFormat("%5d");
            PrintfFormat atomNameFormat = new PrintfFormat("%-4s");
            PrintfFormat positionFormat = new PrintfFormat("%8.3f");
            StringBuffer buffer = new StringBuffer();
            Atom[] atoms = molecule.getAtoms();
            for (int i = 0; i < atoms.length; ++i) {
                buffer.setLength(0);
                buffer.append(hetatmRecordName);
                buffer.append(serialFormat.sprintf(atomNumber));
                buffer.append(' ');
                Atom atom = atoms[i];
                buffer.append(atomNameFormat.sprintf(atom.getSymbol()));
                buffer.append(" MOL          ");
                Point3d position = atom.getPoint3d();
                buffer.append(positionFormat.sprintf(position.x));
                buffer.append(positionFormat.sprintf(position.y));
                buffer.append(positionFormat.sprintf(position.z));
                writer.write(buffer.toString(), 0, buffer.length());
                writer.newLine();
                ++atomNumber;
            }
            writer.write(terRecordName, 0, terRecordName.length());
            writer.newLine();
        }
        catch (IOException exception) {
            throw new CDKException("Error while writing file: " + exception.getMessage());
        }
    }

    public void writeCrystal(Crystal crystal) throws CDKException {
        try {
            writer.write("HEADER created with CDK fileconvertot\n");
            double[] a = crystal.getA();
            double[] b = crystal.getB();
            double[] c = crystal.getC();
            double[] ucParams = CrystalGeometryTools.cartesianToNotional(a, b, c);
            PrintfFormat lengthFormat = new PrintfFormat("%4.3f");
            PrintfFormat angleFormat = new PrintfFormat("%3.3f");
            writer.write("CRYST1 " + lengthFormat.sprintf(ucParams[0]) + lengthFormat.sprintf(ucParams[1]) + lengthFormat.sprintf(ucParams[2]) + angleFormat.sprintf(ucParams[3]) + angleFormat.sprintf(ucParams[4]) + angleFormat.sprintf(ucParams[5]) + "\n");
            Atom[] atoms = crystal.getAtoms();
            for (int i = 0; i < atoms.length; ++i) {
                Atom atom = atoms[i];
                double[] frac = new double[]{atom.getFractX3d(), atom.getFractY3d(), atom.getFractZ3d()};
                double[] cart = CrystalGeometryTools.fractionalToCartesian(a, b, c, frac);
                atom.setX3d(cart[0]);
                atom.setY3d(cart[1]);
                atom.setZ3d(cart[2]);
            }
            this.writeMolecule(new Molecule(crystal));
        }
        catch (IOException exception) {
            throw new CDKException("Error while writing file: " + exception.getMessage());
        }
    }

    public void close() throws IOException {
        writer.close();
    }
}

