/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.StringTokenizer;
import javax.vecmath.Point3d;
import org.openscience.cdk.Atom;
import org.openscience.cdk.AtomType;
import org.openscience.cdk.ChemFile;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.ChemSequence;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.SetOfMolecules;
import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.tools.LoggingTool;

public class Mol2Reader
extends DefaultChemObjectReader {
    BufferedReader input = null;
    private LoggingTool logger = new LoggingTool(this);

    public Mol2Reader(Reader in) {
        this.input = new BufferedReader(in);
    }

    public Mol2Reader() {
        this(new StringReader(""));
    }

    public String getFormatName() {
        return "Mol2 (Sybyl)";
    }

    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    public boolean matches(int lineNumber, String line) {
        return line.indexOf("<TRIPOS>") >= 0;
    }

    public ChemObject read(ChemObject object) throws CDKException {
        if (object instanceof ChemFile) {
            ChemFile file = new ChemFile();
            ChemSequence sequence = new ChemSequence();
            ChemModel model = new ChemModel();
            SetOfMolecules moleculeSet = new SetOfMolecules();
            moleculeSet.addMolecule(this.readMolecule());
            model.setSetOfMolecules(moleculeSet);
            sequence.addChemModel(model);
            file.addChemSequence(sequence);
            return file;
        }
        if (object instanceof ChemModel) {
            ChemModel model = new ChemModel();
            SetOfMolecules moleculeSet = new SetOfMolecules();
            moleculeSet.addMolecule(this.readMolecule());
            model.setSetOfMolecules(moleculeSet);
            return model;
        }
        throw new CDKException("Only supported is ChemModel, and not " + object.getClass().getName() + ".");
    }

    public boolean accepts(ChemObject object) {
        return !(object instanceof ChemFile) && object instanceof ChemModel;
    }

    private Molecule readMolecule() throws CDKException {
        Molecule molecule = new Molecule();
        AtomTypeFactory atFactory = null;
        try {
            atFactory = AtomTypeFactory.getInstance("org/openscience/cdk/config/data/mol2_atomtypes.xml");
        }
        catch (Exception exception) {
            String error = "Could not instantiate an AtomTypeFactory";
            this.logger.error(error);
            this.logger.debug(exception);
            throw new CDKException(error);
        }
        try {
            String line = this.input.readLine();
            int atomCount = 0;
            int bondCount = 0;
            while (line != null) {
                StringTokenizer tokenizer;
                int i;
                if (line.startsWith("@<TRIPOS>MOLECULE")) {
                    String error;
                    this.logger.info("Reading molecule block");
                    String name = this.input.readLine();
                    String counts = this.input.readLine();
                    StringTokenizer tokenizer2 = new StringTokenizer(counts);
                    try {
                        atomCount = Integer.parseInt(tokenizer2.nextToken());
                    }
                    catch (NumberFormatException nfExc) {
                        error = "Error while reading atom count from MOLECULE block";
                        this.logger.error(error);
                        this.logger.debug(nfExc);
                        throw new CDKException(error);
                    }
                    if (tokenizer2.hasMoreTokens()) {
                        try {
                            bondCount = Integer.parseInt(tokenizer2.nextToken());
                        }
                        catch (NumberFormatException nfExc) {
                            error = "Error while reading atom and bond counts";
                            this.logger.error(error);
                            this.logger.debug(nfExc);
                            throw new CDKException(error);
                        }
                    } else {
                        bondCount = 0;
                    }
                    this.logger.info((Object)"Reading #atoms: ", atomCount);
                    this.logger.info((Object)"Reading #bonds: ", bondCount);
                    this.logger.warn("Not reading molecule qualifiers");
                } else if (line.startsWith("@<TRIPOS>ATOM")) {
                    this.logger.info("Reading atom block");
                    for (i = 0; i < atomCount; ++i) {
                        line = this.input.readLine().trim();
                        tokenizer = new StringTokenizer(line);
                        String idStr = tokenizer.nextToken();
                        String nameStr = tokenizer.nextToken();
                        String xStr = tokenizer.nextToken();
                        String yStr = tokenizer.nextToken();
                        String zStr = tokenizer.nextToken();
                        String atomTypeStr = tokenizer.nextToken();
                        AtomType atomType = atFactory.getAtomType(atomTypeStr);
                        if (atomType == null) {
                            atomType = atFactory.getAtomType("X");
                            this.logger.error((Object)"Could not find specified atom type: ", atomTypeStr);
                        }
                        Atom atom = new Atom("X");
                        atom.setID(nameStr);
                        atom.setAtomTypeName(atomTypeStr);
                        atFactory.configure(atom);
                        try {
                            double x = Double.parseDouble(xStr);
                            double y = Double.parseDouble(yStr);
                            double z = Double.parseDouble(zStr);
                            atom.setPoint3d(new Point3d(x, y, z));
                        }
                        catch (NumberFormatException nfExc) {
                            String error = "Error while reading atom coordinates";
                            this.logger.error(error);
                            this.logger.debug(nfExc);
                            throw new CDKException(error);
                        }
                        molecule.addAtom(atom);
                    }
                } else if (line.startsWith("@<TRIPOS>BOND")) {
                    this.logger.info("Reading bond block");
                    for (i = 0; i < bondCount; ++i) {
                        line = this.input.readLine();
                        tokenizer = new StringTokenizer(line);
                        String bondId = tokenizer.nextToken();
                        String atom1Str = tokenizer.nextToken();
                        String atom2Str = tokenizer.nextToken();
                        String orderStr = tokenizer.nextToken();
                        try {
                            int atom1 = Integer.parseInt(atom1Str);
                            int atom2 = Integer.parseInt(atom2Str);
                            double order = 0.0;
                            if ("1".equals(orderStr)) {
                                order = 1.5;
                            } else if ("2".equals(orderStr)) {
                                order = 2.0;
                            } else if ("3".equals(orderStr)) {
                                order = 3.0;
                            } else if ("am".equals(orderStr)) {
                                order = 1.0;
                            } else if ("ar".equals(orderStr)) {
                                order = 1.5;
                            } else if ("du".equals(orderStr)) {
                                order = 1.0;
                            } else if ("un".equals(orderStr)) {
                                order = 1.0;
                            } else if ("nc".equals(orderStr)) {
                                order = 0.0;
                            }
                            if (order == 0.0) continue;
                            molecule.addBond(atom1 - 1, atom2 - 1, order);
                            continue;
                        }
                        catch (NumberFormatException nfExc) {
                            String error = "Error while reading bond information";
                            this.logger.error(error);
                            this.logger.debug(nfExc);
                            throw new CDKException(error);
                        }
                    }
                }
                line = this.input.readLine();
            }
        }
        catch (IOException exception) {
            String error = "Error while reading general structure";
            this.logger.error(error);
            this.logger.debug(exception);
            throw new CDKException(error);
        }
        return molecule;
    }

    public void close() throws IOException {
        this.input.close();
    }
}

