/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.geometry;

import javax.vecmath.Point3d;
import org.openscience.cdk.Atom;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.Crystal;
import org.openscience.cdk.exception.CDKException;

public class CrystalGeometryTools {
    public static double[][] calcInvertedAxes(double[] a, double[] b, double[] c) {
        double det = a[0] * b[1] * c[2] - a[0] * b[2] * c[1] - a[1] * b[0] * c[2] + a[1] * b[2] * c[0] + a[2] * b[0] * c[1] - a[2] * b[1] * c[0];
        double[][] invaxis = new double[3][3];
        invaxis[0][0] = (b[1] * c[2] - b[2] * c[1]) / det;
        invaxis[0][1] = (b[2] * c[0] - b[0] * c[2]) / det;
        invaxis[0][2] = (b[0] * c[1] - b[1] * c[0]) / det;
        invaxis[1][0] = (a[2] * c[1] - a[1] * c[2]) / det;
        invaxis[1][1] = (a[0] * c[2] - a[2] * c[0]) / det;
        invaxis[1][2] = (a[1] * c[0] - a[0] * c[1]) / det;
        invaxis[2][0] = (a[1] * b[2] - a[2] * b[1]) / det;
        invaxis[2][1] = (a[2] * b[0] - a[0] * b[2]) / det;
        invaxis[2][2] = (a[0] * b[1] - a[1] * b[0]) / det;
        return invaxis;
    }

    public static double[] cartesianToFractional(double[] a, double[] b, double[] c, double[] cart) {
        double[] fractCoords = new double[3];
        double[][] invaxis = CrystalGeometryTools.calcInvertedAxes(a, b, c);
        fractCoords[0] = invaxis[0][0] * cart[0] + invaxis[0][1] * cart[1] + invaxis[0][2] * cart[2];
        fractCoords[1] = invaxis[1][0] * cart[0] + invaxis[1][1] * cart[1] + invaxis[1][2] * cart[2];
        fractCoords[2] = invaxis[2][0] * cart[0] + invaxis[2][1] * cart[1] + invaxis[2][2] * cart[2];
        return fractCoords;
    }

    public static Point3d cartesianToFractional(double[] a, double[] b, double[] c, Point3d cartPoint) {
        double[] cart = new double[]{cartPoint.x, cartPoint.y, cartPoint.z};
        double[] frac = CrystalGeometryTools.cartesianToFractional(a, b, c, cart);
        return new Point3d(frac[0], frac[1], frac[2]);
    }

    public static double[] fractionalToCartesian(double[] a, double[] b, double[] c, double[] frac) {
        double[] cart = new double[]{frac[0] * a[0] + frac[1] * b[0] + frac[2] * c[0], frac[0] * a[1] + frac[1] * b[1] + frac[2] * c[1], frac[0] * a[2] + frac[1] * b[2] + frac[2] * c[2]};
        return cart;
    }

    public static Point3d fractionalToCartesian(double[] a, double[] b, double[] c, Point3d fracPoint) {
        double[] frac = new double[]{fracPoint.x, fracPoint.y, fracPoint.z};
        double[] cart = CrystalGeometryTools.fractionalToCartesian(a, b, c, frac);
        return new Point3d(cart[0], cart[1], cart[2]);
    }

    public static double[][] notionalToCartesian(double alength, double blength, double clength, double alpha, double beta, double gamma) {
        double[][] axes = new double[3][3];
        axes[0][0] = alength;
        axes[0][1] = 0.0;
        axes[0][2] = 0.0;
        double toRadians = Math.PI / 180;
        double cosalpha = Math.cos(toRadians * alpha);
        double cosbeta = Math.cos(toRadians * beta);
        double cosgamma = Math.cos(toRadians * gamma);
        double sinalpha = Math.sin(toRadians * alpha);
        double sinbeta = Math.sin(toRadians * beta);
        double singamma = Math.sin(toRadians * gamma);
        axes[1][0] = blength * cosgamma;
        axes[1][1] = blength * singamma;
        axes[1][2] = 0.0;
        double V = alength * blength * clength * Math.sqrt(1.0 - cosalpha * cosalpha - cosbeta * cosbeta - cosgamma * cosgamma + 2.0 * cosalpha * cosbeta * cosgamma);
        axes[2][0] = clength * cosbeta;
        axes[2][1] = clength * (cosalpha - cosbeta * cosgamma) / singamma;
        axes[2][2] = V / (alength * blength * singamma);
        return axes;
    }

    public static double[] cartesianToNotional(double[] a, double[] b, double[] c) {
        double[] notionalCoords = new double[]{CrystalGeometryTools.calcAxisLength(a), CrystalGeometryTools.calcAxisLength(b), CrystalGeometryTools.calcAxisLength(c), CrystalGeometryTools.calcAxesAngle(b, c), CrystalGeometryTools.calcAxesAngle(a, c), CrystalGeometryTools.calcAxesAngle(a, b)};
        return notionalCoords;
    }

    public static Crystal convertToP1Cell(Crystal crystal) throws CDKException {
        Crystal result = (Crystal)crystal.clone();
        if ("P 2_1 2_1 2_1".equals(crystal.getSpaceGroup())) {
            for (int i = 0; i < crystal.getAtomCount(); ++i) {
                Atom atom = crystal.getAtomAt(i);
                Point3d point = atom.getPoint3d();
                if (point != null) {
                    double[] a = crystal.getA();
                    double[] b = crystal.getB();
                    double[] c = crystal.getC();
                    Point3d newPoint = new Point3d();
                    newPoint.x = -1.0 * point.x + 0.5 * (a[0] + b[0] + c[0]);
                    newPoint.y = -1.0 * point.y;
                    newPoint.z = point.z + 0.5 * (a[3] + b[3] + c[3]);
                    Atom syma = (Atom)atom.clone();
                    syma.setPoint3d(newPoint);
                    result.addAtom(syma);
                    newPoint.x = -1.0 * point.x + 0.5 * (a[0] + b[0] + c[0]);
                    newPoint.y = -1.0 * point.y;
                    newPoint.z = point.z + 0.5 * (a[3] + b[3] + c[3]);
                    syma = (Atom)atom.clone();
                    syma.setPoint3d(newPoint);
                    result.addAtom(syma);
                    newPoint.x = -1.0 * point.x + 0.5 * (a[0] + b[0] + c[0]);
                    newPoint.y = -1.0 * point.y;
                    newPoint.z = point.z + 0.5 * (a[3] + b[3] + c[3]);
                    syma = (Atom)atom.clone();
                    syma.setPoint3d(newPoint);
                    result.addAtom(syma);
                    continue;
                }
                Atom syma = (Atom)atom.clone();
                result.addAtom(syma);
                syma = (Atom)atom.clone();
                result.addAtom(syma);
                syma = (Atom)atom.clone();
                result.addAtom(syma);
            }
        } else if (!"P 2_1 2_1 2_1".equals(crystal.getSpaceGroup())) {
            throw new CDKException("This given spacegroup is not supported.");
        }
        return result;
    }

    public static double calcAxisLength(double[] a) {
        return Math.sqrt(Math.pow(a[0], 2.0) + Math.pow(a[1], 2.0) + Math.pow(a[2], 2.0));
    }

    public static double calcAxesAngle(double[] a, double[] b) {
        return Math.toDegrees(Math.acos((a[0] * b[0] + a[1] * b[1] + a[2] * b[2]) / (CrystalGeometryTools.calcAxisLength(a) * CrystalGeometryTools.calcAxisLength(b))));
    }

    public static boolean hasCrystalCoordinates(AtomContainer m) {
        Atom[] atoms = m.getAtoms();
        for (int i = 0; i < atoms.length; ++i) {
            if (atoms[i].getFractionalPoint3d() != null) continue;
            return false;
        }
        return true;
    }

    public static void fractionalToCartesian(Crystal crystal) {
        Atom[] atoms = crystal.getAtoms();
        double[] a = crystal.getA();
        double[] b = crystal.getB();
        double[] c = crystal.getC();
        for (int i = 0; i < atoms.length; ++i) {
            Point3d fracPoint = atoms[i].getFractionalPoint3d();
            if (fracPoint == null) continue;
            atoms[i].setPoint3d(CrystalGeometryTools.fractionalToCartesian(a, b, c, fracPoint));
        }
    }
}

