/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.ChemObject;

public class SetOfAtomContainers
extends ChemObject
implements Serializable,
Cloneable {
    protected AtomContainer[] atomContainers = new AtomContainer[this.growArraySize];
    protected int atomContainerCount = 0;
    protected double[] multipliers = new double[this.growArraySize];
    protected int growArraySize = 5;

    public void addAtomContainer(AtomContainer atomContainer) {
        this.addAtomContainer(atomContainer, 1.0);
    }

    public boolean setMultiplier(AtomContainer container, double multiplier) {
        for (int i = 0; i < this.atomContainers.length; ++i) {
            if (this.atomContainers[i] != container) continue;
            this.multipliers[i] = multiplier;
            return true;
        }
        return false;
    }

    public void setMultiplier(int position, double multiplier) {
        this.multipliers[position] = multiplier;
    }

    public double[] getMultipliers() {
        double[] returnArray = new double[this.atomContainerCount];
        System.arraycopy(this.multipliers, 0, returnArray, 0, this.atomContainerCount);
        return returnArray;
    }

    public boolean setMultipliers(double[] newMultipliers) {
        if (newMultipliers.length == this.atomContainerCount) {
            System.arraycopy(newMultipliers, 0, this.multipliers, 0, this.atomContainerCount);
            return true;
        }
        return false;
    }

    public void addAtomContainer(AtomContainer atomContainer, double multiplier) {
        if (this.atomContainerCount + 1 >= this.atomContainers.length) {
            this.growAtomContainerArray();
        }
        this.atomContainers[this.atomContainerCount] = atomContainer;
        this.multipliers[this.atomContainerCount] = multiplier;
        ++this.atomContainerCount;
    }

    public void add(SetOfAtomContainers atomContainerSet) {
        AtomContainer[] mols = atomContainerSet.getAtomContainers();
        for (int i = 0; i < mols.length; ++i) {
            this.addAtomContainer(mols[i]);
        }
    }

    public AtomContainer[] getAtomContainers() {
        AtomContainer[] result = new AtomContainer[this.atomContainerCount];
        System.arraycopy(this.atomContainers, 0, result, 0, result.length);
        return result;
    }

    public AtomContainer getAtomContainer(int number) {
        return this.atomContainers[number];
    }

    public double getMultiplier(int number) {
        return this.multipliers[number];
    }

    public double getMultiplier(AtomContainer container) {
        for (int i = 0; i < this.atomContainerCount; ++i) {
            if (!this.atomContainers[i].equals(container)) continue;
            return this.multipliers[i];
        }
        return -1.0;
    }

    protected void growAtomContainerArray() {
        this.growArraySize = this.atomContainers.length;
        AtomContainer[] newatomContainers = new AtomContainer[this.atomContainers.length + this.growArraySize];
        System.arraycopy(this.atomContainers, 0, newatomContainers, 0, this.atomContainers.length);
        this.atomContainers = newatomContainers;
        double[] newMultipliers = new double[this.multipliers.length + this.growArraySize];
        System.arraycopy(this.multipliers, 0, newMultipliers, 0, this.multipliers.length);
        this.multipliers = newMultipliers;
    }

    public int getAtomContainerCount() {
        return this.atomContainerCount;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SetOfAtomContainers(");
        buffer.append(this.hashCode() + ", ");
        buffer.append("M=" + this.getAtomContainerCount() + ", ");
        AtomContainer[] atomContainers = this.getAtomContainers();
        for (int i = 0; i < atomContainers.length; ++i) {
            buffer.append(atomContainers[i].toString());
        }
        buffer.append(")");
        return buffer.toString();
    }
}

