/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import org.openscience.cdk.Atom;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.Bond;
import org.openscience.cdk.ElectronContainer;
import org.openscience.cdk.Molecule;

public class Ring
extends AtomContainer
implements Serializable,
Cloneable {
    public Ring() {
    }

    public Ring(int ringSize, String elementSymbol) {
        this(ringSize);
        Atom[] atoms = new Atom[ringSize];
        atoms[0] = new Atom(elementSymbol);
        for (int i = 1; i < ringSize; ++i) {
            atoms[i] = new Atom(elementSymbol);
            this.addElectronContainer(new Bond(atoms[i - 1], atoms[i], 1.0));
        }
        this.addElectronContainer(new Bond(atoms[ringSize - 1], atoms[0], 1.0));
        this.setAtoms(atoms);
    }

    public Ring(int ringSize) {
        super(ringSize, ringSize);
    }

    public int getRingSize() {
        return this.atomCount;
    }

    public Bond getNextBond(Bond bond, Atom atom) {
        for (int f = 0; f < this.getElectronContainerCount(); ++f) {
            Bond tempBond;
            ElectronContainer ec = this.getElectronContainerAt(f);
            if (!(ec instanceof Bond) || !(tempBond = (Bond)ec).contains(atom) || bond == tempBond) continue;
            return tempBond;
        }
        return null;
    }

    public int getOrderSum() {
        int orderSum = 0;
        for (int i = 0; i < this.getElectronContainerCount(); ++i) {
            ElectronContainer ec = this.getElectronContainerAt(i);
            if (!(ec instanceof Bond)) continue;
            Bond tempBond = (Bond)ec;
            orderSum = (int)((double)orderSum + tempBond.getOrder());
        }
        return orderSum;
    }

    public String toString(Molecule molecule) {
        String str = "";
        for (int f = 0; f < this.getAtomCount(); ++f) {
            try {
                str = str + molecule.getAtomNumber(this.getAtomAt(f)) + " - ";
                continue;
            }
            catch (Exception exc) {
                // empty catch block
            }
        }
        return str;
    }
}

