/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.openscience.cdk.ChemObjectListener;
import org.openscience.cdk.event.ChemObjectChangeEvent;

public class ChemObject
implements Serializable,
Cloneable {
    private Vector chemObjects = null;
    private Hashtable properties = null;
    private boolean[] flags = new boolean[6];
    private Vector[] pointers = null;
    private String id = null;

    private Vector lazyChemObjects() {
        if (this.chemObjects == null) {
            this.chemObjects = new Vector();
        }
        return this.chemObjects;
    }

    public void addListener(ChemObjectListener col) {
        Vector listeners = this.lazyChemObjects();
        if (!listeners.contains(col)) {
            listeners.addElement(col);
        }
    }

    public void removeListener(ChemObjectListener col) {
        Vector listeners = this.lazyChemObjects();
        if (listeners.contains(col)) {
            listeners.removeElement(col);
        }
    }

    protected void notifyChanged() {
        Vector listeners = this.lazyChemObjects();
        for (int f = 0; f < listeners.size(); ++f) {
            ((ChemObjectListener)listeners.elementAt(f)).stateChanged(new ChemObjectChangeEvent((Object)this));
        }
    }

    private Hashtable lazyProperties() {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        return this.properties;
    }

    public void setProperty(Object description, Object property) {
        this.lazyProperties().put(description, property);
    }

    public void removeProperty(Object description) {
        this.lazyProperties().remove(description);
    }

    public Object getProperty(Object description) {
        return this.lazyProperties().get(description);
    }

    public Hashtable getProperties() {
        return this.lazyProperties();
    }

    public Object clone() {
        Object o = null;
        try {
            o = super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace(System.err);
        }
        ((ChemObject)o).flags = new boolean[6];
        for (int f = 0; f < this.flags.length; ++f) {
            ((ChemObject)o).flags[f] = this.flags[f];
        }
        return o;
    }

    public boolean compare(Object object) {
        if (!(object instanceof ChemObject)) {
            return false;
        }
        ChemObject chemObj = (ChemObject)object;
        return this.id == chemObj.id;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public void setFlag(int flag_type, boolean flag_value) {
        this.flags[flag_type] = flag_value;
    }

    public boolean getFlag(int flag_type) {
        return this.flags[flag_type];
    }

    private Vector[] lazyPointers() {
        if (this.pointers == null) {
            this.pointers = new Vector[1];
        }
        return this.pointers;
    }

    public void setPointer(int pointer_type, Vector pointer_value) {
        this.lazyPointers()[pointer_type] = pointer_value;
    }

    public Vector getPointer(int pointer_type) {
        return this.lazyPointers()[pointer_type];
    }

    public void setProperties(Hashtable properties) {
        Enumeration keys = properties.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            this.properties.put(key, properties.get(key));
        }
    }
}

