/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import java.util.Vector;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.Atom;
import org.openscience.cdk.ElectronContainer;

public class Bond
extends ElectronContainer
implements Serializable,
Cloneable {
    protected double order;
    protected int atomCount = 2;
    protected Atom[] atoms = new Atom[2];
    protected int stereo;

    public Bond() {
        this(null, null, 0.0, 0);
    }

    public Bond(Atom atom1, Atom atom2) {
        this(atom1, atom2, 1.0, 0);
    }

    public Bond(Atom atom1, Atom atom2, double order) {
        this(atom1, atom2, order, 0);
    }

    public Bond(Atom atom1, Atom atom2, double order, int stereo) {
        this.setAtomAt(atom1, 0);
        this.setAtomAt(atom2, 1);
        this.setOrder(order);
        this.setStereo(stereo);
    }

    public Atom[] getAtoms() {
        Atom[] returnAtoms = new Atom[this.getAtomCount()];
        System.arraycopy(this.atoms, 0, returnAtoms, 0, returnAtoms.length);
        return returnAtoms;
    }

    public Vector getAtomsVector() {
        Vector<Atom> atomsVector = new Vector<Atom>();
        for (int f = 0; f < this.getAtomCount(); ++f) {
            atomsVector.addElement(this.getAtomAt(f));
        }
        return atomsVector;
    }

    public void setAtoms(Atom[] atoms) {
        this.atoms = atoms;
    }

    public int getAtomCount() {
        return this.atomCount;
    }

    public Atom getAtomAt(int position) {
        return this.atoms[position];
    }

    public Atom getConnectedAtom(Atom atom) {
        if (this.atoms[0] == atom) {
            return this.atoms[1];
        }
        if (this.atoms[1] == atom) {
            return this.atoms[0];
        }
        return null;
    }

    public boolean contains(Atom atom) {
        if (this.atoms[0] == atom) {
            return true;
        }
        return this.atoms[1] == atom;
    }

    public void setAtomAt(Atom atom, int position) {
        this.atoms[position] = atom;
    }

    public double getOrder() {
        return this.order;
    }

    public void setOrder(double order) {
        this.order = order;
    }

    public int getStereo() {
        return this.stereo;
    }

    public void setStereo(int stereo) {
        this.stereo = stereo;
    }

    public Point2d get2DCenter() {
        double x = 0.0;
        double y = 0.0;
        for (int f = 0; f < this.getAtomCount(); ++f) {
            x += this.getAtomAt(f).getX2d();
            y += this.getAtomAt(f).getY2d();
        }
        return new Point2d(x / (double)this.getAtomCount(), y / (double)this.getAtomCount());
    }

    public Point3d get3DCenter() {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        for (int f = 0; f < this.getAtomCount(); ++f) {
            x += this.getAtomAt(f).getX3d();
            y += this.getAtomAt(f).getY3d();
            z += this.getAtomAt(f).getZ3d();
        }
        return new Point3d(x / (double)this.getAtomCount(), y / (double)this.getAtomCount(), z / (double)this.getAtomCount());
    }

    public boolean compare(Object object) {
        if (object instanceof Bond) {
            Bond bond = (Bond)object;
            for (int i = 0; i < this.atoms.length; ++i) {
                if (bond.contains(this.atoms[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isConnectedTo(Bond bond) {
        for (int f = 0; f < this.getAtomCount(); ++f) {
            if (!bond.contains(this.getAtomAt(f))) continue;
            return true;
        }
        return false;
    }

    public Object clone() {
        Bond o = null;
        try {
            o = (Bond)super.clone();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return o;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("Bond(");
        s.append(this.hashCode());
        s.append(", #O:" + this.getOrder());
        s.append(", #S:" + this.getStereo());
        Atom[] atoms = this.getAtoms();
        s.append(", #A:" + atoms.length);
        for (int i = 0; i < atoms.length; ++i) {
            if (atoms[i] == null) {
                s.append(", null");
                continue;
            }
            s.append(", " + atoms[i].toString());
        }
        s.append(")");
        return s.toString();
    }
}

