/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.awt.Component;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import org.jmol.g3d.Platform3D;

final class Awt3D
extends Platform3D
implements ImageProducer {
    Component component;
    ColorModel colorModelRGB;
    ImageConsumer ic;

    Awt3D(Component component) {
        this.component = component;
        this.colorModelRGB = ColorModel.getRGBdefault();
    }

    void allocatePixelBuffer() {
        this.pBuffer = new int[this.size];
        this.imagePixelBuffer = this.component.createImage(this);
    }

    void notifyEndOfRendering() {
        if (this.ic != null) {
            this.startProduction(this.ic);
        }
    }

    Image allocateOffscreenImage(int width, int height) {
        Image img = this.component.createImage(width, height);
        return img;
    }

    void clearScreenBuffer(int argbBackground) {
        int i = this.width;
        while (--i >= 0) {
            this.zBuffer[i] = Short.MAX_VALUE;
            this.pBuffer[i] = argbBackground;
        }
        i = this.height;
        int offset = this.size;
        while (--i > 0) {
            System.arraycopy(this.pBuffer, 0, this.pBuffer, offset -= this.width, this.width);
            System.arraycopy(this.zBuffer, 0, this.zBuffer, offset, this.width);
        }
    }

    public synchronized void addConsumer(ImageConsumer ic) {
        this.startProduction(ic);
    }

    public boolean isConsumer(ImageConsumer ic) {
        return this.ic == ic;
    }

    public void removeConsumer(ImageConsumer ic) {
        if (this.ic == ic) {
            this.ic = null;
        }
    }

    public void requestTopDownLeftRightResend(ImageConsumer ic) {
    }

    public void startProduction(ImageConsumer ic) {
        if (this.ic != ic) {
            this.ic = ic;
            ic.setDimensions(this.width, this.height);
            ic.setHints(14);
        }
        ic.setPixels(0, 0, this.width, this.height, this.colorModelRGB, this.pBuffer, 0, this.width);
        ic.imageComplete(2);
    }
}

