/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.jcon.protocol;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Map;
import org.apache.log4j.Category;
import org.apache.velocity.VelocityContext;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.io.SeqIOTools;
import uk.ac.sanger.jcon.JobControlException;
import uk.ac.sanger.jcon.job.BatchJob;
import uk.ac.sanger.jcon.job.Job;
import uk.ac.sanger.jcon.job.Owner;
import uk.ac.sanger.jcon.job.TaskDefaultImpl;
import uk.ac.sanger.jcon.protocol.ConfigurableProtocol;
import uk.ac.sanger.jcon.util.Configuration;

public class DdiscoideumDeNovo
extends ConfigurableProtocol {
    static Category cat = Category.getInstance((String)(class$uk$ac$sanger$jcon$protocol$DdiscoideumDeNovo == null ? (class$uk$ac$sanger$jcon$protocol$DdiscoideumDeNovo = DdiscoideumDeNovo.class$("uk.ac.sanger.jcon.protocol.DdiscoideumDeNovo")) : class$uk$ac$sanger$jcon$protocol$DdiscoideumDeNovo).getName());
    static /* synthetic */ Class class$uk$ac$sanger$jcon$protocol$DdiscoideumDeNovo;

    public void apply(String ownerName, Map config, String[] data) throws Exception {
        if (ownerName == null) {
            throw new IllegalArgumentException("ownerName was null");
        }
        Owner owner = this.admin.getOwnerByUserName(ownerName);
        int i = 0;
        while (i < data.length) {
            try {
                this.applySingle(owner, data[i]);
            }
            catch (Exception e) {
                System.err.println("Exception while processing '" + data[i] + "'. Skipping this element");
                e.printStackTrace();
            }
            ++i;
        }
    }

    private void applySingle(Owner owner, String arg) throws Exception {
        BufferedReader br = new BufferedReader(new FileReader(arg));
        SequenceIterator seqI = SeqIOTools.readFastaDNA((BufferedReader)br);
        String ntSuffix = this.config.getString(Configuration.FASTA_NT_EXTENSION_KEY);
        String aaSuffix = this.config.getString(Configuration.FASTA_AA_EXTENSION_KEY);
        String emSuffix = this.config.getString(Configuration.EMBL_EXTENSION_KEY);
        String tabSuffix = this.config.getString(Configuration.FTABLE_EXTENSION_KEY);
        String inpSuffix = this.config.getString(Configuration.INPUT_EXTENSION_KEY);
        String outSuffix = this.config.getString(Configuration.OUTPUT_EXTENSION_KEY);
        String errSuffix = this.config.getString(Configuration.ERROR_EXTENSION_KEY);
        String queue = this.config.getString(Configuration.EXEC_QUEUE_KEY);
        String workDirectory = System.getProperty("user.dir");
        String geneidLogName = "geneid.log";
        String geneid2tabLogName = "geneid2tab.log";
        String merge2emblLogName = "merge2embl.log";
        String createidsLogName = "createids.log";
        String translateLogName = "translate.log";
        String catLogName = "cat.log";
        String trnascanLogName = "trnascan.log";
        VelocityContext context = new VelocityContext();
        context.put("executable", (Object)"<Error: this should not have been expanded>");
        BatchJob rootJob = this.createEmptyBatchJob(queue);
        rootJob.setWorkDirectoryName(workDirectory);
        while (seqI.hasNext()) {
            Sequence seq = seqI.nextSequence();
            String name = seq.getName();
            if (name.equals("")) {
                throw new JobControlException("Sequence used empty string as identifier");
            }
            String ntFileName = name + "." + ntSuffix;
            File ntFile = new File(workDirectory, ntFileName);
            if (!ntFile.exists()) {
                this.writeFasta(seq, ntFile);
            }
            String geneidOutName = name + ".geneid." + outSuffix;
            String geneid2tabOutName = name + ".geneid.cds." + tabSuffix;
            String trnascanOutName = name + ".trnscan." + outSuffix;
            String merge2emblOutName = name + "." + emSuffix;
            String createidsOutName = name + ".ids." + emSuffix;
            String translateOutName = name + "." + aaSuffix;
            String concatTranslateOutName = arg + "." + aaSuffix;
            String trnascanParseOutName = name + ".trnas";
            context = new VelocityContext();
            context.put("executable", (Object)"<Error: this should not have been expanded>");
            context.put("input_name", (Object)ntFileName);
            context.put("output_name", (Object)geneidOutName);
            Job geneidRun = this.createJob(new String[]{null, geneidLogName, null}, context, "d_discoideum", "geneid");
            geneidRun.setWorkDirectoryName(workDirectory);
            context.put("input_name", (Object)geneidOutName);
            context.put("output_name1", (Object)geneid2tabOutName);
            context.put("output_name2", (Object)"/dev/null");
            Job geneidParse = this.createJob(new String[]{null, geneid2tabLogName, null}, context, "d_discoideum", "geneid2tab");
            geneidParse.setWorkDirectoryName(workDirectory);
            geneidParse.add(geneidRun);
            context.put("input_name2", (Object)geneid2tabOutName);
            Job merge2emblRun = this.createJob(new String[]{ntFileName, merge2emblLogName, null}, context, "d_discoideum", "merge2embl");
            merge2emblRun.setWorkDirectoryName(workDirectory);
            merge2emblRun.add(geneidParse);
            context.put("input_name", (Object)name);
            context.put("output_name", (Object)createidsOutName);
            Job createidsRun = this.createJob(new String[]{merge2emblOutName, createidsLogName, null}, context, "d_discoideum", "create_ids");
            createidsRun.setWorkDirectoryName(workDirectory);
            createidsRun.add(merge2emblRun);
            context.put("output_name", (Object)translateOutName);
            Job translateRun = this.createJob(new String[]{createidsOutName, translateLogName, null}, context, "d_discoideum", "translate_features");
            translateRun.setWorkDirectoryName(workDirectory);
            translateRun.add(createidsRun);
            rootJob.add(translateRun);
            context.put("input_name", (Object)ntFileName);
            context.put("output_name", (Object)trnascanOutName);
            Job trnascanRun = this.createJob(new String[]{null, trnascanLogName, null}, context, "d_discoideum", "trnascanse");
            trnascanRun.setWorkDirectoryName(workDirectory);
            context.put("output_name", (Object)trnascanParseOutName);
            Job trnascanParse = this.createJob(new String[]{trnascanOutName, trnascanLogName, null}, context, "d_discoideum", "trnascanse2tab");
            trnascanParse.setWorkDirectoryName(workDirectory);
            trnascanParse.add(trnascanRun);
            rootJob.add(trnascanParse);
        }
        TaskDefaultImpl task = new TaskDefaultImpl("d_discoideum_denovo", "D. discoideum de novo gene prediction", owner);
        task.setJobs(new Job[]{rootJob});
        int taskId = this.manager.createTask(task);
        this.manager.submitTask(taskId);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

