/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.jcon.lsf;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Category;
import uk.ac.sanger.jcon.lsf.LSFBatchException;
import uk.ac.sanger.jcon.lsf.LSFJobInfo;
import uk.ac.sanger.jcon.run.BufferedStringSink;

public final class LSFBjobsExec {
    static Category cat = Category.getInstance((String)(class$uk$ac$sanger$jcon$lsf$LSFBjobsExec == null ? (class$uk$ac$sanger$jcon$lsf$LSFBjobsExec = LSFBjobsExec.class$("uk.ac.sanger.jcon.lsf.LSFBjobsExec")) : class$uk$ac$sanger$jcon$lsf$LSFBjobsExec).getName());
    private static final LSFBjobsExec INSTANCE = new LSFBjobsExec();
    static /* synthetic */ Class class$uk$ac$sanger$jcon$lsf$LSFBjobsExec;

    private LSFBjobsExec() {
    }

    public static LSFBjobsExec getInstance() {
        return INSTANCE;
    }

    public List getJobInfo(Set lsfJobIds) throws LSFBatchException {
        ArrayList<String> bjobsCommand = new ArrayList<String>();
        bjobsCommand.add("bjobs_plus");
        ArrayList lsfJobInfo = new ArrayList();
        try {
            try {
                Runtime runtime = Runtime.getRuntime();
                String[] tokens = bjobsCommand.toArray(new String[0]);
                Process process = runtime.exec(tokens);
                BufferedStringSink stderrSink = new BufferedStringSink(process.getErrorStream());
                stderrSink.start();
                Parser parser = new Parser(process.getInputStream(), lsfJobIds, lsfJobInfo);
                Thread thread = new Thread(parser);
                thread.start();
                int exitValue = process.waitFor();
                stderrSink.join();
                thread.join();
                String stderr = stderrSink.getBuffer().substring(0);
                if (exitValue != 0) {
                    throw new LSFBatchException("Recieved exit code " + exitValue + "from bjobs with stderr '" + stderr + "'");
                }
                Object var13_15 = null;
                process = null;
            }
            catch (InterruptedException ie) {
                cat.error((Object)"Caught Exception while getting Job info", (Throwable)ie);
                throw new LSFBatchException("Failed to get Job info from LSF");
            }
            catch (IOException ioe) {
                cat.error((Object)"Caught Exception while getting Job info", (Throwable)ioe);
                throw new LSFBatchException("Failed to get Job info from LSF");
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            Object process = null;
            throw throwable;
        }
        return lsfJobInfo;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Parser
    implements Runnable {
        BufferedReader br;
        Set lsfJobIds;
        List target;

        Parser(InputStream is, Set lsfJobIds, List target) {
            this.br = new BufferedReader(new InputStreamReader(is));
            this.lsfJobIds = lsfJobIds;
            this.target = target;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            String line = null;
            try {
                while (true) {
                    if ((line = this.br.readLine()) == null) {
                        return;
                    }
                    try {
                        LSFJobInfo info = this.parseLine(line);
                        Integer lsfJobId = new Integer(info.getJobId());
                        if (!this.lsfJobIds.contains(lsfJobId)) continue;
                        this.target.add(info);
                    }
                    catch (NumberFormatException nfe) {
                        cat.error((Object)("Caught Exception while parsing line '" + line + "'"), (Throwable)nfe);
                    }
                }
            }
            catch (IOException ioe) {
                cat.error((Object)"Caught Exception", (Throwable)ioe);
                return;
            }
        }

        private LSFJobInfo parseLine(String line) {
            String[] tokens = this.tokenize(line, ",");
            int jobId = Integer.parseInt(tokens[0]);
            String user = tokens[1];
            int status = Integer.parseInt(tokens[2]);
            String fromHost = tokens[3];
            String[] exHosts = this.tokenize(tokens[4], " ");
            int exitValue = Integer.parseInt(tokens[5]);
            return new LSFJobInfo(jobId, user, status, exitValue, fromHost, exHosts);
        }

        private String[] tokenize(String line, String delim) {
            if (line.equals("null")) {
                return new String[0];
            }
            if (line.indexOf(delim) == -1) {
                return new String[]{line};
            }
            StringTokenizer st = new StringTokenizer(line, delim);
            int tokenCount = st.countTokens();
            String[] tokens = new String[tokenCount];
            int i = 0;
            while (i < tokenCount) {
                tokens[i] = st.nextToken();
                ++i;
            }
            return tokens;
        }
    }
}

