/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.jcon.gui;

import java.awt.Component;
import java.awt.Font;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeModel;
import uk.ac.sanger.jcon.dao.TaskSQLDAO;
import uk.ac.sanger.jcon.gui.JobTreeCellRenderer;
import uk.ac.sanger.jcon.job.Job;
import uk.ac.sanger.jcon.job.Task;

public class JobViewer
extends JFrame {
    private Job[] rootJobs;
    private int currentJobIndex;
    private DefaultTreeModel model;
    private JTree tree;
    private JScrollPane treePane;
    private TreeModelListener repaintListener = new TreeModelListener(){

        public void treeNodesChanged(TreeModelEvent tme) {
            JobViewer.this.repaint();
        }

        public void treeNodesInserted(TreeModelEvent tme) {
            this.treeNodesChanged(tme);
        }

        public void treeNodesRemoved(TreeModelEvent tme) {
            this.treeNodesChanged(tme);
        }

        public void treeStructureChanged(TreeModelEvent tme) {
            this.treeNodesChanged(tme);
        }
    };

    public static void main(String[] argv) throws Exception {
        InitialContext context = new InitialContext();
        DataSource datasource = (DataSource)context.lookup("jdbc/JobControl");
        JobViewer viewer = new JobViewer(datasource, Integer.parseInt(argv[0]));
        viewer.setSize(400, 600);
        viewer.setVisible(true);
    }

    public JobViewer(DataSource datasource, int taskId) throws Exception {
        TaskSQLDAO taskSQLDAO = new TaskSQLDAO(datasource);
        Task task = taskSQLDAO.readTaskById(taskId, 0);
        this.rootJobs = task.getJobs();
        this.currentJobIndex = this.rootJobs.length - 1;
        this.initComponents();
    }

    private void initComponents() throws Exception {
        this.model = new DefaultTreeModel(this.rootJobs[this.currentJobIndex]);
        this.tree = new JTree(this.model);
        this.treePane = new JScrollPane(this.tree);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setCellRenderer(new JobTreeCellRenderer());
        this.tree.setFont(new Font("Sanserif", 0, 11));
        this.model.addTreeModelListener(this.repaintListener);
        this.getContentPane().add((Component)this.treePane, "Center");
        this.setDefaultCloseOperation(3);
    }

    public Job[] getJobs() {
        return this.rootJobs;
    }

    public void setJobs(Job[] rootJobs) {
        this.rootJobs = rootJobs;
        this.setCurrentJobIndex(rootJobs.length - 1);
    }

    public void setCurrentJobIndex(int currentJobIndex) {
        this.currentJobIndex = currentJobIndex;
        Job rootJob = this.rootJobs[currentJobIndex];
        this.model.setRoot(rootJob);
        this.model.nodeStructureChanged(rootJob);
        int i = this.tree.getRowCount();
        while (i-- >= 0) {
            this.tree.expandRow(i);
        }
    }
}

