/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import IceInternal.Acceptor;
import IceInternal.BasicStream;
import IceInternal.Connector;
import IceInternal.Endpoint;
import IceInternal.EndpointHolder;
import IceInternal.Instance;
import IceInternal.Transceiver;

final class UnknownEndpoint
implements Endpoint {
    private Instance _instance;
    private short _type;
    private byte[] _rawBytes;
    private int _hashCode;

    public UnknownEndpoint(short type, BasicStream s) {
        this._instance = s.instance();
        this._type = type;
        s.startReadEncaps();
        int sz = s.getReadEncapsSize();
        this._rawBytes = s.readBlob(sz);
        s.endReadEncaps();
        this.calcHashValue();
    }

    public void streamWrite(BasicStream s) {
        s.writeShort(this._type);
        s.startWriteEncaps();
        s.writeBlob(this._rawBytes);
        s.endWriteEncaps();
    }

    public String toString() {
        return "";
    }

    public short type() {
        return this._type;
    }

    public int timeout() {
        return -1;
    }

    public Endpoint timeout(int t) {
        return this;
    }

    public boolean compress() {
        return false;
    }

    public Endpoint compress(boolean compress) {
        return this;
    }

    public boolean datagram() {
        return false;
    }

    public boolean secure() {
        return false;
    }

    public boolean unknown() {
        return true;
    }

    public Transceiver clientTransceiver() {
        return null;
    }

    public Transceiver serverTransceiver(EndpointHolder endpoint) {
        endpoint.value = null;
        return null;
    }

    public Connector connector() {
        return null;
    }

    public Acceptor acceptor(EndpointHolder endpoint) {
        endpoint.value = null;
        return null;
    }

    public boolean equivalent(Transceiver transceiver) {
        return false;
    }

    public boolean equivalent(Acceptor acceptor) {
        return false;
    }

    public int hashCode() {
        return this._hashCode;
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public int compareTo(Object obj) {
        UnknownEndpoint p = null;
        try {
            p = (UnknownEndpoint)obj;
        }
        catch (ClassCastException ex) {
            return 1;
        }
        if (this == p) {
            return 0;
        }
        if (this._type < p._type) {
            return -1;
        }
        if (p._type < this._type) {
            return 1;
        }
        if (this._rawBytes.length < p._rawBytes.length) {
            return -1;
        }
        if (p._rawBytes.length < this._rawBytes.length) {
            return 1;
        }
        for (int i = 0; i < this._rawBytes.length; ++i) {
            if (this._rawBytes[i] < p._rawBytes[i]) {
                return -1;
            }
            if (p._rawBytes[i] >= this._rawBytes[i]) continue;
            return 1;
        }
        return 0;
    }

    private void calcHashValue() {
        this._hashCode = this._type;
        for (int i = 0; i < this._rawBytes.length; ++i) {
            this._hashCode = 5 * this._hashCode + this._rawBytes[i];
        }
    }
}

