/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.DNSException;
import Ice.EndpointParseException;
import Ice.UnsupportedEncodingException;
import Ice.UnsupportedProtocolException;
import IceInternal.Acceptor;
import IceInternal.BasicStream;
import IceInternal.Connector;
import IceInternal.Endpoint;
import IceInternal.EndpointHolder;
import IceInternal.Instance;
import IceInternal.Network;
import IceInternal.Transceiver;
import IceInternal.UdpTransceiver;
import java.net.InetSocketAddress;

final class UdpEndpoint
implements Endpoint {
    static final short TYPE = 3;
    private Instance _instance;
    private String _host;
    private int _port;
    private byte _protocolMajor;
    private byte _protocolMinor;
    private byte _encodingMajor;
    private byte _encodingMinor;
    private boolean _connect;
    private boolean _compress;
    private int _hashCode;
    static final /* synthetic */ boolean $assertionsDisabled;

    public UdpEndpoint(Instance instance, String ho, int po, boolean co) {
        this._instance = instance;
        this._host = ho;
        this._port = po;
        this._protocolMajor = 1;
        this._protocolMinor = 0;
        this._encodingMajor = 1;
        this._encodingMinor = 0;
        this._connect = false;
        this._compress = co;
        this.calcHashValue();
    }

    public UdpEndpoint(Instance instance, String str) {
        this._instance = instance;
        this._host = null;
        this._port = 0;
        this._protocolMajor = 1;
        this._protocolMinor = 0;
        this._encodingMajor = 1;
        this._encodingMinor = 0;
        this._connect = false;
        this._compress = false;
        String[] arr = str.split("[ \t\n\r]+");
        int i = 0;
        block14: while (i < arr.length) {
            String option;
            if (arr[i].length() == 0) {
                ++i;
                continue;
            }
            if ((option = arr[i++]).length() != 2 || option.charAt(0) != '-') {
                EndpointParseException e = new EndpointParseException();
                e.str = "udp " + str;
                throw e;
            }
            String argument = null;
            if (i < arr.length && arr[i].charAt(0) != '-') {
                argument = arr[i++];
            }
            switch (option.charAt(1)) {
                case 'v': {
                    int minVersion;
                    int majVersion;
                    EndpointParseException e;
                    if (argument == null) {
                        EndpointParseException e2 = new EndpointParseException();
                        e2.str = "udp " + str;
                        throw e2;
                    }
                    int pos = argument.indexOf(46);
                    if (pos == -1) {
                        e = new EndpointParseException();
                        e.str = "udp " + str;
                        throw e;
                    }
                    String majStr = argument.substring(0, pos);
                    String minStr = argument.substring(pos + 1, argument.length());
                    try {
                        majVersion = Integer.parseInt(majStr);
                        minVersion = Integer.parseInt(minStr);
                    }
                    catch (NumberFormatException ex) {
                        EndpointParseException e3 = new EndpointParseException();
                        e3.str = "udp " + str;
                        throw e3;
                    }
                    if (majVersion < 1 || majVersion > 255 || minVersion < 0 || minVersion > 255) {
                        EndpointParseException e4 = new EndpointParseException();
                        e4.str = "udp " + str;
                        throw e4;
                    }
                    if (majVersion != 1) {
                        UnsupportedProtocolException e5 = new UnsupportedProtocolException();
                        e5.badMajor = majVersion < 0 ? majVersion + 255 : majVersion;
                        e5.badMinor = minVersion < 0 ? minVersion + 255 : minVersion;
                        e5.major = 1;
                        e5.minor = 0;
                        throw e5;
                    }
                    this._protocolMajor = (byte)majVersion;
                    this._protocolMinor = (byte)minVersion;
                    continue block14;
                }
                case 'e': {
                    int minVersion;
                    int majVersion;
                    EndpointParseException e;
                    if (argument == null) {
                        EndpointParseException e6 = new EndpointParseException();
                        e6.str = "udp " + str;
                        throw e6;
                    }
                    int pos = argument.indexOf(46);
                    if (pos == -1) {
                        e = new EndpointParseException();
                        e.str = "udp " + str;
                        throw e;
                    }
                    String majStr = argument.substring(0, pos);
                    String minStr = argument.substring(pos + 1, argument.length());
                    try {
                        majVersion = Integer.parseInt(majStr);
                        minVersion = Integer.parseInt(minStr);
                    }
                    catch (NumberFormatException ex) {
                        EndpointParseException e7 = new EndpointParseException();
                        e7.str = "udp " + str;
                        throw e7;
                    }
                    if (majVersion < 1 || majVersion > 255 || minVersion < 0 || minVersion > 255) {
                        EndpointParseException e8 = new EndpointParseException();
                        e8.str = "udp " + str;
                        throw e8;
                    }
                    if (majVersion != 1) {
                        UnsupportedEncodingException e9 = new UnsupportedEncodingException();
                        e9.badMajor = majVersion < 0 ? majVersion + 255 : majVersion;
                        e9.badMinor = minVersion < 0 ? minVersion + 255 : minVersion;
                        e9.major = 1;
                        e9.minor = 0;
                        throw e9;
                    }
                    this._encodingMajor = (byte)majVersion;
                    this._encodingMinor = (byte)minVersion;
                    continue block14;
                }
                case 'h': {
                    if (argument == null) {
                        EndpointParseException e = new EndpointParseException();
                        e.str = "udp " + str;
                        throw e;
                    }
                    this._host = argument;
                    continue block14;
                }
                case 'p': {
                    EndpointParseException e;
                    if (argument == null) {
                        EndpointParseException e10 = new EndpointParseException();
                        e10.str = "udp " + str;
                        throw e10;
                    }
                    try {
                        this._port = Integer.parseInt(argument);
                        continue block14;
                    }
                    catch (NumberFormatException ex) {
                        e = new EndpointParseException();
                        e.str = "udp " + str;
                        throw e;
                    }
                }
                case 'c': {
                    if (argument != null) {
                        EndpointParseException e = new EndpointParseException();
                        e.str = "udp " + str;
                        throw e;
                    }
                    this._connect = true;
                    continue block14;
                }
                case 'z': {
                    if (argument != null) {
                        EndpointParseException e = new EndpointParseException();
                        e.str = "udp " + str;
                        throw e;
                    }
                    this._compress = true;
                    continue block14;
                }
            }
            EndpointParseException e = new EndpointParseException();
            e.str = "udp " + str;
            throw e;
        }
        if (this._host == null) {
            this._host = instance.defaultsAndOverrides().defaultHost;
        }
        this.calcHashValue();
    }

    public UdpEndpoint(BasicStream s) {
        this._instance = s.instance();
        s.startReadEncaps();
        this._host = s.readString();
        this._port = s.readInt();
        this._protocolMajor = s.readByte();
        this._protocolMinor = s.readByte();
        this._encodingMajor = s.readByte();
        this._encodingMinor = s.readByte();
        if (this._protocolMajor != 1) {
            UnsupportedProtocolException e = new UnsupportedProtocolException();
            e.badMajor = this._protocolMajor < 0 ? this._protocolMajor + 255 : this._protocolMajor;
            e.badMinor = this._protocolMinor < 0 ? this._protocolMinor + 255 : this._protocolMinor;
            e.major = 1;
            e.minor = 0;
            throw e;
        }
        if (this._encodingMajor != 1) {
            UnsupportedEncodingException e = new UnsupportedEncodingException();
            e.badMajor = this._encodingMajor < 0 ? this._encodingMajor + 255 : this._encodingMajor;
            e.badMinor = this._encodingMinor < 0 ? this._encodingMinor + 255 : this._encodingMinor;
            e.major = 1;
            e.minor = 0;
            throw e;
        }
        this._connect = false;
        this._compress = s.readBool();
        s.endReadEncaps();
        this.calcHashValue();
    }

    public void streamWrite(BasicStream s) {
        s.writeShort((short)3);
        s.startWriteEncaps();
        s.writeString(this._host);
        s.writeInt(this._port);
        s.writeByte(this._protocolMajor);
        s.writeByte(this._protocolMinor);
        s.writeByte(this._encodingMajor);
        s.writeByte(this._encodingMinor);
        s.writeBool(this._compress);
        s.endWriteEncaps();
    }

    public String toString() {
        String s = "udp";
        s = s + " -v " + (this._protocolMajor < 0 ? this._protocolMajor + 255 : this._protocolMajor) + "." + (this._protocolMinor < 0 ? this._protocolMinor + 255 : this._protocolMinor);
        s = s + " -e " + (this._encodingMajor < 0 ? this._encodingMajor + 255 : this._encodingMajor) + "." + (this._encodingMinor < 0 ? this._encodingMinor + 255 : this._encodingMinor);
        s = s + " -h " + this._host + " -p " + this._port;
        if (this._connect) {
            s = s + " -c";
        }
        if (this._compress) {
            s = s + " -z";
        }
        return s;
    }

    public short type() {
        return 3;
    }

    public int timeout() {
        return -1;
    }

    public boolean compress() {
        return this._compress;
    }

    public Endpoint compress(boolean compress) {
        if (compress == this._compress) {
            return this;
        }
        return new UdpEndpoint(this._instance, this._host, this._port, compress);
    }

    public Endpoint timeout(int timeout) {
        return this;
    }

    public boolean datagram() {
        return true;
    }

    public boolean secure() {
        return false;
    }

    public boolean unknown() {
        return false;
    }

    public Transceiver clientTransceiver() {
        return new UdpTransceiver(this._instance, this._host, this._port);
    }

    public Transceiver serverTransceiver(EndpointHolder endpoint) {
        UdpTransceiver p = new UdpTransceiver(this._instance, this._host, this._port, this._connect);
        endpoint.value = new UdpEndpoint(this._instance, this._host, p.effectivePort(), this._compress);
        return p;
    }

    public Connector connector() {
        return null;
    }

    public Acceptor acceptor(EndpointHolder endpoint) {
        endpoint.value = this;
        return null;
    }

    public boolean equivalent(Transceiver transceiver) {
        UdpTransceiver udpTransceiver = null;
        try {
            udpTransceiver = (UdpTransceiver)transceiver;
        }
        catch (ClassCastException ex) {
            return false;
        }
        return udpTransceiver.equivalent(this._host, this._port);
    }

    public boolean equivalent(Acceptor acceptor) {
        return false;
    }

    public int hashCode() {
        return this._hashCode;
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public int compareTo(Object obj) {
        UdpEndpoint p = null;
        try {
            p = (UdpEndpoint)obj;
        }
        catch (ClassCastException ex) {
            return 1;
        }
        if (this == p) {
            return 0;
        }
        if (this._port < p._port) {
            return -1;
        }
        if (p._port < this._port) {
            return 1;
        }
        if (!this._connect && p._connect) {
            return -1;
        }
        if (!p._connect && this._connect) {
            return 1;
        }
        if (!this._compress && p._compress) {
            return -1;
        }
        if (!p._compress && this._compress) {
            return 1;
        }
        if (this._protocolMajor < p._protocolMajor) {
            return -1;
        }
        if (p._protocolMajor < this._protocolMajor) {
            return 1;
        }
        if (this._protocolMinor < p._protocolMinor) {
            return -1;
        }
        if (p._protocolMinor < this._protocolMinor) {
            return 1;
        }
        if (this._encodingMajor < p._encodingMajor) {
            return -1;
        }
        if (p._encodingMajor < this._encodingMajor) {
            return 1;
        }
        if (this._encodingMinor < p._encodingMinor) {
            return -1;
        }
        if (p._encodingMinor < this._encodingMinor) {
            return 1;
        }
        if (!this._host.equals(p._host)) {
            InetSocketAddress laddr = null;
            try {
                laddr = Network.getAddress(this._host, this._port);
            }
            catch (DNSException ex) {
                // empty catch block
            }
            InetSocketAddress raddr = null;
            try {
                raddr = Network.getAddress(p._host, p._port);
            }
            catch (DNSException ex) {
                // empty catch block
            }
            if (laddr == null && raddr != null) {
                return -1;
            }
            if (raddr == null && laddr != null) {
                return 1;
            }
            if (laddr != null && raddr != null) {
                byte[] larr = laddr.getAddress().getAddress();
                byte[] rarr = raddr.getAddress().getAddress();
                if (!$assertionsDisabled && larr.length != rarr.length) {
                    throw new AssertionError();
                }
                for (int i = 0; i < larr.length; ++i) {
                    if (larr[i] < rarr[i]) {
                        return -1;
                    }
                    if (rarr[i] >= larr[i]) continue;
                    return 1;
                }
            }
        }
        return 0;
    }

    private void calcHashValue() {
        this._hashCode = this._host.hashCode();
        this._hashCode = 5 * this._hashCode + this._port;
        this._hashCode = 5 * this._hashCode + (this._connect ? 1 : 0);
        this._hashCode = 5 * this._hashCode + (this._compress ? 1 : 0);
    }

    static {
        $assertionsDisabled = !UdpEndpoint.class.desiredAssertionStatus();
    }
}

