/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.CloseConnectionException;
import Ice.FacetNotExistException;
import Ice.Identity;
import Ice.LocalException;
import Ice.MarshalException;
import Ice.ObjectNotExistException;
import Ice.OperationMode;
import Ice.OperationNotExistException;
import Ice.RequestFailedException;
import Ice.TimeoutException;
import Ice.UnknownException;
import Ice.UnknownLocalException;
import Ice.UnknownReplyStatusException;
import Ice.UnknownUserException;
import IceInternal.BasicStream;
import IceInternal.Connection;
import IceInternal.NonRepeatable;
import IceInternal.Reference;
import java.util.Iterator;
import java.util.Map;

public final class Outgoing {
    private Connection _connection;
    private Reference _reference;
    private LocalException _exception;
    private static final int StateUnsent = 0;
    private static final int StateInProgress = 1;
    private static final int StateOK = 2;
    private static final int StateUserException = 3;
    private static final int StateLocalException = 4;
    private int _state;
    private BasicStream _is;
    private BasicStream _os;
    public Outgoing next;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Outgoing(Connection connection, Reference ref, String operation, OperationMode mode, Map context) {
        this._connection = connection;
        this._reference = ref;
        this._state = 0;
        this._is = new BasicStream(ref.instance);
        this._os = new BasicStream(ref.instance);
        this.writeHeader(operation, mode, context);
    }

    public void destroy() {
        if (!$assertionsDisabled && this._is == null) {
            throw new AssertionError();
        }
        this._is.destroy();
        this._is = null;
        if (!$assertionsDisabled && this._os == null) {
            throw new AssertionError();
        }
        this._os.destroy();
        this._os = null;
    }

    public void reset(String operation, OperationMode mode, Map context) {
        this._state = 0;
        this._exception = null;
        if (!$assertionsDisabled && this._is == null) {
            throw new AssertionError();
        }
        this._is.reset();
        if (!$assertionsDisabled && this._os == null) {
            throw new AssertionError();
        }
        this._os.reset();
        this.writeHeader(operation, mode, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invoke() throws NonRepeatable {
        this._os.endWriteEncaps();
        switch (this._reference.mode) {
            case 0: {
                this._connection.sendRequest(this._os, this);
                boolean timedOut = false;
                Outgoing outgoing = this;
                synchronized (outgoing) {
                    if (this._state == 0) {
                        this._state = 1;
                    }
                    int timeout = this._connection.timeout();
                    while (this._state == 1 && !timedOut) {
                        try {
                            if (timeout >= 0) {
                                this.wait(timeout);
                                if (this._state != 1) continue;
                                timedOut = true;
                                continue;
                            }
                            this.wait();
                        }
                        catch (InterruptedException ex) {}
                    }
                }
                if (timedOut) {
                    this._connection.exception(new TimeoutException());
                    outgoing = this;
                    synchronized (outgoing) {
                        while (this._state == 1) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                }
                if (this._exception != null) {
                    this._exception.fillInStackTrace();
                    if (this._exception instanceof CloseConnectionException) {
                        throw this._exception;
                    }
                    throw new NonRepeatable(this._exception);
                }
                if (this._state == 3) {
                    return false;
                }
                if (!$assertionsDisabled && this._state != 2) {
                    throw new AssertionError();
                }
                break;
            }
            case 1: 
            case 3: {
                this._connection.sendRequest(this._os, null);
                break;
            }
            case 2: 
            case 4: {
                this._connection.finishBatchRequest(this._os);
            }
        }
        return true;
    }

    public synchronized void finished(BasicStream is) {
        if (!$assertionsDisabled && this._reference.mode != 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this._state > 1) {
            throw new AssertionError();
        }
        this._is.swap(is);
        byte status = this._is.readByte();
        switch (status) {
            case 0: {
                this._is.startReadEncaps();
                this._state = 2;
                break;
            }
            case 1: {
                this._is.startReadEncaps();
                this._state = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                RequestFailedException ex = null;
                switch (status) {
                    case 2: {
                        ex = new ObjectNotExistException();
                        break;
                    }
                    case 3: {
                        ex = new FacetNotExistException();
                        break;
                    }
                    case 4: {
                        ex = new OperationNotExistException();
                        break;
                    }
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break;
                    }
                }
                ex.id = new Identity();
                ex.id.__read(this._is);
                String[] facetPath = this._is.readStringSeq();
                if (facetPath.length > 0) {
                    if (facetPath.length > 1) {
                        throw new MarshalException();
                    }
                    ex.facet = facetPath[0];
                } else {
                    ex.facet = "";
                }
                ex.operation = this._is.readString();
                this._exception = ex;
                this._state = 4;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                UnknownException ex = null;
                switch (status) {
                    case 7: {
                        ex = new UnknownException();
                        break;
                    }
                    case 5: {
                        ex = new UnknownLocalException();
                        break;
                    }
                    case 6: {
                        ex = new UnknownUserException();
                        break;
                    }
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break;
                    }
                }
                ex.unknown = this._is.readString();
                this._exception = ex;
                this._state = 4;
                break;
            }
            default: {
                this._exception = new UnknownReplyStatusException();
                this._state = 4;
            }
        }
        this.notify();
    }

    public synchronized void finished(LocalException ex) {
        if (!$assertionsDisabled && this._reference.mode != 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this._state > 1) {
            throw new AssertionError();
        }
        this._state = 4;
        this._exception = ex;
        this.notify();
    }

    public BasicStream is() {
        return this._is;
    }

    public BasicStream os() {
        return this._os;
    }

    private void writeHeader(String operation, OperationMode mode, Map context) {
        switch (this._reference.mode) {
            case 0: 
            case 1: 
            case 3: {
                this._connection.prepareRequest(this._os);
                break;
            }
            case 2: 
            case 4: {
                this._connection.prepareBatchRequest(this._os);
            }
        }
        this._reference.identity.__write(this._os);
        if (this._reference.facet == null || this._reference.facet.length() == 0) {
            this._os.writeStringSeq(null);
        } else {
            String[] facetPath = new String[]{this._reference.facet};
            this._os.writeStringSeq(facetPath);
        }
        this._os.writeString(operation);
        this._os.writeByte((byte)mode.value());
        if (context == null) {
            this._os.writeSize(0);
        } else {
            int sz = context.size();
            this._os.writeSize(sz);
            if (sz > 0) {
                Iterator i = context.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    this._os.writeString((String)entry.getKey());
                    this._os.writeString((String)entry.getValue());
                }
            }
        }
        this._os.startWriteEncaps();
    }

    static {
        $assertionsDisabled = !Outgoing.class.desiredAssertionStatus();
    }
}

