/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Communicator;
import Ice.ObjectAdapter;
import Ice.ObjectAdapterDeactivatedException;
import Ice.ObjectAdapterI;
import Ice.ObjectPrx;
import IceInternal.Instance;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public final class ObjectAdapterFactory {
    private Instance _instance;
    private Communicator _communicator;
    private HashMap _adapters = new HashMap();
    private boolean _waitForShutdown;
    static final /* synthetic */ boolean $assertionsDisabled;

    public synchronized void shutdown() {
        if (this._instance == null) {
            return;
        }
        Iterator i = this._adapters.values().iterator();
        while (i.hasNext()) {
            ObjectAdapter adapter = (ObjectAdapter)i.next();
            adapter.deactivate();
        }
        this._instance = null;
        this._communicator = null;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForShutdown() {
        ObjectAdapterFactory objectAdapterFactory = this;
        synchronized (objectAdapterFactory) {
            while (this._instance != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {}
            }
            while (this._waitForShutdown) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {}
            }
            this._waitForShutdown = true;
        }
        Iterator i = this._adapters.values().iterator();
        while (i.hasNext()) {
            ObjectAdapter adapter = (ObjectAdapter)i.next();
            adapter.waitForDeactivate();
        }
        this._adapters.clear();
        ObjectAdapterFactory objectAdapterFactory2 = this;
        synchronized (objectAdapterFactory2) {
            this._waitForShutdown = false;
            this.notifyAll();
        }
    }

    public synchronized ObjectAdapter createObjectAdapter(String name) {
        if (this._instance == null) {
            throw new ObjectAdapterDeactivatedException();
        }
        ObjectAdapter adapter = (ObjectAdapter)this._adapters.get(name);
        if (adapter != null) {
            return adapter;
        }
        adapter = new ObjectAdapterI(this._instance, this._communicator, name);
        this._adapters.put(name, adapter);
        return adapter;
    }

    public synchronized ObjectAdapter findObjectAdapter(ObjectPrx proxy) {
        if (this._instance == null) {
            return null;
        }
        Iterator i = this._adapters.values().iterator();
        while (i.hasNext()) {
            ObjectAdapterI adapter = (ObjectAdapterI)i.next();
            try {
                if (!adapter.isLocal(proxy)) continue;
                return adapter;
            }
            catch (ObjectAdapterDeactivatedException ex) {
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBatchRequests() {
        LinkedList a = new LinkedList();
        ObjectAdapterFactory objectAdapterFactory = this;
        synchronized (objectAdapterFactory) {
            Iterator i = this._adapters.values().iterator();
            while (i.hasNext()) {
                a.add(i.next());
            }
        }
        Iterator p = a.iterator();
        while (p.hasNext()) {
            ((ObjectAdapterI)p.next()).flushBatchRequests();
        }
    }

    ObjectAdapterFactory(Instance instance, Communicator communicator) {
        this._instance = instance;
        this._communicator = communicator;
        this._waitForShutdown = false;
    }

    protected void finalize() throws Throwable {
        if (!$assertionsDisabled && this._instance != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this._communicator != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this._adapters.size() != 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this._waitForShutdown) {
            throw new AssertionError();
        }
        super.finalize();
    }

    static {
        $assertionsDisabled = !ObjectAdapterFactory.class.desiredAssertionStatus();
    }
}

