/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Communicator;
import Ice.CommunicatorDestroyedException;
import Ice.LocalException;
import Ice.LocatorPrxHelper;
import Ice.Logger;
import Ice.LoggerI;
import Ice.PluginManager;
import Ice.PluginManagerI;
import Ice.Properties;
import Ice.RouterPrxHelper;
import Ice.Stats;
import Ice.StringSeqHolder;
import Ice.SysLoggerI;
import IceInternal.BufferManager;
import IceInternal.ConnectionMonitor;
import IceInternal.DefaultsAndOverrides;
import IceInternal.EndpointFactoryManager;
import IceInternal.LocatorManager;
import IceInternal.ObjectAdapterFactory;
import IceInternal.ObjectFactoryManager;
import IceInternal.OutgoingConnectionFactory;
import IceInternal.ProxyFactory;
import IceInternal.ReferenceFactory;
import IceInternal.RouterManager;
import IceInternal.TcpEndpointFactory;
import IceInternal.ThreadPool;
import IceInternal.TraceLevels;
import IceInternal.UdpEndpointFactory;

public class Instance {
    private boolean _destroyed = false;
    private final Properties _properties;
    private Logger _logger;
    private Stats _stats;
    private final TraceLevels _traceLevels;
    private final DefaultsAndOverrides _defaultsAndOverrides;
    private final int _messageSizeMax;
    private final int _connectionIdleTime;
    private RouterManager _routerManager;
    private LocatorManager _locatorManager;
    private ReferenceFactory _referenceFactory;
    private ProxyFactory _proxyFactory;
    private OutgoingConnectionFactory _outgoingConnectionFactory;
    private ConnectionMonitor _connectionMonitor;
    private ObjectFactoryManager _servantFactoryManager;
    private ObjectAdapterFactory _objectAdapterFactory;
    private ThreadPool _clientThreadPool;
    private ThreadPool _serverThreadPool;
    private EndpointFactoryManager _endpointFactoryManager;
    private PluginManager _pluginManager;
    private final BufferManager _bufferManager;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Properties properties() {
        return this._properties;
    }

    public synchronized Logger logger() {
        return this._logger;
    }

    public synchronized void logger(Logger logger) {
        if (this._destroyed) {
            throw new CommunicatorDestroyedException();
        }
        this._logger = logger;
    }

    public synchronized Stats stats() {
        if (this._destroyed) {
            throw new CommunicatorDestroyedException();
        }
        return this._stats;
    }

    public synchronized void stats(Stats stats) {
        if (this._destroyed) {
            throw new CommunicatorDestroyedException();
        }
        this._stats = stats;
    }

    public TraceLevels traceLevels() {
        return this._traceLevels;
    }

    public DefaultsAndOverrides defaultsAndOverrides() {
        return this._defaultsAndOverrides;
    }

    public synchronized RouterManager routerManager() {
        if (this._destroyed) {
            throw new CommunicatorDestroyedException();
        }
        return this._routerManager;
    }

    public synchronized LocatorManager locatorManager() {
        if (this._destroyed) {
            throw new CommunicatorDestroyedException();
        }
        return this._locatorManager;
    }

    public synchronized ReferenceFactory referenceFactory() {
        if (this._destroyed) {
            throw new CommunicatorDestroyedException();
        }
        return this._referenceFactory;
    }

    public synchronized ProxyFactory proxyFactory() {
        if (this._destroyed) {
            throw new CommunicatorDestroyedException();
        }
        return this._proxyFactory;
    }

    public synchronized OutgoingConnectionFactory outgoingConnectionFactory() {
        if (this._destroyed) {
            throw new CommunicatorDestroyedException();
        }
        return this._outgoingConnectionFactory;
    }

    public synchronized ConnectionMonitor connectionMonitor() {
        if (this._destroyed) {
            throw new CommunicatorDestroyedException();
        }
        return this._connectionMonitor;
    }

    public synchronized ObjectFactoryManager servantFactoryManager() {
        if (this._destroyed) {
            throw new CommunicatorDestroyedException();
        }
        return this._servantFactoryManager;
    }

    public synchronized ObjectAdapterFactory objectAdapterFactory() {
        if (this._destroyed) {
            throw new CommunicatorDestroyedException();
        }
        return this._objectAdapterFactory;
    }

    public synchronized ThreadPool clientThreadPool() {
        if (this._destroyed) {
            throw new CommunicatorDestroyedException();
        }
        if (this._clientThreadPool == null) {
            this._clientThreadPool = new ThreadPool(this, "Ice.ThreadPool.Client", 0);
        }
        return this._clientThreadPool;
    }

    public synchronized ThreadPool serverThreadPool() {
        if (this._destroyed) {
            throw new CommunicatorDestroyedException();
        }
        if (this._serverThreadPool == null) {
            int timeout = this._properties.getPropertyAsInt("Ice.ServerIdleTime");
            this._serverThreadPool = new ThreadPool(this, "Ice.ThreadPool.Server", timeout);
        }
        return this._serverThreadPool;
    }

    public synchronized EndpointFactoryManager endpointFactoryManager() {
        if (this._destroyed) {
            throw new CommunicatorDestroyedException();
        }
        return this._endpointFactoryManager;
    }

    public synchronized PluginManager pluginManager() {
        if (this._destroyed) {
            throw new CommunicatorDestroyedException();
        }
        return this._pluginManager;
    }

    public int messageSizeMax() {
        return this._messageSizeMax;
    }

    public int connectionIdleTime() {
        return this._connectionIdleTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBatchRequests() {
        ObjectAdapterFactory adapterFactory;
        OutgoingConnectionFactory connectionFactory;
        Instance instance = this;
        synchronized (instance) {
            if (this._destroyed) {
                throw new CommunicatorDestroyedException();
            }
            connectionFactory = this._outgoingConnectionFactory;
            adapterFactory = this._objectAdapterFactory;
        }
        connectionFactory.flushBatchRequests();
        adapterFactory.flushBatchRequests();
    }

    public BufferManager bufferManager() {
        return this._bufferManager;
    }

    public Instance(Communicator communicator, Properties properties) {
        this._properties = properties;
        try {
            this._logger = this._properties.getPropertyAsInt("Ice.UseSyslog") > 0 ? new SysLoggerI(this._properties.getProperty("Ice.ProgramName")) : new LoggerI(this._properties.getProperty("Ice.ProgramName"), this._properties.getPropertyAsInt("Ice.Logger.Timestamp") > 0);
            this._stats = null;
            this._traceLevels = new TraceLevels(this._properties);
            this._defaultsAndOverrides = new DefaultsAndOverrides(this._properties);
            int defaultMessageSizeMax = 1024;
            int num = this._properties.getPropertyAsIntWithDefault("Ice.MessageSizeMax", 1024);
            this._messageSizeMax = num < 1 ? 0x100000 : (num > 0x1FFFFF ? Integer.MAX_VALUE : num * 1024);
            int num2 = this._properties.getPropertyAsIntWithDefault("Ice.ConnectionIdleTime", 60);
            this._connectionIdleTime = num2 < 0 ? 0 : num2;
            this._routerManager = new RouterManager();
            this._locatorManager = new LocatorManager();
            this._referenceFactory = new ReferenceFactory(this);
            this._proxyFactory = new ProxyFactory(this);
            this._endpointFactoryManager = new EndpointFactoryManager(this);
            TcpEndpointFactory tcpEndpointFactory = new TcpEndpointFactory(this);
            this._endpointFactoryManager.add(tcpEndpointFactory);
            UdpEndpointFactory udpEndpointFactory = new UdpEndpointFactory(this);
            this._endpointFactoryManager.add(udpEndpointFactory);
            this._pluginManager = new PluginManagerI(communicator);
            this._outgoingConnectionFactory = new OutgoingConnectionFactory(this);
            this._servantFactoryManager = new ObjectFactoryManager();
            this._objectAdapterFactory = new ObjectAdapterFactory(this, communicator);
            this._bufferManager = new BufferManager();
        }
        catch (LocalException ex) {
            this.destroy();
            throw ex;
        }
    }

    protected void finalize() throws Throwable {
        if (!$assertionsDisabled && !this._destroyed) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this._referenceFactory != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this._proxyFactory != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this._outgoingConnectionFactory != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this._connectionMonitor != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this._servantFactoryManager != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this._objectAdapterFactory != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this._clientThreadPool != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this._serverThreadPool != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this._routerManager != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this._locatorManager != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this._endpointFactoryManager != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this._pluginManager != null) {
            throw new AssertionError();
        }
        super.finalize();
    }

    public void finishSetup(StringSeqHolder args) {
        int interval;
        PluginManagerI pluginManagerImpl = (PluginManagerI)this._pluginManager;
        pluginManagerImpl.loadPlugins(args);
        if (this._defaultsAndOverrides.defaultRouter.length() > 0) {
            this._referenceFactory.setDefaultRouter(RouterPrxHelper.uncheckedCast(this._proxyFactory.stringToProxy(this._defaultsAndOverrides.defaultRouter)));
        }
        if (this._defaultsAndOverrides.defaultLocator.length() > 0) {
            this._referenceFactory.setDefaultLocator(LocatorPrxHelper.uncheckedCast(this._proxyFactory.stringToProxy(this._defaultsAndOverrides.defaultLocator)));
        }
        if ((interval = this._properties.getPropertyAsIntWithDefault("Ice.MonitorConnections", this._connectionIdleTime)) > 0) {
            this._connectionMonitor = new ConnectionMonitor(this, interval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (!$assertionsDisabled && this._destroyed) {
            throw new AssertionError();
        }
        if (this._objectAdapterFactory != null) {
            this._objectAdapterFactory.shutdown();
        }
        if (this._outgoingConnectionFactory != null) {
            this._outgoingConnectionFactory.destroy();
        }
        if (this._objectAdapterFactory != null) {
            this._objectAdapterFactory.waitForShutdown();
        }
        if (this._outgoingConnectionFactory != null) {
            this._outgoingConnectionFactory.waitUntilFinished();
        }
        ThreadPool serverThreadPool = null;
        ThreadPool clientThreadPool = null;
        Instance instance = this;
        synchronized (instance) {
            this._objectAdapterFactory = null;
            this._outgoingConnectionFactory = null;
            if (this._connectionMonitor != null) {
                this._connectionMonitor.destroy();
                this._connectionMonitor = null;
            }
            if (this._serverThreadPool != null) {
                this._serverThreadPool.destroy();
                serverThreadPool = this._serverThreadPool;
                this._serverThreadPool = null;
            }
            if (this._clientThreadPool != null) {
                this._clientThreadPool.destroy();
                clientThreadPool = this._clientThreadPool;
                this._clientThreadPool = null;
            }
            if (this._servantFactoryManager != null) {
                this._servantFactoryManager.destroy();
                this._servantFactoryManager = null;
            }
            if (this._referenceFactory != null) {
                this._referenceFactory.destroy();
                this._referenceFactory = null;
            }
            this._proxyFactory = null;
            if (this._routerManager != null) {
                this._routerManager.destroy();
                this._routerManager = null;
            }
            if (this._locatorManager != null) {
                this._locatorManager.destroy();
                this._locatorManager = null;
            }
            if (this._endpointFactoryManager != null) {
                this._endpointFactoryManager.destroy();
                this._endpointFactoryManager = null;
            }
            if (this._pluginManager != null) {
                this._pluginManager.destroy();
                this._pluginManager = null;
            }
            this._destroyed = true;
        }
        if (clientThreadPool != null) {
            clientThreadPool.joinWithAllThreads();
        }
        if (serverThreadPool != null) {
            serverThreadPool.joinWithAllThreads();
        }
    }

    static {
        $assertionsDisabled = !Instance.class.desiredAssertionStatus();
    }
}

