/*
 * Decompiled with CFR 0.152.
 */
package IceBox;

import Ice.Application;
import Ice.ObjectPrx;
import Ice.Properties;
import IceBox.ServiceManagerPrx;
import IceBox.ServiceManagerPrxHelper;
import java.util.ArrayList;

public final class Admin {
    public static void main(String[] args) {
        Client app = new Client();
        int rc = app.main("IceBox.Admin", args);
        System.exit(rc);
    }

    private static class Client
    extends Application {
        private Client() {
        }

        private void usage() {
            System.err.println("Usage: " + Client.appName() + " [options] [command...]\n" + "Options:\n" + "-h, --help          Show this message.\n" + "\n" + "Commands:\n" + "shutdown            Shutdown the server.");
        }

        /*
         * Enabled aggressive block sorting
         */
        public int run(String[] args) {
            String managerProxy;
            String managerEndpoints;
            ArrayList<String> commands;
            block12: {
                commands = new ArrayList<String>();
                for (int idx = 0; idx < args.length; ++idx) {
                    if (args[idx].equals("-h") || args[idx].equals("--help")) {
                        this.usage();
                        return 1;
                    }
                    if (args[idx].charAt(0) == '-') {
                        System.err.println(Client.appName() + ": unknown option `" + args[idx] + "'");
                        this.usage();
                        return 1;
                    }
                    commands.add(args[idx]);
                }
                if (commands.isEmpty()) {
                    this.usage();
                    return 0;
                }
                Properties properties = Client.communicator().getProperties();
                String namePrefix = properties.getProperty("IceBox.Name");
                if (namePrefix.length() > 0) {
                    namePrefix = namePrefix + ".";
                }
                if ((managerEndpoints = properties.getProperty("IceBox.ServiceManager.Endpoints")).length() == 0) {
                    if (properties.getProperty("Ice.Default.Locator").length() > 0 && namePrefix.length() > 0) {
                        managerProxy = namePrefix + "ServiceManager@" + namePrefix + "ServiceManagerAdapter";
                        break block12;
                    } else {
                        System.err.println(Client.appName() + ": property `IceBox.ServiceManager.Endpoints' is not set");
                        return 1;
                    }
                }
                String managerIdentity = properties.getPropertyWithDefault("IceBox.ServiceManager.Identity", "ServiceManager");
                managerProxy = namePrefix + managerIdentity + ":" + managerEndpoints;
            }
            ObjectPrx base = Client.communicator().stringToProxy(managerProxy);
            ServiceManagerPrx manager = ServiceManagerPrxHelper.checkedCast(base);
            if (manager == null) {
                System.err.println(Client.appName() + ": `" + managerEndpoints + "' is not running");
                return 1;
            }
            int i = 0;
            while (i < commands.size()) {
                String command = (String)commands.get(i);
                if (!command.equals("shutdown")) {
                    System.err.println(Client.appName() + ": unknown command `" + command + "'");
                    this.usage();
                    return 1;
                }
                manager.shutdown();
                ++i;
            }
            return 0;
        }
    }
}

