/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.Communicator;
import Ice.CommunicatorDestroyedException;
import Ice.LocalObjectImpl;
import Ice.LocatorPrx;
import Ice.Logger;
import Ice.ObjectAdapter;
import Ice.ObjectFactory;
import Ice.ObjectPrx;
import Ice.PluginManager;
import Ice.Properties;
import Ice.RouterPrx;
import Ice.Stats;
import Ice.StringSeqHolder;
import IceInternal.Instance;
import IceInternal.ObjectAdapterFactory;
import IceInternal.ThreadPool;

final class CommunicatorI
extends LocalObjectImpl
implements Communicator {
    private boolean _destroyed = false;
    private Instance _instance;
    private ThreadPool _serverThreadPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Instance instance = null;
        CommunicatorI communicatorI = this;
        synchronized (communicatorI) {
            if (!this._destroyed) {
                this._destroyed = true;
                this._serverThreadPool = null;
                instance = this._instance;
            }
        }
        if (instance != null) {
            instance.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ObjectAdapterFactory objectAdapterFactory;
        CommunicatorI communicatorI = this;
        synchronized (communicatorI) {
            if (this._destroyed) {
                throw new CommunicatorDestroyedException();
            }
            objectAdapterFactory = this._instance.objectAdapterFactory();
        }
        objectAdapterFactory.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForShutdown() {
        ObjectAdapterFactory objectAdapterFactory;
        CommunicatorI communicatorI = this;
        synchronized (communicatorI) {
            if (this._destroyed) {
                throw new CommunicatorDestroyedException();
            }
            objectAdapterFactory = this._instance.objectAdapterFactory();
        }
        objectAdapterFactory.waitForShutdown();
    }

    public synchronized ObjectPrx stringToProxy(String s) {
        if (this._destroyed) {
            throw new CommunicatorDestroyedException();
        }
        return this._instance.proxyFactory().stringToProxy(s);
    }

    public synchronized String proxyToString(ObjectPrx proxy) {
        if (this._destroyed) {
            throw new CommunicatorDestroyedException();
        }
        return this._instance.proxyFactory().proxyToString(proxy);
    }

    public synchronized ObjectAdapter createObjectAdapter(String name) {
        if (this._destroyed) {
            throw new CommunicatorDestroyedException();
        }
        ObjectAdapter adapter = this._instance.objectAdapterFactory().createObjectAdapter(name);
        if (this._serverThreadPool == null) {
            this._serverThreadPool = this._instance.serverThreadPool();
        }
        return adapter;
    }

    public synchronized ObjectAdapter createObjectAdapterWithEndpoints(String name, String endpoints) {
        this.getProperties().setProperty(name + ".Endpoints", endpoints);
        return this.createObjectAdapter(name);
    }

    public synchronized void addObjectFactory(ObjectFactory factory, String id) {
        if (this._destroyed) {
            throw new CommunicatorDestroyedException();
        }
        this._instance.servantFactoryManager().add(factory, id);
    }

    public synchronized void removeObjectFactory(String id) {
        if (this._destroyed) {
            throw new CommunicatorDestroyedException();
        }
        this._instance.servantFactoryManager().remove(id);
    }

    public synchronized ObjectFactory findObjectFactory(String id) {
        if (this._destroyed) {
            throw new CommunicatorDestroyedException();
        }
        return this._instance.servantFactoryManager().find(id);
    }

    public synchronized Properties getProperties() {
        return this._instance.properties();
    }

    public synchronized Logger getLogger() {
        return this._instance.logger();
    }

    public synchronized void setLogger(Logger logger) {
        this._instance.logger(logger);
    }

    public synchronized Stats getStats() {
        if (this._destroyed) {
            throw new CommunicatorDestroyedException();
        }
        return this._instance.stats();
    }

    public synchronized void setStats(Stats stats) {
        if (this._destroyed) {
            throw new CommunicatorDestroyedException();
        }
        this._instance.stats(stats);
    }

    public synchronized void setDefaultRouter(RouterPrx router) {
        if (this._destroyed) {
            throw new CommunicatorDestroyedException();
        }
        this._instance.referenceFactory().setDefaultRouter(router);
    }

    public synchronized void setDefaultLocator(LocatorPrx locator) {
        if (this._destroyed) {
            throw new CommunicatorDestroyedException();
        }
        this._instance.referenceFactory().setDefaultLocator(locator);
    }

    public PluginManager getPluginManager() {
        return null;
    }

    public void flushBatchRequests() {
        this._instance.flushBatchRequests();
    }

    CommunicatorI(Properties properties) {
        this._instance = new Instance(this, properties);
    }

    protected void finalize() throws Throwable {
        if (!this._destroyed) {
            this._instance.logger().warning("Ice::Communicator::destroy() has not been called");
        }
        super.finalize();
    }

    void finishSetup(StringSeqHolder args) {
        this._instance.finishSetup(args);
    }

    Instance getInstance() {
        return this._instance;
    }
}

