/*
 * Decompiled with CFR 0.152.
 */
package Freeze;

import Freeze.Connection;
import Freeze.ConnectionI;
import Freeze.DatabaseException;
import Freeze.DeadlockException;
import Freeze.LinkedList;
import Freeze.NotFoundException;
import Freeze.SharedDb;
import Ice.Communicator;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbBtreeStat;
import com.sleepycat.db.DbDeadlockException;
import com.sleepycat.db.DbException;
import com.sleepycat.db.DbTxn;
import com.sleepycat.db.Dbc;
import com.sleepycat.db.Dbt;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public abstract class Map
extends AbstractMap {
    private ConnectionI _connection;
    private Iterator _token;
    private Set _entrySet;
    private LinkedList _iteratorList = new LinkedList();
    private SharedDb _db;
    private String _errorPrefix;
    private int _trace;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Map(Connection connection, String dbName, boolean createDb) {
        this._connection = (ConnectionI)connection;
        this._errorPrefix = "Freeze DB DbEnv(\"" + this._connection.envName() + "\") Db(\"" + dbName + "\") :";
        this._trace = this._connection.trace();
        this._db = SharedDb.get(this._connection, dbName, createDb);
        this._token = this._connection.registerMap(this);
    }

    public void close() {
        this.close(false);
    }

    public abstract byte[] encodeKey(Object var1, Communicator var2);

    public abstract Object decodeKey(byte[] var1, Communicator var2);

    public abstract byte[] encodeValue(Object var1, Communicator var2);

    public abstract Object decodeValue(byte[] var1, Communicator var2);

    public int size() {
        if (this._db == null) {
            DatabaseException ex = new DatabaseException();
            ex.message = this._errorPrefix + "\"" + this._db.dbName() + "\" has been closed";
            throw ex;
        }
        try {
            DbBtreeStat s = (DbBtreeStat)this._db.stat(0);
            return s.bt_ndata;
        }
        catch (DbException e) {
            DatabaseException ex = new DatabaseException();
            ex.initCause(e);
            ex.message = this._errorPrefix + "Db.stat: " + e.getMessage();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object value) {
        while (true) {
            EntryIterator p = null;
            try {
                Entry e;
                p = (EntryIterator)this.entrySet().iterator();
                if (value == null) {
                    while (p.hasNext()) {
                        e = (Entry)p.next();
                        if (e.getValue() != null) continue;
                        p.close();
                        boolean bl = true;
                        return bl;
                    }
                } else {
                    while (p.hasNext()) {
                        e = (Entry)p.next();
                        if (!value.equals(e.getValue())) continue;
                        p.close();
                        boolean bl = true;
                        return bl;
                    }
                }
                boolean e2 = false;
                return e2;
            }
            catch (DeadlockException e) {
                if (this._connection.dbTxn() != null) {
                    throw e;
                }
                if (!this._connection.deadlockWarning()) continue;
                this._connection.communicator().getLogger().warning("Deadlock in Freeze.Map.containsValue while iterating over Db \"" + this._db.dbName() + "\"; retrying ...");
                continue;
            }
            finally {
                if (p == null) continue;
                p.close();
                continue;
            }
            break;
        }
    }

    public boolean containsKey(Object key) {
        if (this._db == null) {
            DatabaseException ex = new DatabaseException();
            ex.message = this._errorPrefix + "\"" + this._db.dbName() + "\" has been closed";
            throw ex;
        }
        byte[] k = this.encodeKey(key, this._connection.communicator());
        Dbt dbKey = new Dbt(k);
        Dbt dbValue = new Dbt();
        dbValue.set_flags(Db.DB_DBT_PARTIAL);
        if (this._trace >= 1) {
            this._connection.communicator().getLogger().trace("Freeze.Map", "checking key in Db \"" + this._db.dbName() + "\"");
        }
        while (true) {
            try {
                int rc = this._db.get(this._connection.dbTxn(), dbKey, dbValue, 0);
                if (rc == -30990) {
                    return false;
                }
                if (!$assertionsDisabled && rc != 0) {
                    throw new AssertionError();
                }
                return true;
            }
            catch (DbDeadlockException e) {
                if (this._connection.dbTxn() != null) {
                    DeadlockException ex = new DeadlockException();
                    ex.initCause(e);
                    ex.message = this._errorPrefix + "Db.get: " + e.getMessage();
                    throw ex;
                }
                if (!this._connection.deadlockWarning()) continue;
                this._connection.communicator().getLogger().warning("Deadlock in Freeze.Map.containsKey while reading Db \"" + this._db.dbName() + "\"; retrying ...");
                continue;
            }
            catch (DbException e) {
                DatabaseException ex = new DatabaseException();
                ex.initCause(e);
                ex.message = this._errorPrefix + "Db.get: " + e.getMessage();
                throw ex;
            }
            break;
        }
    }

    public Object get(Object key) {
        byte[] k = this.encodeKey(key, this._connection.communicator());
        Dbt dbKey = new Dbt(k);
        byte[] v = this.getImpl(dbKey);
        if (v == null) {
            return null;
        }
        return this.decodeValue(v, this._connection.communicator());
    }

    public Object put(Object key, Object value) {
        byte[] k = this.encodeKey(key, this._connection.communicator());
        Dbt dbKey = new Dbt(k);
        byte[] v = this.getImpl(dbKey);
        Object o = null;
        if (v != null) {
            o = this.decodeValue(v, this._connection.communicator());
        }
        this.putImpl(dbKey, value);
        return o;
    }

    public Object remove(Object key) {
        byte[] k = this.encodeKey(key, this._connection.communicator());
        Dbt dbKey = new Dbt(k);
        byte[] v = this.getImpl(dbKey);
        if (v != null && this.removeImpl(dbKey)) {
            return this.decodeValue(v, this._connection.communicator());
        }
        NotFoundException ex = new NotFoundException();
        ex.message = this._errorPrefix + "Db.del: DB_NOTFOUND";
        throw ex;
    }

    public void fastPut(Object key, Object value) {
        byte[] k = this.encodeKey(key, this._connection.communicator());
        Dbt dbKey = new Dbt(k);
        this.putImpl(dbKey, value);
    }

    public boolean fastRemove(Object key) {
        byte[] k = this.encodeKey(key, this._connection.communicator());
        Dbt dbKey = new Dbt(k);
        return this.removeImpl(dbKey);
    }

    public void clear() {
        if (this._db == null) {
            DatabaseException ex = new DatabaseException();
            ex.message = this._errorPrefix + "\"" + this._db.dbName() + "\" has been closed";
            throw ex;
        }
        DbTxn txn = this._connection.dbTxn();
        while (true) {
            try {
                this._db.truncate(txn, txn != null ? 0 : Db.DB_AUTO_COMMIT);
            }
            catch (DbDeadlockException e) {
                if (txn != null) {
                    DeadlockException ex = new DeadlockException();
                    ex.initCause(e);
                    ex.message = this._errorPrefix + "Db.truncate: " + e.getMessage();
                    throw ex;
                }
                if (!this._connection.deadlockWarning()) continue;
                this._connection.communicator().getLogger().warning("Deadlock in Freeze.Map.clear on Db \"" + this._db.dbName() + "\"; retrying ...");
                continue;
            }
            catch (DbException e) {
                DatabaseException ex = new DatabaseException();
                ex.initCause(e);
                ex.message = this._errorPrefix + "Db.truncate: " + e.getMessage();
                throw ex;
            }
            break;
        }
    }

    public Set entrySet() {
        if (this._entrySet == null) {
            this._entrySet = new AbstractSet(){

                public Iterator iterator() {
                    return new EntryIterator();
                }

                public boolean contains(Object o) {
                    if (!(o instanceof Entry)) {
                        return false;
                    }
                    Entry entry = (Entry)o;
                    Object value = entry.getValue();
                    byte[] v = Map.this.getImpl(entry.getDbKey());
                    return v != null && Map.valEquals(Map.this.decodeValue(v, Map.this._connection.communicator()), value);
                }

                public boolean remove(Object o) {
                    if (!(o instanceof Entry)) {
                        return false;
                    }
                    Entry entry = (Entry)o;
                    Object value = entry.getValue();
                    byte[] v = Map.this.getImpl(entry.getDbKey());
                    if (v != null && Map.valEquals(Map.this.decodeValue(v, Map.this._connection.communicator()), value)) {
                        return Map.this.removeImpl(entry.getDbKey());
                    }
                    return false;
                }

                public int size() {
                    return Map.this.size();
                }

                public void clear() {
                    Map.this.clear();
                }
            };
        }
        return this._entrySet;
    }

    public void closeAllIterators() {
        this.closeAllIteratorsExcept(null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeAllIteratorsExcept(Object except, boolean finalizing) {
        LinkedList linkedList = this._iteratorList;
        synchronized (linkedList) {
            Iterator p = this._iteratorList.iterator();
            while (p.hasNext()) {
                Object obj = p.next();
                if (obj == except) continue;
                ((EntryIterator)obj).close(finalizing);
            }
        }
    }

    protected void finalize() {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(boolean finalizing) {
        ConnectionI connectionI = this._connection;
        synchronized (connectionI) {
            if (this._db != null) {
                this.closeAllIteratorsExcept(null, finalizing);
                try {
                    this._db.close();
                    Object var4_3 = null;
                    this._db = null;
                    this._connection.unregisterMap(this._token);
                    this._token = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this._db = null;
                    this._connection.unregisterMap(this._token);
                    this._token = null;
                    throw throwable;
                }
            }
        }
    }

    private static boolean valEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private byte[] getImpl(Dbt dbKey) {
        if (this._db == null) {
            DatabaseException ex = new DatabaseException();
            ex.message = this._errorPrefix + "\"" + this._db.dbName() + "\" has been closed";
            throw ex;
        }
        Dbt dbValue = new Dbt();
        if (this._trace >= 1) {
            this._connection.communicator().getLogger().trace("Freeze.Map", "reading value from Db \"" + this._db.dbName() + "\"");
        }
        while (true) {
            try {
                int rc = this._db.get(this._connection.dbTxn(), dbKey, dbValue, 0);
                if (rc == -30990) {
                    return null;
                }
                return dbValue.get_data();
            }
            catch (DbDeadlockException e) {
                if (this._connection.dbTxn() != null) {
                    DeadlockException ex = new DeadlockException();
                    ex.initCause(e);
                    ex.message = this._errorPrefix + "Db.get: " + e.getMessage();
                    throw ex;
                }
                if (!this._connection.deadlockWarning()) continue;
                this._connection.communicator().getLogger().warning("Deadlock in Freeze.Map.getImpl while reading Db \"" + this._db.dbName() + "\"; retrying ...");
                continue;
            }
            catch (DbException e) {
                DatabaseException ex = new DatabaseException();
                ex.initCause(e);
                ex.message = this._errorPrefix + "Db.get: " + e.getMessage();
                throw ex;
            }
            break;
        }
    }

    private void putImpl(Dbt dbKey, Object value) {
        DbTxn txn;
        if (this._db == null) {
            DatabaseException ex = new DatabaseException();
            ex.message = this._errorPrefix + "\"" + this._db.dbName() + "\" has been closed";
            throw ex;
        }
        byte[] v = this.encodeValue(value, this._connection.communicator());
        Dbt dbValue = new Dbt(v);
        if (this._trace >= 1) {
            this._connection.communicator().getLogger().trace("Freeze.Map", "writing value in Db \"" + this._db.dbName() + "\"");
        }
        if ((txn = this._connection.dbTxn()) == null) {
            this.closeAllIterators();
        }
        while (true) {
            try {
                this._db.put(txn, dbKey, dbValue, txn != null ? 0 : Db.DB_AUTO_COMMIT);
            }
            catch (DbDeadlockException e) {
                if (txn != null) {
                    DeadlockException ex = new DeadlockException();
                    ex.initCause(e);
                    ex.message = this._errorPrefix + "Db.put: " + e.getMessage();
                    throw ex;
                }
                if (!this._connection.deadlockWarning()) continue;
                this._connection.communicator().getLogger().warning("Deadlock in Freeze.Map.putImpl while writing into Db \"" + this._db.dbName() + "\"; retrying ...");
                continue;
            }
            catch (DbException e) {
                DatabaseException ex = new DatabaseException();
                ex.initCause(e);
                ex.message = this._errorPrefix + "Db.put: " + e.getMessage();
                throw ex;
            }
            break;
        }
    }

    private boolean removeImpl(Dbt dbKey) {
        DbTxn txn;
        if (this._db == null) {
            DatabaseException ex = new DatabaseException();
            ex.message = this._errorPrefix + "\"" + this._db.dbName() + "\" has been closed";
            throw ex;
        }
        if (this._trace >= 1) {
            this._connection.communicator().getLogger().trace("Freeze.Map", "deleting value from Db \"" + this._db.dbName() + "\"");
        }
        if ((txn = this._connection.dbTxn()) == null) {
            this.closeAllIterators();
        }
        while (true) {
            try {
                int rc = this._db.del(txn, dbKey, txn != null ? 0 : Db.DB_AUTO_COMMIT);
                return rc == 0;
            }
            catch (DbDeadlockException e) {
                if (txn != null) {
                    DeadlockException ex = new DeadlockException();
                    ex.initCause(e);
                    ex.message = this._errorPrefix + "Db.del: " + e.getMessage();
                    throw ex;
                }
                if (!this._connection.deadlockWarning()) continue;
                this._connection.communicator().getLogger().warning("Deadlock in Freeze.Map.removeImpl while writing into Db \"" + this._db.dbName() + "\"; retrying ...");
                continue;
            }
            catch (DbException e) {
                DatabaseException ex = new DatabaseException();
                ex.initCause(e);
                ex.message = this._errorPrefix + "Db.del: " + e.getMessage();
                throw ex;
            }
            break;
        }
    }

    static {
        $assertionsDisabled = !Map.class.desiredAssertionStatus();
    }

    public static class Patcher
    implements IceInternal.Patcher {
        public String type;
        public Ice.Object value;

        public Patcher(String type) {
            this.type = type;
        }

        public void patch(Ice.Object v) {
            this.value = v;
        }

        public String type() {
            return this.type;
        }

        public Ice.Object value() {
            return this.value;
        }
    }

    static class Entry
    implements Map.Entry {
        private EntryIterator _iterator;
        private Map _map;
        private Communicator _communicator;
        private Dbt _dbKey;
        private byte[] _valueBytes;
        private Object _key;
        private boolean _haveKey = false;
        private Object _value;
        private boolean _haveValue = false;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Entry(EntryIterator iterator, Map map, Communicator communicator, Dbt dbKey, byte[] valueBytes) {
            this._iterator = iterator;
            this._map = map;
            this._communicator = communicator;
            this._dbKey = dbKey;
            this._valueBytes = valueBytes;
        }

        public Object getKey() {
            if (!this._haveKey) {
                if (!$assertionsDisabled && this._dbKey == null) {
                    throw new AssertionError();
                }
                this._key = this._map.decodeKey(this._dbKey.get_data(), this._communicator);
                this._haveKey = true;
            }
            return this._key;
        }

        public Object getValue() {
            if (!this._haveValue) {
                if (!$assertionsDisabled && this._valueBytes == null) {
                    throw new AssertionError();
                }
                this._value = this._map.decodeValue(this._valueBytes, this._communicator);
                this._haveValue = true;
                this._valueBytes = null;
            }
            return this._value;
        }

        public Object setValue(Object value) {
            Object old = this.getValue();
            this._iterator.setValue(this, value);
            this._value = value;
            this._haveValue = true;
            return old;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            return this.eq(this.getKey(), e.getKey()) && this.eq(this.getValue(), e.getValue());
        }

        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        Dbt getDbKey() {
            return this._dbKey;
        }

        private boolean eq(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }

        static {
            $assertionsDisabled = !(class$Freeze$Map == null ? (class$Freeze$Map = Map.class$("Freeze.Map")) : class$Freeze$Map).desiredAssertionStatus();
        }
    }

    public class EntryIterator
    implements Iterator {
        private DbTxn _txn;
        private Dbc _cursor;
        private Entry _current;
        private Entry _lastReturned;
        private Iterator _iteratorListToken;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        EntryIterator() {
            if (Map.this._trace >= 3) {
                Map.this._connection.communicator().getLogger().trace("Freeze.Map", "starting transaction for cursor on Db \"" + Map.this._db.dbName() + "\"");
            }
            try {
                DbTxn txn = Map.this._connection.dbTxn();
                if (txn == null) {
                    this._txn = txn = Map.this._connection.dbEnv().txn_begin(null, 0);
                }
                this._cursor = Map.this._db.cursor(txn, 0);
            }
            catch (DbDeadlockException dx) {
                this.dead();
                DeadlockException ex = new DeadlockException();
                ex.initCause(dx);
                ex.message = Map.this._errorPrefix + "EntryIterator constructor: " + dx.getMessage();
                throw ex;
            }
            catch (DbException dx) {
                DatabaseException ex = new DatabaseException();
                ex.initCause(dx);
                ex.message = Map.this._errorPrefix + "EntryIterator constructor: " + dx.getMessage();
                throw ex;
            }
            LinkedList linkedList = Map.this._iteratorList;
            synchronized (linkedList) {
                Map.this._iteratorList.addFirst(this);
                Iterator p = Map.this._iteratorList.iterator();
                p.next();
                this._iteratorListToken = p;
            }
        }

        public boolean hasNext() {
            if (this._current == null || this._current == this._lastReturned) {
                Dbt dbKey = new Dbt();
                Dbt dbValue = new Dbt();
                try {
                    if (this._cursor.get(dbKey, dbValue, Db.DB_NEXT) == 0) {
                        this._current = new Entry(this, Map.this, Map.this._connection.communicator(), dbKey, dbValue.get_data());
                        return true;
                    }
                    return false;
                }
                catch (DbDeadlockException dx) {
                    this.dead();
                    DeadlockException ex = new DeadlockException();
                    ex.initCause(dx);
                    ex.message = Map.this._errorPrefix + "Dbc.get: " + dx.getMessage();
                    throw ex;
                }
                catch (DbException dx) {
                    DatabaseException ex = new DatabaseException();
                    ex.initCause(dx);
                    ex.message = Map.this._errorPrefix + "Dbc.get: " + dx.getMessage();
                    throw ex;
                }
            }
            return true;
        }

        public Object next() {
            if (this.hasNext()) {
                this._lastReturned = this._current;
                return this._lastReturned;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            block16: {
                if (this._txn != null) {
                    Map.this.closeAllIteratorsExcept(this, false);
                }
                if (this._lastReturned == null) {
                    throw new IllegalStateException();
                }
                if (this._lastReturned == this._current) {
                    try {
                        if (this._cursor.del(0) == -30997) {
                            throw new IllegalStateException();
                        }
                        break block16;
                    }
                    catch (DbDeadlockException e) {
                        this.dead();
                        DeadlockException ex = new DeadlockException();
                        ex.initCause(e);
                        ex.message = Map.this._errorPrefix + "Dbc.del: " + e.getMessage();
                        throw ex;
                    }
                    catch (DbException e) {
                        DatabaseException ex = new DatabaseException();
                        ex.initCause(e);
                        ex.message = Map.this._errorPrefix + "Dbc.del: " + e.getMessage();
                        throw ex;
                    }
                }
                Dbc clone = null;
                try {
                    clone = this._cursor.dup(Db.DB_POSITION);
                    Dbt dbValue = new Dbt();
                    dbValue.set_flags(Db.DB_DBT_PARTIAL);
                    int rc = clone.get(this._lastReturned.getDbKey(), dbValue, Db.DB_SET);
                    if (rc == -30990) {
                        throw new IllegalStateException();
                    }
                    if (clone.del(0) == -30997) {
                        throw new IllegalStateException();
                    }
                }
                catch (DbDeadlockException e) {
                    this.dead();
                    DeadlockException ex = new DeadlockException();
                    ex.initCause(e);
                    ex.message = Map.this._errorPrefix + "EntryIterator.remove: " + e.getMessage();
                    throw ex;
                }
                catch (DbException e) {
                    DatabaseException ex = new DatabaseException();
                    ex.initCause(e);
                    ex.message = Map.this._errorPrefix + "EntryIterator.remove: " + e.getMessage();
                    throw ex;
                }
                finally {
                    if (clone != null) {
                        this.closeCursor(clone);
                    }
                }
            }
        }

        public void close() {
            this.close(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void close(boolean finalizing) {
            if (finalizing && (this._cursor != null || this._txn != null) && Map.this._connection.closeInFinalizeWarning()) {
                Map.this._connection.communicator().getLogger().warning("finalize() closing a live iterator on Map \"" + Map.this._db.dbName() + "\"; the application " + "should have closed it earlier by calling Map.EntryIterator.close(), " + "Map.closeAllIterators(), Map.close(), Connection.close(), or (if also " + "leaking a transaction) Transaction.commit() or Transaction.rollback()");
            }
            if (this._iteratorListToken != null) {
                LinkedList linkedList = Map.this._iteratorList;
                synchronized (linkedList) {
                    this._iteratorListToken.remove();
                    this._iteratorListToken = null;
                }
            }
            if (this._cursor != null) {
                Dbc cursor = this._cursor;
                this._cursor = null;
                this.closeCursor(cursor);
            }
            if (this._txn != null) {
                if (Map.this._trace >= 3) {
                    Map.this._connection.communicator().getLogger().trace("Freeze.Map", "committing transaction for cursor on Db \"" + Map.this._db.dbName() + "\"");
                }
                try {
                    this._txn.commit(0);
                }
                catch (DbDeadlockException e) {
                    DeadlockException ex = new DeadlockException();
                    ex.initCause(e);
                    ex.message = Map.this._errorPrefix + "DbTxn.commit: " + e.getMessage();
                    throw ex;
                }
                catch (DbException e) {
                    DatabaseException ex = new DatabaseException();
                    ex.initCause(e);
                    ex.message = Map.this._errorPrefix + "DbTxn.commit: " + e.getMessage();
                    throw ex;
                }
                finally {
                    this._txn = null;
                }
            }
        }

        public void destroy() {
            this.close();
        }

        protected void finalize() {
            this.close(true);
        }

        void setValue(Entry entry, Object value) {
            if (this._txn != null) {
                Map.this.closeAllIteratorsExcept(this, false);
            }
            if (this._current == entry) {
                byte[] v = Map.this.encodeValue(value, Map.this._connection.communicator());
                Dbt dbValue = new Dbt(v);
                try {
                    this._cursor.put(entry.getDbKey(), dbValue, Db.DB_CURRENT);
                }
                catch (DbDeadlockException e) {
                    this.dead();
                    DeadlockException ex = new DeadlockException();
                    ex.initCause(e);
                    ex.message = Map.this._errorPrefix + "Dbc.put: " + e.getMessage();
                    throw ex;
                }
                catch (DbException e) {
                    DatabaseException ex = new DatabaseException();
                    ex.initCause(e);
                    ex.message = Map.this._errorPrefix + "Dbc.put: " + e.getMessage();
                    throw ex;
                }
            }
            Dbc clone = null;
            try {
                clone = this._cursor.dup(Db.DB_POSITION);
                Dbt dummy = new Dbt();
                dummy.set_flags(Db.DB_DBT_PARTIAL);
                int rc = clone.get(entry.getDbKey(), dummy, Db.DB_SET);
                if (rc == -30990) {
                    NotFoundException ex = new NotFoundException();
                    ex.message = Map.this._errorPrefix + "Dbc.get: DB_NOTFOUND";
                    throw ex;
                }
                byte[] v = Map.this.encodeValue(value, Map.this._connection.communicator());
                Dbt dbValue = new Dbt(v);
                clone.put(entry.getDbKey(), dbValue, Db.DB_CURRENT);
            }
            catch (DbDeadlockException e) {
                this.dead();
                DeadlockException ex = new DeadlockException();
                ex.initCause(e);
                ex.message = Map.this._errorPrefix + "EntryIterator.setValue: " + e.getMessage();
                throw ex;
            }
            catch (DbException e) {
                DatabaseException ex = new DatabaseException();
                ex.initCause(e);
                ex.message = Map.this._errorPrefix + "EntryIterator.setValue: " + e.getMessage();
                throw ex;
            }
            finally {
                if (clone != null) {
                    this.closeCursor(clone);
                }
            }
        }

        private void closeCursor(Dbc cursor) {
            try {
                cursor.close();
            }
            catch (DbDeadlockException e) {
                this.dead();
                DeadlockException ex = new DeadlockException();
                ex.initCause(e);
                ex.message = Map.this._errorPrefix + "Dbc.close: " + e.getMessage();
                throw ex;
            }
            catch (DbException e) {
                DatabaseException ex = new DatabaseException();
                ex.initCause(e);
                ex.message = Map.this._errorPrefix + "Dbc.close: " + e.getMessage();
                throw ex;
            }
        }

        private void dead() {
            if (this._cursor != null) {
                Dbc cursor = this._cursor;
                this._cursor = null;
                this.closeCursor(cursor);
            }
            if (this._txn != null) {
                if (Map.this._trace >= 3) {
                    Map.this._connection.communicator().getLogger().trace("Freeze.Map", "rolling back transaction for cursor on Db \"" + Map.this._db.dbName() + "\"");
                }
                try {
                    this._txn.abort();
                }
                catch (DbDeadlockException e) {
                    DeadlockException ex = new DeadlockException();
                    ex.initCause(e);
                    ex.message = Map.this._errorPrefix + "DbTxn.abort: " + e.getMessage();
                    throw ex;
                }
                catch (DbException e) {
                    DatabaseException ex = new DatabaseException();
                    ex.initCause(e);
                    ex.message = Map.this._errorPrefix + "DbTxn.abort: " + e.getMessage();
                    throw ex;
                }
                finally {
                    this._txn = null;
                }
            }
        }
    }
}

