
const gchar *
my_utf_string(const gchar *t)
{
    static gchar *s = NULL;
    GError *error = NULL;
    gsize r_bytes, w_bytes;
    unsigned char *c;
    const char *fc;
    gchar *from_codeset=NULL;
    
    if(!t) {
	return "";
    }
    
    if (g_utf8_validate (t,-1,NULL)) {
	return t;
    }
    
    /* so we got a non-UTF-8 */

    /* SMB_CODESET now obsolete... */
    /*if (getenv("SMB_CODESET") && strlen( getenv("SMB_CODESET"))){
	    from_codeset=g_strdup(getenv("SMB_CODESET"));
    }
    else */
    {
    	g_get_charset(&fc);
    	if (fc) from_codeset = g_strdup(fc);
    	else from_codeset = g_strdup("ISO-8859-1");
    }
    
    
    if(s) {
	    g_free(s);
	    s=NULL;
    }
    for(c = (unsigned char *)t; *c != 0; c++)
	if(*c < 32 && *c != '\n')
	    *c = ' ';
    s = g_convert (t,strlen(t),"UTF-8",from_codeset,&r_bytes, &w_bytes, &error);

    if(!s)
    {
	s=g_strdup(t);
	for(c = (unsigned char *)s; *c != 0; c++) if(*c > 128) *c = '?';
    }
    if(error){
        g_warning("%s. Codeset for system is: %s\nunable to convert to utf-8",
			error->message,from_codeset);
	g_error_free(error);
    }
     g_free(from_codeset);
    from_codeset=NULL;
   return (const gchar *)s;
}

