
/* TreeSize for Unix  http://treesize.sf.net/
 * Copyright (c) 2006-2007 Marcos Diez <marcos_AT_unitron.com.br>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _UTIL_H_
#define _UTIL_H_
#include <stdlib.h>

#ifdef WIN32
#define DIRECTORY_SLASH '\\'
#define DIRECTORY_SLASH_STRING "\\"
#define my_mkdir( dir , perm ) mkdir( dir )
#else
#define DIRECTORY_SLASH '/'
#define DIRECTORY_SLASH_STRING "/"
#define my_mkdir mkdir
#endif



#define PRINT_BUFFER_SIZE 4096
#define MAX_DIR_SIZE 1024

#define FIX_ME         printf("\n\tFIX ME %s %s:%d -->FIX ME\n" , __FILE__ , __FUNCTION__ , __LINE__ );
#define FIX_ME2( x )    printf("\n\tFIX ME %s %s:%d -->%s\n" , __FILE__ , __FUNCTION__ , __LINE__ , x);
#define FIXME FIX_ME
#define FIXME2 FIX_ME
int snprintf(char *str, size_t size, const char *format, ...);

extern char printBuffer[PRINT_BUFFER_SIZE];

void *xMalloc(  const size_t size );
void *xRealloc( void *ptr, const size_t size);
void *xCalloc( const size_t nmemb, const size_t size );

#define pointerSwap( a , b )  {void *tempPointer=a; a=b;b=tempPointer;}


void *memdup( const void *src , size_t n );
void doNothing( void *a , void *b , void *c , void *d);
#define vecMalloc(x,quant)  x=xMalloc( sizeof(*x ) * quant )

#define myMalloc(x)  x=xMalloc( sizeof(*x ) )
#define myCalloc(x , quant )  x=xCalloc( quant , sizeof(*x ) )
#define myAtoi( x ) ( x ? atoi(x) : 0 )

#define divideCeilInt( a , b ) ( ((a)%(b)) ? (((a)/(b) )+1 ) : ((a)/(b) ) )


double getGCD( double u,  double v) ; /*  */
double getLCM( double u , double v );

#endif
