/* TreeSize for Unix  http://treesize.sf.net/
 * Copyright (c) 2006-2007 Marcos Diez <marcos_AT_unitron.com.br>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include <stdio.h>

#include "FAfolderAnalyzer.h"

/* this program shall be uses with valgrind, to look for leeks */
int TSrunning=1;
int main(int argc, char **argv) {

	char *theFolder=argv[1];
	FolderInfo f;
	if (argc <2) {
		printf("Usage: %s 'folderName' [(bool) onlyOneFileSystem] \n", argv[0]);
		return 1;
	}

	printf("Folder: [%s]\n", theFolder);
	bool onlyOneFileSystem = 0;

	if (argc > 3 && atoi(argv[2]) != 0 ) {
		onlyOneFileSystem = 1;
	}

	f=FAanalyze(theFolder , onlyOneFileSystem );
	if ( !f) {
		printf("ERROR on FAanalyze(\"%s\");\n", theFolder);
		return 2;
	}
	printf("f: %p\n", f);
	FIprint(f);
	FIfree(f);
	return 0;
}
