
/* TreeSize for Unix  http://treesize.sf.net/
 * Copyright (c) 2006-2007 Marcos Diez <marcos_AT_unitron.com.br>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#include "interface.h"
#include "support.h"
#include "dragAndDrop.h"


#include "TStreeSizeGui.h"
#include "../pixmaps/treesize.xpm"

#include <sys/types.h>
#include <sys/stat.h>

GdkPixbuf* gdkTreeSize;
GtkMenu *TreeSizeMenuGlobal;
GtkWidget *mainWindow;


int
main (int argc, char *argv[])
{


#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

  gtk_set_locale ();
  gtk_init (&argc, &argv);

/*   add_pixmap_directory (PACKAGE_DATA_DIR "/" PACKAGE "/pixmaps"); */

  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */
  mainWindow = create_mainWindow ();
  TreeSizeMenuGlobal = ( GtkMenu *) create_TreeSizeMenu();
  /* icon */
  {
    gdkTreeSize = gdk_pixbuf_new_from_xpm_data ( (const char **) treesize_xpm );
    gtk_window_set_icon (GTK_WINDOW (mainWindow), gdkTreeSize );
    /*     gdk_pixbuf_unref (gdkTreeSize); */
  }
  
  gtk_widget_show (mainWindow);

  {
    GtkWidget *treeView=lookup_widget( mainWindow , "TVtreeView");
    TSprepareTreeView( treeView );
    DND_initialize( treeView );
    if( argc > 1 ) {
      TScalculateSize( treeView , argv[1] );
    }
  }



  gtk_main ();
  return 0;
}

