/*-
 * Copyright (c) 2006-2007 Marcos Diez <marcos_AT_unitron.com.br>
 * Copyright (C) 2001 Havoc Pennington ( from gnome-terminal )

 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include "dragAndDrop.h"
#include "TStreeSizeGui.h"
#include "support.h"

#include <stdlib.h>
#include <string.h>


enum
  {
    TARGET_URI_LIST,
    TARGET_UTF8_STRING,
    TARGET_TEXT,
    TARGET_COMPOUND_TEXT,
    TARGET_STRING,
    TARGET_TEXT_PLAIN,
    TARGET_MOZ_URL
  };



static void
drag_data_received  (GtkWidget *widget, GdkDragContext *context,
		     gint x, gint y,
		     GtkSelectionData *selection_data, guint info,
		     guint time,
                     gpointer data)
{
  char *str=0;
  
  switch (info)
    {
    case TARGET_STRING:
    case TARGET_UTF8_STRING:
    case TARGET_COMPOUND_TEXT:
    case TARGET_TEXT:
      {
        str = (char *)  gtk_selection_data_get_text (selection_data); 
	/* an UTF-8 string is exactelly what I need */
	break;
      }
      
    case TARGET_TEXT_PLAIN:
      {
        if (selection_data->format != 8 ||
            selection_data->length == 0)
          {
            g_printerr ("text/plain dropped on terminal had wrong format (%d) or length (%d)\n",
                        selection_data->format,
                        selection_data->length);
            return;
          }
	if( selection_data->data[0] == '/' ){
	  str= ( char *) malloc( (selection_data->length + 1) * sizeof( char )  );
	  strncpy( (char *) str , (char *) selection_data->data , selection_data->length );
	  str[ selection_data->length ] = 0;
	} 
	break;
      }

    case TARGET_MOZ_URL:
      {
	int realLength;
	int i;
        
        /* MOZ_URL is in UCS-2 but in format 8. BROKEN!
         *
         * The data contains the URL, a \n, then the
         * title of the web page.
         */
        if (selection_data->format != 8 ||
            selection_data->length == 0 ||
            (selection_data->length % 2) != 0)
          {
            g_printerr ("Mozilla url dropped on terminal had wrong format (%d) or length (%d)\n",
                        selection_data->format,
                        selection_data->length);
            return;
          };
#define SKIPPED_SIZE 14        /* twice the size of "file://" */
	if( selection_data->data[ SKIPPED_SIZE ] != '/' ) break;
	realLength=SKIPPED_SIZE; 		
	while( selection_data->data[realLength+=2] != '\n'
	       && realLength < selection_data->length );
	/* first I found where this string end */

	realLength-=SKIPPED_SIZE;
	realLength/=2;		/* now I divide my size by 2 */

	
	str= (char *) malloc( (realLength +1) * sizeof( char )  );
	for( i = 0 ; i < realLength ; i++ ){
	  str[i ]=selection_data->data[i + i + SKIPPED_SIZE ];
	}
	str[i]=0;
	break;
      }

      
    case TARGET_URI_LIST:
      {
        
        if (selection_data->format != 8 ||
            selection_data->length == 0)
          {
            g_printerr ("URI list dropped on terminal had wrong format (%d) or length (%d)\n",
                        selection_data->format,
                        selection_data->length);
            return;
          }

	/* the user can send me as many files as he want, and they will be separated by a
	   \r\n or and a \0 at the end. It does not metter, I will just look at the first one.
	*/


	str= g_filename_from_uri( (char *) selection_data->data  , NULL , NULL ); /* get the string */
	{
	  int oldSize=strlen( str );
	  int newSize=0;
	  char *d=str;
/* 	  printf("str: [%s]\n" , str ); */
	  while( *d ){
	    if( *d == '\r' || *d == '\n' ){
	      *d=0;
	      break;
	    }
	    d++;
	    newSize++;
	  }
/* 	  printf("str: [%s]\n" , str ); */

	  if( newSize +2 < oldSize ){
	    extern GtkWidget *mainWindow;

	    GtkWidget *dialog = gtk_message_dialog_new ( (GtkWindow*)  mainWindow ,
							 GTK_DIALOG_DESTROY_WITH_PARENT,
							 GTK_MESSAGE_INFO,
							 GTK_BUTTONS_CLOSE,
"Warning: you've dragged more than one folder. Only one of them will be analized"

							 );
	    

	    gtk_dialog_run (GTK_DIALOG (dialog));
	    gtk_widget_destroy (dialog);
	  }

	}

	break;
      }
      break;
    }
    
/*  debug */
/*   { */
/*     int i=0; */
/*     g_print("Target: [%s]\n" , gdk_atom_name( (GdkAtom ) GPOINTER_TO_UINT( context->targets->data ) )); */
/*     g_print("Info: %d Length= %d Format: %d Data:[\n" , */
/* 	     info , selection_data->length , selection_data->format ); */

/*     while( i <  selection_data->length  ){ */
/*       putchar( selection_data->data[i++] ); */
/*     } */
/*     puts("]"); */
/*     g_print("Parsed: [%s]\n" , str ); */
/*   } */

  if( str ){

    extern GtkWidget *mainWindow;
    GtkWidget *treeView=( GtkWidget *) lookup_widget( mainWindow , "TVtreeView");
    TScalculateSize( treeView , str );
    free( str );
  }
}


void
DND_initialize ( GtkWidget *gtkWid)
{
  static GtkTargetEntry target_table[] = {
    { "text/uri-list",  0, TARGET_URI_LIST },
    { "text/x-moz-url",  0, TARGET_MOZ_URL },
    { "UTF8_STRING", 0, TARGET_UTF8_STRING },
    { "COMPOUND_TEXT", 0, TARGET_COMPOUND_TEXT },
    { "TEXT", 0, TARGET_TEXT },
    { "STRING",     0, TARGET_STRING },
    /* text/plain problematic, we don't know its encoding */
    { "text/plain", 0, TARGET_TEXT_PLAIN }
    /* add when gtk supports it perhaps */
    /* { "text/unicode", 0, TARGET_TEXT_UNICODE } */
  };
  
  g_signal_connect (G_OBJECT ( gtkWid ), "drag_data_received",
		    G_CALLBACK (drag_data_received), gtkWid );
  
  gtk_drag_dest_set (GTK_WIDGET ( gtkWid ),
		     GTK_DEST_DEFAULT_MOTION |
		     GTK_DEST_DEFAULT_HIGHLIGHT |
		     GTK_DEST_DEFAULT_DROP,
		     target_table, G_N_ELEMENTS (target_table),
		     GDK_ACTION_COPY | GDK_ACTION_MOVE);
}
