/*
	ssh_widgets.c
	
	This file contains all of the functions/variables for the ssh_config window.
	
	+---------------------------------------------+
	| ______________ @ ______________ : _______   | Table
	| Username         Host             Port      |
	+------------------------+--------------------+
	| < RSA Authent            _________________  | Table
	| < X11 Forwarding                            |
	| > Agent Forwarding                          |
	+------------------------+--------------------+
	| < Verbose              | < Quiet            | Table
	+---------------------------------------------+
	| < Forward (selected)   | ____:______:_____  | HBox <- Table, Separator, Table
	|   port to (non-select) | Lis  Host   Port   |
	|   address.             |                    |
	| ( )Remote ( )Local     |                    |
	+---------------------------------------------+
	| < Set Esc Char    __________                | VBOX <- Table, Toggle, HBox
	| < Set Cipher      __________                |
	| < Compression                               |
	| ( )IPv4 only ( )IPv6 only (*)Not set        |
	+---------------------------------------------+
	|[                Start SSH                  ]| Button
	+---------------------------------------------+
*/
#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>

#define MAX_ARGS  256
struct EXEC_COMMAND {
   char *program;
   char *args[MAX_ARGS];
};
typedef struct EXEC_COMMAND EXEC_COMMAND;

extern GtkWidget *window[1];
extern GtkWidget *notebook[1];
extern int parent;

GtkWidget *box[4];
GtkWidget *table[5];
GtkWidget *separator[7];

GtkWidget *button[1];

GtkWidget *base_entry[3];	//Username,Host,Port,
GtkWidget *base_label[5];
GtkWidget *base_toggle[1];

GtkWidget *auth_toggle[3];	//X11 frwd,agent frwd,RSA auth
GtkWidget *auth_entry[1];

GtkWidget *verb_toggle[2];	//Verbose, Quiet

GtkWidget *forw_entry[3];	//Forward (remote/local) port to (local/remote) addr.
GtkWidget *forw_toggle[3];
GtkWidget *forw_label[6];

GtkWidget *inte_entry[2];	//IPv?, Esc Char, Cipher, Compression
GtkWidget *inte_toggle[6];

gint start_ssh(GtkWidget *widget,
		GdkEvent  *event,
		gpointer   data )
{
   EXEC_COMMAND *ec;
   int i;
   char str[1024];
   char *username, *host;

   ec = malloc(sizeof(EXEC_COMMAND));
   if( ec == NULL ) {
      printf("Out of memory\n");
   }

   ec->program = "xterm";
   i = 0;
   ec->args[i++] = "xterm";
   ec->args[i++] = "-e";

   ec->args[i++] = "ssh";
	if(GTK_TOGGLE_BUTTON(inte_toggle[3])->active) ec->args[i++] = "-4";
	else if(GTK_TOGGLE_BUTTON(inte_toggle[4])->active) ec->args[i++] = "-6";
	
	if(GTK_TOGGLE_BUTTON(inte_toggle[2])->active) ec->args[i++] = "C";
	if(GTK_TOGGLE_BUTTON(inte_toggle[1])->active) {
      ec->args[i++] = "-c";
		ec->args[i++] = gtk_editable_get_chars(GTK_EDITABLE(inte_entry[1]), 0, -1);
   }
	if(GTK_TOGGLE_BUTTON(inte_toggle[0])->active) {
      ec->args[i++] = "-e";
      ec->args[i++] = gtk_editable_get_chars(GTK_EDITABLE(inte_entry[0]), 0, 1);
   }
	if(GTK_TOGGLE_BUTTON(forw_toggle[0])->active) {
		if(GTK_TOGGLE_BUTTON(forw_toggle[1])->active) ec->args[i++] = "-L";
		else if(GTK_TOGGLE_BUTTON(forw_toggle[2])->active) ec->args[i++] = "R";

		sprintf(str, "%s:%s:%s", 
         gtk_editable_get_chars(GTK_EDITABLE(forw_entry[0]), 0, -1),
			gtk_editable_get_chars(GTK_EDITABLE(forw_entry[1]), 0, -1),
			gtk_editable_get_chars(GTK_EDITABLE(forw_entry[2]), 0, -1));
      ec->args[i++] = strdup(str);
	}
	
	if(GTK_TOGGLE_BUTTON(verb_toggle[0])->active) ec->args[i++] = "-v";
	if(GTK_TOGGLE_BUTTON(verb_toggle[1])->active) ec->args[i++] = "-q";
	
	if(!GTK_TOGGLE_BUTTON(auth_toggle[2])->active) ec->args[i++] = "-a";
	if(GTK_TOGGLE_BUTTON(auth_toggle[1])->active) ec->args[i++] = "-X";
	else ec->args[i++] = "-x";
	
	if(GTK_TOGGLE_BUTTON(auth_toggle[0])->active) {
      ec->args[i++] = "-i";
      ec->args[i++] = gtk_editable_get_chars(GTK_EDITABLE(auth_entry[0]), 0, -1);
   }
																		
	if(strcmp(gtk_editable_get_chars(GTK_EDITABLE(base_entry[2]), 0, -1), "")) {
      ec->args[i++] = "-p";
      ec->args[i++] = gtk_editable_get_chars(GTK_EDITABLE(base_entry[2]), 0, -1);
   }
      
   username = gtk_editable_get_chars(GTK_EDITABLE(base_entry[0]), 0, -1);
   host = gtk_editable_get_chars(GTK_EDITABLE(base_entry[1]), 0, -1);

   if ( strcmp(username, "") != 0 ) {
      ec->args[i++] = "-l";
      ec->args[i++] = username;
   }
   ec->args[i++] = host;
   ec->args[i++] = NULL;

	parent = fork();
   if( parent == -1 ) {
      perror("ssh_widget.c");
      return FALSE;
   }
   if( parent == 0 ) {
      execvp(ec->program, ec->args);
		exit(2);
   }

	if(GTK_TOGGLE_BUTTON(base_toggle[0])->active ){
		exit(2);
	}
	
   free(ec);
	return TRUE;
}

//Configures All Widgets
void ssh_widget_init(void)
{

	//Boxes
	box[0] = gtk_vbox_new(FALSE, 0);
	
	box[1] = gtk_hbox_new(FALSE, 0);
	
	box[2] = gtk_vbox_new(FALSE, 0);
	
	box[3] = gtk_hbox_new(FALSE, 0);
	
	//Tables
	table[0] = gtk_table_new(2, 5, FALSE);
	
	table[1] = gtk_table_new(3, 2, FALSE);
	
	table[2] = gtk_table_new(1, 3, FALSE);
	
	table[3] = gtk_table_new(3, 5, FALSE);

	table[4] = gtk_table_new(2, 2, FALSE);
	
	
	//Separators
	separator[0] = gtk_hseparator_new();
	
	separator[1] = gtk_hseparator_new();
	
	separator[2] = gtk_vseparator_new();
	
	separator[3] = gtk_hseparator_new();
	
	separator[4] = gtk_vseparator_new();
	
	separator[5] = gtk_hseparator_new();
		
	separator[6] = gtk_hseparator_new();

	//Button
	button[0] = gtk_button_new_with_label("Start SSH");
	gtk_signal_connect(GTK_OBJECT(button[0]), "clicked",
					GTK_SIGNAL_FUNC(start_ssh), NULL);
	
	//Base
	base_entry[0] = gtk_entry_new();
	gtk_widget_set_usize(base_entry[0], 158, -2);
	
	base_entry[1] = gtk_entry_new();
	gtk_widget_set_usize(base_entry[1], 158, -2);
	
	base_entry[2] = gtk_entry_new();
	gtk_widget_set_usize(base_entry[2], 35, -2);


	base_label[0] = gtk_label_new(" @  ");
	gtk_misc_set_alignment(GTK_MISC(base_label[0]), 0, 0);
	
	base_label[1] = gtk_label_new(" : ");
	gtk_misc_set_alignment(GTK_MISC(base_label[1]), 0, 0);
	
	base_label[2] = gtk_label_new("Username");
	gtk_misc_set_alignment(GTK_MISC(base_label[2]), 0, 0);
	
	base_label[3] = gtk_label_new("Host");
	gtk_misc_set_alignment(GTK_MISC(base_label[3]), 0, 0);
	
	base_label[4] = gtk_label_new("Port");
	gtk_misc_set_alignment(GTK_MISC(base_label[4]), 0, 0);
	
	base_toggle[0] = gtk_check_button_new_with_label("Close SSH-GUI On Connection Attempt");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(base_toggle[0]), FALSE);
	
	//Authentication
	auth_toggle[0] = gtk_check_button_new_with_label("RSA Authentification");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(auth_toggle[0]), FALSE);
	
	auth_toggle[1] = gtk_check_button_new_with_label("X11 Connection Forwarding");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(auth_toggle[1]), FALSE);
	
	auth_toggle[2] = gtk_check_button_new_with_label("Authentication Agent Forwarding");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(auth_toggle[2]), TRUE);
	
	auth_entry[0] = gtk_entry_new();
	gtk_widget_set_usize(auth_entry[0], 35, -2);
	
	//Verbosity
	verb_toggle[0] = gtk_check_button_new_with_label("Verbose");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(verb_toggle[0]), FALSE);
	
	verb_toggle[1] = gtk_check_button_new_with_label("Quiet");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(verb_toggle[1]), FALSE);
	
	//Forwarding Ports to Addresses
	forw_entry[0] = gtk_entry_new();
	gtk_widget_set_usize(forw_entry[0], 158, -2);
	
	forw_entry[1] = gtk_entry_new();
	gtk_widget_set_usize(forw_entry[1], 158, -2);
	
	forw_entry[2] = gtk_entry_new();
	gtk_widget_set_usize(forw_entry[2], 35, -2);
	
	forw_toggle[0] = gtk_check_button_new_with_label("Forward port to address:");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(forw_toggle[0]), FALSE);
	
	forw_toggle[1] = gtk_radio_button_new_with_label(NULL, "Local");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(forw_toggle[1]), FALSE);

	forw_toggle[2] = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(forw_toggle[1])), "Remote");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(forw_toggle[2]), FALSE);
	
	forw_label[0] = gtk_label_new(" : ");
	gtk_misc_set_alignment(GTK_MISC(forw_label[0]), 0, 0);
	
	forw_label[1] = gtk_label_new(" : ");
	gtk_misc_set_alignment(GTK_MISC(forw_label[1]), 0, 0);
	
	forw_label[2] = gtk_label_new("Listen-Port");
	gtk_misc_set_alignment(GTK_MISC(forw_label[2]), 0, 0);
	
	forw_label[3] = gtk_label_new("Host");
	gtk_misc_set_alignment(GTK_MISC(forw_label[3]), 0, 0);
	
	forw_label[4] = gtk_label_new("Port");
	gtk_misc_set_alignment(GTK_MISC(forw_label[4]), 0, 0);
	
	forw_label[5] = gtk_label_new("Port: ");
	gtk_misc_set_alignment(GTK_MISC(forw_label[5]), 0, 0);
	
	//Interface
	inte_toggle[0] = gtk_check_button_new_with_label("Set Escape Character");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(inte_toggle[0]), FALSE);
	
	inte_toggle[1] = gtk_check_button_new_with_label("Set Cipher");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(inte_toggle[1]), FALSE);
	
	inte_toggle[2] = gtk_check_button_new_with_label("Compression");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(inte_toggle[2]), FALSE);
	
	inte_toggle[3] = gtk_radio_button_new_with_label(NULL, "IPv4");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(inte_toggle[3]), FALSE);

	inte_toggle[4] = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(inte_toggle[3])), "IPv6");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(inte_toggle[4]), FALSE);
	
	inte_toggle[5] = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(inte_toggle[4])), "None Set");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(inte_toggle[5]), TRUE);
	
		
	inte_entry[0] = gtk_entry_new();
	gtk_widget_set_usize(inte_entry[0], 158, -2);
	
	inte_entry[1] = gtk_entry_new();
	gtk_widget_set_usize(inte_entry[1], 158, -2);
}

void ssh_widget_pack(void)
{
	
	//Notebook0.Box0
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook[0]), box[0], gtk_label_new("SSH Config"));
	
	//Box0.Table0
	gtk_box_pack_start(GTK_BOX(box[0]), table[0], FALSE,FALSE, 0);
	
	gtk_table_attach_defaults(GTK_TABLE(table[0]), base_entry[0], 0,1, 0,1);
	gtk_table_attach_defaults(GTK_TABLE(table[0]), base_label[0], 1,2, 0,1);
	gtk_table_attach_defaults(GTK_TABLE(table[0]), base_entry[1], 2,3, 0,1);
	gtk_table_attach_defaults(GTK_TABLE(table[0]), base_label[1], 3,4, 0,1);
	gtk_table_attach_defaults(GTK_TABLE(table[0]), base_entry[2], 4,5, 0,1);
	
	gtk_table_attach_defaults(GTK_TABLE(table[0]), base_label[2], 0,1, 1,2);
	gtk_table_attach_defaults(GTK_TABLE(table[0]), base_label[3], 2,3, 1,2);
	gtk_table_attach_defaults(GTK_TABLE(table[0]), base_label[4], 4,5, 1,2);
	
	//Box0.Separator0
	gtk_box_pack_start(GTK_BOX(box[0]), separator[0], FALSE,FALSE, 0);
	
	//Box0.Table1
	gtk_box_pack_start(GTK_BOX(box[0]), table[1], FALSE,FALSE, 0);
	
	gtk_table_attach_defaults(GTK_TABLE(table[1]), auth_toggle[0], 0,1, 0,1);
	gtk_table_attach_defaults(GTK_TABLE(table[1]), auth_entry[0], 1,2, 0,1);
	
	gtk_table_attach_defaults(GTK_TABLE(table[1]), auth_toggle[1], 0,1, 1,2);

	gtk_table_attach_defaults(GTK_TABLE(table[1]), auth_toggle[2], 0,1, 2,3);
	
	//Box0.Separator1
	gtk_box_pack_start(GTK_BOX(box[0]), separator[1], FALSE,FALSE, 0);
	
	//Box0.Table2
	gtk_box_pack_start(GTK_BOX(box[0]), table[2], FALSE,FALSE, 0);
	
	gtk_table_attach_defaults(GTK_TABLE(table[2]), verb_toggle[0], 0,1, 0,1);
	gtk_table_attach_defaults(GTK_TABLE(table[2]), separator[2], 1,2, 0,1);
	gtk_table_attach_defaults(GTK_TABLE(table[2]), verb_toggle[1], 2,3, 0,1);
	
	//Box0.Separator3
	gtk_box_pack_start(GTK_BOX(box[0]), separator[3], FALSE,FALSE, 0);
	
	//Box0.Box1
	gtk_box_pack_start(GTK_BOX(box[0]), box[1], FALSE,FALSE, 0);
	
	//Box1	
	gtk_box_pack_start(GTK_BOX(box[1]), forw_toggle[0], FALSE, FALSE, 0);
	
	
	gtk_box_pack_start(GTK_BOX(box[1]), separator[4], FALSE, FALSE, 0);
	
	//Box1.Table3
	gtk_box_pack_start(GTK_BOX(box[1]), table[3], FALSE, FALSE, 0);
	
	gtk_table_attach_defaults(GTK_TABLE(table[3]), forw_entry[0], 0,1, 0,1);
	gtk_table_attach_defaults(GTK_TABLE(table[3]), forw_label[0], 1,2, 0,1);
	gtk_table_attach_defaults(GTK_TABLE(table[3]), forw_entry[1], 2,3, 0,1);
	gtk_table_attach_defaults(GTK_TABLE(table[3]), forw_label[1], 3,4, 0,1);
	gtk_table_attach_defaults(GTK_TABLE(table[3]), forw_entry[2], 4,5, 0,1);

	gtk_table_attach_defaults(GTK_TABLE(table[3]), forw_label[2], 0,1, 1,2);
	gtk_table_attach_defaults(GTK_TABLE(table[3]), forw_label[3], 2,3, 1,2);
	gtk_table_attach_defaults(GTK_TABLE(table[3]), forw_label[4], 4,5, 1,2);
	
	gtk_table_attach_defaults(GTK_TABLE(table[3]), forw_label[5], 0,1, 2,3);
	gtk_table_attach_defaults(GTK_TABLE(table[3]), forw_toggle[1], 1,2, 2,3);
	gtk_table_attach_defaults(GTK_TABLE(table[3]), forw_toggle[2], 2,3, 2,3);
	
	//Box0.Separator5
	gtk_box_pack_start(GTK_BOX(box[0]), separator[5], FALSE,FALSE, 0);
	
	//Box0.Box2
	gtk_box_pack_start(GTK_BOX(box[0]), box[2], FALSE,FALSE, 0);
	
	//Box2.Table4
	gtk_box_pack_start(GTK_BOX(box[2]), table[4], FALSE, FALSE, 0);
	
	gtk_table_attach_defaults(GTK_TABLE(table[4]), inte_toggle[0], 0,1, 0,1);
	gtk_table_attach_defaults(GTK_TABLE(table[4]), inte_entry[0], 1,2, 0,1);
	gtk_table_attach_defaults(GTK_TABLE(table[4]), inte_toggle[1], 0,1, 1,2);
	gtk_table_attach_defaults(GTK_TABLE(table[4]), inte_entry[1], 1,2, 1,2);
	
	gtk_box_pack_start(GTK_BOX(box[2]), inte_toggle[2], FALSE, FALSE, 0);
	
	//Box2.Box3
	gtk_box_pack_start(GTK_BOX(box[2]), box[3], FALSE,FALSE, 0);
	
	gtk_box_pack_start(GTK_BOX(box[3]), inte_toggle[3], FALSE, FALSE,0);
	gtk_box_pack_start(GTK_BOX(box[3]), inte_toggle[4], FALSE, FALSE,0);
	gtk_box_pack_start(GTK_BOX(box[3]), inte_toggle[5], FALSE, FALSE,0);
	
	
	//Box0.Separator6
	gtk_box_pack_start(GTK_BOX(box[0]), separator[6], FALSE,FALSE, 0);
	
	
	//Box0.toggle0
	gtk_box_pack_start(GTK_BOX(box[0]), base_toggle[0], FALSE, FALSE, 0);
	
	//Box0.Button
	gtk_box_pack_start(GTK_BOX(box[0]), button[0], FALSE,FALSE, 0);
	
	
	
}

void ssh_window_show(void)
{
	gtk_widget_show(base_entry[0]);
	gtk_widget_show(base_entry[1]);
	gtk_widget_show(base_entry[2]);
	gtk_widget_show(base_label[0]);
	gtk_widget_show(base_label[1]);
	gtk_widget_show(base_label[2]);
	gtk_widget_show(base_label[3]);
	gtk_widget_show(base_label[4]);
	gtk_widget_show(base_toggle[0]);
	gtk_widget_show(auth_toggle[0]);
	gtk_widget_show(auth_toggle[1]);
	gtk_widget_show(auth_toggle[2]);
	gtk_widget_show(auth_entry[0]);
	gtk_widget_show(verb_toggle[0]);
	gtk_widget_show(verb_toggle[1]);
	gtk_widget_show(forw_entry[0]);
	gtk_widget_show(forw_entry[1]);
	gtk_widget_show(forw_entry[2]);
	gtk_widget_show(forw_toggle[0]);
	gtk_widget_show(forw_toggle[1]);
	gtk_widget_show(forw_toggle[2]);
	gtk_widget_show(forw_label[0]);
	gtk_widget_show(forw_label[1]);
	gtk_widget_show(forw_label[2]);
	gtk_widget_show(forw_label[3]);
	gtk_widget_show(forw_label[4]);
	gtk_widget_show(forw_label[5]);
	gtk_widget_show(inte_entry[1]);
	gtk_widget_show(inte_entry[0]);
	gtk_widget_show(inte_toggle[5]);
	gtk_widget_show(inte_toggle[4]);
	gtk_widget_show(inte_toggle[3]);
	gtk_widget_show(inte_toggle[2]);
	gtk_widget_show(inte_toggle[1]);
	gtk_widget_show(inte_toggle[0]);
	gtk_widget_show(button[0]);
	gtk_widget_show(separator[0]);
	gtk_widget_show(separator[1]);
	gtk_widget_show(separator[2]);
	gtk_widget_show(separator[3]);
	gtk_widget_show(separator[4]);
	gtk_widget_show(separator[5]);
	gtk_widget_show(separator[6]);
	gtk_widget_show(separator[7]);
	gtk_widget_show(table[0]);
	gtk_widget_show(table[1]);
	gtk_widget_show(table[2]);
	gtk_widget_show(table[3]);
	gtk_widget_show(table[4]);
	gtk_widget_show(box[0]);
	gtk_widget_show(box[1]);
	gtk_widget_show(box[2]);
	gtk_widget_show(box[3]);
}
