/*	main.c
	Copyright (C) 2007 Mark Tyler

	This file is part of mtPaint.

	mtPaint is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 3 of the License, or
	(at your option) any later version.

	mtPaint is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with mtPaint in the file COPYING.
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <gtk/gtk.h>

#include <mtpaint.h>


#define BUTTONS_TOT 18

static void clear_background()
{
	mtpaint_selection(1, 149, 180, 248);
	mtpaint_selection_copy();
	mtpaint_paste(0, 0);
}

static void paint_sprite(int sprite, int x, int y)
{
	sprite = sprite % 8;
	mtpaint_selection(200, sprite*20, 219, 19+sprite*20);
	mtpaint_selection_copy();
	mtpaint_clipboard_alpha2mask();
	mtpaint_paste(x, y);
}

static void save_frame(int frame)
{
	char txt[128];

	snprintf(txt, 128, "frame%03i.gif", frame);
	mtpaint_selection(0, 0, 179, 99);
	mtpaint_selection_copy();
	mtpaint_clipboard_save(txt, FT_GIF, 5);
}

static gint button_click(GtkWidget *w, gpointer user)
{
	int i, j, y, item = (int) user, yo[8] = {0, 5, 2, 10, 7, 3, 12, 4 };
	char *fonts[8] = { "Sans", "Sans Bold", "Sans Bold Italic", "Sans Italic",
			"Serif", "Serif Bold", "Serif Bold Italic", "Serif Italic" };

	if ( item<0 || item>=BUTTONS_TOT ) item=0;

	switch (item)
	{
		case 0:		mtpaint_new_image(320, 200, 256, 0, 3);
				break;
		case 1:		mtpaint_rgb_a(255, 255, 0);
//				srand(123);
				for ( i=0; i<1000; i++ )
					mtpaint_pixel( rand() % 320, rand() % 200 );
				mtpaint_refresh();
				break;
		case 2:		//srand(123);
				for ( i=0; i<100; i++ )
				{
					mtpaint_col_a( rand() % 256 );
					mtpaint_line( rand() % 320, rand() % 200,
							rand() % 320, rand() % 200, rand() % 5 );
				}
				mtpaint_refresh();
				break;
		case 3:
				for ( i=0; i<100; i++ )
				{
					mtpaint_col_a( rand() % 256 );
					mtpaint_ellipse( rand() % 320, rand() % 200,
							rand() % 320, rand() % 200, rand() % 5 );
				}
				mtpaint_refresh();
				break;
		case 4:
				for ( i=0; i<100; i++ )
				{
					mtpaint_col_a( rand() % 256 );
					mtpaint_rectangle( rand() % 320, rand() % 200,
							rand() % 320, rand() % 200 );
				}
				mtpaint_refresh();
				break;
		case 5:
				for ( i=0; i<100; i++ )
				{
					mtpaint_col_a( rand() % 256 );
					mtpaint_polygon_new();
					for ( j=0; j<3; j++ )
						mtpaint_polygon_point(rand() % 320, rand() % 200);
					mtpaint_polygon_fill();

					mtpaint_col_a(0);
					mtpaint_polygon_draw();
				}
				mtpaint_refresh();
				break;
		case 6:
				for ( i=0; i<20; i++ )
				{
					mtpaint_col_a( rand() % 256 );
					mtpaint_text("libmtpaint", fonts[rand()%8], 6+rand()%10,
							rand()%360, 1);
					mtpaint_paste( rand() % 320, rand() % 200 );
				}
				mtpaint_refresh();
				break;
		case 7:
				for ( i=0; i<100; i++ )
				{
					mtpaint_paste( rand() % 320, rand() % 200 );
				}
				mtpaint_refresh();
				break;
		case 8:		gtk_widget_hide(main_window);
				break;
		case 9:		gtk_widget_show(main_window);
				break;
		case 10:	gtk_widget_set_sensitive(main_window, TRUE);
				break;
		case 11:	gtk_widget_set_sensitive(main_window, FALSE);
				break;
		case 12:	mtpaint_file_load("sprites.png");
				mtpaint_refresh();
				break;
		case 13:	mtpaint_file_save("save.png", FT_PNG, 5);
				mtpaint_refresh();
				break;
		case 14:	mtpaint_clipboard_load("clip.png");
				for ( i=0; i<20; i++ )
				{
					mtpaint_paste( rand() % 320, rand() % 200 );
				}
				mtpaint_refresh();
				break;
		case 15:	mtpaint_clipboard_save("clip.png", FT_PNG, 5);
				mtpaint_refresh();
				break;
		case 16:	mtpaint_file_load("sprites.png");
				for ( j=0; j<8; j++ )
				{
					mtpaint_selection(200, j*20, 219, 19+j*20);
					mtpaint_selection_copy();
					mtpaint_clipboard_alpha2mask();
					for ( i=0; i<10; i++ )
						mtpaint_paste( rand() % 160, rand() % 100 );
					mtpaint_refresh();
				}
				break;
		case 17:	mtpaint_file_load("sprites.png");
				for ( j=0; j<100; j++ )
				{
					clear_background();
					for ( i=0; i<8; i++ )
					{
						y = 2*j - 25 - 4*yo[i];
						if ( y<100 ) paint_sprite( ((i+j)%8), 5+i*22, y );
					}
					save_frame(j);
				}
				mtpaint_animated_gif("frame???.gif", "frames.gif", 10);
				mtpaint_refresh();
				system("gifview -a frames.gif &");
				break;
	}

	return FALSE;
}

static void init_control_window()
{
	int i, row, column;
	char *labels[BUTTONS_TOT] = {
			"New Image", "Dots", "Lines", "Ellipses", "Rectangles",
			"Polygons", "Text", "Paste", "Hide", "Show",
			"Activate", "De-Activate", "Load File", "Save File", "Load Clip",
			"Save Clip", "Sprites", "GIF animation"
			};
	GtkWidget *win, *vbox, *hbox, *button, *table;


	win = gtk_window_new (GTK_WINDOW_TOPLEVEL);
//	gtk_window_set_default_size(GTK_WINDOW(win), 800, 600);
//	gtk_window_set_position( GTK_WINDOW(win), GTK_WIN_POS_CENTER );

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (win), vbox);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

	table = gtk_table_new(4, 10, FALSE);
	gtk_box_pack_start(GTK_BOX(hbox), table, TRUE, TRUE, 0);

	for ( i=0; i<BUTTONS_TOT; i++ )
	{
		column = i % 10;
		row = i / 10;

		button = gtk_button_new_with_label(labels[i]);
		gtk_table_attach(GTK_TABLE (table), button, column, column+1, row, row+1,
			(GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			(GtkAttachOptions) (0), 0, 0);

		gtk_signal_connect( GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC (button_click), (gpointer)i );
	}

	gtk_widget_show_all (win);

	gtk_window_set_transient_for( GTK_WINDOW(win), GTK_WINDOW(main_window) );
}

int main( int argc, char *argv[] )
{
	gtk_init( &argc, &argv );

	mtpaint_mem_init();
	mtpaint_window_init();

	init_control_window();

	gtk_main();

	mtpaint_mem_end();

	return 0;
}
