#!/bin/sh
#  Deamon for adding/removing desktop icons (+fstab entries) for removable
#+ devices and permanents (if asked) 
#  Meant to be run from xinitrc
## yet another dubious Dougal script for Puppy Linux, May 2007
## Latest update: September 5th (add renicing before waiting for Rox)

# Can now be run with parameters:
# "perm":	add icons for permanent devices
# "cdrom":	add icons for cdroms like for permanent devices-don't check content
# "floppy":	add icon for floppy, like for permanent devices
# "all":	all the above
# "automount": mount each partition after adding to fstab

if [ "$1" ] ; then #parse params
  case "$@" in 
   *all*) # turn on all
    	 PERMON="yes"
    	 CDSON="yes"
    	 [ -d /sys/block/fd0 ] && FLOPPYON="yes"
    	 ;; 
       *) #else... check individual cases
         case "$@" in *perm*) PERMON="yes" ;; esac
         case "$@" in *cdrom*) CDSON="yes" ;; esac
         case "$@" in *floppy*) [ -d /sys/block/fd0 ] && FLOPPYON="yes" ;; esac
         ;;
  esac
  case "$@" in *automount*) AUTOMOUNT="yes" ;; esac
fi

##### Some variables we need
# time to sleep before checking for devices again:
INTERVAL=10
# dir this script is in (for running other scripts)
APPDIR="`dirname $0`"
[ "$APPDIR" = "." ] && APPDIR="`pwd`"
# files used
FSTAB="/etc/fstab"
PINFILE="/root/Choices/ROX-Filer/PuppyPin"
#PINFILE=$HOME/.config/rox.sourceforge.net/ROX-Filer/pb_Default
#####

## clean fstab of all sr and mmc devices
grep -E -v "/dev/sr[0-9]|/dev/mmc|/dev/ub[a-f]" $FSTAB >$FSTAB.tmp
sync
mv -f $FSTAB.tmp $FSTAB
# get contents of fstab
OLDFSTAB="`cat $FSTAB`"

## this should be done in xinitrc
##### clean all old entries from pinboard -- the "dirty" way, before Rox starts
#grep -E -v '>/mnt/[a-z]?[[:alnum:]]+<' $PINFILE >$PINFILE.tmp
#mv -f $PINFILE.tmp $PINFILE
#####

########## Some things we need to do before starting the loop: ##########

########## Update fstab

##### Add floppy entry to fstab, if needed.
if [ "$FLOPPYON" = "yes" ] ; then
  case "$OLDFSTAB" in 
	*/mnt/floppy*) ;; #entry exists -- do nothing
	*) # add
	  OPTIONS="noauto,rw" ; AFSYS="auto"
	  echo -e "/dev/fd0\t/mnt/floppy\t\t$AFSYS\t\t$OPTIONS\t\t\t\t0 0" >>$FSTAB
	  ;; #...and add again below 
  esac
fi
#####

##### Get list of cd devices and add entries to fstab (if they don't exist)
# list of all cd drives (NOTE: two command substitutions in here!)
#CDROMDRIVES="`test-eide | grep -F 'cdrom' | cut -d' ' -f1 | tr '\n' ' '` `cd /sys/block ; echo sr[0-9]* | grep -F -v '*'`"
# get only ide drives, as sr devices are treated as removables
CDROMDRIVES="`grep 'hd[a-z]' /etc/.cdrominfo | cut -d: -f1`"

TARGET1=""
if [ -e /dev/dvd ] ; then
	TARGET1="`readlink /dev/dvd`"
	# if it's an sr dev, add to CDROMDRIVES, so won't be added again later
	case "$TARGET1" in *sr[0-9]) CDROMDRIVES="$CDROMDRIVES $TARGET1" ;; esac
	case "$OLDFSTAB" in 
	 */dev/dvd*/mnt/dvd*) CDDEVS="dvd\n $CDDEVS" ;; 
	 *"$TARGET1"*) CDDEVS="${TARGET1#/dev/}\n $CDDEVS" ;; 
	 *) #else...
		[ -d /mnt/dvd ] || mkdir /mnt/dvd
		AFSYS="iso9660" ; OPTIONS="noauto,ro,utf8"
		echo -e "/dev/dvd\t/mnt/dvd\t\t$AFSYS\t\t$OPTIONS\t\t\t\t0 0" >>$FSTAB
		CDDEVS="dvd\n $CDDEVS"
		;;
	esac
fi
TARGET2="`readlink /dev/cdrom 2>/dev/null`"
# make sure that cdrom and dvd aren't the same
if [ -e /dev/cdrom ] && [ "$TARGET2" != "$TARGET1" ] ; then	
	# if it's an sr dev, add to CDROMDRIVES, so won't be added again later
	case "$TARGET2" in *sr[0-9]) CDROMDRIVES="$CDROMDRIVES $TARGET2" ;; esac
	case "$OLDFSTAB" in 
	 */dev/cdrom*/mnt/cdrom*) CDDEVS="cdrom\n $CDDEVS" ;;
	 *"$TARGET2"*) CDDEVS="${TARGET2#/dev/}\n $CDDEVS" ;; 
	 *) #else...
		[ -d /mnt/cdrom ] || mkdir /mnt/cdrom 
		AFSYS="iso9660" ; OPTIONS="noauto,ro,utf8"
		echo -e "/dev/cdrom\t/mnt/cdrom\t\t$AFSYS\t\t$OPTIONS\t\t\t\t0 0" >>$FSTAB
		CDDEVS="cdrom\n $CDDEVS"
		;;
	esac
fi
# maybe 2 cdroms (but no dvd) or 2 dvds
if [ -z "$TARGET1" -a -n "$TARGET2" ] || [ "$TARGET1" = "$TARGET2" ]; then 
	for ONECDROM in $CDROMDRIVES
	do 
	  [ "/dev/$ONECDROM" = "$TARGET2" ] && continue # we added already
	  APNT="/mnt/cdrom2"
	  grep -F "$ONECDROM:" /etc/.cdrominfo | grep -Fq 'dvd' && APNT="/mnt/dvd2"
	  case "$OLDFSTAB" in 
	   *"/dev/$ONECDROM"*"$APNT"*) CDDEVS="$ONECDROM\n $CDDEVS" ; break ;;
	   *"$APNT"*) break ;; #APNT used  
	   *"/dev/$ONECDROM"*) CDDEVS="$ONECDROM\n $CDDEVS" ; break ;; # there exists a mountpoint for device
	   *) #else...
	  	if [ -e "/dev/$ONECDROM" ]; then
		  [ -d $APNT ] || mkdir $APNT
		  AFSYS="iso9660" ; OPTIONS="noauto,ro,utf8"
		  echo -e "/dev/$ONECDROM\t$APNT\t\t$AFSYS\t\t$OPTIONS\t\t\t\t0 0" >>$FSTAB
		  CDDEVS="$ONECDROM\n $CDDEVS"
		  break
	 	fi
	 	;;
	  esac
	done	
fi
#####

# tidy up CDDEVS (change the \n to newline):
CDDEVS="`echo -e "$CDDEVS"`"

##### Get list of all devices we currently have, add to fstab and make permanent
ALLDEVS="`cd /sys/block ; echo [hs]d[a-z]* | grep -F -v '*'`"
for ADEV in $ALLDEVS
do
	[ "$ADEV" ] || continue
	# make sure it isn't IDE cdrom
	case "$ADEV" in 
	 hd*) #ide dev
	   if [ "`cat /proc/ide/$ADEV/media`" != "disk" ] ;then continue ; fi
	   ;;
	 sd*) #scsi drive
	   if [ "`cat /sys/block/$ADEV/removable`" = "1" ]; then #removable
	     if ! mount | grep -F "/dev/$ADEV" | grep -F -q '/initrd/mnt/' ; then
	   	   continue # not drive we booted from
	     fi
	   else # =0
	     case "`cat /sys/block/$ADEV/device/vendor`" in
	      *ATA*) # sata drive - go on and add to permanenets
	        ;; 
	      *) # either scsi HD or removable USB HD (can also be bad flash drive)
	        case "`cat /sys/block/$ADEV/device/model`" in
	         *[Ff][Ll][Aa]Ss][Hh]*) # probably flash drive
	           if ! mount | grep -F "/dev/$ADEV" | grep -F -q '/initrd/mnt/'
	             then continue # not drive we booted from
	           fi
	           ;;
	         *External*|*[Uu][Ss][Bb]*) #usb hd
	           if ! mount | grep -F "/dev/$ADEV" | grep -F -q '/initrd/mnt/' 
	             then continue # not drive we booted from, skip
	           fi
	           ;; 
	         *) # let's assume it a scsi HD...
	           ;; 
	        esac
	        ;;
	     esac
	   fi
	   ;;
	esac 
	# now add to list of permanent devices and add fstab entries
	if [ "$PERMON" = "yes" ] ; then # have the option of only handling removables
	  $APPDIR/add_device_to_fstab $ADEV $AUTOMOUNT || continue
	fi
	PERMANENTS="$PERMANENTS $ADEV"
done
#####

##### Clean "old" entries out of fstab (pinboard done above)
# (we don't have a "proper" shutdown in Puppy, so might have from last boot)
## This had deleting of [0-9], but it's not good for mmc and sr
OLDDEVS="`grep '[hs]d[a-z]' $FSTAB | tr '\t' ' ' | cut -d' ' -f1 | sed 's%/dev/%%g' | tr -d '[0-9]' | sort | uniq | tr '\n' ' '`"
## No! remove all sr and mmc devices at the beginning.
# get mmc, sr devices (need to delete the "p#" from mmc partitions
#OLDDEVS2="`grep -E 'sr[0-9]|mmc' $FSTAB | tr '\t' ' ' | cut -d' ' -f1 | sed 's%/dev/%%g' | sed 's%p[0-9]%%g' | sort | uniq | tr '\n' ' '`"
#OLDDEVS="$OLDDEVS1 $OLDDEVS2"
for AOLD in $OLDDEVS
do
	[ "$AOLD" ] || continue # this is a precaution... in case OLDDEVS is empty
	# don't touch permanent devices -- might be added by user
	case "$PERMANENTS" in *$AOLD*) continue ;; esac
	# if we got here, device has been removed
	# if it's a cd device -- we want to leave the fstab entry
	case "$CDDEVS" in *$AOLD*) continue ;; esac
	grep -F -v "/dev/$AOLD" $FSTAB >$FSTAB.tmp
	mv -f $FSTAB.tmp $FSTAB
done
##### 

###### Check if we have a floppy drive
#if [ -d /sys/block/fd0 ] ; then
 #FLOPPY="fd0"
#fi
######

###### Renice process, so it's lower in priority than Rox
renice 19 -p $$
######

##### Wait until Rox is running before using pinboard
until pidof ROX-Filer >/dev/null
do sleep 1 
done
#####

########## Update pinboard (if not only removables)

##### Add pinboard icon for floppy
if [ "$FLOPPYON" = "yes" ] ; then
  $APPDIR/add_icons_for_device fd0
fi
#####

##### Add pinboard icons for permanent devices (only if run with param)
if [ "$PERMON" = "yes" ] ; then
  for ADEV in $PERMANENTS
  do
	# add to pinboard
	$APPDIR/add_icons_for_device $ADEV
  done
fi
#####

##### Add pinboard icons for cdroms
if [ "$CDSON" = "yes" ] ; then
  for ADEV in $CDDEVS
  do
	$APPDIR/add_icons_for_device $ADEV
  done
fi
#####

# count how many times "usb" apears in dmesg output -- so don't always check
# start with 0, so at the first round of the loop it will work
## Replaced use of dmesg by counting in /var/log/messages
OLDDMESG=0

################################  The loop  ################################
while true ; do
	
  if [ "$CDSON" != "yes" ] ; then #check cd drives
	for ACD in $CDDEVS
	do
		[ "$ACD" ] || continue
		# first look if new cd inserted (clumsy...)
		case `/usr/lib/mut/bin/cdrominfo /dev/$ACD -p | cut -d'|' -f8` in 
		none|Audio) # no cd in drive (or audio, which can't be mounted)
		  case "$ONCDS" in *$ACD*) # cd was removed
		    # remove link
		    $APPDIR/remove_icons_for_device $ACD
		    ONCDS="`echo "$ONCDS" | grep -v "$ACD"`"
		    ;;
		  esac
		  ;;
		#Audio) # audio cd, only add icon for /dev/cdrom
		  #case "$ONCDS" in *$ACD*) continue ;; esac
		  #if [ "$" = "cdrom" ] ; then
		    ## add link to desktop
		    #$APPDIR/add_icons_for_device $ACD
		    #ONCDS="$ONCDS
 #$ACD"
          #fi
		  #;;
		*) # there's a cd inside
		  case "$ONCDS" in *$ACD*) continue ;; esac
		  # add link to desktop
		  $APPDIR/add_icons_for_device $ACD
		  ONCDS="$ONCDS
 $ACD"
		  ;;
		esac
	done
	# in case a removable cdrom was disconnected without being emptied first
	for AON in $ONCDS
	do
	  case "$CDDEVS" in *$AON*) continue ;; esac
	  # we got here, so it must have been removed
	  ONCDS="`echo "$ONCDS" | grep -v "$ACD"`"
	done
  fi #checking cdroms

  # Now check if any USB devices added/removed (they register in dmesg)
  ## add mmc
  NEWDMESG=`grep -E -ic 'usb|mmc' /var/log/messages`
  ### using stat not so good -- too precise
  ## Replace dmesg count with check of last mod. time of /proc/bus/usb/devices
  ## (I'll keep the param name... makes it easier to change back if needed)
  #NEWDMESG=`stat -c%Y /proc/bus/usb/devices`
  if [ $NEWDMESG -gt $OLDDMESG ] ; then
      # first do this for next time
      OLDDMESG=$NEWDMESG
      # now see what has changed
	  # get list of current sd devices
	  CURRENT="`ls -1 /sys/block | grep -E 'sd[a-z]|sr[0-9]|mmc|ub[a-f]'`"
	  # check for removed devices
	  for AON in $ONSDEVS
	  do
		[ "$AON" ] || continue
		case "$CURRENT" in *$AON*) continue ;; esac
		# if we got here, device was removed
		# remove links
		$APPDIR/remove_icons_for_device $AON
		# force unmounting of any stray partitions...
		STRAYPOINTS="`mount | grep -F "/dev/$AON" | tr -s ' ' | cut -f3 -d' ' | tr '\n' ' '`"
		if [ "$STRAYPOINTS" ] ; then
		  for APNT in $STRAYPOINTS ; do
		    umount -f $APNT
		  done
		fi
		# remove from fstab (removes all partitions for this device)
		grep -F -v "/dev/$AON" $FSTAB >$FSTAB.tmp
		sync
		mv -f $FSTAB.tmp $FSTAB
		# remove from our list
		ONSDEVS="`echo "$ONSDEVS" | grep -v "$AON"`"
		# if it's a cdrom, remove from cdrom list (and refresh cdrominfo)
		case "$AON" in sr[0-9])
		  CDDEVS="`echo "$CDDEVS" | grep -v "$AON"`" 
		  make-cdrominfo
		  ;;
		esac
	  done
	  
	  # check for new devices
	  for ASD in $CURRENT
	  do
		# first make sure it's not a permanent device
		case "$PERMANENTS" in *$ASD*) continue ;; esac
		# now check it's not already "on" (includes cds, too)
		case "$ONSDEVS" in *$ASD*) continue ;; esac
		# might be linked to /dev/cdrom or /dev/dvd
		case "$CDROMDRIVES" in *$ASD*) continue ;; esac
		# must be new removable
		## split it to cdroms and others: cdroms don't need fs check
		case "$ASD" in
		 sr[0-9]) # cdrom device, add "manually" to fstab
		   # refresh cdrominfo file
		   make-cdrominfo
		   # get the type of device it is, use for deciding on mountpoint
		   if grep -F "$ASD:" /etc/.cdrominfo | grep -Fq 'dvd' ; then
		     APNT="/mnt/dvd"
		   else
		     APNT="/mnt/cdrom"
		   fi
		   grep -F -q "$APNT" $FSTAB && APNT="${APNT}2"
		   grep -F -q "$APNT" $FSTAB && APNT="${APNT%2}3"
		   # add to fstab
		   [ -d $APNT ] || mkdir $APNT
		   AFSYS="iso9660" ; OPTIONS="noauto,ro"
		   echo -e "/dev/$ASD\t$APNT\t\t$AFSYS\t\t$OPTIONS\t\t0 0" >>$FSTAB
		   # add to cdrom list
		   CDDEVS="$CDDEVS
 $ASD"
		   # now, add icon if required:
		   if [ "$CDSON" = "yes" ] ; then
		     $APPDIR/add_icons_for_device $ASD
		   fi
		   ;;
		 *) # other devices
		   # add fstab entries for device (if device doesn't exist, skip)
		   $APPDIR/add_device_to_fstab $ASD $AUTOMOUNT || continue
		   # add links for device
		   $APPDIR/add_icons_for_device $ASD
		   ;;
		esac
		# add to list
		ONSDEVS="$ONSDEVS
 $ASD"
	  done
  fi # if [ $NEWDMESG -gt $OLDDMESG ]			
  # sleep before checking again
  sleep $INTERVAL
done
##############################  end loop  ##############################

