#! /bin/bash
#
#  fotox-build.sh

g++ > /dev/null 2>&1
if [ $? -ne 1 ]
then
   echo "*** You must install the GCC compiler package"
   echo "    (C/C++ software development, g++ command)"
   exit 1
fi

pkg-config --cflags gtk+-2.0 --libs gtk+-2.0 gthread-2.0 > /dev/null 2>&1
if [ $? -ne 0 ]
then
   echo "*** You must install the GTK+ development package"
   echo "    (GTK+ software development, libgtk2.0-dev)"
   exit 1
fi

g++ -O3 -Wall -o fotox.x fotox.cpp zlib.cpp              \
         $(pkg-config --cflags gtk+-2.0)                 \
         $(pkg-config --libs gtk+-2.0)                   \
         $(pkg-config --libs gthread-2.0)            

if [ $? -eq 0 ]
then 
   echo "fotox build successful"
   chmod a+rx fotox.x
   chmod -R a+r *
   exit 0
fi

exit 1



## g++  -g  -O0 -o fotox.x fotox.cpp zlib.cpp               \        ## debug build
## g++ -O3 -Wall -o fotox.x fotox.cpp zlib.cpp              \        ##  normal build
