.\".ds LB /usr/lib/canna
.ds LB /usr/local/canna/lib
.TH DPBINDIC 1
.SHNAME
dpbindic \- Convert a binary-form dictionary into the text-form dictionary
.SHSYNOPSYS
.B dpbindic
[
.B\-xiu
[
.I frequency
]
]
.I "binary-file"
[
.I "text-file"
]
.SH DESCRIPTION
.I Dpbindic
outputs the file information of the binary-form dictionary file specified in
\B "binary-file".
At this time, the word information of the dictionary can be output in text form
to the standard output.  To do so, use
.I "test-file"
to specify the text-form dictionary used as the source of binary-form
dictionary file.  If this specification is omitted, the text
dictionary file information in the binary dictionary file will be
output.  The standard grammar file name is
\*(LB/dic/hyoujun.gram. It will be used if the grammar file
name specification is omitted.  The output format of word information
data is specified using an option.
.SHOPTIONS
.TP
.B\-x
Outputs the data without using omission symbol @, which is used when the initial word represents the reading.
.TP
.B\-i
Replaces the reading and word for output.
.TP
.B\-u
Outputs the candidates used in conversion.  Outputs all candidates having 
.I frequency
or more.  If
.I frequency
is omitted, all candidates having frequency 1 will be output.
.SHEXAMPLES
.PP
(1) If the text-form dictionary file name is omitted:
.nf
.B
%dibindic iroha.d
.B
(Text dictionary file name = Directory size + Word size, packed)
.B
iroha.swd = 2985 + 5306 pak a4
.B
iroha.mwd = 36276 + 113139 pak a4
.PP
(2) If the text-form dictionary file name iroha.mwd is specified:
.nf
.B
%dpbindic iroha.d iroha.mwd
.B
(Text dictionary file name = Directory size + Word size, packed)
.B
iroha.mwd = 36276 + 113139 pak a4

.\" Copyright 1994 NEC Corporation, Tokyo, Japan.
.\"
.\" Permission to use, copy, modify, distribute and sell this software
.\" and its documentation for any purpose is hereby granted without
.\" fee, provided that the above copyright notice appear in all copies
.\" and that both that copyright notice and this permission notice
.\" appear in supporting documentation, and that the name of NEC
.\" Corporation not be used in advertising or publicity pertaining to
.\" distribution of the software without specific, written prior
.\" permission.  NEC Corporation makes no representations about the
.\" suitability of this software for any purpose.  It is provided "as
.\" is" without express or implied warranty.
.\"
.\" NEC CORPORATION DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
.\" INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN 
.\" NO EVENT SHALL NEC CORPORATION BE LIABLE FOR ANY SPECIAL, INDIRECT OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF 
.\" USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR 
.\" OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR 
.\" PERFORMANCE OF THIS SOFTWARE. 
.\"
.\" $Id: dpbindic.man,v 1.1.1.1 2002/10/19 08:27:34 aida_s Exp $
