#!/bin/sh
#v2.0 : GUI
#v2.1 10dec09: vitual disk info
#v2.2 30dec09: bugfix: was overwriting virtualpc disk image, refine to find bootable cd
MYVERSION=2.2
CREDIT="QemuPuppy $MYVERSION"
ABOUT="30 Dec 2009 by shinobar <shino@pos.to>"
#MYOPTION="$1"

# initial values
MODEL="QemuPuppy-$MYVERSION"
DEFAULTRAM=256	# MegaByte
DEFAULTDISKSIZE=10G	# default new virtual disk size
ADDOPT0="-localtime -name $MODEL" # basic options for qemu
ADDOPT="-soundhw all"	# additional options for qemu
HELPPAGE="qemupuppy"
CD=""
FD0=""
FD1="NOGUI"	# 'NOGUI' suppresses GUI box for FD1
SDA=""
SDB=""
BOOT=""
NULL="(none)"

# move to my directory
MYPATH="$0"
[ -L "$MYPATH" ] && MYPATH=$(readlink "$MYPATH")
MYPATH=$(dirname "$MYPATH")
[ "$MYPATH" != "." ] && cd "$MYPATH"
export MYPATH=$(pwd)
MYPC="$MYPATH/virtualpc"
MYSTOCK="$MYPATH/stocks"
LOGFILE="/tmp/$(basename "$0").log"
ERRFILE="/tmp/$(basename "$0").err"

# enable kqemu module if can
if [ ! -c /dev/kqemu ] ;then
  if ! modprobe kqemu && [ -f /lib/modules/$(uname -r)/misc/kqemu.ko ] ; then
          depmod -a && modprobe kqemu
  fi
fi

# which man command
which pman &>/dev/null && MAN=pman || MAN=man

XPID=""
mysplash() {
	[ "$XPID" != "" ] && kill $XPID
   case "$1" in
     start)
       shift;;
     stop) return;;
   esac
   DIALOG="<window title=\"QemuPupy\"><vbox>
      <text><input>echo -e \"$@\"</input></text>
      </vbox></window>"
   echo "$DIALOG"
   gtkdialog3 -p DIALOG -c >/dev/null &
   XPID=$!
}

make_combo() {
  ADDNULL=""
  [ "$1" = '-' ] && ADDNULL="yes" && shift
  CHOICE=""
  LIST="$@"
  [ "$ADDNULL" = "" ] || echo "$@" | grep -q "$NULL" || LIST="$@ $NULL"
for ONEITEM in $LIST;do
  echo "$CHOICE" | grep -q "<item>$ONEITEM</item>" && continue
  CHOICE="$CHOICE
  <item>$ONEITEM</item>"
done
  echo "$CHOICE"
}
# virtual disk info
deatail() {
 LIST="<label> File name                 |type    |Virtual|Real sz</label>"
 for D in $@;do
  [ -d "$D" ] && cd "$D"
  BASE=$(basename "$D")
  LIST="$LIST
<item>--- $BASE||||</item>"
  for F in $(find . -follow -type f -name '*.img'|sort) $(find . -follow -type f -name '*.iso'|sort);do
   if echo $F| grep -q '.img$'; then
     ONEINFO=$(LANG=C qemu-img info "$F"|head -n 4|tail -n 3|cut -d':' -f2|cut -d' ' -f2)
   else
     ONEINFO="iso - $(du -h $F|cut -d' ' -f1)"
   fi
   ONEITEM="<item>$(basename $F)"
   for I in $ONEINFO; do
     ONEITEM="$ONEITEM|$I"
   done
   LIST="$LIST
   $ONEITEM</item>"
  done
 done
 echo "$LIST"
}

avoidnamedup() {
  DIR=$(dirname "$1")
  BASE=$(basename "$1" .img)
  for TAIL in '' $(seq 1 9);do
    DUP=""
    FILENAME="$BASE$TAIL.img"
    #echo "$FILENAME"
    [ -f "$MYPC/$FILENAME" ] || [ -f "$MYSTOCK/$FILENAME" ] || break
    DUP="yes"
    [ "$TAIL" = "" ] && BASE="$(echo $BASE|sed -e 's/[0-9]$//')"
  done
  [ "$DUP" = "" ] && echo "$DIR/$FILENAME" && return
  DIALOG="<window title=\"Qemu error\"><vbox>
    <hbox>
      <pixmap icon_size=\"3\"><input file stock=\"gtk-dialog-error\"></input></pixmap>
      <text><label>Duplicate file name.</label></text>
    </hbox>
    <text><label>$1</label></text>
    <hbox><button ok></button></hbox>
</vbox></window>"
    gtkdialog3 -p DIALOG -c >/dev/null
  return 1
}
# creat virtal disks
create_disk() {
	SIZECHOICE=$(make_combo $DEFAULTDISKSIZE '1.44M(Floppy)' 1G 2G 4G 10G 20G 40G 80G 160G 300G 500G 1T 2T 3T)
  DLIST=$(deatail "$MYPC" "$MYSTOCK")
  export DIALOG="<window title=\"Qemu create new virtual disk\"><hbox>
<frame Create new disk image>
    <pixmap icon_size=\"5\"><input file stock=\"gtk-save-as\"></input></pixmap>
   <hbox>
   <text><label>Name: sdx_</label></text>
   <entry><variable>FNAME</variable></entry>
   <text><label>.img</label></text>
   </hbox>
   <hbox>
   <text><label>Size:</label></text>
   <combobox><variable>SIZE</variable>
      $SIZECHOICE
      </combobox>
   </hbox>
   <hbox>
   <radiobutton><label>qcow2</label>
   <variable>TYPEQCOW2</variable><default>yes</default></radiobutton>
   <radiobutton><label>vmdk</label>
   <variable>TYPEVMDK</variable></radiobutton>
   </hbox>
   <hbox>
    <button tooltip-text=\"Help\"><input file icon=\"gtk-help\"></input><action>$MAN $HELPPAGE &</action></button>
     </hbox>
   <hbox>
      <button ok></button>
      <button cancel></button>
    </hbox>
    </frame>
    <frame Disk Info.>
    <table><width>300</width><height>200</height>
    <variable>TABLE</variable>
 	$DLIST
    </table>
    </frame>
</hbox></window>"
  RET=$(gtkdialog3 -p DIALOG -c| grep -E '^[A-Z][0-9A-Z]*=')
  #echo "$RET"
  eval "$RET"
  [ "$EXIT" = "OK" ] || return
  SIZE=$(echo $SIZE|cut -d'(' -f1) #)
  SIZESAVE="$SIZE"
  UNIT=$(echo $SIZE|tr -d '0-9.')
  case $UNIT in
  M) SIZE="1440K";;
  T) SIZE="$(expr $(echo $SIZE|tr -d 'T') '*' 1024)G";;
  esac
  TYPE=$(echo "$RET" | grep '^TYPE[0-9A-Z]*=.*true'| cut -d'=' -f1| cut -b 5-|tr 'A-Z' 'a-z')
  FNAME=$(basename "$FNAME" .img)
  FNAME=$(echo -n $FNAME|tr -c '0-9A-Za-z.' '_')
  ROOT=""
  [ "$UNIT" = 'M' ] && [ "$FNAME" = "" ] && ROOT="fd2HD"
  [ "$ROOT" = "" ] && [ "$UNIT" = 'M' ] && ROOT="fd_$FNAME"
  [ "$ROOT" = "" ] && [ "$FNAME" = "" ] && ROOT="sdx$SIZESAVE"
  [ "$ROOT" = "" ] && ROOT="sdx_$FNAME"
  FILENAME=$(avoidnamedup "$MYSTOCK/$ROOT$TAIL.img")
  if [ "$FILENAME" = "" ]; then
    DIALOG="<window title=\"Qemu create error\"><vbox>
    <hbox>
      <pixmap icon_size=\"3\"><input file stock=\"gtk-dialog-error\"></input></pixmap>
      <text><label>Duplicate file name.</label></text>
    </hbox>
    <text><label>$ROOT.img</label></text>
    <hbox><button ok></button></hbox>
</vbox></window>"
    gtkdialog3 -p DIALOG -c >/dev/null
    return
  fi
  mysplash "Creating a disk image...\nWait..."
  CMD="qemu-img create -f $TYPE $FILENAME $SIZE"
  date > $LOGFILE
  echo "$CMD" >> $LOGFILE
  echo $CMD
  $CMD &> $ERRFILE ; STATUS=$?
  mysplash stop
  ADDINFO=""
  if [ $STATUS -ne 0 ]; then
   if [ "$UNIT" != "M" ] && [ $(echo $SIZE|tr -d -c '0-9') -gt 1024 ]; then
     NEWSIZE=$(LANG=C qemu-img info $FILENAME|grep 'virtual size:'|tr -s ' '|cut -d' ' -f2)
     [ "$NEWSIZE" != "" ] && \
     ADDINFO="qemu-img seems segfault, but it seems okey."
   fi
   if [ "$ADDINFO" = "" ]; then
     DIALOG="<window title=\"Qemu create error\"><vbox>
      <pixmap icon_size=\"3\"><input file stock=\"gtk-dialog-error\"></input></pixmap>
      <text><label>An error occured.</label></text>
    <frame>
    <text><input>cat $LOGFILE $ERRFILE</input></text>
    </frame>
    <hbox><button ok></button></hbox>
</vbox></window>"
      gtkdialog3 -p DIALOG -c
      return
    fi
  fi  
  # success
   [ "$ADDINFO" != "" ] && ADDINFO="<text><label>$ADDINFO</label></text>"
   DIALOG="<window title=\"Qemu create\"><vbox>
      <pixmap icon_size=\"3\"><input file stock=\"gtk-dialog-info\"></input></pixmap>
      <text><label>A new disk successfully created.</label></text>
      $ADDINFO
    <frame>
    <text><input>qemu-img info $FILENAME 2>&1</input></text>
    </frame>
    <hbox><button ok></button></hbox>
</vbox></window>"
    gtkdialog3 -p DIALOG -c
 rm -f $LOGFILE $ERRFILE   
}

# how do i called
case "$1" in
*info) shift; vdinfo "$@";exit ;;
esac

# scan real PC
RAMLIMIT=$(LANG=C free|grep -i '^total:'| tr -s ' '| cut -d' ' -f2) 
[ "$RAMLIMIT" != "" ] && RAMLIMIT=$(expr $RAMLIMIT / 1024 - 128) || RAMLIMIT=512
[ $RAMLIMIT -gt 1024 ] && RAMLIMIT=1024	# max ram qemu supports
[ -b /dev/cdrom ] && DEVCD=$(readlink /dev/cdrom | cut -d'/' -f3) || DEVCD=""
[ -b /dev/fd0 ] && DEVFD="/dev/fd0" || DEVFD=""

MSG="You can change the componets."
while [ "$MSG" != "" ]; do

  # scan the virtual PC componentss
  cd "$MYPC"
  [ -f ADDOPT ] && ADDOPT=$(cat ADDOPT 2>/dev/null)
  [ -f RAMSIZE ] && RAM=$(cat RAMSIZE 2>/dev/null|tr -d -c '0-9')
  [ "$RAM" = "" ] && RAM=0
  [ $RAM -eq 0 ] && [ "$DEFAULTRAM" != "" ] && RAM=$DEFAULTRAM
  [ $RAM -gt $RAMLIMIT ] && RAM=$RAMLIMIT
  BOOTABLECD=""
  [ "$CD" = "" ] && CD=$(ls -1 *.iso 2>/dev/null | tail -n 1)
  echo "$CD"| grep -q '.iso$' && BOOTABLECD="$CD"
  [ -d /root/.pup_event/drive_$DEVCD ] && CD=/dev/cdrom && BOOTABLECD="/dev/cdrom"
  [ "$CD" = "" -a "$DEVCD" != "" ] && CD="/dev/cdrom"
  [ "$FD0" = "" ] && FD0=$(ls -1 fd*.img 2>/dev/null | tail -n 1)
  [ "$FD0" != "" ] && BOOTABLEFD="$FD0" || BOOTABLEFD=""
  [ "$FD0" = "$NULL" ] && BOOTABLEFD=""
  [ "$FD1" = "" ] && FD1=$(ls -1 fd*.img 2>/dev/null |grep -v "^$FD0\$" | tail -n 1)
  [ "$FD0" = "" ] && [ "$DEVFD" != "" ] && FD0="$DEVFD"
  [ "$SDA" = "" ] && SDA=$(ls -1 ?da*.img 2>/dev/null | tail -n 1)
  [ "$SDA" = "" ] && SDA=$(ls -1 [^f]?[^b]*.img 2>/dev/null | tail -n 1)
  [ "$SDB" = "" ] && SDB=$(ls -1 ?db*.img 2>/dev/null | tail -n 1)
  [ "$SDA" = "" ] && SDA=$(ls -1 [^f]*.img 2>/dev/null |grep -v "^$SDB\$"| tail -n 1)
  [ "$SDB" = "" ] && SDB=$(ls -1 [^f]*.img 2>/dev/null |grep -v "^$SDA\$"| tail -n 1)
  # from where to boot
  BOOT=""
  [ "$BOOTABLECD" != "" ] && BOOT="d"
  [ "$BOOT" = "" ] && [ "$BOOTABLEFD" != "" ] && BOOT="a"

# GUI
  cd "$MYSTOCK"
  OLDOPT="$ADDOPT"
  # ram size option
  OLDRAM="$RAM"
  RAMCHOICE=""
  for M in 32 64 96 128 192 256 380 512 640 1024 1536 2048 3036 3295;do
    [ $M -le $RAMLIMIT ] && RAMCHOICE="$RAMCHOICE $M"
  done
  RAMCHOICE=$(make_combo $RAM $RAMCHOICE)
  [ "$CD" = "" ] && CD="$NULL" 
  OLDCD="$CD"
  cd "$MYPC"
  CDS="$CD $(ls *.iso 2>/dev/null)"
  cd "$MYSTOCK"
  CDS="$CDS $(ls *.iso 2>/dev/null)"
  [ "$CD" != "/dev/cdrom" ] && [ "$DEVCD" != "" ] && \
  CDS="$CDS /dev/cdrom"
  CDCHOICE=$(make_combo - $CDS)
  [ "$FD0" = "" ] && FD0="$NULL" 
  [ "$FD1" = "" ] && FD1="$NULL" 
  OLDFD0="$FD0"
  OLDFD1="$FD1"
  FDS="$(ls fd*.img 2>/dev/null |grep -v -E "^($FD0|$FD1)\$")"
  FDCHOICE1=$(make_combo - $FD1 $FDS)
  [ "$FD0" != "/dev/fd0" ] && [ "$DEVFD" != "" ] && \
  FDS="$FDS /dev/fd0"
  FDCHOICE0=$(make_combo - $FD0 $FDS)
  [ "$SDA" = "" ] && SDA="$NULL"
  OLDSDA="$SDA"
  SDACHOICE=$(make_combo - $SDA $(ls [^f]*.img 2>/dev/null|grep -v -E "^($SDA|$SDB)\$"))
  [ "$SDB" = "" ] && SDB="$NULL"
  OLDSDB="$SDB"
  SDBCHOICE=$(make_combo - $SDB $(ls [^f]*.img 2>/dev/null|grep -v -E "^($SDA|$SDB)\$"))
  BOOTCD=""
  BOOTFD=""
  BOOTHD=""
  DEFAULT="<default>yes</default>"
  case "$BOOT" in
  a) BOOTFD="$DEFAULT" ;;
  d) BOOTCD="$DEFAULT" ;;
  *) BOOTHD="$DEFAULT" ;;
  esac
  OPTDEFAULT=""
  [ "$ADDOPT" != "" ] && OPTDEFAULT="<default>$ADDOPT</default>"
  DLIST=$(deatail "$MYPC" "$MYSTOCK")
  [ "$FD1" = "NOGUI" ] && FD1BOX="" || \
  FD1BOX="<hbox>
      <text><label>fd1</label></text>
      <pixmap icon_size=\"3\" tooltip-text=\"The 2nd floppy disk\"><input file stock=\"gtk-floppy\"></input></pixmap>
        <combobox><variable>FD1</variable>
       $FDCHOICE1
       </combobox>
   </hbox>"
  export DIALOG="<window title=\"QemuPuppy\">
  <vbox>
  <text><label>$CREDIT</label></text>
  <text><label>$MSG</label></text>
  <hbox>
  <frame Virtual PC>
    <hbox>
      <text><label>RAM size(MB):</label></text>
      <combobox width-request=\"120\"><variable>RAM</variable>
      $RAMCHOICE
      </combobox>
     </hbox>
    <hbox>
       <pixmap icon_size=\"3\" tooltip-text=\"CD/DVD\"><input file stock=\"gtk-cdrom\"></input></pixmap>
       <combobox><variable>CD</variable>
       $CDCHOICE
       </combobox>
   </hbox>
     <hbox>
      <text><label>fd0</label></text>
      <pixmap icon_size=\"3\" tooltip-text=\"The 1st floppy disk\"><input file stock=\"gtk-floppy\"></input></pixmap>
        <combobox><variable>FD0</variable>
       $FDCHOICE0
       </combobox>
   </hbox>
     $FD1BOX
    <hbox>
       <text><label>sda</label></text>
       <pixmap icon_size=\"3\" tooltip-text=\"The 1st HDD\"><input file stock=\"gtk-harddisk\"></input></pixmap>
       <combobox><variable>SDA</variable>
       $SDACHOICE
       </combobox>
   </hbox>
   <hbox>
      <text><label>sdb</label></text>
       <pixmap icon_size=\"3\" tooltip-text=\"The 2nd HDD\"><input file stock=\"gtk-harddisk\"></input></pixmap>
       <combobox><variable>SDB</variable>
       $SDBCHOICE
       </combobox>
    </hbox>
    <hbox>
     <text><label>Boot from:</label></text>
     <radiobutton><label>CD</label><variable>BOOTD</variable>$BOOTCD</radiobutton>
     <radiobutton><label>Floppy</label><variable>BOOTA</variable>$BOOTFD</radiobutton>
     <radiobutton><label>HDD</label><variable>BOOTC</variable>$BOOTHD</radiobutton>
    </hbox>
     <hbox>
     <entry><variable>ADDOPT</variable><visible>disabled</visible>$OPTDEFAULT</entry>
   <button tooltip-text=\"Advanced options\"><input file icon=\"gtk-preferences\"></input><action type=\"enable\">ADDOPT</action>
</button>
     </hbox>
    </frame>
    <frame Disk Info.>
    <table><width>300</width><height>200</height>
    <variable>TABLE</variable>
 	$DLIST
    </table>
     <hbox>
   <button tooltip-text=\"Create new disks\"><input file stock=\"gtk-save-as\"></input><label>Create</label></button>
   <button tooltip-text=\"Open ROX-Filer\"><input file stock=\"gtk-open\"></input><action>rox \"$MYPATH\" &</action></button>
     </hbox>
    </frame>
    </hbox>
   <hbox>
      <button ok></button>
      <button tooltip-text=\"Refresh\"><input file stock=\"gtk-refresh\"></input><action>EXIT:Refresh</action></button>
      <button tooltip-text=\"Help\"><input file icon=\"gtk-help\"></input><action>$MAN $HELPPAGE &</action></button>
      <button tooltip-text=\"Quit\"><input file stock=\"gtk-quit\"></input><action>EXIT:Quit</action></button>
    </hbox>
  </vbox>
</window>"
  #echo "$DIALOG"
  RET=$(gtkdialog3 -p DIALOG -c | grep -E '^[A-Z][0-9A-Z]*=')
  #echo "$RET"
  eval "$RET"
  #echo "EXIT=$EXIT"
   if [ "$EXIT" = "Create" ]; then
    create_disk
    exec $0
  fi
  [ "$EXIT" = "OK" ] || [ "$EXIT" = "Refresh" ] || exit
# restruct
  CHANGED=""
  [ "$ADDOPT" != "$OLDOPT" ] && echo -n "$ADDOPT" > "$MYPC/ADDOPT"
  [ "$RAM" != "$OLDRAM" ] && echo -n "$RAM" > "$MYPC/RAMSIZE"
  if [ "$CD" != "$OLDCD" ]; then
    CHANGED="yes"
    CD=$(echo $CD|sed -e "s,^$OLDCD,,")
    if [ "$CD" = "/dev/cdrom" -o "$CD" = "$NULL" ]; then
      mv -f $MYPC/*.iso "$MYSTOCK" 2>/dev/null
    elif [ -f "$MYSTOCK/$CD" ]; then
        mv -f $MYPC/*.iso "$MYSTOCK" 2>/dev/null
        mv -f $MYSTOCK/$CD "$MYPC"
    else
        CD="$OLDCD"
    fi
  fi
  if [ "$FD0" != "$OLDFD0" ]; then
    CHANGED="yes"
    FD0=$(echo $FD0|sed -e "s,^$OLDFD0,,")
    REMOVE=""
    if [ "$FD0" = "/dev/fd0" -o "$FD0" = "$NULL" ]; then
      REMOVE="yes"
    elif [ "$(echo $FD0|sed -e 's/^[^.]*\.//')" = "img" ]; then
     [ -f "$MYSTOCK/$FD0" ] &&
       mv -f "$MYSTOCK/$FD0" "$MYPC" && REMOVE="yes"
    fi
    [ "$REMOVE" = "yes" ] || FD0="$OLDFD0"
    if [ "$REMOVE" = "yes" -a -f "$MYPC/$OLDFD0" ]; then
      NEWSTOCK=$(avoidnamedup "$MYSTOCK/$OLDFD0")
      [ "$NEWSTOCK" != "" ] && mv -f "$MYPC/$OLDFD0" "$NEWSTOCK"
    fi
  fi
  if [ "$FD1" != "$OLDFD1" ]; then
    CHANGED="yes"
    FD1=$(echo $FD1|sed -e "s,^$OLDFD1,,")
    REMOVE=""
    if [ "$FD1" = "$NULL" ]; then
      REMOVE="yes"
    elif [ "$(echo $FD1|sed -e 's/^[^.]*\.//')" = "img" ]; then
     [ -f "$MYSTOCK/$FD1" ] &&
       mv -f "$MYSTOCK/$FD1" "$MYPC" && REMOVE="yes"
    fi
    [ "$REMOVE" = "yes" ] || FD1="$OLDFD1"
    if [ "$REMOVE" = "yes" -a -f "$MYPC/$OLDFD1" ]; then
      NEWSTOCK=$(avoidnamedup "$MYSTOCK/$OLDFD1")
      [ "$NEWSTOCK" != "" ] && mv -f "$MYPC/$OLDFD1" "$NEWSTOCK"
    fi
  fi
  # disks
  if [ "$SDA" != "$OLDSDA" ]; then
    CHANGED="yes"
    SDA=$(echo $SDA|sed -e "s,^$OLDSDA,,")
    REMOVE=""
    if [ "$SDA" = "$NULL" ]; then
      REMOVE="yes"
    elif [ "$(echo $SDA|sed -e 's/^[^.]*\.//')" = "img" ]; then
     if [ -f "$MYSTOCK/$SDA" ]; then
      if echo $SDA|grep -q '^sda' ;then
        NEWSD="$MYPC/$SDA"
       [ -f "$NEWSD" ] && NEWSD=$(avoidnamedup "$NEWSD")
      else
        NEWSD=$(avoidnamedup "$MYPC/sda$(echo $SDA|cut -c 4-)")
      fi
      mv -f "$MYSTOCK/$SDA" "$NEWSD" && SDA=$(basename "$NEWSD") && REMOVE="yes"
     #elif [ -f "$SDA" ];then
     #  ln -sf "$SDA" "$MYPC" && REMOVE="yes"
     fi
    fi
    [ "$REMOVE" = "yes" ] || SDA="$OLDSDA"
    if [ "$REMOVE" = "yes" -a -f "$MYPC/$OLDSDA" ]; then
      #[ -L "$MYPC/$OLDSDA" ] && rm -f "$MYPC/$OLDSDA"
      NEWSD="$MYSTOCK/$OLDSDA"
      [ -f "$NEWSD" ] && NEWSD=$(avoidnamedup "$NEWSD")
      [ "$NEWSD" != "" ] && mv -f "$MYPC/$OLDSDA" "$NEWSD"
    fi
  fi
  if [ "$SDB" != "$OLDSDB" ]; then
    CHANGED="yes"
    SDB=$(avoidnamedup "$MYPC/$(echo $SDB|sed -e "s,^$OLDSDB,,")")
    REMOVE=""
    if [ "$SDB" = "$NULL" ]; then
      REMOVE="yes"
    elif [ "$(echo $SDB|sed -e 's/^[^.]*\.//')" = "img" ]; then
     if [ -f "$MYSTOCK/$SDB" ]; then
      if echo $SDB|grep -q '^sdb' ;then
        NEWSD="$MYPC/$SDB"
       [ -f "$NEWSD" ] && NEWSD=$(avoidnamedup "$NEWSD")
      else
        NEWSD=$(avoidnamedup "$MYPC/sdb$(echo $SDB|cut -c 4-)")
      fi
      mv -f "$MYSTOCK/$SDB" "$NEWSD" && SDB=$(basename "$NEWSD") && REMOVE="yes"
     fi
    fi
    [ "$REMOVE" = "yes" ] || SDB="$OLDSDB"
    if [ "$REMOVE" = "yes" -a -f "$MYPC/$OLDSDB" ]; then
      NEWSD="$MYSTOCK/$OLDSDB"
      [ -f "$NEWSD" ] && NEWSTOCK=$(avoidnamedup "$NEWSD")
      [ "$NEWSD" != "" ] && mv -f "$MYPC/$OLDSDB" "$NEWSD"
    fi
  fi
  [ "$EXIT" = "Refresh" ] && exec $0
  # changed? check again
  if [ "$CHANGED" = "" ];then
    cd "$MYPC"
    [ "$CD" = "/dev/cdrom" ] || [ "$CD" = "$NULL" ] || [ -f "$CD" ] || CHANGED="yes"
    [ "$FD0" = "/dev/fd0" ] || [ "$FD0" = "$NULL" ] || [ -f "$FD0" ] || CHANGED="yes"
    [ "$FD1" = "NOGUI" ] || [ "$FD1" = "$NULL" ] || [ -f "$FD1" ] || CHANGED="yes"
    [ "$SDA" = "$NULL" ] || [ -f "$SDA" ] || CHANGED="yes"
    [ "$SDB" = "$NULL" ] || [ -f "$SDB" ] || CHANGED="yes"
    [ "$CHANGED" != "" ] && exec $0
  fi
  [ "$CHANGED" = "" ] && MSG="" || MSG="Some components changed."
done
  [ "$CD" = "$NULL" ] && CD=""
  [ "$FD0" = "$NULL" ] && FD0=""
  [ "$FD1" = "$NULL" ] && FD1=""
  [ "$FD1" = "NOGUI" ] && FD1=""
  [ "$SDA" = "$NULL" ] && SDA=""
  [ "$SDB" = "$NULL" ] && SDB=""


cd "$MYPC"	# move to excution directory
# from where to boot
BOOT=$(echo "$RET" | grep '^BOOT[A-D]=.*true'| cut -d'=' -f1| cut -b 5|tr 'A-D' 'a-d')
# boot options
[ "$CD" != "" ] && CD="-cdrom $CD"
[ "$FD0" != "" ] && FD0="-fda $FD0"
[ "$FD1" != "" ] && FD1="-fdb $FD1"
[ "$SDA" != "" ] && SDA="-hda $SDA"
[ "$SDB" != "" ] && SDB="-hdb $SDB"
[ "$BOOT" != "" ] && BOOT="-boot $BOOT"
#[ -c /dev/kqemu ] && KQEMU="-kernel-kqemu" || KQEMU="-no-kqemu"

CMD="qemu -m $RAM $SDA $SDB $FD0 $FD1 $CD $BOOT $ADDOPT0 $ADDOPT"
echo "$CMD"
DEFAULT=$RETURN
[ "$DEFAULT" != "" ] && DEFAULT="<default>$DEFAULT</default>"
DIALOG="<window title=\"QemuPuppy boot up\"><vbox>
   <text><label>Remind: 'Ctrl' + 'Alt' to leave qemu.</label></text>
   <checkbox><variable>RETURNCHECK</variable><label>Return to QemuPupy GUI after the virtual PC stops.</label>$DEFAULT</checkbox>
   <hbox>
   <button tooltip-text=\"Start virtual PC\"><input file stock=\"gtk-media-play\"></input><label>Start</label><action>EXIT:OK</action></button>
   <button tooltip-text=\"Cancel\"><input file stock=\"gtk-stop\"></input><action>EXIT:Cancel</action></button>
     </hbox>
</vbox></window>"
#echo "$DIALOG"
RET=$(gtkdialog3 -p DIALOG -c | grep -E '^[A-Z]+=')
#echo "$RET"
eval "$RET"
[ "$EXIT" = "OK" ] || exec $0

# excute qemu
#CMD is specified beffore
date > $LOGFILE
echo "$CMD" >> $LOGFILE
#echo $CMD
if $CMD &> $ERRFILE ;then
 rm -f $LOGFILE $ERRFILE
 [ "$RETURNCHECK" = "true" ] && exec $0
 exit 0
fi
   DIALOG="<window title=\"QemuPuppy error\"><vbox>
      <pixmap icon_size=\"3\"><input file stock=\"gtk-dialog-error\"></input></pixmap>
      <text><label>An error occured.</label></text>
    <frame>
    <text><input>cat $LOGFILE $ERRFILE</input></text>
    </frame>
    <hbox><button ok></button></hbox>
</vbox></window>"
    gtkdialog3 -p DIALOG -c > /dev/null
 [ "$RETURNCHECK" = "true" ] && exec $0
 exit 1