#!/bin/sh
#called from /usr/local/petget/downloadpkgs.sh
#/tmp/petget_repos has the list of repos, each line in this format:
#repository.slacky.eu|http://repository.slacky.eu/slackware-12.2|Packages-slackware-12.2-slacky
#...only the first field is of interest in this script.
# 20aug10 shinobar: petget_urltest0

# i18n gettext by L18L
# 20aug10 shinobar: i18n_head
APPDIR=$(dirname $0)
source "$APPDIR/i18n_head"
export T_testing="`gettext \"Testing the URLs:\"`"
export T_title="`gettext \"Package Manager: download\"`"
export T_TESTING_SUMMARY="`gettext \"TESTING SUMMARY\"`"
export T_finished="`gettext \"TESTING FINISHED\"`"
export T_text="`gettext \"Read the above, any that returned '200 OK' succeeded.\"`"
export T_entertoexit="`gettext \"Press ENTER key to exit: \"`"
LANG=C
#
echo '#!/bin/sh' >  /tmp/petget_urltest
echo 'echo "${T_testing}"' >>  /tmp/petget_urltest
echo "echo > /tmp/petget_urltest0"  >>  /tmp/petget_urltest

for ONEURLSPEC in `cat /tmp/petget_repos`
do
 URL_TEST="`echo -n "$ONEURLSPEC" | cut -f 1 -d '|'`"
 
 #[ "`wget -t 2 -T 20 --waitretry=20 --spider -S $ONE_PET_SITE -o /dev/stdout 2>/dev/null | grep '200 OK'`" != "" ]
 
 echo 'echo' >> /tmp/petget_urltest
 echo "wget -t 2 -T 20 --waitretry=20 --spider -S $URL_TEST 2>&1 | tee /tmp/petget_urltest1" >> /tmp/petget_urltest
 echo "U=\$(grep '^--' /tmp/petget_urltest1)
 R=\$(grep '^[ ]*HTTP/' /tmp/petget_urltest1)
 echo \"\$U \$R\" >> /tmp/petget_urltest0
 "  >>  /tmp/petget_urltest

done

echo "echo '
$T_TESTING_SUMMARY'
cat /tmp/petget_urltest0
echo '$T_finished
${T_text}'" >>  /tmp/petget_urltest
echo "echo -n '$T_entertoexit'
read ENDIT"  >>  /tmp/petget_urltest

chmod 777 /tmp/petget_urltest
#rxvt -title "Puppy ${T_title}" -bg orange -fg black -e /tmp/petget_urltest
export LC_CTYPE=$LANG_USER	#; printf "\33]701;$LC_CTYPE\007"
$RXVT -title "Puppy ${T_title}" -bg orange -fg black -e /tmp/petget_urltest

###END###
