#!/bin/bash
#(c) Copyright Barry Kauler 2009, puppylinux.com
#2009 Lesser GPL licence v2 (http://www.fsf.org/licensing/licenses/lgpl.html).
#called from /usr/local/petget/pkg_chooser.sh
#  ENTRY1 is a string, to search for a package.
#101129 checkboxes for show EXE DEV DOC NLS. fixed some search bugs.

# 20aug10 shinobar: i18n_head, mysplash
F=$(dirname $0)
[ "$F" != "" ] && F="$F/"
F="${F}i18n_head"
source "$F"
LANG_USER=$LANG
LANG=C
#
. /etc/DISTRO_SPECS #has DISTRO_BINARY_COMPAT, DISTRO_COMPAT_VERSION
. /root/.packages/DISTRO_PKGS_SPECS #has PKGS_SPECS_TABLE.
. /root/.packages/DISTRO_PET_REPOS #has PET_REPOS, PACKAGELISTS_PET_ORDER

entryPATTERN='^'"`echo -n "$ENTRY1" | sed -e 's%\\-%\\\\-%g' -e 's%\\.%\\\\.%g' -e 's%\\*%.*%'`"

CURRENTREPO="`cat /tmp/petget_filterversion`" #search here first.
REPOLIST="${CURRENTREPO} `cat /tmp/petget_active_repo_list | grep -v "$CURRENTREPO" | tr '\n' ' '`"

FNDIT=no
for ONEREPO in $REPOLIST
do
 FNDENTRIES="`cat /root/.packages/Packages-${ONEREPO} | grep -i "$entryPATTERN"`"
 if [ "$FNDENTRIES" != "" ];then
  FIRSTCHAR="`echo "$FNDENTRIES" | cut -c 1 | tr '\n' ' ' | sed -e 's% %%g'`"
  #write these just in case needed...
  ALPHAPRE="`cat /tmp/petget_pkg_first_char`"
  #if [ "$ALPHAPRE" != "ALL" ];then
  # echo "$FIRSTCHAR" > /tmp/petget_pkg_first_char
  #fi
  #echo "ALL" > /tmp/petget_filtercategory
  echo "$ONEREPO" > /tmp/petget_filterversion #ex: slackware-12.2-official
  #this is read when update TREE1 in pkg_chooser.sh...
  echo "$FNDENTRIES" | cut -f 1,10 -d '|' > /tmp/filterpkgs.results
  FNDIT=yes
  break
 fi
done

# i18n begin
LANG=$LANG_USER	# 20aug10 shinobar
#[ "$FNDIT" = "no" ] && xmessage -bg red -center -title "PPM find" "Sorry, no matching package name"
if [ "$FNDIT" = "no" ];then
 mysplash "$T_nomatch"
else
 #101129 postprocess, show EXE, DEV, DOC, NLS...
 DEF_CHK_EXE='true'
 DEF_CHK_DEV='false'
 DEF_CHK_DOC='false'
 DEF_CHK_NLS='false'
 [ -e /var/local/petget/postfilter_EXE ] && DEF_CHK_EXE="`cat /var/local/petget/postfilter_EXE`"
 [ -e /var/local/petget/postfilter_DEV ] && DEF_CHK_DEV="`cat /var/local/petget/postfilter_DEV`"
 [ -e /var/local/petget/postfilter_DOC ] && DEF_CHK_DOC="`cat /var/local/petget/postfilter_DOC`"
 [ -e /var/local/petget/postfilter_NLS ] && DEF_CHK_NLS="`cat /var/local/petget/postfilter_NLS`"
 cp -f /tmp/filterpkgs.results /tmp/filterpkgs.results.post
 [ "$DEF_CHK_EXE" = "false" ] && sed -i -e '/_EXE/d' /tmp/filterpkgs.results.post
 [ "$DEF_CHK_DEV" = "false" ] && sed -i -e '/_DEV/d' /tmp/filterpkgs.results.post
 [ "$DEF_CHK_DOC" = "false" ] && sed -i -e '/_DOC/d' /tmp/filterpkgs.results.post
 [ "$DEF_CHK_NLS" = "false" ] && sed -i -e '/_NLS/d' /tmp/filterpkgs.results.post
 #...main gui will read /tmp/filterpkgs.results.post
 [ "${LANG:0:2}" != "en" -a "$LANG" != "C" ] && . `dirname $0`/i18n "/tmp/filterpkgs.results"
fi
# i18n end
