#!/bin/sh
#2007 Lesser GPL licence v2 (http://www.fsf.org/licensing/licenses/lgpl.html)
#make the pup_save.2fs file bigger.

#variables created at bootup by /initrd/usr/sbin/init...
. /etc/rc.d/PUPSTATE #v2.02
#PUPMODE=current operating configuration,
#PDEV1=the partition have booted off, DEV1FS=f.s. of PDEV1,
#PUPSFS=pup_201.sfs versioned name, stored on PDEV1, PUPSAVE=vfat,sda1,/pup_save.2fs

#find out what modes use a pup_save.2fs file...
CANDOIT="no"
case $PUPMODE in
 "12") #pup_save.3fs (pup_rw), nothing on pup_ro1, pup_xxx.sfs (pup_ro2).
  PERSISTMNTPT="/initrd/pup_rw"
  CANDOIT="yes"
  ;;
 "13") #tmpfs (pup_rw), pup_save.3fs (pup_ro1), pup_xxx.sfs (pup_ro2).
  PERSISTMNTPT="/initrd/pup_ro1"
  CANDOIT="yes"
  ;;
esac

 if [ "$CANDOIT" != "yes" ];then
  gxmessage -center -bg "#ffc0c0" -title "個人用保存ファイルのサイズの変更：エラー" "パピーは現在個人用の持続性保存ファイルを使っていません。
もし、これが始めてパピーをブートしたならば（例えばライブ
CDから）すべてのプログラムはRAM内にあり、セッションが
終わり次第（パソコンをシャットダウンか再起動する時）、
個人用保存ファイルの生成を聞かれます。
注意：ファイルは「pup_save.2fs」と名付けられ、
あなたの指定した場所に生成されます。パピーをハード
ドライブにインストール、あるいは１つのパーティション
全体に個人用保存ファイルがインストールされていれば、
「pup_save.2fs」ファイルは生成されません。
「OK」ボタンを押して終了して下さい…"
  exit
 fi

[ ! "$PUPSAVE" ] && exit #precaution
[ ! "$PUP_HOME" ] && exit #precaution.

SAVEFS="`echo -n "$PUPSAVE" | cut -f 2 -d ','`"
SAVEPART="`echo -n "$PUPSAVE" | cut -f 1 -d ','`"
SAVEFILE="`echo -n "$PUPSAVE" | cut -f 3 -d ','`"
NAMEPFILE="`basename $SAVEFILE`"

HOMELOCATION="/initrd${PUP_HOME}${SAVEFILE}"
SIZEFREE=`df -m | grep "$PERSISTMNTPT" | tr -s " " | cut -f 4 -d " "` #free space in pup_save.3fs
ACTUALSIZK=`ls -sk $HOMELOCATION | tr -s " " | cut -f 1 -d " "` #total size of pup_save.3fs
if [ ! $ACTUALSIZK ];then
 ACTUALSIZK=`ls -sk $HOMELOCATION | tr -s " " | cut -f 2 -d " "`
fi
ACTUALSIZE=`expr $ACTUALSIZK \/ 1024`
APATTERN="/dev/${SAVEPART} "
PARTFREE=`df -m | grep "$APATTERN" | tr -s " " | cut -f 4 -d " "`


REPORTACTION="パピー個人用保存ファイルの変更ユティリティへようこそ！"

MAINTEXT="あなたの個人ファイル名は $NAMEPFILE であり、あなたの個人のデータ、
設定ファイル、メール、ニュースグループ・キャッシュ、ヒストリ・ファイル、
インストールされたパッケージなどが含まれています。

全体のサイズは $ACTUALSIZE Mバイトで、$NAMEPFILE の中に　
$SIZEFREE Mバイトのフリースペースが残っています。

$NAMEPFILE ファイルは実際 $SAVEPART パーティションに保存されています。
$SAVEPART に $PARTFREE Mバイトのスペースが残っています。

ここであなたは決定を下す必要があります。もし、$NAMEPFILE のフリースペースが
少なくなってきたら、このファイルのサイズを大きくすることができますが、
もちろん $SAVEPART に十分のスペースが無ければはなりません。
ご注意：英語掲示板には $NAMEPFILE のサイズが１GBより大きくしてはいけないと言う
レポートがありますが、この制限を実際確認してません。

下のボタンをクリックしても、何も起こらない事に注意して下さい。
$NAMEPFILE のリサイズはリブートしてから有効になります。

下のどれかのボタンをクリックして $NAMEPFILE のサイズをそれだけ大きくして下さい…
（ご注意：これは一方向です。サイズを小さくはできません）"

BUTTONS="+16M:15,+32M:14,+64M:10,+128M:11,+256M:12,+512M:13,EXIT:19"


gxmessage -center -bg "#c0ffff" -title "個人用保存ファイルのサイズの変更" -buttons "$BUTTONS" -file -<<MSG1
$REPORTACTION

$MAINTEXT
MSG1

REPLYX=$?

KILOBIG=
case ${REPLYX} in
   15)# 16M
    KILOBIG=16384
   ;;
   14)# 32M
    KILOBIG=32768
   ;;
   10)# 64M
    KILOBIG=65536
   ;;
   11)# 128M
    KILOBIG=131072
   ;;
   12)# 256M
    KILOBIG=262144
   ;;
   13)# 512M
    KILOBIG=524288
   ;;
   *)
    exit
   ;;
esac

echo -n "$KILOBIG" > /initrd${PUP_HOME}/pupsaveresize.txt

gxmessage -center -bg "orange" -title "個人用保存ファイルのサイズの変更" "オーケー、$NAMEPFILE を $KILOBIG Kバイト大きくする事を選択しました。
しかし、このファイルは現在使用中なので、リサイズはリブート時有効になります。

テクニカル・ノート：
増加に必要なサイズは $SAVEPART パーティション（現在 $SPARTMNTPT にマウントされている）
の「pupsaveresize.txt」と言うファイルに書き込まれます。
ブート時「pupsaveresize.txt」ファイルは読み込まれ、リサイズが実行され、
「pupsaveresize.txt」はその後削除されます。

警告: 複数の pup_save ファイルがある場合、再起動時に
同じファイルを選択するように気をつけて下さい。

パピーを続けて使用できます。変更はリブート後のみ有効になります。
「OK」をクリックして終了して下さい…"

###END###

#notes:
#  dd if=/dev/zero bs=1k count=$KILOBIG | tee -a $HOMELOCATION > /dev/null
