/* Copyright (c) 1999 Thorsten Kukuk
   Author: Thorsten Kukuk <kukuk@suse.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#include <mcheck.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include "nis_db.h"
#include "db_private.h"

#define MAX_TABLES 10

static table_obj *
create_table (void)
{
  table_obj *table = (table_obj *)malloc (sizeof (table_obj));
  table_col *tcol = malloc (sizeof (table_col) * 7);

  memset (table, '\0', sizeof(table_obj));
  memset (tcol, '\0', sizeof (table_col) * 7);

  table->ta_type = strdup ("passwd_tbl");
  table->ta_maxcol = 64;
  table->ta_sep = ':';
  table->ta_path = strdup ("foo");

  tcol[0].tc_name = strdup ("name");
  tcol[0].tc_flags = TA_SEARCHABLE | TA_CASE;
  tcol[0].tc_rights = DEFAULT_RIGHTS;

  tcol[1].tc_name = strdup ("passwd");
  tcol[1].tc_flags = TA_CASE;
  tcol[1].tc_rights = DEFAULT_RIGHTS;

  tcol[2].tc_name = strdup ("uid");
  tcol[2].tc_flags = TA_SEARCHABLE | TA_CASE;
  tcol[2].tc_rights = DEFAULT_RIGHTS;

  tcol[3].tc_name = strdup ("gid");
  tcol[3].tc_flags = TA_SEARCHABLE | TA_CASE;
  tcol[3].tc_rights = DEFAULT_RIGHTS;

  tcol[4].tc_name = strdup ("gecos");
  tcol[4].tc_flags = TA_CASE;
  tcol[4].tc_rights = DEFAULT_RIGHTS;

  tcol[5].tc_name = strdup ("home");
  tcol[5].tc_flags = TA_CASE;
  tcol[5].tc_rights = DEFAULT_RIGHTS;

  tcol[6].tc_name = strdup ("shell");
  tcol[6].tc_flags = TA_SEARCHABLE | TA_CASE;
  tcol[6].tc_rights = DEFAULT_RIGHTS;

  table->ta_cols.ta_cols_len = 7;
  table->ta_cols.ta_cols_val = tcol;

  return table;
}

int
main (void)
{
  char *catalog_file = "data.dict";
  int i;

  mtrace ();

  /* Initialize the database backend */
  if (db_initialize (catalog_file) == FALSE)
    {
      fprintf (stderr, "db_initialize (%s) failed.\n", catalog_file);
      return 1;
    }

  for (i = 0; i < MAX_TABLES; ++i)
  {
    db_status status;
    char buf[255];
    table_obj *obj = create_table ();

    sprintf (buf, "table_%.8d", i);
    status = db_create_table (buf, obj);
    xdr_free ((xdrproc_t) __nisdb_xdr_table_obj, (caddr_t)obj);
    free (obj);
    if (status != DB_SUCCESS)
      {
	fprintf (stderr, "db_create_table (\"%s\") failed: %d\n", buf,
		 status);
	return 1;
      }

    db_checkpoint (buf);
    if ((i % 2) == 0)
      db_destroy_table (buf);
  }

  muntrace ();

  return 0;
}
