/*
 * SH7269 Pinmux
 *
 * Copyright (C) 2012  Renesas Electronics Europe Ltd
 * Copyright (C) 2012  Phil Edworthy
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 */

#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/gpio.h>
#include <cpu/sh7269.h>

enum {
	PINMUX_RESERVED = 0,

	PINMUX_DATA_BEGIN,
	/* Port A */
	PA1_DATA, PA0_DATA,
	/* Port B */
	PB22_DATA, PB21_DATA, PB20_DATA,
	PB19_DATA, PB18_DATA, PB17_DATA, PB16_DATA,
	PB15_DATA, PB14_DATA, PB13_DATA, PB12_DATA,
	PB11_DATA, PB10_DATA, PB9_DATA, PB8_DATA,
	PB7_DATA, PB6_DATA, PB5_DATA, PB4_DATA,
	PB3_DATA, PB2_DATA, PB1_DATA,
	/* Port C */
	PC8_DATA,
	PC7_DATA, PC6_DATA, PC5_DATA, PC4_DATA,
	PC3_DATA, PC2_DATA, PC1_DATA, PC0_DATA,
	/* Port D */
	PD15_DATA, PD14_DATA, PD13_DATA, PD12_DATA,
	PD11_DATA, PD10_DATA, PD9_DATA, PD8_DATA,
	PD7_DATA, PD6_DATA, PD5_DATA, PD4_DATA,
	PD3_DATA, PD2_DATA, PD1_DATA, PD0_DATA,
	/* Port E */
	PE7_DATA, PE6_DATA, PE5_DATA, PE4_DATA,
	PE3_DATA, PE2_DATA, PE1_DATA, PE0_DATA,
	/* Port F */
	PF23_DATA, PF22_DATA, PF21_DATA, PF20_DATA,
	PF19_DATA, PF18_DATA, PF17_DATA, PF16_DATA,
	PF15_DATA, PF14_DATA, PF13_DATA, PF12_DATA,
	PF11_DATA, PF10_DATA, PF9_DATA, PF8_DATA,
	PF7_DATA, PF6_DATA, PF5_DATA, PF4_DATA,
	PF3_DATA, PF2_DATA, PF1_DATA, PF0_DATA,
	/* Port G */
	PG27_DATA, PG26_DATA, PG25_DATA, PG24_DATA,
	PG23_DATA, PG22_DATA, PG21_DATA, PG20_DATA,
	PG19_DATA, PG18_DATA, PG17_DATA, PG16_DATA,
	PG15_DATA, PG14_DATA, PG13_DATA, PG12_DATA,
	PG11_DATA, PG10_DATA, PG9_DATA, PG8_DATA,
	PG7_DATA, PG6_DATA, PG5_DATA, PG4_DATA,
	PG3_DATA, PG2_DATA, PG1_DATA, PG0_DATA,
	/* Port H */
	/* NOTE - Port H does not have a Data Register, but PH Data is
	   connected to PH Port Register */
	PH7_DATA, PH6_DATA, PH5_DATA, PH4_DATA,
	PH3_DATA, PH2_DATA, PH1_DATA, PH0_DATA,
	/* Port I - not on device */
	/* Port J */
	PJ31_DATA, PJ30_DATA, PJ29_DATA, PJ28_DATA,
	PJ27_DATA, PJ26_DATA, PJ25_DATA, PJ24_DATA,
	PJ23_DATA, PJ22_DATA, PJ21_DATA, PJ20_DATA,
	PJ19_DATA, PJ18_DATA, PJ17_DATA, PJ16_DATA,
	PJ15_DATA, PJ14_DATA, PJ13_DATA, PJ12_DATA,
	PJ11_DATA, PJ10_DATA, PJ9_DATA, PJ8_DATA,
	PJ7_DATA, PJ6_DATA, PJ5_DATA, PJ4_DATA,
	PJ3_DATA, PJ2_DATA, PJ1_DATA, PJ0_DATA,
	PINMUX_DATA_END,

	PINMUX_INPUT_BEGIN,
	FORCE_IN,
	/* Port A */
	PA1_IN, PA0_IN,
	/* Port B */
	PB22_IN, PB21_IN, PB20_IN,
	PB19_IN, PB18_IN, PB17_IN, PB16_IN,
	PB15_IN, PB14_IN, PB13_IN, PB12_IN,
	PB11_IN, PB10_IN, PB9_IN, PB8_IN,
	PB7_IN, PB6_IN, PB5_IN, PB4_IN,
	PB3_IN, PB2_IN, PB1_IN,
	/* Port C */
	PC8_IN,
	PC7_IN, PC6_IN, PC5_IN, PC4_IN,
	PC3_IN, PC2_IN, PC1_IN, PC0_IN,
	/* Port D */
	PD15_IN, PD14_IN, PD13_IN, PD12_IN,
	PD11_IN, PD10_IN, PD9_IN, PD8_IN,
	PD7_IN, PD6_IN, PD5_IN, PD4_IN,
	PD3_IN, PD2_IN, PD1_IN, PD0_IN,
	/* Port E */
	PE7_IN, PE6_IN, PE5_IN, PE4_IN,
	PE3_IN, PE2_IN, PE1_IN, PE0_IN,
	/* Port F */
	PF23_IN, PF22_IN, PF21_IN, PF20_IN,
	PF19_IN, PF18_IN, PF17_IN, PF16_IN,
	PF15_IN, PF14_IN, PF13_IN, PF12_IN,
	PF11_IN, PF10_IN, PF9_IN, PF8_IN,
	PF7_IN, PF6_IN, PF5_IN, PF4_IN,
	PF3_IN, PF2_IN, PF1_IN, PF0_IN,
	/* Port G */
	PG27_IN, PG26_IN, PG25_IN, PG24_IN,
	PG23_IN, PG22_IN, PG21_IN, PG20_IN,
	PG19_IN, PG18_IN, PG17_IN, PG16_IN,
	PG15_IN, PG14_IN, PG13_IN, PG12_IN,
	PG11_IN, PG10_IN, PG9_IN, PG8_IN,
	PG7_IN, PG6_IN, PG5_IN, PG4_IN,
	PG3_IN, PG2_IN, PG1_IN, PG0_IN,
	/* Port H - Port H does not have a Data Register */
	/* Port I - not on device */
	/* Port J */
	PJ31_IN, PJ30_IN, PJ29_IN, PJ28_IN,
	PJ27_IN, PJ26_IN, PJ25_IN, PJ24_IN,
	PJ23_IN, PJ22_IN, PJ21_IN, PJ20_IN,
	PJ19_IN, PJ18_IN, PJ17_IN, PJ16_IN,
	PJ15_IN, PJ14_IN, PJ13_IN, PJ12_IN,
	PJ11_IN, PJ10_IN, PJ9_IN, PJ8_IN,
	PJ7_IN, PJ6_IN, PJ5_IN, PJ4_IN,
	PJ3_IN, PJ2_IN, PJ1_IN, PJ0_IN,
	PINMUX_INPUT_END,

	PINMUX_OUTPUT_BEGIN,
	FORCE_OUT,
	/* Port A */
	PA1_OUT, PA0_OUT,
	/* Port B */
	PB22_OUT, PB21_OUT, PB20_OUT,
	PB19_OUT, PB18_OUT, PB17_OUT, PB16_OUT,
	PB15_OUT, PB14_OUT, PB13_OUT, PB12_OUT,
	PB11_OUT, PB10_OUT, PB9_OUT, PB8_OUT,
	PB7_OUT, PB6_OUT, PB5_OUT, PB4_OUT,
	PB3_OUT, PB2_OUT, PB1_OUT,
	/* Port C */
	PC8_OUT,
	PC7_OUT, PC6_OUT, PC5_OUT, PC4_OUT,
	PC3_OUT, PC2_OUT, PC1_OUT, PC0_OUT,
	/* Port D */
	PD15_OUT, PD14_OUT, PD13_OUT, PD12_OUT,
	PD11_OUT, PD10_OUT, PD9_OUT, PD8_OUT,
	PD7_OUT, PD6_OUT, PD5_OUT, PD4_OUT,
	PD3_OUT, PD2_OUT, PD1_OUT, PD0_OUT,
	/* Port E */
	PE7_OUT, PE6_OUT, PE5_OUT, PE4_OUT,
	PE3_OUT, PE2_OUT, PE1_OUT, PE0_OUT,
	/* Port F */
	PF23_OUT, PF22_OUT, PF21_OUT, PF20_OUT,
	PF19_OUT, PF18_OUT, PF17_OUT, PF16_OUT,
	PF15_OUT, PF14_OUT, PF13_OUT, PF12_OUT,
	PF11_OUT, PF10_OUT, PF9_OUT, PF8_OUT,
	PF7_OUT, PF6_OUT, PF5_OUT, PF4_OUT,
	PF3_OUT, PF2_OUT, PF1_OUT, PF0_OUT,
	/* Port G */
	PG27_OUT, PG26_OUT, PG25_OUT, PG24_OUT,
	PG23_OUT, PG22_OUT, PG21_OUT, PG20_OUT,
	PG19_OUT, PG18_OUT, PG17_OUT, PG16_OUT,
	PG15_OUT, PG14_OUT, PG13_OUT, PG12_OUT,
	PG11_OUT, PG10_OUT, PG9_OUT, PG8_OUT,
	PG7_OUT, PG6_OUT, PG5_OUT, PG4_OUT,
	PG3_OUT, PG2_OUT, PG1_OUT, PG0_OUT,
	/* Port H - Port H does not have a Data Register */
	/* Port I - not on device */
	/* Port J */
	PJ31_OUT, PJ30_OUT, PJ29_OUT, PJ28_OUT,
	PJ27_OUT, PJ26_OUT, PJ25_OUT, PJ24_OUT,
	PJ23_OUT, PJ22_OUT, PJ21_OUT, PJ20_OUT,
	PJ19_OUT, PJ18_OUT, PJ17_OUT, PJ16_OUT,
	PJ15_OUT, PJ14_OUT, PJ13_OUT, PJ12_OUT,
	PJ11_OUT, PJ10_OUT, PJ9_OUT, PJ8_OUT,
	PJ7_OUT, PJ6_OUT, PJ5_OUT, PJ4_OUT,
	PJ3_OUT, PJ2_OUT, PJ1_OUT, PJ0_OUT,
	PINMUX_OUTPUT_END,

	PINMUX_FUNCTION_BEGIN,
	/* Port A */
	PA1_IOR_IN, PA1_IOR_OUT,
	PA0_IOR_IN, PA0_IOR_OUT,

	/* Port B */
	PB22_IOR_IN, PB22_IOR_OUT,
	PB21_IOR_IN, PB21_IOR_OUT,
	PB20_IOR_IN, PB20_IOR_OUT,
	PB19_IOR_IN, PB19_IOR_OUT,
	PB18_IOR_IN, PB18_IOR_OUT,
	PB17_IOR_IN, PB17_IOR_OUT,
	PB16_IOR_IN, PB16_IOR_OUT,

	PB15_IOR_IN, PB15_IOR_OUT,
	PB14_IOR_IN, PB14_IOR_OUT,
	PB13_IOR_IN, PB13_IOR_OUT,
	PB12_IOR_IN, PB12_IOR_OUT,
	PB11_IOR_IN, PB11_IOR_OUT,
	PB10_IOR_IN, PB10_IOR_OUT,
	PB9_IOR_IN, PB9_IOR_OUT,
	PB8_IOR_IN, PB8_IOR_OUT,

	PB7_IOR_IN, PB7_IOR_OUT,
	PB6_IOR_IN, PB6_IOR_OUT,
	PB5_IOR_IN, PB5_IOR_OUT,
	PB4_IOR_IN, PB4_IOR_OUT,
	PB3_IOR_IN, PB3_IOR_OUT,
	PB2_IOR_IN, PB2_IOR_OUT,
	PB1_IOR_IN, PB1_IOR_OUT,
	PB0_IOR_IN, PB0_IOR_OUT,

	PB22MD_000, PB22MD_001, PB22MD_010, PB22MD_011,
	PB22MD_100, PB22MD_101, PB22MD_110, PB22MD_111,
	PB21MD_00, PB21MD_01, PB21MD_10, PB21MD_11,
	PB20MD_000, PB20MD_001, PB20MD_010, PB20MD_011,
	PB20MD_100, PB20MD_101, PB20MD_110, PB20MD_111,
	PB19MD_000, PB19MD_001, PB19MD_010, PB19MD_011,
	PB19MD_100, PB19MD_101, PB19MD_110, PB19MD_111,
	PB18MD_000, PB18MD_001, PB18MD_010, PB18MD_011,
	PB18MD_100, PB18MD_101, PB18MD_110, PB18MD_111,
	PB17MD_000, PB17MD_001, PB17MD_010, PB17MD_011,
	PB17MD_100, PB17MD_101, PB17MD_110, PB17MD_111,
	PB16MD_000, PB16MD_001, PB16MD_010, PB16MD_011,
	PB16MD_100, PB16MD_101, PB16MD_110, PB16MD_111,
	PB15MD_000, PB15MD_001, PB15MD_010, PB15MD_011,
	PB15MD_100, PB15MD_101, PB15MD_110, PB15MD_111,
	PB14MD_000, PB14MD_001, PB14MD_010, PB14MD_011,
	PB14MD_100, PB14MD_101, PB14MD_110, PB14MD_111,
	PB13MD_000, PB13MD_001, PB13MD_010, PB13MD_011,
	PB13MD_100, PB13MD_101, PB13MD_110, PB13MD_111,
	PB12MD_00, PB12MD_01, PB12MD_10, PB12MD_11,

	PB11MD_00, PB11MD_01, PB11MD_10, PB11MD_11,
	PB10MD_00, PB10MD_01, PB10MD_10, PB10MD_11,
	PB9MD_00, PB9MD_01, PB9MD_10, PB9MD_11,
	PB8MD_00, PB8MD_01, PB8MD_10, PB8MD_11,

	PB7MD_00, PB7MD_01, PB7MD_10, PB7MD_11,
	PB6MD_00, PB6MD_01, PB6MD_10, PB6MD_11,
	PB5MD_00, PB5MD_01, PB5MD_10, PB5MD_11,
	PB4MD_00, PB4MD_01, PB4MD_10, PB4MD_11,

	PB3MD_00, PB3MD_01, PB3MD_10, PB3MD_11,
	PB2MD_00, PB2MD_01, PB2MD_10, PB2MD_11,
	PB1MD_00, PB1MD_01, PB1MD_10, PB1MD_11,

	/* Port C */
	PC8_IOR_IN, PC8_IOR_OUT,
	PC7_IOR_IN, PC7_IOR_OUT,
	PC6_IOR_IN, PC6_IOR_OUT,
	PC5_IOR_IN, PC5_IOR_OUT,
	PC4_IOR_IN, PC4_IOR_OUT,
	PC3_IOR_IN, PC3_IOR_OUT,
	PC2_IOR_IN, PC2_IOR_OUT,
	PC1_IOR_IN, PC1_IOR_OUT,
	PC0_IOR_IN, PC0_IOR_OUT,

	PC8MD_000, PC8MD_001, PC8MD_010, PC8MD_011,
	PC8MD_100, PC8MD_101, PC8MD_110, PC8MD_111,
	PC7MD_000, PC7MD_001, PC7MD_010, PC7MD_011,
	PC7MD_100, PC7MD_101, PC7MD_110, PC7MD_111,
	PC6MD_000, PC6MD_001, PC6MD_010, PC6MD_011,
	PC6MD_100, PC6MD_101, PC6MD_110, PC6MD_111,
	PC5MD_000, PC5MD_001, PC5MD_010, PC5MD_011,
	PC5MD_100, PC5MD_101, PC5MD_110, PC5MD_111,
	PC4MD_00, PC4MD_01, PC4MD_10, PC4MD_11,

	PC3MD_00, PC3MD_01, PC3MD_10, PC3MD_11,
	PC2MD_00, PC2MD_01, PC2MD_10, PC2MD_11,
	PC1MD_0, PC1MD_1,
	PC0MD_0, PC0MD_1,

	/* Port D */
	PD15_IOR_IN, PD15_IOR_OUT,
	PD14_IOR_IN, PD14_IOR_OUT,
	PD13_IOR_IN, PD13_IOR_OUT,
	PD12_IOR_IN, PD12_IOR_OUT,
	PD11_IOR_IN, PD11_IOR_OUT,
	PD10_IOR_IN, PD10_IOR_OUT,
	PD9_IOR_IN, PD9_IOR_OUT,
	PD8_IOR_IN, PD8_IOR_OUT,
	PD7_IOR_IN, PD7_IOR_OUT,
	PD6_IOR_IN, PD6_IOR_OUT,
	PD5_IOR_IN, PD5_IOR_OUT,
	PD4_IOR_IN, PD4_IOR_OUT,
	PD3_IOR_IN, PD3_IOR_OUT,
	PD2_IOR_IN, PD2_IOR_OUT,
	PD1_IOR_IN, PD1_IOR_OUT,
	PD0_IOR_IN, PD0_IOR_OUT,

	PD15MD_00, PD15MD_01, PD15MD_10, PD15MD_11,
	PD14MD_00, PD14MD_01, PD14MD_10, PD14MD_11,
	PD13MD_00, PD13MD_01, PD13MD_10, PD13MD_11,
	PD12MD_00, PD12MD_01, PD12MD_10, PD12MD_11,

	PD11MD_00, PD11MD_01, PD11MD_10, PD11MD_11,
	PD10MD_00, PD10MD_01, PD10MD_10, PD10MD_11,
	PD9MD_00, PD9MD_01, PD9MD_10, PD9MD_11,
	PD8MD_00, PD8MD_01, PD8MD_10, PD8MD_11,

	PD7MD_00, PD7MD_01, PD7MD_10, PD7MD_11,
	PD6MD_00, PD6MD_01, PD6MD_10, PD6MD_11,
	PD5MD_00, PD5MD_01, PD5MD_10, PD5MD_11,
	PD4MD_00, PD4MD_01, PD4MD_10, PD4MD_11,

	PD3MD_00, PD3MD_01, PD3MD_10, PD3MD_11,
	PD2MD_00, PD2MD_01, PD2MD_10, PD2MD_11,
	PD1MD_00, PD1MD_01, PD1MD_10, PD1MD_11,
	PD0MD_00, PD0MD_01, PD0MD_10, PD0MD_11,

	/* Port E */
	PE7_IOR_IN, PE7_IOR_OUT,
	PE6_IOR_IN, PE6_IOR_OUT,
	PE5_IOR_IN, PE5_IOR_OUT,
	PE4_IOR_IN, PE4_IOR_OUT,
	PE3_IOR_IN, PE3_IOR_OUT,
	PE2_IOR_IN, PE2_IOR_OUT,
	PE1_IOR_IN, PE1_IOR_OUT,
	PE0_IOR_IN, PE0_IOR_OUT,

	PE7MD_00, PE7MD_01, PE7MD_10, PE7MD_11,
	PE6MD_00, PE6MD_01, PE6MD_10, PE6MD_11,
	PE5MD_00, PE5MD_01, PE5MD_10, PE5MD_11,
	PE4MD_00, PE4MD_01, PE4MD_10, PE4MD_11,

	PE3MD_000, PE3MD_001, PE3MD_010, PE3MD_011,
	PE3MD_100, PE3MD_101, PE3MD_110, PE3MD_111,
	PE2MD_000, PE2MD_001, PE2MD_010, PE2MD_011,
	PE2MD_100, PE2MD_101, PE2MD_110, PE2MD_111,
	PE1MD_000, PE1MD_001, PE1MD_010, PE1MD_011,
	PE1MD_100, PE1MD_101, PE1MD_110, PE1MD_111,
	PE0MD_00, PE0MD_01, PE0MD_10, PE0MD_11,

	/* Port F */
	PF23_IOR_IN, PF23_IOR_OUT,
	PF22_IOR_IN, PF22_IOR_OUT,
	PF21_IOR_IN, PF21_IOR_OUT,
	PF20_IOR_IN, PF20_IOR_OUT,
	PF19_IOR_IN, PF19_IOR_OUT,
	PF18_IOR_IN, PF18_IOR_OUT,
	PF17_IOR_IN, PF17_IOR_OUT,
	PF16_IOR_IN, PF16_IOR_OUT,
	PF15_IOR_IN, PF15_IOR_OUT,
	PF14_IOR_IN, PF14_IOR_OUT,
	PF13_IOR_IN, PF13_IOR_OUT,
	PF12_IOR_IN, PF12_IOR_OUT,
	PF11_IOR_IN, PF11_IOR_OUT,
	PF10_IOR_IN, PF10_IOR_OUT,
	PF9_IOR_IN, PF9_IOR_OUT,
	PF8_IOR_IN, PF8_IOR_OUT,
	PF7_IOR_IN, PF7_IOR_OUT,
	PF6_IOR_IN, PF6_IOR_OUT,
	PF5_IOR_IN, PF5_IOR_OUT,
	PF4_IOR_IN, PF4_IOR_OUT,
	PF3_IOR_IN, PF3_IOR_OUT,
	PF2_IOR_IN, PF2_IOR_OUT,
	PF1_IOR_IN, PF1_IOR_OUT,
	PF0_IOR_IN, PF0_IOR_OUT,

	PF23MD_000, PF23MD_001, PF23MD_010, PF23MD_011,
	PF23MD_100, PF23MD_101, PF23MD_110, PF23MD_111,
	PF22MD_000, PF22MD_001, PF22MD_010, PF22MD_011,
	PF22MD_100, PF22MD_101, PF22MD_110, PF22MD_111,
	PF21MD_000, PF21MD_001, PF21MD_010, PF21MD_011,
	PF21MD_100, PF21MD_101, PF21MD_110, PF21MD_111,
	PF20MD_000, PF20MD_001, PF20MD_010, PF20MD_011,
	PF20MD_100, PF20MD_101, PF20MD_110, PF20MD_111,

	PF19MD_000, PF19MD_001, PF19MD_010, PF19MD_011,
	PF19MD_100, PF19MD_101, PF19MD_110, PF19MD_111,
	PF18MD_000, PF18MD_001, PF18MD_010, PF18MD_011,
	PF18MD_100, PF18MD_101, PF18MD_110, PF18MD_111,
	PF17MD_000, PF17MD_001, PF17MD_010, PF17MD_011,
	PF17MD_100, PF17MD_101, PF17MD_110, PF17MD_111,
	PF16MD_000, PF16MD_001, PF16MD_010, PF16MD_011,
	PF16MD_100, PF16MD_101, PF16MD_110, PF16MD_111,

	PF15MD_000, PF15MD_001, PF15MD_010, PF15MD_011,
	PF15MD_100, PF15MD_101, PF15MD_110, PF15MD_111,
	PF14MD_000, PF14MD_001, PF14MD_010, PF14MD_011,
	PF14MD_100, PF14MD_101, PF14MD_110, PF14MD_111,
	PF13MD_000, PF13MD_001, PF13MD_010, PF13MD_011,
	PF13MD_100, PF13MD_101, PF13MD_110, PF13MD_111,
	PF12MD_000, PF12MD_001, PF12MD_010, PF12MD_011,
	PF12MD_100, PF12MD_101, PF12MD_110, PF12MD_111,

	PF11MD_000, PF11MD_001, PF11MD_010, PF11MD_011,
	PF11MD_100, PF11MD_101, PF11MD_110, PF11MD_111,
	PF10MD_000, PF10MD_001, PF10MD_010, PF10MD_011,
	PF10MD_100, PF10MD_101, PF10MD_110, PF10MD_111,
	PF9MD_000, PF9MD_001, PF9MD_010, PF9MD_011,
	PF9MD_100, PF9MD_101, PF9MD_110, PF9MD_111,
	PF8MD_000, PF8MD_001, PF8MD_010, PF8MD_011,
	PF8MD_100, PF8MD_101, PF8MD_110, PF8MD_111,

	PF7MD_000, PF7MD_001, PF7MD_010, PF7MD_011,
	PF7MD_100, PF7MD_101, PF7MD_110, PF7MD_111,
	PF6MD_000, PF6MD_001, PF6MD_010, PF6MD_011,
	PF6MD_100, PF6MD_101, PF6MD_110, PF6MD_111,
	PF5MD_000, PF5MD_001, PF5MD_010, PF5MD_011,
	PF5MD_100, PF5MD_101, PF5MD_110, PF5MD_111,
	PF4MD_000, PF4MD_001, PF4MD_010, PF4MD_011,
	PF4MD_100, PF4MD_101, PF4MD_110, PF4MD_111,

	PF3MD_000, PF3MD_001, PF3MD_010, PF3MD_011,
	PF3MD_100, PF3MD_101, PF3MD_110, PF3MD_111,
	PF2MD_000, PF2MD_001, PF2MD_010, PF2MD_011,
	PF2MD_100, PF2MD_101, PF2MD_110, PF2MD_111,
	PF1MD_000, PF1MD_001, PF1MD_010, PF1MD_011,
	PF1MD_100, PF1MD_101, PF1MD_110, PF1MD_111,
	PF0MD_000, PF0MD_001, PF0MD_010, PF0MD_011,
	PF0MD_100, PF0MD_101, PF0MD_110, PF0MD_111,

	/* Port G */
	PG27_IOR_IN, PG27_IOR_OUT,
	PG26_IOR_IN, PG26_IOR_OUT,
	PG25_IOR_IN, PG25_IOR_OUT,
	PG24_IOR_IN, PG24_IOR_OUT,
	PG23_IOR_IN, PG23_IOR_OUT,
	PG22_IOR_IN, PG22_IOR_OUT,
	PG21_IOR_IN, PG21_IOR_OUT,
	PG20_IOR_IN, PG20_IOR_OUT,
	PG19_IOR_IN, PG19_IOR_OUT,
	PG18_IOR_IN, PG18_IOR_OUT,
	PG17_IOR_IN, PG17_IOR_OUT,
	PG16_IOR_IN, PG16_IOR_OUT,
	PG15_IOR_IN, PG15_IOR_OUT,
	PG14_IOR_IN, PG14_IOR_OUT,
	PG13_IOR_IN, PG13_IOR_OUT,
	PG12_IOR_IN, PG12_IOR_OUT,
	PG11_IOR_IN, PG11_IOR_OUT,
	PG10_IOR_IN, PG10_IOR_OUT,
	PG9_IOR_IN, PG9_IOR_OUT,
	PG8_IOR_IN, PG8_IOR_OUT,
	PG7_IOR_IN, PG7_IOR_OUT,
	PG6_IOR_IN, PG6_IOR_OUT,
	PG5_IOR_IN, PG5_IOR_OUT,
	PG4_IOR_IN, PG4_IOR_OUT,
	PG3_IOR_IN, PG3_IOR_OUT,
	PG2_IOR_IN, PG2_IOR_OUT,
	PG1_IOR_IN, PG1_IOR_OUT,
	PG0_IOR_IN, PG0_IOR_OUT,

	PG27MD_00, PG27MD_01, PG27MD_10, PG27MD_11,
	PG26MD_00, PG26MD_01, PG26MD_10, PG26MD_11,
	PG25MD_00, PG25MD_01, PG25MD_10, PG25MD_11,
	PG24MD_00, PG24MD_01, PG24MD_10, PG24MD_11,

	PG23MD_000, PG23MD_001, PG23MD_010, PG23MD_011,
	PG23MD_100, PG23MD_101, PG23MD_110, PG23MD_111,
	PG22MD_000, PG22MD_001, PG22MD_010, PG22MD_011,
	PG22MD_100, PG22MD_101, PG22MD_110, PG22MD_111,
	PG21MD_000, PG21MD_001, PG21MD_010, PG21MD_011,
	PG21MD_100, PG21MD_101, PG21MD_110, PG21MD_111,
	PG20MD_000, PG20MD_001, PG20MD_010, PG20MD_011,
	PG20MD_100, PG20MD_101, PG20MD_110, PG20MD_111,

	PG19MD_000, PG19MD_001, PG19MD_010, PG19MD_011,
	PG19MD_100, PG19MD_101, PG19MD_110, PG19MD_111,
	PG18MD_000, PG18MD_001, PG18MD_010, PG18MD_011,
	PG18MD_100, PG18MD_101, PG18MD_110, PG18MD_111,
	PG17MD_00, PG17MD_01, PG17MD_10, PG17MD_11,
	PG16MD_00, PG16MD_01, PG16MD_10, PG16MD_11,

	PG15MD_00, PG15MD_01, PG15MD_10, PG15MD_11,
	PG14MD_00, PG14MD_01, PG14MD_10, PG14MD_11,
	PG13MD_00, PG13MD_01, PG13MD_10, PG13MD_11,
	PG12MD_00, PG12MD_01, PG12MD_10, PG12MD_11,

	PG11MD_000, PG11MD_001, PG11MD_010, PG11MD_011,
	PG11MD_100, PG11MD_101, PG11MD_110, PG11MD_111,
	PG10MD_000, PG10MD_001, PG10MD_010, PG10MD_011,
	PG10MD_100, PG10MD_101, PG10MD_110, PG10MD_111,
	PG9MD_000, PG9MD_001, PG9MD_010, PG9MD_011,
	PG9MD_100, PG9MD_101, PG9MD_110, PG9MD_111,
	PG8MD_000, PG8MD_001, PG8MD_010, PG8MD_011,
	PG8MD_100, PG8MD_101, PG8MD_110, PG8MD_111,

	PG7MD_000, PG7MD_001, PG7MD_010, PG7MD_011,
	PG7MD_100, PG7MD_101, PG7MD_110, PG7MD_111,
	PG6MD_000, PG6MD_001, PG6MD_010, PG6MD_011,
	PG6MD_100, PG6MD_101, PG6MD_110, PG6MD_111,
	PG5MD_000, PG5MD_001, PG5MD_010, PG5MD_011,
	PG5MD_100, PG5MD_101, PG5MD_110, PG5MD_111,
	PG4MD_000, PG4MD_001, PG4MD_010, PG4MD_011,
	PG4MD_100, PG4MD_101, PG4MD_110, PG4MD_111,

	PG3MD_000, PG3MD_001, PG3MD_010, PG3MD_011,
	PG3MD_100, PG3MD_101, PG3MD_110, PG3MD_111,
	PG2MD_000, PG2MD_001, PG2MD_010, PG2MD_011,
	PG2MD_100, PG2MD_101, PG2MD_110, PG2MD_111,
	PG1MD_000, PG1MD_001, PG1MD_010, PG1MD_011,
	PG1MD_100, PG1MD_101, PG1MD_110, PG1MD_111,
	PG0MD_000, PG0MD_001, PG0MD_010, PG0MD_011,
	PG0MD_100, PG0MD_101, PG0MD_110, PG0MD_111,

	/* Port H */
	PH7MD_00, PH7MD_01, PH7MD_10, PH7MD_11,
	PH6MD_00, PH6MD_01, PH6MD_10, PH6MD_11,
	PH5MD_00, PH5MD_01, PH5MD_10, PH5MD_11,
	PH4MD_00, PH4MD_01, PH4MD_10, PH4MD_11,

	PH3MD_00, PH3MD_01, PH3MD_10, PH3MD_11,
	PH2MD_00, PH2MD_01, PH2MD_10, PH2MD_11,
	PH1MD_00, PH1MD_01, PH1MD_10, PH1MD_11,
	PH0MD_00, PH0MD_01, PH0MD_10, PH0MD_11,

	/* Port I - not on device */

	/* Port J */
	PJ31_IOR_IN, PJ31_IOR_OUT,
	PJ30_IOR_IN, PJ30_IOR_OUT,
	PJ29_IOR_IN, PJ29_IOR_OUT,
	PJ28_IOR_IN, PJ28_IOR_OUT,
	PJ27_IOR_IN, PJ27_IOR_OUT,
	PJ26_IOR_IN, PJ26_IOR_OUT,
	PJ25_IOR_IN, PJ25_IOR_OUT,
	PJ24_IOR_IN, PJ24_IOR_OUT,
	PJ23_IOR_IN, PJ23_IOR_OUT,
	PJ22_IOR_IN, PJ22_IOR_OUT,
	PJ21_IOR_IN, PJ21_IOR_OUT,
	PJ20_IOR_IN, PJ20_IOR_OUT,
	PJ19_IOR_IN, PJ19_IOR_OUT,
	PJ18_IOR_IN, PJ18_IOR_OUT,
	PJ17_IOR_IN, PJ17_IOR_OUT,
	PJ16_IOR_IN, PJ16_IOR_OUT,
	PJ15_IOR_IN, PJ15_IOR_OUT,
	PJ14_IOR_IN, PJ14_IOR_OUT,
	PJ13_IOR_IN, PJ13_IOR_OUT,
	PJ12_IOR_IN, PJ12_IOR_OUT,
	PJ11_IOR_IN, PJ11_IOR_OUT,
	PJ10_IOR_IN, PJ10_IOR_OUT,
	PJ9_IOR_IN, PJ9_IOR_OUT,
	PJ8_IOR_IN, PJ8_IOR_OUT,
	PJ7_IOR_IN, PJ7_IOR_OUT,
	PJ6_IOR_IN, PJ6_IOR_OUT,
	PJ5_IOR_IN, PJ5_IOR_OUT,
	PJ4_IOR_IN, PJ4_IOR_OUT,
	PJ3_IOR_IN, PJ3_IOR_OUT,
	PJ2_IOR_IN, PJ2_IOR_OUT,
	PJ1_IOR_IN, PJ1_IOR_OUT,
	PJ0_IOR_IN, PJ0_IOR_OUT,

	PJ31MD_0, PJ31MD_1,
	PJ30MD_000, PJ30MD_001, PJ30MD_010, PJ30MD_011,
	PJ30MD_100, PJ30MD_101, PJ30MD_110, PJ30MD_111,
	PJ29MD_000, PJ29MD_001, PJ29MD_010, PJ29MD_011,
	PJ29MD_100, PJ29MD_101, PJ29MD_110, PJ29MD_111,
	PJ28MD_000, PJ28MD_001, PJ28MD_010, PJ28MD_011,
	PJ28MD_100, PJ28MD_101, PJ28MD_110, PJ28MD_111,

	PJ27MD_000, PJ27MD_001, PJ27MD_010, PJ27MD_011,
	PJ27MD_100, PJ27MD_101, PJ27MD_110, PJ27MD_111,
	PJ26MD_000, PJ26MD_001, PJ26MD_010, PJ26MD_011,
	PJ26MD_100, PJ26MD_101, PJ26MD_110, PJ26MD_111,
	PJ25MD_000, PJ25MD_001, PJ25MD_010, PJ25MD_011,
	PJ25MD_100, PJ25MD_101, PJ25MD_110, PJ25MD_111,
	PJ24MD_000, PJ24MD_001, PJ24MD_010, PJ24MD_011,
	PJ24MD_100, PJ24MD_101, PJ24MD_110, PJ24MD_111,

	PJ23MD_000, PJ23MD_001, PJ23MD_010, PJ23MD_011,
	PJ23MD_100, PJ23MD_101, PJ23MD_110, PJ23MD_111,
	PJ22MD_000, PJ22MD_001, PJ22MD_010, PJ22MD_011,
	PJ22MD_100, PJ22MD_101, PJ22MD_110, PJ22MD_111,
	PJ21MD_000, PJ21MD_001, PJ21MD_010, PJ21MD_011,
	PJ21MD_100, PJ21MD_101, PJ21MD_110, PJ21MD_111,
	PJ20MD_000, PJ20MD_001, PJ20MD_010, PJ20MD_011,
	PJ20MD_100, PJ20MD_101, PJ20MD_110, PJ20MD_111,

	PJ19MD_000, PJ19MD_001, PJ19MD_010, PJ19MD_011,
	PJ19MD_100, PJ19MD_101, PJ19MD_110, PJ19MD_111,
	PJ18MD_000, PJ18MD_001, PJ18MD_010, PJ18MD_011,
	PJ18MD_100, PJ18MD_101, PJ18MD_110, PJ18MD_111,
	PJ17MD_000, PJ17MD_001, PJ17MD_010, PJ17MD_011,
	PJ17MD_100, PJ17MD_101, PJ17MD_110, PJ17MD_111,
	PJ16MD_000, PJ16MD_001, PJ16MD_010, PJ16MD_011,
	PJ16MD_100, PJ16MD_101, PJ16MD_110, PJ16MD_111,

	PJ15MD_000, PJ15MD_001, PJ15MD_010, PJ15MD_011,
	PJ15MD_100, PJ15MD_101, PJ15MD_110, PJ15MD_111,
	PJ14MD_000, PJ14MD_001, PJ14MD_010, PJ14MD_011,
	PJ14MD_100, PJ14MD_101, PJ14MD_110, PJ14MD_111,
	PJ13MD_000, PJ13MD_001, PJ13MD_010, PJ13MD_011,
	PJ13MD_100, PJ13MD_101, PJ13MD_110, PJ13MD_111,
	PJ12MD_000, PJ12MD_001, PJ12MD_010, PJ12MD_011,
	PJ12MD_100, PJ12MD_101, PJ12MD_110, PJ12MD_111,

	PJ11MD_000, PJ11MD_001, PJ11MD_010, PJ11MD_011,
	PJ11MD_100, PJ11MD_101, PJ11MD_110, PJ11MD_111,
	PJ10MD_000, PJ10MD_001, PJ10MD_010, PJ10MD_011,
	PJ10MD_100, PJ10MD_101, PJ10MD_110, PJ10MD_111,
	PJ9MD_000, PJ9MD_001, PJ9MD_010, PJ9MD_011,
	PJ9MD_100, PJ9MD_101, PJ9MD_110, PJ9MD_111,
	PJ8MD_000, PJ8MD_001, PJ8MD_010, PJ8MD_011,
	PJ8MD_100, PJ8MD_101, PJ8MD_110, PJ8MD_111,

	PJ7MD_000, PJ7MD_001, PJ7MD_010, PJ7MD_011,
	PJ7MD_100, PJ7MD_101, PJ7MD_110, PJ7MD_111,
	PJ6MD_000, PJ6MD_001, PJ6MD_010, PJ6MD_011,
	PJ6MD_100, PJ6MD_101, PJ6MD_110, PJ6MD_111,
	PJ5MD_000, PJ5MD_001, PJ5MD_010, PJ5MD_011,
	PJ5MD_100, PJ5MD_101, PJ5MD_110, PJ5MD_111,
	PJ4MD_000, PJ4MD_001, PJ4MD_010, PJ4MD_011,
	PJ4MD_100, PJ4MD_101, PJ4MD_110, PJ4MD_111,

	PJ3MD_000, PJ3MD_001, PJ3MD_010, PJ3MD_011,
	PJ3MD_100, PJ3MD_101, PJ3MD_110, PJ3MD_111,
	PJ2MD_000, PJ2MD_001, PJ2MD_010, PJ2MD_011,
	PJ2MD_100, PJ2MD_101, PJ2MD_110, PJ2MD_111,
	PJ1MD_000, PJ1MD_001, PJ1MD_010, PJ1MD_011,
	PJ1MD_100, PJ1MD_101, PJ1MD_110, PJ1MD_111,
	PJ0MD_000, PJ0MD_001, PJ0MD_010, PJ0MD_011,
	PJ0MD_100, PJ0MD_101, PJ0MD_110, PJ0MD_111,

	PINMUX_FUNCTION_END,

	PINMUX_MARK_BEGIN,
	/* Port H */
	PHAN7_MARK, PHAN6_MARK, PHAN5_MARK, PHAN4_MARK,
	PHAN3_MARK, PHAN2_MARK, PHAN1_MARK, PHAN0_MARK,

	/* IRQs */
	IRQ7_PG_MARK, IRQ6_PG_MARK, IRQ5_PG_MARK, IRQ4_PG_MARK,
	IRQ3_PG_MARK, IRQ2_PG_MARK, IRQ1_PG_MARK, IRQ0_PG_MARK,
	IRQ7_PF_MARK, IRQ6_PF_MARK, IRQ5_PF_MARK, IRQ4_PF_MARK,
	IRQ3_PJ_MARK, IRQ2_PJ_MARK, IRQ1_PJ_MARK, IRQ0_PJ_MARK,
	IRQ1_PC_MARK, IRQ0_PC_MARK,

	PINT7_PG_MARK, PINT6_PG_MARK, PINT5_PG_MARK, PINT4_PG_MARK,
	PINT3_PG_MARK, PINT2_PG_MARK, PINT1_PG_MARK, PINT0_PG_MARK,
	PINT7_PH_MARK, PINT6_PH_MARK, PINT5_PH_MARK, PINT4_PH_MARK,
	PINT3_PH_MARK, PINT2_PH_MARK, PINT1_PH_MARK, PINT0_PH_MARK,
	PINT7_PJ_MARK, PINT6_PJ_MARK, PINT5_PJ_MARK, PINT4_PJ_MARK,
	PINT3_PJ_MARK, PINT2_PJ_MARK, PINT1_PJ_MARK, PINT0_PJ_MARK,

	/* SD */
	SD_D0_MARK, SD_D1_MARK, SD_D2_MARK, SD_D3_MARK,
	SD_WP_MARK, SD_CLK_MARK, SD_CMD_MARK, SD_CD_MARK,

	/* MMC */
	MMC_D0_MARK, MMC_D1_MARK, MMC_D2_MARK, MMC_D3_MARK,
	MMC_D4_MARK, MMC_D5_MARK, MMC_D6_MARK, MMC_D7_MARK,
	MMC_CLK_MARK, MMC_CMD_MARK, MMC_CD_MARK,

	/* PWM */
	PWM1A_MARK, PWM1B_MARK, PWM1C_MARK, PWM1D_MARK,
	PWM1E_MARK, PWM1F_MARK, PWM1G_MARK, PWM1H_MARK,
	PWM2A_MARK, PWM2B_MARK, PWM2C_MARK, PWM2D_MARK,
	PWM2E_MARK, PWM2F_MARK, PWM2G_MARK, PWM2H_MARK,

	/* IEBus */
	IERXD_MARK, IETXD_MARK,

	/* WDT */
	WDTOVF_MARK,

	/* DMAC */
	TEND0_MARK, DACK0_MARK, DREQ0_MARK,
	TEND1_MARK, DACK1_MARK, DREQ1_MARK,

	/* ADC */
	ADTRG_MARK,

	/* BSC */
	A25_MARK, A24_MARK,
	A23_MARK, A22_MARK, A21_MARK, A20_MARK,
	A19_MARK, A18_MARK, A17_MARK, A16_MARK,
	A15_MARK, A14_MARK, A13_MARK, A12_MARK,
	A11_MARK, A10_MARK, A9_MARK, A8_MARK,
	A7_MARK, A6_MARK, A5_MARK, A4_MARK,
	A3_MARK, A2_MARK, A1_MARK, A0_MARK,
	D31_MARK, D30_MARK, D29_MARK, D28_MARK,
	D27_MARK, D26_MARK, D25_MARK, D24_MARK,
	D23_MARK, D22_MARK, D21_MARK, D20_MARK,
	D19_MARK, D18_MARK, D17_MARK, D16_MARK,
	D15_MARK, D14_MARK, D13_MARK, D12_MARK,
	D11_MARK, D10_MARK, D9_MARK, D8_MARK,
	D7_MARK, D6_MARK, D5_MARK, D4_MARK,
	D3_MARK, D2_MARK, D1_MARK, D0_MARK,
	BS_MARK,
	CS4_MARK, CS3_MARK, CS2_MARK, CS1_MARK, CS0_MARK,
	CS5CE1A_MARK,
	CE2A_MARK, CE2B_MARK,
	RD_MARK, RDWR_MARK,
	WE3ICIOWRAHDQMUU_MARK,
	WE2ICIORDDQMUL_MARK,
	WE1DQMUWE_MARK,
	WE0DQML_MARK,
	RAS_MARK, CAS_MARK, CKE_MARK,
	WAIT_MARK, BREQ_MARK, BACK_MARK, IOIS16_MARK,

	/* TMU */
	TIOC0A_MARK, TIOC0B_MARK, TIOC0C_MARK, TIOC0D_MARK,
	TIOC1A_MARK, TIOC1B_MARK,
	TIOC2A_MARK, TIOC2B_MARK,
	TIOC3A_MARK, TIOC3B_MARK, TIOC3C_MARK, TIOC3D_MARK,
	TIOC4A_MARK, TIOC4B_MARK, TIOC4C_MARK, TIOC4D_MARK,
	TCLKA_MARK, TCLKB_MARK, TCLKC_MARK, TCLKD_MARK,

	/* SCIF */
	SCK0_MARK, RXD0_MARK, TXD0_MARK,
	SCK1_MARK, RXD1_MARK, TXD1_MARK, RTS1_MARK, CTS1_MARK,
	SCK2_MARK, RXD2_MARK, TXD2_MARK,
	SCK3_MARK, RXD3_MARK, TXD3_MARK,
	SCK4_MARK, RXD4_MARK, TXD4_MARK,
	SCK5_MARK, RXD5_MARK, TXD5_MARK, RTS5_MARK, CTS5_MARK,
	SCK6_MARK, RXD6_MARK, TXD6_MARK,
	SCK7_MARK, RXD7_MARK, TXD7_MARK, RTS7_MARK, CTS7_MARK,

	/* RSPI */
	MISO0_PB20_MARK, MOSI0_PB19_MARK, SSL00_PB18_MARK, RSPCK0_PB17_MARK,
	MISO0_PJ19_MARK, MOSI0_PJ18_MARK, SSL00_PJ17_MARK, RSPCK0_PJ16_MARK,
	MISO1_MARK, MOSI1_MARK, SSL10_MARK, RSPCK1_MARK,

	/* IIC3 */
	SCL0_MARK, SDA0_MARK,
	SCL1_MARK, SDA1_MARK,
	SCL2_MARK, SDA2_MARK,
	SCL3_MARK, SDA3_MARK,

	/* SSI */
	SSISCK0_MARK, SSIWS0_MARK, SSITXD0_MARK, SSIRXD0_MARK,
	SSISCK1_MARK, SSIWS1_MARK, SSIDATA1_MARK,
	SSISCK2_MARK, SSIWS2_MARK, SSIDATA2_MARK,
	SSISCK3_MARK, SSIWS3_MARK, SSIDATA3_MARK,
	SSISCK4_MARK, SSIWS4_MARK, SSIDATA4_MARK,
	SSISCK5_MARK, SSIWS5_MARK, SSIDATA5_MARK,
	AUDIO_CLK_MARK,
	AUDIO_XOUT_MARK,

	/* SIOF */ /* NOTE Shares AUDIO_CLK with SSI */
	SIOFTXD_MARK, SIOFRXD_MARK, SIOFSYNC_MARK, SIOFSCK_MARK,

	/* SPDIF */ /* NOTE Shares AUDIO_CLK with SSI */
	SPDIF_IN_MARK, SPDIF_OUT_MARK,
	SPDIF_IN_PJ24_MARK, SPDIF_OUT_PJ25_MARK,

	/* NANDFMC */ /* NOTE Controller is not available in boot mode 0 */
	FCE_MARK,
	FRB_MARK,

	/* CAN */
	CRX0_MARK, CTX0_MARK,
	CRX1_MARK, CTX1_MARK,
	CRX2_MARK, CTX2_MARK,
	CRX0CRX1_MARK,
	CRX0CRX1CRX2_MARK,
	CTX0CTX1CTX2_MARK,
	CRX1_PJ22_MARK, CTX1_PJ23_MARK,
	CRX2_PJ20_MARK, CTX2_PJ21_MARK,
	CRX0CRX1_PJ22_MARK,
	CRX0CRX1CRX2_PJ20_MARK,

	/* VDC */
	DV_CLK_MARK,
	DV_VSYNC_MARK, DV_HSYNC_MARK,
	DV_DATA23_MARK, DV_DATA22_MARK, DV_DATA21_MARK, DV_DATA20_MARK,
	DV_DATA19_MARK, DV_DATA18_MARK, DV_DATA17_MARK, DV_DATA16_MARK,
	DV_DATA15_MARK, DV_DATA14_MARK, DV_DATA13_MARK, DV_DATA12_MARK,
	DV_DATA11_MARK, DV_DATA10_MARK, DV_DATA9_MARK, DV_DATA8_MARK,
	DV_DATA7_MARK, DV_DATA6_MARK, DV_DATA5_MARK, DV_DATA4_MARK,
	DV_DATA3_MARK, DV_DATA2_MARK, DV_DATA1_MARK, DV_DATA0_MARK,
	LCD_CLK_MARK, LCD_EXTCLK_MARK,
	LCD_VSYNC_MARK, LCD_HSYNC_MARK, LCD_DE_MARK,
	LCD_DATA23_PG23_MARK, LCD_DATA22_PG22_MARK, LCD_DATA21_PG21_MARK,
	LCD_DATA20_PG20_MARK, LCD_DATA19_PG19_MARK, LCD_DATA18_PG18_MARK,
	LCD_DATA17_PG17_MARK, LCD_DATA16_PG16_MARK, LCD_DATA15_PG15_MARK,
	LCD_DATA14_PG14_MARK, LCD_DATA13_PG13_MARK, LCD_DATA12_PG12_MARK,
	LCD_DATA11_PG11_MARK, LCD_DATA10_PG10_MARK, LCD_DATA9_PG9_MARK,
	LCD_DATA8_PG8_MARK, LCD_DATA7_PG7_MARK, LCD_DATA6_PG6_MARK,
	LCD_DATA5_PG5_MARK, LCD_DATA4_PG4_MARK, LCD_DATA3_PG3_MARK,
	LCD_DATA2_PG2_MARK, LCD_DATA1_PG1_MARK, LCD_DATA0_PG0_MARK,
	LCD_DATA23_PJ23_MARK, LCD_DATA22_PJ22_MARK, LCD_DATA21_PJ21_MARK,
	LCD_DATA20_PJ20_MARK, LCD_DATA19_PJ19_MARK, LCD_DATA18_PJ18_MARK,
	LCD_DATA17_PJ17_MARK, LCD_DATA16_PJ16_MARK, LCD_DATA15_PJ15_MARK,
	LCD_DATA14_PJ14_MARK, LCD_DATA13_PJ13_MARK, LCD_DATA12_PJ12_MARK,
	LCD_DATA11_PJ11_MARK, LCD_DATA10_PJ10_MARK, LCD_DATA9_PJ9_MARK,
	LCD_DATA8_PJ8_MARK, LCD_DATA7_PJ7_MARK, LCD_DATA6_PJ6_MARK,
	LCD_DATA5_PJ5_MARK, LCD_DATA4_PJ4_MARK, LCD_DATA3_PJ3_MARK,
	LCD_DATA2_PJ2_MARK, LCD_DATA1_PJ1_MARK, LCD_DATA0_PJ0_MARK,
	LCD_TCON6_MARK, LCD_TCON5_MARK, LCD_TCON4_MARK,
	LCD_TCON3_MARK, LCD_TCON2_MARK, LCD_TCON1_MARK, LCD_TCON0_MARK,
	LCD_M_DISP_MARK,
	PINMUX_MARK_END,
};

static pinmux_enum_t pinmux_data[] = {

	/* Port A */
	PINMUX_DATA(PA1_DATA, PA1_IN),
	PINMUX_DATA(PA0_DATA, PA0_IN),

	/* Port B */
	PINMUX_DATA(PB22_DATA, PB22MD_000, PB22_IN, PB22_OUT),
	PINMUX_DATA(A22_MARK, PB22MD_001),
	PINMUX_DATA(CTX2_MARK, PB22MD_010),
	PINMUX_DATA(IETXD_MARK, PB22MD_011),
	PINMUX_DATA(CS4_MARK, PB22MD_100),

	PINMUX_DATA(PB21_DATA, PB21MD_00, PB21_IN, PB21_OUT),
	PINMUX_DATA(A21_MARK, PB21MD_01),
	PINMUX_DATA(CRX2_MARK, PB21MD_10),
	PINMUX_DATA(IERXD_MARK, PB21MD_11),

	PINMUX_DATA(A20_MARK, PB20MD_001),
	PINMUX_DATA(A19_MARK, PB19MD_001),
	PINMUX_DATA(A18_MARK, PB18MD_001),
	PINMUX_DATA(A17_MARK, PB17MD_001),
	PINMUX_DATA(A16_MARK, PB16MD_001),
	PINMUX_DATA(A15_MARK, PB15MD_001),
	PINMUX_DATA(A14_MARK, PB14MD_001),
	PINMUX_DATA(A13_MARK, PB13MD_001),
	PINMUX_DATA(A12_MARK, PB12MD_01),
	PINMUX_DATA(A11_MARK, PB11MD_01),
	PINMUX_DATA(A10_MARK, PB10MD_01),
	PINMUX_DATA(A9_MARK, PB9MD_01),
	PINMUX_DATA(A8_MARK, PB8MD_01),
	PINMUX_DATA(A7_MARK, PB7MD_01),
	PINMUX_DATA(A6_MARK, PB6MD_01),
	PINMUX_DATA(A5_MARK, PB5MD_01),
	PINMUX_DATA(A4_MARK, PB4MD_01),
	PINMUX_DATA(A3_MARK, PB3MD_01),
	PINMUX_DATA(A2_MARK, PB2MD_01),
	PINMUX_DATA(A1_MARK, PB1MD_01),

	/* Port C */
	PINMUX_DATA(PC8_DATA, PC8MD_000),
	PINMUX_DATA(CS3_MARK, PC8MD_001),
	PINMUX_DATA(TXD7_MARK, PC8MD_010),
	PINMUX_DATA(CTX1_MARK, PC8MD_011),

	PINMUX_DATA(PC7_DATA, PC7MD_000),
	PINMUX_DATA(CKE_MARK, PC7MD_001),
	PINMUX_DATA(RXD7_MARK, PC7MD_010),
	PINMUX_DATA(CRX1_MARK, PC7MD_011),
	PINMUX_DATA(CRX0CRX1_MARK, PC7MD_100),
	PINMUX_DATA(IRQ1_PC_MARK, PC7MD_101),

	PINMUX_DATA(PC6_DATA, PC6MD_000),
	PINMUX_DATA(CAS_MARK, PC6MD_001),
	PINMUX_DATA(SCK7_MARK, PC6MD_010),
	PINMUX_DATA(CTX0_MARK, PC6MD_011),

	PINMUX_DATA(PC5_DATA, PC5MD_000),
	PINMUX_DATA(RAS_MARK, PC5MD_001),
	PINMUX_DATA(CRX0_MARK, PC5MD_011),
	PINMUX_DATA(CTX0CTX1CTX2_MARK, PC5MD_100),
	PINMUX_DATA(IRQ0_PC_MARK, PC5MD_101),

	PINMUX_DATA(PC4_DATA, PC4MD_00),
	PINMUX_DATA(WE1DQMUWE_MARK, PC4MD_01),
	PINMUX_DATA(TXD6_MARK, PC4MD_10),

	PINMUX_DATA(PC3_DATA, PC3MD_00),
	PINMUX_DATA(WE0DQML_MARK, PC3MD_01),
	PINMUX_DATA(RXD6_MARK, PC3MD_10),

	PINMUX_DATA(PC2_DATA, PC2MD_00),
	PINMUX_DATA(RDWR_MARK, PC2MD_01),
	PINMUX_DATA(SCK5_MARK, PC2MD_10),

	PINMUX_DATA(PC1_DATA, PC1MD_0),
	PINMUX_DATA(RD_MARK, PC1MD_1),

	PINMUX_DATA(PC0_DATA, PC0MD_0),
	PINMUX_DATA(CS0_MARK, PC0MD_1),

	/* Port D */
	PINMUX_DATA(D15_MARK, PD15MD_01),
	PINMUX_DATA(D14_MARK, PD14MD_01),

	PINMUX_DATA(PD13_DATA, PD13MD_00),
	PINMUX_DATA(D13_MARK, PD13MD_01),
	PINMUX_DATA(PWM2F_MARK, PD13MD_10),

	PINMUX_DATA(PD12_DATA, PD12MD_00),
	PINMUX_DATA(D12_MARK, PD12MD_01),
	PINMUX_DATA(PWM2E_MARK, PD12MD_10),

	PINMUX_DATA(D11_MARK, PD11MD_01),
	PINMUX_DATA(D10_MARK, PD10MD_01),
	PINMUX_DATA(D9_MARK, PD9MD_01),
	PINMUX_DATA(D8_MARK, PD8MD_01),
	PINMUX_DATA(D7_MARK, PD7MD_01),
	PINMUX_DATA(D6_MARK, PD6MD_01),
	PINMUX_DATA(D5_MARK, PD5MD_01),
	PINMUX_DATA(D4_MARK, PD4MD_01),
	PINMUX_DATA(D3_MARK, PD3MD_01),
	PINMUX_DATA(D2_MARK, PD2MD_01),
	PINMUX_DATA(D1_MARK, PD1MD_01),
	PINMUX_DATA(D0_MARK, PD0MD_01),

	/* Port E */
	PINMUX_DATA(PE7_DATA, PE7MD_00),
	PINMUX_DATA(SDA3_MARK, PE7MD_01),
	PINMUX_DATA(RXD7_MARK, PE7MD_10),

	PINMUX_DATA(PE6_DATA, PE6MD_00),
	PINMUX_DATA(SCL3_MARK, PE6MD_01),
	PINMUX_DATA(RXD6_MARK, PE6MD_10),

	PINMUX_DATA(PE5_DATA, PE5MD_00),
	PINMUX_DATA(SDA2_MARK, PE5MD_01),
	PINMUX_DATA(RXD5_MARK, PE5MD_10),
	PINMUX_DATA(DV_HSYNC_MARK, PE5MD_11),

	PINMUX_DATA(PE4_DATA, PE4MD_00),
	PINMUX_DATA(SCL2_MARK, PE4MD_01),
	PINMUX_DATA(DV_VSYNC_MARK, PE4MD_11),

	PINMUX_DATA(PE3_DATA, PE3MD_000),
	PINMUX_DATA(SDA1_MARK, PE3MD_001),
	PINMUX_DATA(TCLKD_MARK, PE3MD_010),
	PINMUX_DATA(ADTRG_MARK, PE3MD_011),
	PINMUX_DATA(DV_HSYNC_MARK, PE3MD_100),

	PINMUX_DATA(PE2_DATA, PE2MD_000),
	PINMUX_DATA(SCL1_MARK, PE2MD_001),
	PINMUX_DATA(TCLKD_MARK, PE2MD_010),
	PINMUX_DATA(IOIS16_MARK, PE2MD_011),
	PINMUX_DATA(DV_VSYNC_MARK, PE2MD_100),

	PINMUX_DATA(PE1_DATA, PE1MD_000),
	PINMUX_DATA(SDA0_MARK, PE1MD_001),
	PINMUX_DATA(TCLKB_MARK, PE1MD_010),
	PINMUX_DATA(AUDIO_CLK_MARK, PE1MD_010),
	PINMUX_DATA(DV_CLK_MARK, PE1MD_100),

	PINMUX_DATA(PE0_DATA, PE0MD_00),
	PINMUX_DATA(SCL0_MARK, PE0MD_01),
	PINMUX_DATA(TCLKA_MARK, PE0MD_10),
	PINMUX_DATA(LCD_EXTCLK_MARK, PE0MD_11),

	/* Port F */
	PINMUX_DATA(PF23_DATA, PF23MD_000),
	PINMUX_DATA(SD_D2_MARK, PF23MD_001),
	PINMUX_DATA(TXD3_MARK, PF23MD_100),
	PINMUX_DATA(MMC_D2_MARK, PF23MD_101),

	PINMUX_DATA(PF22_DATA, PF22MD_000),
	PINMUX_DATA(SD_D3_MARK, PF22MD_001),
	PINMUX_DATA(RXD3_MARK, PF22MD_100),
	PINMUX_DATA(MMC_D3_MARK, PF22MD_101),

	PINMUX_DATA(PF21_DATA, PF21MD_000),
	PINMUX_DATA(SD_CMD_MARK, PF21MD_001),
	PINMUX_DATA(SCK3_MARK, PF21MD_100),
	PINMUX_DATA(MMC_CMD_MARK, PF21MD_101),

	PINMUX_DATA(PF20_DATA, PF20MD_000),
	PINMUX_DATA(SD_CLK_MARK, PF20MD_001),
	PINMUX_DATA(SSIDATA3_MARK, PF20MD_010),
	PINMUX_DATA(MMC_CLK_MARK, PF20MD_101),

	PINMUX_DATA(PF19_DATA, PF19MD_000),
	PINMUX_DATA(SD_D0_MARK, PF19MD_001),
	PINMUX_DATA(SSIWS3_MARK, PF19MD_010),
	PINMUX_DATA(IRQ7_PF_MARK, PF19MD_100),
	PINMUX_DATA(MMC_D0_MARK, PF19MD_101),

	PINMUX_DATA(PF18_DATA, PF18MD_000),
	PINMUX_DATA(SD_D1_MARK, PF18MD_001),
	PINMUX_DATA(SSISCK3_MARK, PF18MD_010),
	PINMUX_DATA(IRQ6_PF_MARK, PF18MD_100),
	PINMUX_DATA(MMC_D1_MARK, PF18MD_101),

	PINMUX_DATA(PF17_DATA, PF17MD_000),
	PINMUX_DATA(SD_WP_MARK, PF17MD_001),
	PINMUX_DATA(FRB_MARK, PF17MD_011),
	PINMUX_DATA(IRQ5_PF_MARK, PF17MD_100),

	PINMUX_DATA(PF16_DATA, PF16MD_000),
	PINMUX_DATA(SD_CD_MARK, PF16MD_001),
	PINMUX_DATA(FCE_MARK, PF16MD_011),
	PINMUX_DATA(IRQ4_PF_MARK, PF16MD_100),
	PINMUX_DATA(MMC_CD_MARK, PF16MD_101),

	PINMUX_DATA(PF15_DATA, PF15MD_000),
	PINMUX_DATA(A0_MARK, PF15MD_001),
	PINMUX_DATA(SSIDATA2_MARK, PF15MD_010),
	PINMUX_DATA(WDTOVF_MARK, PF15MD_011),
	PINMUX_DATA(TXD2_MARK, PF15MD_100),

	PINMUX_DATA(PF14_DATA, PF14MD_000),
	PINMUX_DATA(A25_MARK, PF14MD_001),
	PINMUX_DATA(SSIWS2_MARK, PF14MD_010),
	PINMUX_DATA(RXD2_MARK, PF14MD_100),

	PINMUX_DATA(PF13_DATA, PF13MD_000),
	PINMUX_DATA(A24_MARK, PF13MD_001),
	PINMUX_DATA(SSISCK2_MARK, PF13MD_010),
	PINMUX_DATA(SCK2_MARK, PF13MD_100),

	PINMUX_DATA(PF12_DATA, PF12MD_000),
	PINMUX_DATA(SSIDATA1_MARK, PF12MD_010),
	PINMUX_DATA(DV_DATA12_MARK, PF12MD_011),
	PINMUX_DATA(TXD1_MARK, PF12MD_100),
	PINMUX_DATA(MMC_D7_MARK, PF12MD_101),

	PINMUX_DATA(PF11_DATA, PF11MD_000),
	PINMUX_DATA(SSIWS1_MARK, PF11MD_010),
	PINMUX_DATA(DV_DATA2_MARK, PF11MD_011),
	PINMUX_DATA(RXD1_MARK, PF11MD_100),
	PINMUX_DATA(MMC_D6_MARK, PF11MD_101),

	PINMUX_DATA(PF10_DATA, PF10MD_000),
	PINMUX_DATA(CS1_MARK, PF10MD_001),
	PINMUX_DATA(SSISCK1_MARK, PF10MD_010),
	PINMUX_DATA(DV_DATA1_MARK, PF10MD_011),
	PINMUX_DATA(SCK1_MARK, PF10MD_100),
	PINMUX_DATA(MMC_D5_MARK, PF10MD_101),

	PINMUX_DATA(PF9_DATA, PF9MD_000),
	PINMUX_DATA(BS_MARK, PF9MD_001),
	PINMUX_DATA(DV_DATA0_MARK, PF9MD_011),
	PINMUX_DATA(SCK0_MARK, PF9MD_100),
	PINMUX_DATA(MMC_D4_MARK, PF9MD_101),
	PINMUX_DATA(RTS1_MARK, PF9MD_110),

	PINMUX_DATA(PF8_DATA, PF8MD_000),
	PINMUX_DATA(A23_MARK, PF8MD_001),
	PINMUX_DATA(TXD0_MARK, PF8MD_100),

	PINMUX_DATA(PF7_DATA, PF7MD_000),
	PINMUX_DATA(SSIRXD0_MARK, PF7MD_010),
	PINMUX_DATA(RXD0_MARK, PF7MD_100),
	PINMUX_DATA(CTS1_MARK, PF7MD_110),

	PINMUX_DATA(PF6_DATA, PF6MD_000),
	PINMUX_DATA(CE2A_MARK, PF6MD_001),
	PINMUX_DATA(SSITXD0_MARK, PF6MD_010),

	PINMUX_DATA(PF5_DATA, PF5MD_000),
	PINMUX_DATA(SSIWS0_MARK, PF5MD_010),

	PINMUX_DATA(PF4_DATA, PF4MD_000),
	PINMUX_DATA(CS5CE1A_MARK, PF4MD_001),
	PINMUX_DATA(SSISCK0_MARK, PF4MD_010),

	PINMUX_DATA(PF3_DATA, PF3MD_000),
	PINMUX_DATA(CS2_MARK, PF3MD_001),
	PINMUX_DATA(MISO1_MARK, PF3MD_011),
	PINMUX_DATA(TIOC4D_MARK, PF3MD_100),

	PINMUX_DATA(PF2_DATA, PF2MD_000),
	PINMUX_DATA(WAIT_MARK, PF2MD_001),
	PINMUX_DATA(MOSI1_MARK, PF2MD_011),
	PINMUX_DATA(TIOC4C_MARK, PF2MD_100),
	PINMUX_DATA(TEND0_MARK, PF2MD_101),

	PINMUX_DATA(PF1_DATA, PF1MD_000),
	PINMUX_DATA(BACK_MARK, PF1MD_001),
	PINMUX_DATA(SSL10_MARK, PF1MD_011),
	PINMUX_DATA(TIOC4B_MARK, PF1MD_100),
	PINMUX_DATA(DACK0_MARK, PF1MD_101),

	PINMUX_DATA(PF0_DATA, PF0MD_000),
	PINMUX_DATA(BREQ_MARK, PF0MD_001),
	PINMUX_DATA(RSPCK1_MARK, PF0MD_011),
	PINMUX_DATA(TIOC4A_MARK, PF0MD_100),
	PINMUX_DATA(DREQ0_MARK, PF0MD_101),

	/* Port G */
	PINMUX_DATA(PG27_DATA, PG27MD_00),
	PINMUX_DATA(LCD_TCON2_MARK, PG27MD_10),
	PINMUX_DATA(LCD_EXTCLK_MARK, PG27MD_11),
	PINMUX_DATA(LCD_DE_MARK, PG27MD_11),

	PINMUX_DATA(PG26_DATA, PG26MD_00),
	PINMUX_DATA(LCD_TCON1_MARK, PG26MD_10),
	PINMUX_DATA(LCD_HSYNC_MARK, PG26MD_10),

	PINMUX_DATA(PG25_DATA, PG25MD_00),
	PINMUX_DATA(LCD_TCON0_MARK, PG25MD_10),
	PINMUX_DATA(LCD_VSYNC_MARK, PG25MD_10),

	PINMUX_DATA(PG24_DATA, PG24MD_00),
	PINMUX_DATA(LCD_CLK_MARK, PG24MD_10),

	PINMUX_DATA(PG23_DATA, PG23MD_000),
	PINMUX_DATA(LCD_DATA23_PG23_MARK, PG23MD_010),
	PINMUX_DATA(LCD_TCON6_MARK, PG23MD_011),
	PINMUX_DATA(TXD5_MARK, PG23MD_100),

	PINMUX_DATA(PG22_DATA, PG22MD_000),
	PINMUX_DATA(LCD_DATA22_PG22_MARK, PG22MD_010),
	PINMUX_DATA(LCD_TCON5_MARK, PG22MD_011),
	PINMUX_DATA(RXD5_MARK, PG22MD_100),

	PINMUX_DATA(PG21_DATA, PG21MD_000),
	PINMUX_DATA(DV_DATA7_MARK, PG21MD_001),
	PINMUX_DATA(LCD_DATA21_PG21_MARK, PG21MD_010),
	PINMUX_DATA(LCD_TCON4_MARK, PG21MD_011),
	PINMUX_DATA(TXD4_MARK, PG21MD_100),

	PINMUX_DATA(PG20_DATA, PG20MD_000),
	PINMUX_DATA(DV_DATA6_MARK, PG20MD_001),
	PINMUX_DATA(LCD_DATA20_PG20_MARK, PG21MD_010),
	PINMUX_DATA(LCD_TCON3_MARK, PG20MD_011),
	PINMUX_DATA(RXD4_MARK, PG20MD_100),

	PINMUX_DATA(PG19_DATA, PG19MD_000),
	PINMUX_DATA(DV_DATA5_MARK, PG19MD_001),
	PINMUX_DATA(LCD_DATA19_PG19_MARK, PG19MD_010),
	PINMUX_DATA(SPDIF_OUT_MARK, PG19MD_011),
	PINMUX_DATA(SCK5_MARK, PG19MD_100),

	PINMUX_DATA(PG18_DATA, PG18MD_000),
	PINMUX_DATA(DV_DATA4_MARK, PG18MD_001),
	PINMUX_DATA(LCD_DATA18_PG18_MARK, PG18MD_010),
	PINMUX_DATA(SPDIF_IN_MARK, PG18MD_011),
	PINMUX_DATA(SCK4_MARK, PG18MD_100),

// TODO hardware manual has PG17 3 bits wide in reg picture and 2 bits in description
// we're going with 2 bits
	PINMUX_DATA(PG17_DATA, PG17MD_00),
	PINMUX_DATA(WE3ICIOWRAHDQMUU_MARK, PG17MD_01),
	PINMUX_DATA(LCD_DATA17_PG17_MARK, PG17MD_10),

// TODO hardware manual has PG16 3 bits wide in reg picture and 2 bits in description
// we're going with 2 bits
	PINMUX_DATA(PG16_DATA, PG16MD_00),
	PINMUX_DATA(WE2ICIORDDQMUL_MARK, PG16MD_01),
	PINMUX_DATA(LCD_DATA16_PG16_MARK, PG16MD_10),

	PINMUX_DATA(PG15_DATA, PG15MD_00),
	PINMUX_DATA(D31_MARK, PG15MD_01),
	PINMUX_DATA(LCD_DATA15_PG15_MARK, PG15MD_10),
	PINMUX_DATA(PINT7_PG_MARK, PG15MD_11),

	PINMUX_DATA(PG14_DATA, PG14MD_00),
	PINMUX_DATA(D30_MARK, PG14MD_01),
	PINMUX_DATA(LCD_DATA14_PG14_MARK, PG14MD_10),
	PINMUX_DATA(PINT6_PG_MARK, PG14MD_11),

	PINMUX_DATA(PG13_DATA, PG13MD_00),
	PINMUX_DATA(D29_MARK, PG13MD_01),
	PINMUX_DATA(LCD_DATA13_PG13_MARK, PG13MD_10),
	PINMUX_DATA(PINT5_PG_MARK, PG13MD_11),

	PINMUX_DATA(PG12_DATA, PG12MD_00),
	PINMUX_DATA(D28_MARK, PG12MD_01),
	PINMUX_DATA(LCD_DATA12_PG12_MARK, PG12MD_10),
	PINMUX_DATA(PINT4_PG_MARK, PG12MD_11),

	PINMUX_DATA(PG11_DATA, PG11MD_000),
	PINMUX_DATA(D27_MARK, PG11MD_001),
	PINMUX_DATA(LCD_DATA11_PG11_MARK, PG11MD_010),
	PINMUX_DATA(PINT3_PG_MARK, PG11MD_011),
	PINMUX_DATA(TIOC3D_MARK, PG11MD_100),

	PINMUX_DATA(PG10_DATA, PG10MD_000),
	PINMUX_DATA(D26_MARK, PG10MD_001),
	PINMUX_DATA(LCD_DATA10_PG10_MARK, PG10MD_010),
	PINMUX_DATA(PINT2_PG_MARK, PG10MD_011),
	PINMUX_DATA(TIOC3C_MARK, PG10MD_100),

	PINMUX_DATA(PG9_DATA, PG9MD_000),
	PINMUX_DATA(D25_MARK, PG9MD_001),
	PINMUX_DATA(LCD_DATA9_PG9_MARK, PG9MD_010),
	PINMUX_DATA(PINT1_PG_MARK, PG9MD_011),
	PINMUX_DATA(TIOC3B_MARK, PG9MD_100),

	PINMUX_DATA(PG8_DATA, PG8MD_000),
	PINMUX_DATA(D24_MARK, PG8MD_001),
	PINMUX_DATA(LCD_DATA8_PG8_MARK, PG8MD_010),
	PINMUX_DATA(PINT0_PG_MARK, PG8MD_011),
	PINMUX_DATA(TIOC3A_MARK, PG8MD_100),

	PINMUX_DATA(PG7_DATA, PG7MD_000),
	PINMUX_DATA(D23_MARK, PG7MD_001),
	PINMUX_DATA(LCD_DATA7_PG7_MARK, PG7MD_010),
	PINMUX_DATA(IRQ7_PG_MARK, PG7MD_011),
	PINMUX_DATA(TIOC2B_MARK, PG7MD_100),

	PINMUX_DATA(PG6_DATA, PG6MD_000),
	PINMUX_DATA(D22_MARK, PG6MD_001),
	PINMUX_DATA(LCD_DATA6_PG6_MARK, PG6MD_010),
	PINMUX_DATA(IRQ6_PG_MARK, PG6MD_011),
	PINMUX_DATA(TIOC2A_MARK, PG6MD_100),

	PINMUX_DATA(PG5_DATA, PG5MD_000),
	PINMUX_DATA(D21_MARK, PG5MD_001),
	PINMUX_DATA(LCD_DATA5_PG5_MARK, PG5MD_010),
	PINMUX_DATA(IRQ5_PG_MARK, PG5MD_011),
	PINMUX_DATA(TIOC1B_MARK, PG5MD_100),

	PINMUX_DATA(PG4_DATA, PG4MD_000),
	PINMUX_DATA(D20_MARK, PG4MD_001),
	PINMUX_DATA(LCD_DATA4_PG4_MARK, PG4MD_010),
	PINMUX_DATA(IRQ4_PG_MARK, PG4MD_011),
	PINMUX_DATA(TIOC1A_MARK, PG4MD_100),

	PINMUX_DATA(PG3_DATA, PG3MD_000),
	PINMUX_DATA(D19_MARK, PG3MD_001),
	PINMUX_DATA(LCD_DATA3_PG3_MARK, PG3MD_010),
	PINMUX_DATA(IRQ3_PG_MARK, PG3MD_011),
	PINMUX_DATA(TIOC0D_MARK, PG3MD_100),

	PINMUX_DATA(PG2_DATA, PG2MD_000),
	PINMUX_DATA(D18_MARK, PG2MD_001),
	PINMUX_DATA(LCD_DATA2_PG2_MARK, PG2MD_010),
	PINMUX_DATA(IRQ2_PG_MARK, PG2MD_011),
	PINMUX_DATA(TIOC0C_MARK, PG2MD_100),

	PINMUX_DATA(PG1_DATA, PG1MD_000),
	PINMUX_DATA(D17_MARK, PG1MD_001),
	PINMUX_DATA(LCD_DATA1_PG1_MARK, PG1MD_010),
	PINMUX_DATA(IRQ1_PG_MARK, PG1MD_011),
	PINMUX_DATA(TIOC0B_MARK, PG1MD_100),

	PINMUX_DATA(PG0_DATA, PG0MD_000),
	PINMUX_DATA(D16_MARK, PG0MD_001),
	PINMUX_DATA(LCD_DATA0_PG0_MARK, PG0MD_010),
	PINMUX_DATA(IRQ0_PG_MARK, PG0MD_011),
	PINMUX_DATA(TIOC0A_MARK, PG0MD_100),

	/* Port H */
	PINMUX_DATA(PH7_DATA, PH7MD_00),
	PINMUX_DATA(PHAN7_MARK, PH7MD_01),
	PINMUX_DATA(PINT7_PH_MARK, PH7MD_10),

	PINMUX_DATA(PH6_DATA, PH6MD_00),
	PINMUX_DATA(PHAN6_MARK, PH6MD_01),
	PINMUX_DATA(PINT6_PH_MARK, PH6MD_10),

	PINMUX_DATA(PH5_DATA, PH5MD_00),
	PINMUX_DATA(PHAN5_MARK, PH5MD_01),
	PINMUX_DATA(PINT5_PH_MARK, PH5MD_10),
	PINMUX_DATA(LCD_EXTCLK_MARK, PH5MD_11),

	PINMUX_DATA(PH4_DATA, PH4MD_00),
	PINMUX_DATA(PHAN4_MARK, PH4MD_01),
	PINMUX_DATA(PINT4_PH_MARK, PH4MD_10),

	PINMUX_DATA(PH3_DATA, PH3MD_00),
	PINMUX_DATA(PHAN3_MARK, PH3MD_01),
	PINMUX_DATA(PINT3_PH_MARK, PH3MD_10),

	PINMUX_DATA(PH2_DATA, PH2MD_00),
	PINMUX_DATA(PHAN2_MARK, PH2MD_01),
	PINMUX_DATA(PINT2_PH_MARK, PH2MD_10),

	PINMUX_DATA(PH1_DATA, PH1MD_00),
	PINMUX_DATA(PHAN1_MARK, PH1MD_01),
	PINMUX_DATA(PINT1_PH_MARK, PH1MD_10),

	PINMUX_DATA(PH0_DATA, PH0MD_00),
	PINMUX_DATA(PHAN0_MARK, PH0MD_01),
	PINMUX_DATA(PINT0_PH_MARK, PH0MD_10),

	/* Port I - not on device */

	/* Port J */
	PINMUX_DATA(PJ31_DATA, PJ31MD_0),
	PINMUX_DATA(DV_CLK_MARK, PJ31MD_1),

	PINMUX_DATA(PJ30_DATA, PJ30MD_000),
	PINMUX_DATA(SSIDATA5_MARK, PJ30MD_010),
	PINMUX_DATA(TIOC2B_MARK, PJ30MD_100),
	PINMUX_DATA(IETXD_MARK, PJ30MD_101),

	PINMUX_DATA(PJ29_DATA, PJ29MD_000),
	PINMUX_DATA(SSIWS5_MARK, PJ29MD_010),
	PINMUX_DATA(TIOC2A_MARK, PJ29MD_100),
	PINMUX_DATA(IERXD_MARK, PJ29MD_101),

	PINMUX_DATA(PJ28_DATA, PJ28MD_000),
	PINMUX_DATA(SSISCK5_MARK, PJ28MD_010),
	PINMUX_DATA(TIOC1B_MARK, PJ28MD_100),
	PINMUX_DATA(RTS7_MARK, PJ28MD_101),

	PINMUX_DATA(PJ27_DATA, PJ27MD_000),
	PINMUX_DATA(TIOC1A_MARK, PJ27MD_100),
	PINMUX_DATA(CTS7_MARK, PJ27MD_101),

	PINMUX_DATA(PJ26_DATA, PJ26MD_000),
	PINMUX_DATA(SSIDATA4_MARK, PJ26MD_010),
	PINMUX_DATA(LCD_TCON5_MARK, PJ26MD_011),
	PINMUX_DATA(TXD7_MARK, PJ26MD_101),

	PINMUX_DATA(PJ25_DATA, PJ25MD_000),
	PINMUX_DATA(SSIWS4_MARK, PJ25MD_010),
	PINMUX_DATA(LCD_TCON4_MARK, PJ25MD_011),
	PINMUX_DATA(SPDIF_OUT_MARK, PJ25MD_100),
	PINMUX_DATA(RXD7_MARK, PJ25MD_101),

	PINMUX_DATA(PJ24_DATA, PJ24MD_000),
	PINMUX_DATA(SSISCK4_MARK, PJ24MD_010),
	PINMUX_DATA(LCD_TCON3_MARK, PJ24MD_011),
	PINMUX_DATA(SPDIF_IN_MARK, PJ24MD_100),
	PINMUX_DATA(SCK7_MARK, PJ24MD_101),

	PINMUX_DATA(PJ23_DATA, PJ23MD_000),
	PINMUX_DATA(DV_DATA23_MARK, PJ23MD_001),
	PINMUX_DATA(LCD_DATA23_PJ23_MARK, PJ23MD_010),
	PINMUX_DATA(LCD_TCON6_MARK, PJ23MD_011),
	PINMUX_DATA(IRQ3_PJ_MARK, PJ23MD_100),
	PINMUX_DATA(CTX1_MARK, PJ23MD_101),

	PINMUX_DATA(PJ22_DATA, PJ22MD_000),
	PINMUX_DATA(DV_DATA22_MARK, PJ22MD_001),
	PINMUX_DATA(LCD_DATA22_PJ22_MARK, PJ22MD_010),
	PINMUX_DATA(LCD_TCON5_MARK, PJ22MD_011),
	PINMUX_DATA(IRQ2_PJ_MARK, PJ22MD_100),
	PINMUX_DATA(CRX1_MARK, PJ22MD_101),
	PINMUX_DATA(CRX0CRX1_MARK, PJ22MD_110),

	PINMUX_DATA(PJ21_DATA, PJ21MD_000),
	PINMUX_DATA(DV_DATA21_MARK, PJ21MD_001),
	PINMUX_DATA(LCD_DATA21_PJ21_MARK, PJ21MD_010),
	PINMUX_DATA(LCD_TCON4_MARK, PJ21MD_011),
	PINMUX_DATA(IRQ1_PJ_MARK, PJ21MD_100),
	PINMUX_DATA(CTX2_MARK, PJ21MD_101),

	PINMUX_DATA(PJ20_DATA, PJ20MD_000),
	PINMUX_DATA(DV_DATA20_MARK, PJ20MD_001),
	PINMUX_DATA(LCD_DATA20_PJ20_MARK, PJ20MD_010),
	PINMUX_DATA(LCD_TCON3_MARK, PJ20MD_011),
	PINMUX_DATA(IRQ0_PJ_MARK, PJ20MD_100),
	PINMUX_DATA(CRX2_MARK, PJ20MD_101),
	PINMUX_DATA(CRX0CRX1CRX2_PJ20_MARK, PJ20MD_110),

	PINMUX_DATA(PJ19_DATA, PJ19MD_000),
	PINMUX_DATA(DV_DATA19_MARK, PJ19MD_001),
	PINMUX_DATA(LCD_DATA19_PJ19_MARK, PJ19MD_010),
	PINMUX_DATA(MISO0_PJ19_MARK, PJ19MD_011),
	PINMUX_DATA(TIOC0D_MARK, PJ19MD_100),
	PINMUX_DATA(SIOFRXD_MARK, PJ19MD_101),
	PINMUX_DATA(AUDIO_XOUT_MARK, PJ19MD_110),

	PINMUX_DATA(PJ18_DATA, PJ18MD_000),
	PINMUX_DATA(DV_DATA18_MARK, PJ18MD_001),
	PINMUX_DATA(LCD_DATA18_PJ18_MARK, PJ18MD_010),
	PINMUX_DATA(MOSI0_PJ18_MARK, PJ18MD_011),
	PINMUX_DATA(TIOC0C_MARK, PJ18MD_100),
	PINMUX_DATA(SIOFTXD_MARK, PJ18MD_101),

	PINMUX_DATA(PJ17_DATA, PJ17MD_000),
	PINMUX_DATA(DV_DATA17_MARK, PJ17MD_001),
	PINMUX_DATA(LCD_DATA17_PJ17_MARK, PJ17MD_010),
	PINMUX_DATA(SSL00_PJ17_MARK, PJ17MD_011),
	PINMUX_DATA(TIOC0B_MARK, PJ17MD_100),
	PINMUX_DATA(SIOFSYNC_MARK, PJ17MD_101),

	PINMUX_DATA(PJ16_DATA, PJ16MD_000),
	PINMUX_DATA(DV_DATA16_MARK, PJ16MD_001),
	PINMUX_DATA(LCD_DATA16_PJ16_MARK, PJ16MD_010),
	PINMUX_DATA(RSPCK0_PJ16_MARK, PJ16MD_011),
	PINMUX_DATA(TIOC0A_MARK, PJ16MD_100),
	PINMUX_DATA(SIOFSCK_MARK, PJ16MD_101),

	PINMUX_DATA(PJ15_DATA, PJ15MD_000),
	PINMUX_DATA(DV_DATA15_MARK, PJ15MD_001),
	PINMUX_DATA(LCD_DATA15_PJ15_MARK, PJ15MD_010),
	PINMUX_DATA(PINT7_PJ_MARK, PJ15MD_011),
	PINMUX_DATA(PWM2H_MARK, PJ15MD_100),
	PINMUX_DATA(TXD7_MARK, PJ15MD_101),

	PINMUX_DATA(PJ14_DATA, PJ14MD_000),
	PINMUX_DATA(DV_DATA14_MARK, PJ14MD_001),
	PINMUX_DATA(LCD_DATA14_PJ14_MARK, PJ14MD_010),
	PINMUX_DATA(PINT6_PJ_MARK, PJ14MD_011),
	PINMUX_DATA(PWM2G_MARK, PJ14MD_100),
	PINMUX_DATA(TXD6_MARK, PJ14MD_101),

	PINMUX_DATA(PJ13_DATA, PJ13MD_000),
	PINMUX_DATA(DV_DATA13_MARK, PJ13MD_001),
	PINMUX_DATA(LCD_DATA13_PJ13_MARK, PJ13MD_010),
	PINMUX_DATA(PINT5_PJ_MARK, PJ13MD_011),
	PINMUX_DATA(PWM2F_MARK, PJ13MD_100),
	PINMUX_DATA(TXD5_MARK, PJ13MD_101),

	PINMUX_DATA(PJ12_DATA, PJ12MD_000),
	PINMUX_DATA(DV_DATA12_MARK, PJ12MD_001),
	PINMUX_DATA(LCD_DATA12_PJ12_MARK, PJ12MD_010),
	PINMUX_DATA(PINT4_PJ_MARK, PJ12MD_011),
	PINMUX_DATA(PWM2E_MARK, PJ12MD_100),
	PINMUX_DATA(SCK7_MARK, PJ12MD_101),

	PINMUX_DATA(PJ11_DATA, PJ11MD_000),
	PINMUX_DATA(DV_DATA11_MARK, PJ11MD_001),
	PINMUX_DATA(LCD_DATA11_PJ11_MARK, PJ11MD_010),
	PINMUX_DATA(PINT3_PJ_MARK, PJ11MD_011),
	PINMUX_DATA(PWM2D_MARK, PJ11MD_100),
	PINMUX_DATA(SCK6_MARK, PJ11MD_101),

	PINMUX_DATA(PJ10_DATA, PJ10MD_000),
	PINMUX_DATA(DV_DATA10_MARK, PJ10MD_001),
	PINMUX_DATA(LCD_DATA10_PJ10_MARK, PJ10MD_010),
	PINMUX_DATA(PINT2_PJ_MARK, PJ10MD_011),
	PINMUX_DATA(PWM2C_MARK, PJ10MD_100),
	PINMUX_DATA(SCK5_MARK, PJ10MD_101),

	PINMUX_DATA(PJ9_DATA, PJ9MD_000),
	PINMUX_DATA(DV_DATA9_MARK, PJ9MD_001),
	PINMUX_DATA(LCD_DATA9_PJ9_MARK, PJ9MD_010),
	PINMUX_DATA(PINT1_PJ_MARK, PJ9MD_011),
	PINMUX_DATA(PWM2B_MARK, PJ9MD_100),
	PINMUX_DATA(RTS5_MARK, PJ9MD_101),

	PINMUX_DATA(PJ8_DATA, PJ8MD_000),
	PINMUX_DATA(DV_DATA8_MARK, PJ8MD_001),
	PINMUX_DATA(LCD_DATA8_PJ8_MARK, PJ8MD_010),
	PINMUX_DATA(PINT0_PJ_MARK, PJ8MD_011),
	PINMUX_DATA(PWM2A_MARK, PJ8MD_100),
	PINMUX_DATA(CTS5_MARK, PJ8MD_101),

	PINMUX_DATA(PJ7_DATA, PJ7MD_000),
	PINMUX_DATA(DV_DATA7_MARK, PJ7MD_001),
	PINMUX_DATA(LCD_DATA7_PJ7_MARK, PJ7MD_010),
	PINMUX_DATA(SD_D2_MARK, PJ7MD_011),
	PINMUX_DATA(PWM1H_MARK, PJ7MD_100),

	PINMUX_DATA(PJ6_DATA, PJ6MD_000),
	PINMUX_DATA(DV_DATA6_MARK, PJ6MD_001),
	PINMUX_DATA(LCD_DATA6_PJ6_MARK, PJ6MD_010),
	PINMUX_DATA(SD_D3_MARK, PJ6MD_011),
	PINMUX_DATA(PWM1G_MARK, PJ6MD_100),

	PINMUX_DATA(PJ5_DATA, PJ5MD_000),
	PINMUX_DATA(DV_DATA5_MARK, PJ5MD_001),
	PINMUX_DATA(LCD_DATA5_PJ5_MARK, PJ5MD_010),
	PINMUX_DATA(SD_CMD_MARK, PJ5MD_011),
	PINMUX_DATA(PWM1F_MARK, PJ5MD_100),

	PINMUX_DATA(PJ4_DATA, PJ4MD_000),
	PINMUX_DATA(DV_DATA4_MARK, PJ4MD_001),
	PINMUX_DATA(LCD_DATA4_PJ4_MARK, PJ4MD_010),
	PINMUX_DATA(SD_CLK_MARK, PJ4MD_011),
	PINMUX_DATA(PWM1E_MARK, PJ4MD_100),

	PINMUX_DATA(PJ3_DATA, PJ3MD_000),
	PINMUX_DATA(DV_DATA3_MARK, PJ3MD_001),
	PINMUX_DATA(LCD_DATA3_PJ3_MARK, PJ3MD_010),
	PINMUX_DATA(SD_D0_MARK, PJ3MD_011),
	PINMUX_DATA(PWM1D_MARK, PJ3MD_100),

	PINMUX_DATA(PJ2_DATA, PJ2MD_000),
	PINMUX_DATA(DV_DATA2_MARK, PJ2MD_001),
	PINMUX_DATA(LCD_DATA2_PJ2_MARK, PJ2MD_010),
	PINMUX_DATA(SD_D1_MARK, PJ2MD_011),
	PINMUX_DATA(PWM1C_MARK, PJ2MD_100),

	PINMUX_DATA(PJ1_DATA, PJ1MD_000),
	PINMUX_DATA(DV_DATA1_MARK, PJ1MD_001),
	PINMUX_DATA(LCD_DATA1_PJ1_MARK, PJ1MD_010),
	PINMUX_DATA(SD_WP_MARK, PJ1MD_011),
	PINMUX_DATA(PWM1B_MARK, PJ1MD_100),

	PINMUX_DATA(PJ0_DATA, PJ0MD_000),
	PINMUX_DATA(DV_DATA0_MARK, PJ0MD_001),
	PINMUX_DATA(LCD_DATA0_PJ0_MARK, PJ0MD_010),
	PINMUX_DATA(SD_CD_MARK, PJ0MD_011),
	PINMUX_DATA(PWM1A_MARK, PJ0MD_100),
};

static struct pinmux_gpio pinmux_gpios[] = {
	/* Port A */
	PINMUX_GPIO(GPIO_PA1, PA1_DATA),
	PINMUX_GPIO(GPIO_PA0, PA0_DATA),

	/* Port B */
	PINMUX_GPIO(GPIO_PB22, PB22_DATA),
	PINMUX_GPIO(GPIO_PB21, PB21_DATA),
	PINMUX_GPIO(GPIO_PB20, PB20_DATA),
	PINMUX_GPIO(GPIO_PB19, PB19_DATA),
	PINMUX_GPIO(GPIO_PB18, PB18_DATA),
	PINMUX_GPIO(GPIO_PB17, PB17_DATA),
	PINMUX_GPIO(GPIO_PB16, PB16_DATA),
	PINMUX_GPIO(GPIO_PB15, PB15_DATA),
	PINMUX_GPIO(GPIO_PB14, PB14_DATA),
	PINMUX_GPIO(GPIO_PB13, PB13_DATA),
	PINMUX_GPIO(GPIO_PB12, PB12_DATA),
	PINMUX_GPIO(GPIO_PB11, PB11_DATA),
	PINMUX_GPIO(GPIO_PB10, PB10_DATA),
	PINMUX_GPIO(GPIO_PB9, PB9_DATA),
	PINMUX_GPIO(GPIO_PB8, PB8_DATA),
	PINMUX_GPIO(GPIO_PB7, PB7_DATA),
	PINMUX_GPIO(GPIO_PB6, PB6_DATA),
	PINMUX_GPIO(GPIO_PB5, PB5_DATA),
	PINMUX_GPIO(GPIO_PB4, PB4_DATA),
	PINMUX_GPIO(GPIO_PB3, PB3_DATA),
	PINMUX_GPIO(GPIO_PB2, PB2_DATA),
	PINMUX_GPIO(GPIO_PB1, PB1_DATA),

	/* Port C */
	PINMUX_GPIO(GPIO_PC8, PC8_DATA),
	PINMUX_GPIO(GPIO_PC7, PC7_DATA),
	PINMUX_GPIO(GPIO_PC6, PC6_DATA),
	PINMUX_GPIO(GPIO_PC5, PC5_DATA),
	PINMUX_GPIO(GPIO_PC4, PC4_DATA),
	PINMUX_GPIO(GPIO_PC3, PC3_DATA),
	PINMUX_GPIO(GPIO_PC2, PC2_DATA),
	PINMUX_GPIO(GPIO_PC1, PC1_DATA),
	PINMUX_GPIO(GPIO_PC0, PC0_DATA),

	/* Port D */
	PINMUX_GPIO(GPIO_PD15, PD15_DATA),
	PINMUX_GPIO(GPIO_PD14, PD14_DATA),
	PINMUX_GPIO(GPIO_PD13, PD13_DATA),
	PINMUX_GPIO(GPIO_PD12, PD12_DATA),
	PINMUX_GPIO(GPIO_PD11, PD11_DATA),
	PINMUX_GPIO(GPIO_PD10, PD10_DATA),
	PINMUX_GPIO(GPIO_PD9, PD9_DATA),
	PINMUX_GPIO(GPIO_PD8, PD8_DATA),
	PINMUX_GPIO(GPIO_PD7, PD7_DATA),
	PINMUX_GPIO(GPIO_PD6, PD6_DATA),
	PINMUX_GPIO(GPIO_PD5, PD5_DATA),
	PINMUX_GPIO(GPIO_PD4, PD4_DATA),
	PINMUX_GPIO(GPIO_PD3, PD3_DATA),
	PINMUX_GPIO(GPIO_PD2, PD2_DATA),
	PINMUX_GPIO(GPIO_PD1, PD1_DATA),
	PINMUX_GPIO(GPIO_PD0, PD0_DATA),

	/* Port E */
	PINMUX_GPIO(GPIO_PE7, PE7_DATA),
	PINMUX_GPIO(GPIO_PE6, PE6_DATA),
	PINMUX_GPIO(GPIO_PE5, PE5_DATA),
	PINMUX_GPIO(GPIO_PE4, PE4_DATA),
	PINMUX_GPIO(GPIO_PE3, PE3_DATA),
	PINMUX_GPIO(GPIO_PE2, PE2_DATA),
	PINMUX_GPIO(GPIO_PE1, PE1_DATA),
	PINMUX_GPIO(GPIO_PE0, PE0_DATA),

	/* Port F */
	PINMUX_GPIO(GPIO_PF23, PF23_DATA),
	PINMUX_GPIO(GPIO_PF22, PF22_DATA),
	PINMUX_GPIO(GPIO_PF21, PF21_DATA),
	PINMUX_GPIO(GPIO_PF20, PF20_DATA),
	PINMUX_GPIO(GPIO_PF19, PF19_DATA),
	PINMUX_GPIO(GPIO_PF18, PF18_DATA),
	PINMUX_GPIO(GPIO_PF17, PF17_DATA),
	PINMUX_GPIO(GPIO_PF16, PF16_DATA),
	PINMUX_GPIO(GPIO_PF15, PF15_DATA),
	PINMUX_GPIO(GPIO_PF14, PF14_DATA),
	PINMUX_GPIO(GPIO_PF13, PF13_DATA),
	PINMUX_GPIO(GPIO_PF12, PF12_DATA),
	PINMUX_GPIO(GPIO_PF11, PF11_DATA),
	PINMUX_GPIO(GPIO_PF10, PF10_DATA),
	PINMUX_GPIO(GPIO_PF9, PF9_DATA),
	PINMUX_GPIO(GPIO_PF8, PF8_DATA),
	PINMUX_GPIO(GPIO_PF7, PF7_DATA),
	PINMUX_GPIO(GPIO_PF6, PF6_DATA),
	PINMUX_GPIO(GPIO_PF5, PF5_DATA),
	PINMUX_GPIO(GPIO_PF4, PF4_DATA),
	PINMUX_GPIO(GPIO_PF3, PF3_DATA),
	PINMUX_GPIO(GPIO_PF2, PF2_DATA),
	PINMUX_GPIO(GPIO_PF1, PF1_DATA),
	PINMUX_GPIO(GPIO_PF0, PF0_DATA),

	/* Port G */
	PINMUX_GPIO(GPIO_PG27, PG27_DATA),
	PINMUX_GPIO(GPIO_PG26, PG26_DATA),
	PINMUX_GPIO(GPIO_PG25, PG25_DATA),
	PINMUX_GPIO(GPIO_PG24, PG24_DATA),
	PINMUX_GPIO(GPIO_PG23, PG23_DATA),
	PINMUX_GPIO(GPIO_PG22, PG22_DATA),
	PINMUX_GPIO(GPIO_PG21, PG21_DATA),
	PINMUX_GPIO(GPIO_PG20, PG20_DATA),
	PINMUX_GPIO(GPIO_PG19, PG19_DATA),
	PINMUX_GPIO(GPIO_PG18, PG18_DATA),
	PINMUX_GPIO(GPIO_PG17, PG17_DATA),
	PINMUX_GPIO(GPIO_PG16, PG16_DATA),
	PINMUX_GPIO(GPIO_PG15, PG15_DATA),
	PINMUX_GPIO(GPIO_PG14, PG14_DATA),
	PINMUX_GPIO(GPIO_PG13, PG13_DATA),
	PINMUX_GPIO(GPIO_PG12, PG12_DATA),
	PINMUX_GPIO(GPIO_PG11, PG11_DATA),
	PINMUX_GPIO(GPIO_PG10, PG10_DATA),
	PINMUX_GPIO(GPIO_PG9, PG9_DATA),
	PINMUX_GPIO(GPIO_PG8, PG8_DATA),
	PINMUX_GPIO(GPIO_PG7, PG7_DATA),
	PINMUX_GPIO(GPIO_PG6, PG6_DATA),
	PINMUX_GPIO(GPIO_PG5, PG5_DATA),
	PINMUX_GPIO(GPIO_PG4, PG4_DATA),
	PINMUX_GPIO(GPIO_PG3, PG3_DATA),
	PINMUX_GPIO(GPIO_PG2, PG2_DATA),
	PINMUX_GPIO(GPIO_PG1, PG1_DATA),
	PINMUX_GPIO(GPIO_PG0, PG0_DATA),

	/* Port H - Port H does not have a Data Register */

	/* Port I - not on device */

	/* Port J */
	PINMUX_GPIO(GPIO_PJ31, PJ31_DATA),
	PINMUX_GPIO(GPIO_PJ30, PJ30_DATA),
	PINMUX_GPIO(GPIO_PJ29, PJ29_DATA),
	PINMUX_GPIO(GPIO_PJ28, PJ28_DATA),
	PINMUX_GPIO(GPIO_PJ27, PJ27_DATA),
	PINMUX_GPIO(GPIO_PJ26, PJ26_DATA),
	PINMUX_GPIO(GPIO_PJ25, PJ25_DATA),
	PINMUX_GPIO(GPIO_PJ24, PJ24_DATA),
	PINMUX_GPIO(GPIO_PJ23, PJ23_DATA),
	PINMUX_GPIO(GPIO_PJ22, PJ22_DATA),
	PINMUX_GPIO(GPIO_PJ21, PJ21_DATA),
	PINMUX_GPIO(GPIO_PJ20, PJ20_DATA),
	PINMUX_GPIO(GPIO_PJ19, PJ19_DATA),
	PINMUX_GPIO(GPIO_PJ18, PJ18_DATA),
	PINMUX_GPIO(GPIO_PJ17, PJ17_DATA),
	PINMUX_GPIO(GPIO_PJ16, PJ16_DATA),
	PINMUX_GPIO(GPIO_PJ15, PJ15_DATA),
	PINMUX_GPIO(GPIO_PJ14, PJ14_DATA),
	PINMUX_GPIO(GPIO_PJ13, PJ13_DATA),
	PINMUX_GPIO(GPIO_PJ12, PJ12_DATA),
	PINMUX_GPIO(GPIO_PJ11, PJ11_DATA),
	PINMUX_GPIO(GPIO_PJ10, PJ10_DATA),
	PINMUX_GPIO(GPIO_PJ9, PJ9_DATA),
	PINMUX_GPIO(GPIO_PJ8, PJ8_DATA),
	PINMUX_GPIO(GPIO_PJ7, PJ7_DATA),
	PINMUX_GPIO(GPIO_PJ6, PJ6_DATA),
	PINMUX_GPIO(GPIO_PJ5, PJ5_DATA),
	PINMUX_GPIO(GPIO_PJ4, PJ4_DATA),
	PINMUX_GPIO(GPIO_PJ3, PJ3_DATA),
	PINMUX_GPIO(GPIO_PJ2, PJ2_DATA),
	PINMUX_GPIO(GPIO_PJ1, PJ1_DATA),
	PINMUX_GPIO(GPIO_PJ0, PJ0_DATA),

	/* INTC */
	PINMUX_GPIO(GPIO_FN_IRQ7_PG, IRQ7_PG_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ6_PG, IRQ6_PG_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ5_PG, IRQ5_PG_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ4_PG, IRQ4_PG_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ3_PG, IRQ3_PG_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ2_PG, IRQ2_PG_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ1_PG, IRQ1_PG_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ0_PG, IRQ0_PG_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ7_PF, IRQ7_PF_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ6_PF, IRQ6_PF_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ5_PF, IRQ5_PF_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ4_PF, IRQ4_PF_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ3_PJ, IRQ3_PJ_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ2_PJ, IRQ2_PJ_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ1_PJ, IRQ1_PJ_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ0_PJ, IRQ0_PJ_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ1_PC, IRQ1_PC_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ0_PC, IRQ0_PC_MARK),

	PINMUX_GPIO(GPIO_FN_PINT7_PG, PINT7_PG_MARK),
	PINMUX_GPIO(GPIO_FN_PINT6_PG, PINT6_PG_MARK),
	PINMUX_GPIO(GPIO_FN_PINT5_PG, PINT5_PG_MARK),
	PINMUX_GPIO(GPIO_FN_PINT4_PG, PINT4_PG_MARK),
	PINMUX_GPIO(GPIO_FN_PINT3_PG, PINT3_PG_MARK),
	PINMUX_GPIO(GPIO_FN_PINT2_PG, PINT2_PG_MARK),
	PINMUX_GPIO(GPIO_FN_PINT1_PG, PINT1_PG_MARK),
	PINMUX_GPIO(GPIO_FN_PINT0_PG, PINT0_PG_MARK),
	PINMUX_GPIO(GPIO_FN_PINT7_PH, PINT7_PH_MARK),
	PINMUX_GPIO(GPIO_FN_PINT6_PH, PINT6_PH_MARK),
	PINMUX_GPIO(GPIO_FN_PINT5_PH, PINT5_PH_MARK),
	PINMUX_GPIO(GPIO_FN_PINT4_PH, PINT4_PH_MARK),
	PINMUX_GPIO(GPIO_FN_PINT3_PH, PINT3_PH_MARK),
	PINMUX_GPIO(GPIO_FN_PINT2_PH, PINT2_PH_MARK),
	PINMUX_GPIO(GPIO_FN_PINT1_PH, PINT1_PH_MARK),
	PINMUX_GPIO(GPIO_FN_PINT0_PH, PINT0_PH_MARK),
	PINMUX_GPIO(GPIO_FN_PINT7_PJ, PINT7_PJ_MARK),
	PINMUX_GPIO(GPIO_FN_PINT6_PJ, PINT6_PJ_MARK),
	PINMUX_GPIO(GPIO_FN_PINT5_PJ, PINT5_PJ_MARK),
	PINMUX_GPIO(GPIO_FN_PINT4_PJ, PINT4_PJ_MARK),
	PINMUX_GPIO(GPIO_FN_PINT3_PJ, PINT3_PJ_MARK),
	PINMUX_GPIO(GPIO_FN_PINT2_PJ, PINT2_PJ_MARK),
	PINMUX_GPIO(GPIO_FN_PINT1_PJ, PINT1_PJ_MARK),
	PINMUX_GPIO(GPIO_FN_PINT0_PJ, PINT0_PJ_MARK),

	/* WDT */
	PINMUX_GPIO(GPIO_FN_WDTOVF, WDTOVF_MARK),

	/* CAN */
	PINMUX_GPIO(GPIO_FN_CTX1, CTX1_MARK),
	PINMUX_GPIO(GPIO_FN_CRX1, CRX1_MARK),
	PINMUX_GPIO(GPIO_FN_CTX0, CTX0_MARK),
	PINMUX_GPIO(GPIO_FN_CRX0, CRX0_MARK),
	PINMUX_GPIO(GPIO_FN_CRX0_CRX1, CRX0CRX1_MARK),
	PINMUX_GPIO(GPIO_FN_CRX0_CRX1_CRX2, CRX0CRX1CRX2_MARK),

	/* DMAC */
	PINMUX_GPIO(GPIO_FN_TEND0, TEND0_MARK),
	PINMUX_GPIO(GPIO_FN_DACK0, DACK0_MARK),
	PINMUX_GPIO(GPIO_FN_DREQ0, DREQ0_MARK),
	PINMUX_GPIO(GPIO_FN_TEND1, TEND1_MARK),
	PINMUX_GPIO(GPIO_FN_DACK1, DACK1_MARK),
	PINMUX_GPIO(GPIO_FN_DREQ1, DREQ1_MARK),

	/* ADC */
	PINMUX_GPIO(GPIO_FN_ADTRG, ADTRG_MARK),

	/* BSCh */
	PINMUX_GPIO(GPIO_FN_A25, A25_MARK),
	PINMUX_GPIO(GPIO_FN_A24, A24_MARK),
	PINMUX_GPIO(GPIO_FN_A23, A23_MARK),
	PINMUX_GPIO(GPIO_FN_A22, A22_MARK),
	PINMUX_GPIO(GPIO_FN_A21, A21_MARK),
	PINMUX_GPIO(GPIO_FN_A20, A20_MARK),
	PINMUX_GPIO(GPIO_FN_A19, A19_MARK),
	PINMUX_GPIO(GPIO_FN_A18, A18_MARK),
	PINMUX_GPIO(GPIO_FN_A17, A17_MARK),
	PINMUX_GPIO(GPIO_FN_A16, A16_MARK),
	PINMUX_GPIO(GPIO_FN_A15, A15_MARK),
	PINMUX_GPIO(GPIO_FN_A14, A14_MARK),
	PINMUX_GPIO(GPIO_FN_A13, A13_MARK),
	PINMUX_GPIO(GPIO_FN_A12, A12_MARK),
	PINMUX_GPIO(GPIO_FN_A11, A11_MARK),
	PINMUX_GPIO(GPIO_FN_A10, A10_MARK),
	PINMUX_GPIO(GPIO_FN_A9, A9_MARK),
	PINMUX_GPIO(GPIO_FN_A8, A8_MARK),
	PINMUX_GPIO(GPIO_FN_A7, A7_MARK),
	PINMUX_GPIO(GPIO_FN_A6, A6_MARK),
	PINMUX_GPIO(GPIO_FN_A5, A5_MARK),
	PINMUX_GPIO(GPIO_FN_A4, A4_MARK),
	PINMUX_GPIO(GPIO_FN_A3, A3_MARK),
	PINMUX_GPIO(GPIO_FN_A2, A2_MARK),
	PINMUX_GPIO(GPIO_FN_A1, A1_MARK),
	PINMUX_GPIO(GPIO_FN_A0, A0_MARK),

	PINMUX_GPIO(GPIO_FN_D15, D15_MARK),
	PINMUX_GPIO(GPIO_FN_D14, D14_MARK),
	PINMUX_GPIO(GPIO_FN_D13, D13_MARK),
	PINMUX_GPIO(GPIO_FN_D12, D12_MARK),
	PINMUX_GPIO(GPIO_FN_D11, D11_MARK),
	PINMUX_GPIO(GPIO_FN_D10, D10_MARK),
	PINMUX_GPIO(GPIO_FN_D9, D9_MARK),
	PINMUX_GPIO(GPIO_FN_D8, D8_MARK),
	PINMUX_GPIO(GPIO_FN_D7, D7_MARK),
	PINMUX_GPIO(GPIO_FN_D6, D6_MARK),
	PINMUX_GPIO(GPIO_FN_D5, D5_MARK),
	PINMUX_GPIO(GPIO_FN_D4, D4_MARK),
	PINMUX_GPIO(GPIO_FN_D3, D3_MARK),
	PINMUX_GPIO(GPIO_FN_D2, D2_MARK),
	PINMUX_GPIO(GPIO_FN_D1, D1_MARK),
	PINMUX_GPIO(GPIO_FN_D0, D0_MARK),

	PINMUX_GPIO(GPIO_FN_BS, BS_MARK),
	PINMUX_GPIO(GPIO_FN_CS4, CS4_MARK),
	PINMUX_GPIO(GPIO_FN_CS3, CS3_MARK),
	PINMUX_GPIO(GPIO_FN_CS2, CS2_MARK),
	PINMUX_GPIO(GPIO_FN_CS1, CS1_MARK),
	PINMUX_GPIO(GPIO_FN_CS0, CS0_MARK),
	PINMUX_GPIO(GPIO_FN_CS5CE1A, CS5CE1A_MARK),
	PINMUX_GPIO(GPIO_FN_CE2A, CE2A_MARK),
	PINMUX_GPIO(GPIO_FN_CE2B, CE2B_MARK),
	PINMUX_GPIO(GPIO_FN_RD, RD_MARK),
	PINMUX_GPIO(GPIO_FN_RDWR, RDWR_MARK),
	PINMUX_GPIO(GPIO_FN_WE3ICIOWRAHDQMUU, WE3ICIOWRAHDQMUU_MARK),
	PINMUX_GPIO(GPIO_FN_WE2ICIORDDQMUL, WE2ICIORDDQMUL_MARK),
	PINMUX_GPIO(GPIO_FN_WE1DQMUWE, WE1DQMUWE_MARK),
	PINMUX_GPIO(GPIO_FN_WE0DQML, WE0DQML_MARK),
	PINMUX_GPIO(GPIO_FN_RAS, RAS_MARK),
	PINMUX_GPIO(GPIO_FN_CAS, CAS_MARK),
	PINMUX_GPIO(GPIO_FN_CKE, CKE_MARK),
	PINMUX_GPIO(GPIO_FN_WAIT, WAIT_MARK),
	PINMUX_GPIO(GPIO_FN_BREQ, BREQ_MARK),
	PINMUX_GPIO(GPIO_FN_BACK, BACK_MARK),
	PINMUX_GPIO(GPIO_FN_IOIS16, IOIS16_MARK),

	/* TMU */
	PINMUX_GPIO(GPIO_FN_TIOC4D, TIOC4D_MARK),
	PINMUX_GPIO(GPIO_FN_TIOC4C, TIOC4C_MARK),
	PINMUX_GPIO(GPIO_FN_TIOC4B, TIOC4B_MARK),
	PINMUX_GPIO(GPIO_FN_TIOC4A, TIOC4A_MARK),
	PINMUX_GPIO(GPIO_FN_TIOC3D, TIOC3D_MARK),
	PINMUX_GPIO(GPIO_FN_TIOC3C, TIOC3C_MARK),
	PINMUX_GPIO(GPIO_FN_TIOC3B, TIOC3B_MARK),
	PINMUX_GPIO(GPIO_FN_TIOC3A, TIOC3A_MARK),
	PINMUX_GPIO(GPIO_FN_TIOC2B, TIOC2B_MARK),
	PINMUX_GPIO(GPIO_FN_TIOC1B, TIOC1B_MARK),
	PINMUX_GPIO(GPIO_FN_TIOC2A, TIOC2A_MARK),
	PINMUX_GPIO(GPIO_FN_TIOC1A, TIOC1A_MARK),
	PINMUX_GPIO(GPIO_FN_TIOC0D, TIOC0D_MARK),
	PINMUX_GPIO(GPIO_FN_TIOC0C, TIOC0C_MARK),
	PINMUX_GPIO(GPIO_FN_TIOC0B, TIOC0B_MARK),
	PINMUX_GPIO(GPIO_FN_TIOC0A, TIOC0A_MARK),
	PINMUX_GPIO(GPIO_FN_TCLKD, TCLKD_MARK),
	PINMUX_GPIO(GPIO_FN_TCLKC, TCLKC_MARK),
	PINMUX_GPIO(GPIO_FN_TCLKB, TCLKB_MARK),
	PINMUX_GPIO(GPIO_FN_TCLKA, TCLKA_MARK),

	/* SCIF */
	PINMUX_GPIO(GPIO_FN_SCK0, SCK0_MARK),
	PINMUX_GPIO(GPIO_FN_TXD0, TXD0_MARK),
	PINMUX_GPIO(GPIO_FN_RXD0, RXD0_MARK),
	PINMUX_GPIO(GPIO_FN_SCK1, SCK1_MARK),
	PINMUX_GPIO(GPIO_FN_TXD1, TXD1_MARK),
	PINMUX_GPIO(GPIO_FN_RXD1, RXD1_MARK),
	PINMUX_GPIO(GPIO_FN_RTS1, RTS1_MARK),
	PINMUX_GPIO(GPIO_FN_CTS1, CTS1_MARK),
	PINMUX_GPIO(GPIO_FN_SCK2, SCK2_MARK),
	PINMUX_GPIO(GPIO_FN_TXD2, TXD2_MARK),
	PINMUX_GPIO(GPIO_FN_RXD2, RXD2_MARK),
	PINMUX_GPIO(GPIO_FN_SCK3, SCK3_MARK),
	PINMUX_GPIO(GPIO_FN_TXD3, TXD3_MARK),
	PINMUX_GPIO(GPIO_FN_RXD3, RXD3_MARK),
	PINMUX_GPIO(GPIO_FN_SCK4, SCK4_MARK),
	PINMUX_GPIO(GPIO_FN_TXD4, TXD4_MARK),
	PINMUX_GPIO(GPIO_FN_RXD4, RXD4_MARK),
	PINMUX_GPIO(GPIO_FN_SCK5, SCK5_MARK),
	PINMUX_GPIO(GPIO_FN_TXD5, TXD5_MARK),
	PINMUX_GPIO(GPIO_FN_RXD5, RXD5_MARK),
	PINMUX_GPIO(GPIO_FN_RTS5, RTS5_MARK),
	PINMUX_GPIO(GPIO_FN_CTS5, CTS5_MARK),
	PINMUX_GPIO(GPIO_FN_SCK6, SCK6_MARK),
	PINMUX_GPIO(GPIO_FN_TXD6, TXD6_MARK),
	PINMUX_GPIO(GPIO_FN_RXD6, RXD6_MARK),
	PINMUX_GPIO(GPIO_FN_SCK7, SCK7_MARK),
	PINMUX_GPIO(GPIO_FN_TXD7, TXD7_MARK),
	PINMUX_GPIO(GPIO_FN_RXD7, RXD7_MARK),
	PINMUX_GPIO(GPIO_FN_RTS7, RTS7_MARK),
	PINMUX_GPIO(GPIO_FN_CTS7, CTS7_MARK),

	/* RSPI */
	PINMUX_GPIO(GPIO_FN_RSPCK0_PJ16, RSPCK0_PJ16_MARK),
	PINMUX_GPIO(GPIO_FN_SSL00_PJ17, SSL00_PJ17_MARK),
	PINMUX_GPIO(GPIO_FN_MOSI0_PJ18, MOSI0_PJ18_MARK),
	PINMUX_GPIO(GPIO_FN_MISO0_PJ19, MISO0_PJ19_MARK),
	PINMUX_GPIO(GPIO_FN_RSPCK0_PB17, RSPCK0_PB17_MARK),
	PINMUX_GPIO(GPIO_FN_SSL00_PB18, SSL00_PB18_MARK),
	PINMUX_GPIO(GPIO_FN_MOSI0_PB19, MOSI0_PB19_MARK),
	PINMUX_GPIO(GPIO_FN_MISO0_PB20, MISO0_PB20_MARK),
	PINMUX_GPIO(GPIO_FN_RSPCK1, RSPCK1_MARK),
	PINMUX_GPIO(GPIO_FN_MOSI1, MOSI1_MARK),
	PINMUX_GPIO(GPIO_FN_MISO1, MISO1_MARK),
	PINMUX_GPIO(GPIO_FN_SSL10, SSL10_MARK),

	/* IIC3 */
	PINMUX_GPIO(GPIO_FN_SCL0, SCL0_MARK),
	PINMUX_GPIO(GPIO_FN_SCL1, SCL1_MARK),
	PINMUX_GPIO(GPIO_FN_SCL2, SCL2_MARK),
	PINMUX_GPIO(GPIO_FN_SDA0, SDA0_MARK),
	PINMUX_GPIO(GPIO_FN_SDA1, SDA1_MARK),
	PINMUX_GPIO(GPIO_FN_SDA2, SDA2_MARK),

	/* SSI */
	PINMUX_GPIO(GPIO_FN_SSISCK0, SSISCK0_MARK),
	PINMUX_GPIO(GPIO_FN_SSIWS0, SSIWS0_MARK),
	PINMUX_GPIO(GPIO_FN_SSITXD0, SSITXD0_MARK),
	PINMUX_GPIO(GPIO_FN_SSIRXD0, SSIRXD0_MARK),
	PINMUX_GPIO(GPIO_FN_SSIWS1, SSIWS1_MARK),
	PINMUX_GPIO(GPIO_FN_SSIWS2, SSIWS2_MARK),
	PINMUX_GPIO(GPIO_FN_SSIWS3, SSIWS3_MARK),
	PINMUX_GPIO(GPIO_FN_SSISCK1, SSISCK1_MARK),
	PINMUX_GPIO(GPIO_FN_SSISCK2, SSISCK2_MARK),
	PINMUX_GPIO(GPIO_FN_SSISCK3, SSISCK3_MARK),
	PINMUX_GPIO(GPIO_FN_SSIDATA1, SSIDATA1_MARK),
	PINMUX_GPIO(GPIO_FN_SSIDATA2, SSIDATA2_MARK),
	PINMUX_GPIO(GPIO_FN_SSIDATA3, SSIDATA3_MARK),
	PINMUX_GPIO(GPIO_FN_AUDIO_CLK, AUDIO_CLK_MARK),
	PINMUX_GPIO(GPIO_FN_AUDIO_XOUT, AUDIO_XOUT_MARK),

	/* SIOF */ /* NOTE Shares AUDIO_CLK with SSI */
	PINMUX_GPIO(GPIO_FN_SIOFTXD, SIOFTXD_MARK),
	PINMUX_GPIO(GPIO_FN_SIOFRXD, SIOFRXD_MARK),
	PINMUX_GPIO(GPIO_FN_SIOFSYNC, SIOFSYNC_MARK),
	PINMUX_GPIO(GPIO_FN_SIOFSCK, SIOFSCK_MARK),

	/* SPDIF */ /* NOTE Shares AUDIO_CLK with SSI */
	PINMUX_GPIO(GPIO_FN_SPDIF_IN, SPDIF_IN_MARK),
	PINMUX_GPIO(GPIO_FN_SPDIF_OUT, SPDIF_OUT_MARK),

	/* NANDFMC */ /* NOTE Controller is not available in boot mode 0 */
	PINMUX_GPIO(GPIO_FN_FCE, FCE_MARK),
	PINMUX_GPIO(GPIO_FN_FRB, FRB_MARK),

	/* VDC3 */
	PINMUX_GPIO(GPIO_FN_DV_CLK, DV_CLK_MARK),
	PINMUX_GPIO(GPIO_FN_DV_VSYNC, DV_VSYNC_MARK),
	PINMUX_GPIO(GPIO_FN_DV_HSYNC, DV_HSYNC_MARK),

	PINMUX_GPIO(GPIO_FN_DV_DATA23, DV_DATA23_MARK),
	PINMUX_GPIO(GPIO_FN_DV_DATA22, DV_DATA22_MARK),
	PINMUX_GPIO(GPIO_FN_DV_DATA21, DV_DATA21_MARK),
	PINMUX_GPIO(GPIO_FN_DV_DATA20, DV_DATA20_MARK),
	PINMUX_GPIO(GPIO_FN_DV_DATA19, DV_DATA19_MARK),
	PINMUX_GPIO(GPIO_FN_DV_DATA18, DV_DATA18_MARK),
	PINMUX_GPIO(GPIO_FN_DV_DATA17, DV_DATA17_MARK),
	PINMUX_GPIO(GPIO_FN_DV_DATA16, DV_DATA16_MARK),
	PINMUX_GPIO(GPIO_FN_DV_DATA15, DV_DATA15_MARK),
	PINMUX_GPIO(GPIO_FN_DV_DATA14, DV_DATA14_MARK),
	PINMUX_GPIO(GPIO_FN_DV_DATA13, DV_DATA13_MARK),
	PINMUX_GPIO(GPIO_FN_DV_DATA12, DV_DATA12_MARK),
	PINMUX_GPIO(GPIO_FN_DV_DATA11, DV_DATA11_MARK),
	PINMUX_GPIO(GPIO_FN_DV_DATA10, DV_DATA10_MARK),
	PINMUX_GPIO(GPIO_FN_DV_DATA9, DV_DATA9_MARK),
	PINMUX_GPIO(GPIO_FN_DV_DATA8, DV_DATA8_MARK),
	PINMUX_GPIO(GPIO_FN_DV_DATA7, DV_DATA7_MARK),
	PINMUX_GPIO(GPIO_FN_DV_DATA6, DV_DATA6_MARK),
	PINMUX_GPIO(GPIO_FN_DV_DATA5, DV_DATA5_MARK),
	PINMUX_GPIO(GPIO_FN_DV_DATA4, DV_DATA4_MARK),
	PINMUX_GPIO(GPIO_FN_DV_DATA3, DV_DATA3_MARK),
	PINMUX_GPIO(GPIO_FN_DV_DATA2, DV_DATA2_MARK),
	PINMUX_GPIO(GPIO_FN_DV_DATA1, DV_DATA1_MARK),
	PINMUX_GPIO(GPIO_FN_DV_DATA0, DV_DATA0_MARK),

	PINMUX_GPIO(GPIO_FN_LCD_CLK, LCD_CLK_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_EXTCLK, LCD_EXTCLK_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_VSYNC, LCD_VSYNC_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_HSYNC, LCD_HSYNC_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DE, LCD_DE_MARK),

	PINMUX_GPIO(GPIO_FN_LCD_DATA23_PG23, LCD_DATA23_PG23_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA22_PG22, LCD_DATA22_PG22_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA21_PG21, LCD_DATA21_PG21_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA20_PG20, LCD_DATA20_PG20_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA19_PG19, LCD_DATA19_PG19_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA18_PG18, LCD_DATA18_PG18_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA17_PG17, LCD_DATA17_PG17_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA16_PG16, LCD_DATA16_PG16_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA15_PG15, LCD_DATA15_PG15_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA14_PG14, LCD_DATA14_PG14_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA13_PG13, LCD_DATA13_PG13_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA12_PG12, LCD_DATA12_PG12_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA11_PG11, LCD_DATA11_PG11_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA10_PG10, LCD_DATA10_PG10_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA9_PG9, LCD_DATA9_PG9_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA8_PG8, LCD_DATA8_PG8_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA7_PG7, LCD_DATA7_PG7_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA6_PG6, LCD_DATA6_PG6_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA5_PG5, LCD_DATA5_PG5_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA4_PG4, LCD_DATA4_PG4_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA3_PG3, LCD_DATA3_PG3_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA2_PG2, LCD_DATA2_PG2_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA1_PG1, LCD_DATA1_PG1_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA0_PG0, LCD_DATA0_PG0_MARK),

	PINMUX_GPIO(GPIO_FN_LCD_DATA23_PJ23, LCD_DATA23_PJ23_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA22_PJ22, LCD_DATA22_PJ22_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA21_PJ21, LCD_DATA21_PJ21_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA20_PJ20, LCD_DATA20_PJ20_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA19_PJ19, LCD_DATA19_PJ19_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA18_PJ18, LCD_DATA18_PJ18_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA17_PJ17, LCD_DATA17_PJ17_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA16_PJ16, LCD_DATA16_PJ16_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA15_PJ15, LCD_DATA15_PJ15_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA14_PJ14, LCD_DATA14_PJ14_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA13_PJ13, LCD_DATA13_PJ13_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA12_PJ12, LCD_DATA12_PJ12_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA11_PJ11, LCD_DATA11_PJ11_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA10_PJ10, LCD_DATA10_PJ10_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA9_PJ9, LCD_DATA9_PJ9_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA8_PJ8, LCD_DATA8_PJ8_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA7_PJ7, LCD_DATA7_PJ7_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA6_PJ6, LCD_DATA6_PJ6_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA5_PJ5, LCD_DATA5_PJ5_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA4_PJ4, LCD_DATA4_PJ4_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA3_PJ3, LCD_DATA3_PJ3_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA2_PJ2, LCD_DATA2_PJ2_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA1_PJ1, LCD_DATA1_PJ1_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA0_PJ0, LCD_DATA0_PJ0_MARK),

	PINMUX_GPIO(GPIO_FN_LCD_M_DISP, LCD_M_DISP_MARK),
};

static struct pinmux_cfg_reg pinmux_config_regs[] = {
	/* "name" addr register_size Field_Width */

	/* where Field_Width is 1 for single mode registers or 4 for upto 16
	   mode registers and modes are described in assending order [0..16] */

	{ PINMUX_CFG_REG("PAIOR0", 0xfffe3812, 16, 1) {
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, PA1_IN, PA1_OUT,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, PA0_IN, PA0_OUT }
	},
	{ PINMUX_CFG_REG("PBCR5", 0xfffe3824, 16, 4) {
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PB22MD_000, PB22MD_001, PB22MD_010, PB22MD_011,
		PB22MD_100, PB22MD_101, PB22MD_110, PB22MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PB21MD_00, PB21MD_01, PB21MD_10, PB21MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PB20MD_000, PB20MD_001, PB20MD_010, PB20MD_011,
		PB20MD_100, PB20MD_101, PB20MD_110, PB20MD_111,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PBCR4", 0xfffe3826, 16, 4) {
		PB19MD_000, PB19MD_001, PB19MD_010, PB19MD_011,
		PB19MD_100, PB19MD_101, PB19MD_110, PB19MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PB18MD_000, PB18MD_001, PB18MD_010, PB18MD_011,
		PB18MD_100, PB18MD_101, PB18MD_110, PB18MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PB17MD_000, PB17MD_001, PB17MD_010, PB17MD_011,
		PB17MD_100, PB17MD_101, PB17MD_110, PB17MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PB16MD_000, PB16MD_001, PB16MD_010, PB16MD_011,
		PB16MD_100, PB16MD_101, PB16MD_110, PB16MD_111,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PBCR3", 0xfffe3828, 16, 4) {
		PB15MD_000, PB15MD_001, PB15MD_010, PB15MD_011,
		PB15MD_100, PB15MD_101, PB15MD_110, PB15MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PB14MD_000, PB14MD_001, PB14MD_010, PB14MD_011,
		PB14MD_100, PB14MD_101, PB14MD_110, PB14MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PB13MD_000, PB13MD_001, PB13MD_010, PB13MD_011,
		PB13MD_100, PB13MD_101, PB13MD_110, PB13MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PB12MD_00, PB12MD_01, PB12MD_10, PB12MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PBCR2", 0xfffe382a, 16, 4) {
		PB11MD_00, PB11MD_01, PB11MD_10, PB11MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PB10MD_00, PB10MD_01, PB10MD_10, PB10MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PB9MD_00, PB9MD_01, PB9MD_10, PB9MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PB8MD_00, PB8MD_01, PB8MD_10, PB8MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PBCR1", 0xfffe382c, 16, 4) {
		PB7MD_00, PB7MD_01, PB7MD_10, PB7MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PB6MD_00, PB6MD_01, PB6MD_10, PB6MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PB5MD_00, PB5MD_01, PB5MD_10, PB5MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PB4MD_00, PB4MD_01, PB4MD_10, PB4MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PBCR0", 0xfffe382e, 16, 4) {
		PB3MD_00, PB3MD_01, PB3MD_10, PB3MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PB2MD_00, PB2MD_01, PB2MD_10, PB2MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PB1MD_00, PB1MD_01, PB1MD_10, PB1MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
	},

	{ PINMUX_CFG_REG("PBIOR1", 0xfffe3830, 16, 1) {
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0,
		PB22_IN, PB22_OUT,
		PB21_IN, PB21_OUT,
		PB20_IN, PB20_OUT,
		PB19_IN, PB19_OUT,
		PB18_IN, PB18_OUT,
		PB17_IN, PB17_OUT,
		PB16_IN, PB16_OUT }
	},
	{ PINMUX_CFG_REG("PBIOR0", 0xfffe3832, 16, 1) {
		PB15_IN, PB15_OUT,
		PB14_IN, PB14_OUT,
		PB13_IN, PB13_OUT,
		PB12_IN, PB12_OUT,
		PB11_IN, PB11_OUT,
		PB10_IN, PB10_OUT,
		PB9_IN, PB9_OUT,
		PB8_IN, PB8_OUT,
		PB7_IN, PB7_OUT,
		PB6_IN, PB6_OUT,
		PB5_IN, PB5_OUT,
		PB4_IN, PB4_OUT,
		PB3_IN, PB3_OUT,
		PB2_IN, PB2_OUT,
		PB1_IN, PB1_OUT,
		0, 0 }
	},

	{ PINMUX_CFG_REG("PCCR2", 0xfffe384a, 16, 4) {
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PC8MD_000, PC8MD_001, PC8MD_010, PC8MD_011,
		PC8MD_100, PC8MD_101, PC8MD_110, PC8MD_111,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PCCR1", 0xfffe384c, 16, 4) {
		PC7MD_000, PC7MD_001, PC7MD_010, PC7MD_011,
		PC7MD_100, PC7MD_101, PC7MD_110, PC7MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PC6MD_000, PC6MD_001, PC6MD_010, PC6MD_011,
		PC6MD_100, PC6MD_101, PC6MD_110, PC6MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PC5MD_000, PC5MD_001, PC5MD_010, PC5MD_011,
		PC5MD_100, PC5MD_101, PC5MD_110, PC5MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PC4MD_00, PC4MD_01, PC4MD_10, PC4MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PCCR0", 0xfffe384e, 16, 4) {
		PC3MD_00, PC3MD_01, PC3MD_10, PC3MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PC2MD_00, PC2MD_01, PC2MD_10, PC2MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PC1MD_0, PC1MD_1, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PC0MD_0, PC0MD_1, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},

	{ PINMUX_CFG_REG("PCIOR0", 0xfffe3852, 16, 1) {
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		PC8_IN, PC8_OUT,
		PC7_IN, PC7_OUT,
		PC6_IN, PC6_OUT,
		PC5_IN, PC5_OUT,
		PC4_IN, PC4_OUT,
		PC3_IN, PC3_OUT,
		PC2_IN, PC2_OUT,
		PC1_IN, PC1_OUT,
		PC0_IN, PC0_OUT }
	},

	{ PINMUX_CFG_REG("PDCR3", 0xfffe3868, 16, 4) {
		PD15MD_00, PD15MD_01, PD15MD_10, PD15MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PD14MD_00, PD14MD_01, PD14MD_10, PD14MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PD13MD_00, PD13MD_01, PD13MD_10, PD13MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PD12MD_00, PD12MD_01, PD12MD_10, PD12MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PDCR2", 0xfffe386a, 16, 4) {
		PD11MD_00, PD11MD_01, PD11MD_10, PD11MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PD10MD_00, PD10MD_01, PD10MD_10, PD10MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PD9MD_00, PD9MD_01, PD9MD_10, PD9MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PD8MD_00, PD8MD_01, PD8MD_10, PD8MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PDCR1", 0xfffe386c, 16, 4) {
		PD7MD_00, PD7MD_01, PD7MD_10, PD7MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PD6MD_00, PD6MD_01, PD6MD_10, PD6MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PD5MD_00, PD5MD_01, PD5MD_10, PD5MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PD4MD_00, PD4MD_01, PD4MD_10, PD4MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PDCR0", 0xfffe386e, 16, 4) {
		PD3MD_00, PD3MD_01, PD3MD_10, PD3MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PD2MD_00, PD2MD_01, PD2MD_10, PD2MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PD1MD_00, PD1MD_01, PD1MD_10, PD1MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PD0MD_00, PD0MD_01, PD0MD_10, PD0MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},

	{ PINMUX_CFG_REG("PDIOR0", 0xfffe3872, 16, 1) {
		PD15_IN, PD15_OUT,
		PD14_IN, PD14_OUT,
		PD13_IN, PD13_OUT,
		PD12_IN, PD12_OUT,
		PD11_IN, PD11_OUT,
		PD10_IN, PD10_OUT,
		PD9_IN, PD9_OUT,
		PD8_IN, PD8_OUT,
		PD7_IN, PD7_OUT,
		PD6_IN, PD6_OUT,
		PD5_IN, PD5_OUT,
		PD4_IN, PD4_OUT,
		PD3_IN, PD3_OUT,
		PD2_IN, PD2_OUT,
		PD1_IN, PD1_OUT,
		PD0_IN, PD0_OUT }
	},

	{ PINMUX_CFG_REG("PECR1", 0xfffe388c, 16, 4) {
		PE7MD_00, PE7MD_01, PE7MD_10, PE7MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PE6MD_00, PE6MD_01, PE6MD_10, PE6MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PE5MD_00, PE5MD_01, PE5MD_10, PE5MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PE4MD_00, PE4MD_01, PE4MD_10, PE4MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PECR0", 0xfffe388e, 16, 4) {
		PE3MD_000, PE3MD_001, PE3MD_010, PE3MD_011,
		PE3MD_100, PE3MD_101, PE3MD_110, PE3MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PE2MD_000, PE2MD_001, PE2MD_010, PE2MD_011,
		PE2MD_100, PE2MD_101, PE2MD_110, PE2MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PE1MD_000, PE1MD_001, PE1MD_010, PE1MD_011,
		PE1MD_100, PE1MD_101, PE1MD_110, PE1MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PE0MD_00, PE0MD_01, PE0MD_10, PE0MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PEIOR0", 0xfffe3892, 16, 1) {
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PE7_IN, PE7_OUT,
		PE6_IN, PE6_OUT,
		PE5_IN, PE5_OUT,
		PE4_IN, PE4_OUT,
		PE3_IN, PE3_OUT,
		PE2_IN, PE2_OUT,
		PE1_IN, PE1_OUT,
		PE0_IN, PE0_OUT }
	},

	{ PINMUX_CFG_REG("PFCR6", 0xfffe38a2, 16, 4) {
		PF23MD_000, PF23MD_001, PF23MD_010, PF23MD_011,
		PF23MD_100, PF23MD_101, PF23MD_110, PF23MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PF22MD_000, PF22MD_001, PF22MD_010, PF22MD_011,
		PF22MD_100, PF22MD_101, PF22MD_110, PF22MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PF21MD_000, PF21MD_001, PF21MD_010, PF21MD_011,
		PF21MD_100, PF21MD_101, PF21MD_110, PF21MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PF20MD_000, PF20MD_001, PF20MD_010, PF20MD_011,
		PF20MD_100, PF20MD_101, PF20MD_110, PF20MD_111,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PFCR5", 0xfffe38a4, 16, 4) {
		PF19MD_000, PF19MD_001, PF19MD_010, PF19MD_011,
		PF19MD_100, PF19MD_101, PF19MD_110, PF19MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PF18MD_000, PF18MD_001, PF18MD_010, PF18MD_011,
		PF18MD_100, PF18MD_101, PF18MD_110, PF18MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PF17MD_000, PF17MD_001, PF17MD_010, PF17MD_011,
		PF17MD_100, PF17MD_101, PF17MD_110, PF17MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PF16MD_000, PF16MD_001, PF16MD_010, PF16MD_011,
		PF16MD_100, PF16MD_101, PF16MD_110, PF16MD_111,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PFCR4", 0xfffe38a6, 16, 4) {
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF15MD_000, PF15MD_001, PF15MD_010, PF15MD_011,
		PF15MD_100, PF15MD_101, PF15MD_110, PF15MD_111,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PFCR3", 0xfffe38a8, 16, 4) {
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF14MD_000, PF14MD_001, PF14MD_010, PF14MD_011,
		PF14MD_100, PF14MD_101, PF14MD_110, PF14MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PF13MD_000, PF13MD_001, PF13MD_010, PF13MD_011,
		PF13MD_100, PF13MD_101, PF13MD_110, PF13MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PF12MD_000, PF12MD_001, PF12MD_010, PF12MD_011,
		PF12MD_100, PF12MD_101, PF12MD_110, PF12MD_111,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PFCR2", 0xfffe38aa, 16, 4) {
		PF11MD_000, PF11MD_001, PF11MD_010, PF11MD_011,
		PF11MD_100, PF11MD_101, PF11MD_110, PF11MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PF10MD_000, PF10MD_001, PF10MD_010, PF10MD_011,
		PF10MD_100, PF10MD_101, PF10MD_110, PF10MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PF9MD_000, PF9MD_001, PF9MD_010, PF9MD_011,
		PF9MD_100, PF9MD_101, PF9MD_110, PF9MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PF8MD_000, PF8MD_001, PF8MD_010, PF8MD_011,
		PF8MD_100, PF8MD_101, PF8MD_110, PF8MD_111,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PFCR1", 0xfffe38ac, 16, 4) {
		PF7MD_000, PF7MD_001, PF7MD_010, PF7MD_011,
		PF7MD_100, PF7MD_101, PF7MD_110, PF7MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PF6MD_000, PF6MD_001, PF6MD_010, PF6MD_011,
		PF6MD_100, PF6MD_101, PF6MD_110, PF6MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PF5MD_000, PF5MD_001, PF5MD_010, PF5MD_011,
		PF5MD_100, PF5MD_101, PF5MD_110, PF5MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PF4MD_000, PF4MD_001, PF4MD_010, PF4MD_011,
		PF4MD_100, PF4MD_101, PF4MD_110, PF4MD_111,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PFCR0", 0xfffe38ae, 16, 4) {
		PF3MD_000, PF3MD_001, PF3MD_010, PF3MD_011,
		PF3MD_100, PF3MD_101, PF3MD_110, PF3MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PF2MD_000, PF2MD_001, PF2MD_010, PF2MD_011,
		PF2MD_100, PF2MD_101, PF2MD_110, PF2MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PF1MD_000, PF1MD_001, PF1MD_010, PF1MD_011,
		PF1MD_100, PF1MD_101, PF1MD_110, PF1MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PF0MD_000, PF0MD_001, PF0MD_010, PF0MD_011,
		PF0MD_100, PF0MD_101, PF0MD_110, PF0MD_111,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},

	{ PINMUX_CFG_REG("PFIOR1", 0xfffe38b0, 16, 1) {
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PF23_IN, PF23_OUT,
		PF22_IN, PF22_OUT,
		PF21_IN, PF21_OUT,
		PF20_IN, PF20_OUT,
		PF19_IN, PF19_OUT,
		PF18_IN, PF18_OUT,
		PF17_IN, PF17_OUT,
		PF16_IN, PF16_OUT }
	},
	{ PINMUX_CFG_REG("PFIOR0", 0xfffe38b2, 16, 1) {
		PF15_IN, PF15_OUT,
		PF14_IN, PF14_OUT,
		PF13_IN, PF13_OUT,
		PF12_IN, PF12_OUT,
		PF11_IN, PF11_OUT,
		PF10_IN, PF10_OUT,
		PF9_IN, PF9_OUT,
		PF8_IN, PF8_OUT,
		PF7_IN, PF7_OUT,
		PF6_IN, PF6_OUT,
		PF5_IN, PF5_OUT,
		PF4_IN, PF4_OUT,
		PF3_IN, PF3_OUT,
		PF2_IN, PF2_OUT,
		PF1_IN, PF1_OUT,
		PF0_IN, PF0_OUT }
	},

	{ PINMUX_CFG_REG("PGCR6", 0xfffe38c2, 16, 4) {
		PG27MD_00, PG27MD_01, PG27MD_10, PG27MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PG26MD_00, PG26MD_01, PG26MD_10, PG26MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PG25MD_00, PG25MD_01, PG25MD_10, PG25MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PG24MD_00, PG24MD_01, PG24MD_10, PG24MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PGCR5", 0xfffe38c4, 16, 4) {
		PG23MD_000, PG23MD_001, PG23MD_010, PG23MD_011,
		PG23MD_100, PG23MD_101, PG23MD_110, PG23MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PG22MD_000, PG22MD_001, PG22MD_010, PG22MD_011,
		PG22MD_100, PG22MD_101, PG22MD_110, PG22MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PG21MD_000, PG21MD_001, PG21MD_010, PG21MD_011,
		PG21MD_100, PG21MD_101, PG21MD_110, PG21MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PG20MD_000, PG20MD_001, PG20MD_010, PG20MD_011,
		PG20MD_100, PG20MD_101, PG20MD_110, PG20MD_111,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PGCR4", 0xfffe38c6, 16, 4) {
		PG19MD_000, PG19MD_001, PG19MD_010, PG19MD_011,
		PG19MD_100, PG19MD_101, PG19MD_110, PG19MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PG18MD_000, PG18MD_001, PG18MD_010, PG18MD_011,
		PG18MD_100, PG18MD_101, PG18MD_110, PG18MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PG17MD_00, PG17MD_01, PG17MD_10, PG17MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PG16MD_00, PG16MD_01, PG16MD_10, PG16MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PGCR3", 0xfffe38c8, 16, 4) {
		PG15MD_00, PG15MD_01, PG15MD_10, PG15MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PG14MD_00, PG14MD_01, PG14MD_10, PG14MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PG13MD_00, PG13MD_01, PG13MD_10, PG13MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PG12MD_00, PG12MD_01, PG12MD_10, PG12MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PGCR2", 0xfffe38ca, 16, 4) {
		PG11MD_000, PG11MD_001, PG11MD_010, PG11MD_011,
		PG11MD_100, PG11MD_101, PG11MD_110, PG11MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PG10MD_000, PG10MD_001, PG10MD_010, PG10MD_011,
		PG10MD_100, PG10MD_101, PG10MD_110, PG10MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PG9MD_000, PG9MD_001, PG9MD_010, PG9MD_011,
		PG9MD_100, PG9MD_101, PG9MD_110, PG9MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PG8MD_000, PG8MD_001, PG8MD_010, PG8MD_011,
		PG8MD_100, PG8MD_101, PG8MD_110, PG8MD_111,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},

	{ PINMUX_CFG_REG("PGCR1", 0xfffe38cc, 16, 4) {
		PG7MD_000, PG7MD_001, PG7MD_010, PG7MD_011,
		PG7MD_100, PG7MD_101, PG7MD_110, PG7MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PG6MD_000, PG6MD_001, PG6MD_010, PG6MD_011,
		PG6MD_100, PG6MD_101, PG6MD_110, PG6MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PG5MD_000, PG5MD_001, PG5MD_010, PG5MD_011,
		PG5MD_100, PG5MD_101, PG5MD_110, PG5MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PG4MD_000, PG4MD_001, PG4MD_010, PG4MD_011,
		PG4MD_100, PG4MD_101, PG4MD_110, PG4MD_111,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PGCR0", 0xfffe38ce, 16, 4) {
		PG3MD_000, PG3MD_001, PG3MD_010, PG3MD_011,
		PG3MD_100, PG3MD_101, PG3MD_110, PG3MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PG2MD_000, PG2MD_001, PG2MD_010, PG2MD_011,
		PG2MD_100, PG2MD_101, PG2MD_110, PG2MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PG1MD_000, PG1MD_001, PG1MD_010, PG1MD_011,
		PG1MD_100, PG1MD_101, PG1MD_110, PG1MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PG0MD_000, PG0MD_001, PG0MD_010, PG0MD_011,
		PG0MD_100, PG0MD_101, PG0MD_110, PG0MD_111,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},

	{ PINMUX_CFG_REG("PGIOR1", 0xfffe38d0, 16, 1) {
		0, 0, 0, 0, 0, 0, 0, 0,
		PG27_IN, PG27_OUT,
		PG26_IN, PG26_OUT,
		PG25_IN, PG25_OUT,
		PG24_IN, PG24_OUT,
		PG23_IN, PG23_OUT,
		PG22_IN, PG22_OUT,
		PG21_IN, PG21_OUT,
		PG20_IN, PG20_OUT,
		PG19_IN, PG19_OUT,
		PG18_IN, PG18_OUT,
		PG17_IN, PG17_OUT,
		PG16_IN, PG16_OUT }
	},
	{ PINMUX_CFG_REG("PGIOR0", 0xfffe38d2, 16, 1) {
		PG15_IN, PG15_OUT,
		PG14_IN, PG14_OUT,
		PG13_IN, PG13_OUT,
		PG12_IN, PG12_OUT,
		PG11_IN, PG11_OUT,
		PG10_IN, PG10_OUT,
		PG9_IN, PG9_OUT,
		PG8_IN, PG8_OUT,
		PG7_IN, PG7_OUT,
		PG6_IN, PG6_OUT,
		PG5_IN, PG5_OUT,
		PG4_IN, PG4_OUT,
		PG3_IN, PG3_OUT,
		PG2_IN, PG2_OUT,
		PG1_IN, PG1_OUT,
		PG0_IN, PG0_OUT }
	},

	{ PINMUX_CFG_REG("PHCR1", 0xfffe38ec, 16, 4) {
		PH7MD_00, PH7MD_01, PH7MD_10, PH7MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PH6MD_00, PH6MD_01, PH6MD_10, PH6MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PH5MD_00, PH5MD_01, PH5MD_10, PH5MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PH4MD_00, PH4MD_01, PH4MD_10, PH4MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},

	{ PINMUX_CFG_REG("PHCR0", 0xfffe38ee, 16, 4) {
		PH3MD_00, PH3MD_01, PH3MD_10, PH3MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PH2MD_00, PH2MD_01, PH2MD_10, PH2MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PH1MD_00, PH1MD_01, PH1MD_10, PH1MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PH0MD_00, PH0MD_01, PH0MD_10, PH0MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},

	{ PINMUX_CFG_REG("PJCR7", 0xfffe3900, 16, 4) {
		PJ31MD_0, PJ31MD_1, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PJ30MD_000, PJ30MD_001, PJ30MD_010, PJ30MD_011,
		PJ30MD_100, PJ30MD_101, PJ30MD_110, PJ30MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PJ29MD_000, PJ29MD_001, PJ29MD_010, PJ29MD_011,
		PJ29MD_100, PJ29MD_101, PJ29MD_110, PJ29MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PJ28MD_000, PJ28MD_001, PJ28MD_010, PJ28MD_011,
		PJ28MD_100, PJ28MD_101, PJ28MD_110, PJ28MD_111,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PJCR6", 0xfffe3902, 16, 4) {
		PJ27MD_000, PJ27MD_001, PJ27MD_010, PJ27MD_011,
		PJ27MD_100, PJ27MD_101, PJ27MD_110, PJ27MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PJ26MD_000, PJ26MD_001, PJ26MD_010, PJ26MD_011,
		PJ26MD_100, PJ26MD_101, PJ26MD_110, PJ26MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PJ25MD_000, PJ25MD_001, PJ25MD_010, PJ25MD_011,
		PJ25MD_100, PJ25MD_101, PJ25MD_110, PJ25MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PJ24MD_000, PJ24MD_001, PJ24MD_010, PJ24MD_011,
		PJ24MD_100, PJ24MD_101, PJ24MD_110, PJ24MD_111,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PJCR5", 0xfffe3904, 16, 4) {
		PJ23MD_000, PJ23MD_001, PJ23MD_010, PJ23MD_011,
		PJ23MD_100, PJ23MD_101, PJ23MD_110, PJ23MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PJ22MD_000, PJ22MD_001, PJ22MD_010, PJ22MD_011,
		PJ22MD_100, PJ22MD_101, PJ22MD_110, PJ22MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PJ21MD_000, PJ21MD_001, PJ21MD_010, PJ21MD_011,
		PJ21MD_100, PJ21MD_101, PJ21MD_110, PJ21MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PJ20MD_000, PJ20MD_001, PJ20MD_010, PJ20MD_011,
		PJ20MD_100, PJ20MD_101, PJ20MD_110, PJ20MD_111,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PJCR4", 0xfffe3906, 16, 4) {
		PJ19MD_000, PJ19MD_001, PJ19MD_010, PJ19MD_011,
		PJ19MD_100, PJ19MD_101, PJ19MD_110, PJ19MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PJ18MD_000, PJ18MD_001, PJ18MD_010, PJ18MD_011,
		PJ18MD_100, PJ18MD_101, PJ18MD_110, PJ18MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PJ17MD_000, PJ17MD_001, PJ17MD_010, PJ17MD_011,
		PJ17MD_100, PJ17MD_101, PJ17MD_110, PJ17MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PJ16MD_000, PJ16MD_001, PJ16MD_010, PJ16MD_011,
		PJ16MD_100, PJ16MD_101, PJ16MD_110, PJ16MD_111,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PJCR3", 0xfffe3908, 16, 4) {
		PJ15MD_000, PJ15MD_001, PJ15MD_010, PJ15MD_011,
		PJ15MD_100, PJ15MD_101, PJ15MD_110, PJ15MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PJ14MD_000, PJ14MD_001, PJ14MD_010, PJ14MD_011,
		PJ14MD_100, PJ14MD_101, PJ14MD_110, PJ14MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PJ13MD_000, PJ13MD_001, PJ13MD_010, PJ13MD_011,
		PJ13MD_100, PJ13MD_101, PJ13MD_110, PJ13MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PJ12MD_000, PJ12MD_001, PJ12MD_010, PJ12MD_011,
		PJ12MD_100, PJ12MD_101, PJ12MD_110, PJ12MD_111,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PJCR2", 0xfffe390a, 16, 4) {
		PJ11MD_000, PJ11MD_001, PJ11MD_010, PJ11MD_011,
		PJ11MD_100, PJ11MD_101, PJ11MD_110, PJ11MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PJ10MD_000, PJ10MD_001, PJ10MD_010, PJ10MD_011,
		PJ10MD_100, PJ10MD_101, PJ10MD_110, PJ10MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PJ9MD_000, PJ9MD_001, PJ9MD_010, PJ9MD_011,
		PJ9MD_100, PJ9MD_101, PJ9MD_110, PJ9MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PJ8MD_000, PJ8MD_001, PJ8MD_010, PJ8MD_011,
		PJ8MD_100, PJ8MD_101, PJ8MD_110, PJ8MD_111,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PJCR1", 0xfffe390c, 16, 4) {
		PJ7MD_000, PJ7MD_001, PJ7MD_010, PJ7MD_011,
		PJ7MD_100, PJ7MD_101, PJ7MD_110, PJ7MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PJ6MD_000, PJ6MD_001, PJ6MD_010, PJ6MD_011,
		PJ6MD_100, PJ6MD_101, PJ6MD_110, PJ6MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PJ5MD_000, PJ5MD_001, PJ5MD_010, PJ5MD_011,
		PJ5MD_100, PJ5MD_101, PJ5MD_110, PJ5MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PJ4MD_000, PJ4MD_001, PJ4MD_010, PJ4MD_011,
		PJ4MD_100, PJ4MD_101, PJ4MD_110, PJ4MD_111,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PJCR0", 0xfffe390e, 16, 4) {
		PJ3MD_000, PJ3MD_001, PJ3MD_010, PJ3MD_011,
		PJ3MD_100, PJ3MD_101, PJ3MD_110, PJ3MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PJ2MD_000, PJ2MD_001, PJ2MD_010, PJ2MD_011,
		PJ2MD_100, PJ2MD_101, PJ2MD_110, PJ2MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PJ1MD_000, PJ1MD_001, PJ1MD_010, PJ1MD_011,
		PJ1MD_100, PJ1MD_101, PJ1MD_110, PJ1MD_111,
		0, 0, 0, 0, 0, 0, 0, 0,

		PJ0MD_000, PJ0MD_001, PJ0MD_010, PJ0MD_011,
		PJ0MD_100, PJ0MD_101, PJ0MD_110, PJ0MD_111,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},

	{ PINMUX_CFG_REG("PJIOR1", 0xfffe3910, 16, 1) {
		PJ31_IN, PJ31_OUT,
		PJ30_IN, PJ30_OUT,
		PJ29_IN, PJ29_OUT,
		PJ28_IN, PJ28_OUT,
		PJ27_IN, PJ27_OUT,
		PJ26_IN, PJ26_OUT,
		PJ25_IN, PJ25_OUT,
		PJ24_IN, PJ24_OUT,
		PJ23_IN, PJ23_OUT,
		PJ22_IN, PJ22_OUT,
		PJ21_IN, PJ21_OUT,
		PJ20_IN, PJ20_OUT,
		PJ19_IN, PJ19_OUT,
		PJ18_IN, PJ18_OUT,
		PJ17_IN, PJ17_OUT,
		PJ16_IN, PJ16_OUT }
	},
	{ PINMUX_CFG_REG("PJIOR0", 0xfffe3912, 16, 1) {
		PJ15_IN, PJ15_OUT,
		PJ14_IN, PJ14_OUT,
		PJ13_IN, PJ13_OUT,
		PJ12_IN, PJ12_OUT,
		PJ11_IN, PJ11_OUT,
		PJ10_IN, PJ10_OUT,
		PJ9_IN, PJ9_OUT,
		PJ8_IN, PJ8_OUT,
		PJ7_IN, PJ7_OUT,
		PJ6_IN, PJ6_OUT,
		PJ5_IN, PJ5_OUT,
		PJ4_IN, PJ4_OUT,
		PJ3_IN, PJ3_OUT,
		PJ2_IN, PJ2_OUT,
		PJ1_IN, PJ1_OUT,
		PJ0_IN, PJ0_OUT }
	},

	{}
};

static struct pinmux_data_reg pinmux_data_regs[] = {
	{ PINMUX_DATA_REG("PADR0", 0xfffe3816, 16) {
		0, 0, 0, 0, 0, 0, 0, PA1_DATA,
		0, 0, 0, 0, 0, 0, 0, PA0_DATA }
	},

	{ PINMUX_DATA_REG("PBDR1", 0xfffe3834, 16) {
		0, 0, 0, 0, 0, 0, 0, 0,
		0, PB22_DATA, PB21_DATA, PB20_DATA,
		PB19_DATA, PB18_DATA, PB17_DATA, PB16_DATA }
	},
	{ PINMUX_DATA_REG("PBDR0", 0xfffe3836, 16) {
		PB15_DATA, PB14_DATA, PB13_DATA, PB12_DATA,
		PB11_DATA, PB10_DATA, PB9_DATA, PB8_DATA,
		PB7_DATA, PB6_DATA, PB5_DATA, PB4_DATA,
		PB3_DATA, PB2_DATA, PB1_DATA, 0 }
	},

	{ PINMUX_DATA_REG("PCDR0", 0xfffe3856, 16) {
		0, 0, 0, 0,
		0, 0, 0, PC8_DATA,
		PC7_DATA, PC6_DATA, PC5_DATA, PC4_DATA,
		PC3_DATA, PC2_DATA, PC1_DATA, PC0_DATA }
	},

	{ PINMUX_DATA_REG("PDDR0", 0xfffe3876, 16) {
		PD15_DATA, PD14_DATA, PD13_DATA, PD12_DATA,
		PD11_DATA, PD10_DATA, PD9_DATA, PD8_DATA,
		PD7_DATA, PD6_DATA, PD5_DATA, PD4_DATA,
		PD3_DATA, PD2_DATA, PD1_DATA, PD0_DATA }
	},

	{ PINMUX_DATA_REG("PEDR0", 0xfffe3896, 16) {
		0, 0, 0, 0, 0, 0, 0, 0,
		PE7_DATA, PE6_DATA, PE5_DATA, PE4_DATA,
		PE3_DATA, PE2_DATA, PE1_DATA, PE0_DATA }
	},

	{ PINMUX_DATA_REG("PFDR1", 0xfffe38b4, 16) {
		0, 0, 0, 0, 0, 0, 0, 0,
		PF23_DATA, PF22_DATA, PF21_DATA, PF20_DATA,
		PF19_DATA, PF18_DATA, PF17_DATA, PF16_DATA }
	},
	{ PINMUX_DATA_REG("PFDR0", 0xfffe38b6, 16) {
		PF15_DATA, PF14_DATA, PF13_DATA, PF12_DATA,
		PF11_DATA, PF10_DATA, PF9_DATA, PF8_DATA,
		PF7_DATA, PF6_DATA, PF5_DATA, PF4_DATA,
		PF3_DATA, PF2_DATA, PF1_DATA, PF0_DATA }
	},

	{ PINMUX_DATA_REG("PGDR1", 0xfffe38d4, 16) {
		0, 0, 0, 0,
		PG27_DATA, PG26_DATA, PG25_DATA, PG24_DATA,
		PG23_DATA, PG22_DATA, PG21_DATA, PG20_DATA,
		PG19_DATA, PG18_DATA, PG17_DATA, PG16_DATA }
	},
	{ PINMUX_DATA_REG("PGDR0", 0xfffe38d6, 16) {
		PG15_DATA, PG14_DATA, PG13_DATA, PG12_DATA,
		PG11_DATA, PG10_DATA, PG9_DATA, PG8_DATA,
		PG7_DATA, PG6_DATA, PG5_DATA, PG4_DATA,
		PG3_DATA, PG2_DATA, PG1_DATA, PG0_DATA }
	},

	{ PINMUX_DATA_REG("PJDR1", 0xfffe3914, 16) {
		PJ31_DATA, PJ30_DATA, PJ29_DATA, PJ28_DATA,
		PJ27_DATA, PJ26_DATA, PJ25_DATA, PJ24_DATA,
		PJ23_DATA, PJ22_DATA, PJ21_DATA, PJ20_DATA,
		PJ19_DATA, PJ18_DATA, PJ17_DATA, PJ16_DATA }
	},
	{ PINMUX_DATA_REG("PJDR0", 0xfffe3916, 16) {
		PJ15_DATA, PJ14_DATA, PJ13_DATA, PJ12_DATA,
		PJ11_DATA, PJ10_DATA, PJ9_DATA, PJ8_DATA,
		PJ7_DATA, PJ6_DATA, PJ5_DATA, PJ4_DATA,
		PJ3_DATA, PJ2_DATA, PJ1_DATA, PJ0_DATA }
	},

	{ }
};

static struct pinmux_info sh7269_pinmux_info = {
	.name = "sh7269_pfc",
	.reserved_id = PINMUX_RESERVED,
	.data = { PINMUX_DATA_BEGIN, PINMUX_DATA_END },
	.input = { PINMUX_INPUT_BEGIN, PINMUX_INPUT_END, FORCE_IN },
	.output = { PINMUX_OUTPUT_BEGIN, PINMUX_OUTPUT_END, FORCE_OUT },
	.mark = { PINMUX_MARK_BEGIN, PINMUX_MARK_END },
	.function = { PINMUX_FUNCTION_BEGIN, PINMUX_FUNCTION_END },

	.first_gpio = GPIO_PA1,
	.last_gpio = GPIO_FN_LCD_M_DISP,

	.gpios = pinmux_gpios,
	.cfg_regs = pinmux_config_regs,
	.data_regs = pinmux_data_regs,

	.gpio_data = pinmux_data,
	.gpio_data_size = ARRAY_SIZE(pinmux_data),
};

static int __init plat_pinmux_setup(void)
{
	return register_pinmux(&sh7269_pinmux_info);
}
arch_initcall(plat_pinmux_setup);
