/*
 * Copyright ? 1997-2008 Alacritech, Inc. All rights reserved
 *
 * $Id: sxgphycode.h,v 1.2 2008/10/02 01:44:07 Exp $
 *
 * sxgphycode.h:
 *
 * This file PHY microcode and register initialization data.
 */

/**********************************************************************
 * PHY Microcode
 **********************************************************************/
//
// The following contains both PHY microcode and PHY register
// initialization data.  It is specific to both the PHY and the
// type of transceiver.
//

// Download for AEL2005C PHY with SR/LR transceiver (10GBASE-SR or 10GBASE-LR)
// AEL2005 SR firmware rev 18 (microInit_mdio_SR_AEL2005C_18.tx).
static struct phy_ucode	PhyUcode[] = {
	// NOTE:  An address of 0 is a special case.  When the download routine
	// sees an address of 0, it does not write to the PHY.  Instead, it delays
	// the download.  The length of the delay (in ms) is given in the data field.
	// Delays are required at certain points.

	// Platform-specific MDIO Patches:
	// (include patches for 10G RX polarity flip, 50Mhz Synth, etc)
	// Addr		Data
	{0xc017,	0xfeb0},	// flip RX_LOS polarity (mandatory patch for SFP+ applications)
	{0xC001,	0x0428},	// flip RX serial polarity

	{0xc013,	0xf341},	// invert lxmit clock (mandatory patch)
	{0xc210,	0x8000},	// reset datapath (mandatory patch)
	{0xc210,	0x8100},	// reset datapath (mandatory patch)
	{0xc210,	0x8000},	// reset datapath (mandatory patch)
	{0xc210,	0x0000},	// reset datapath (mandatory patch)
	{0x0000,	0x0032},	// wait for 50ms for datapath reset to complete. (mandatory patch)

	// Transceiver-specific MDIO Patches:
	{0xc003,	0x0181},	// (bit 7) enable the CDR inc setting in 1.C005 (mandatory patch for SR code)
	{0xc010,	0x448a},	// (bit 14) mask out high BER input from the LOS signal in 1.000A (mandatory patch for SR code)

	// Transceiver-specific Microcontroller Initialization:
	{0xc04a,	0x5200},	// activate microcontroller and pause
	{0x0000,	0x0032},	// wait 50ms for microcontroller before writing in code.

	// code block starts here:
	{0xcc00,	0x2ff4},	{0xcc01,	0x3cd4},	{0xcc02,	0x2015},	{0xcc03,	0x3125},
	{0xcc04,	0x6524},	{0xcc05,	0x27ff},	{0xcc06,	0x300f},	{0xcc07,	0x2c8b},
	{0xcc08,	0x300b},	{0xcc09,	0x4009},	{0xcc0a,	0x400e},	{0xcc0b,	0x2f12},
	{0xcc0c,	0x3002},	{0xcc0d,	0x1002},	{0xcc0e,	0x2112},	{0xcc0f,	0x3012},
	{0xcc10,	0x1002},	{0xcc11,	0x2572},	{0xcc12,	0x3012},	{0xcc13,	0x1002},
	{0xcc14,	0xd01e},	{0xcc15,	0x2772},	{0xcc16,	0x3012},	{0xcc17,	0x1002},
	{0xcc18,	0x2004},	{0xcc19,	0x3c84},	{0xcc1a,	0x6436},	{0xcc1b,	0x2007},
	{0xcc1c,	0x3f87},	{0xcc1d,	0x8676},	{0xcc1e,	0x40b7},	{0xcc1f,	0xa746},
	{0xcc20,	0x4047},	{0xcc21,	0x5673},	{0xcc22,	0x2982},	{0xcc23,	0x3002},
	{0xcc24,	0x13d2},	{0xcc25,	0x8bbd},	{0xcc26,	0x2802},	{0xcc27,	0x3012},
	{0xcc28,	0x1002},	{0xcc29,	0x2032},	{0xcc2a,	0x3012},	{0xcc2b,	0x1002},
	{0xcc2c,	0x5cc3},	{0xcc2d,	0x0314},	{0xcc2e,	0x2942},	{0xcc2f,	0x3002},
	{0xcc30,	0x1002},	{0xcc31,	0xd019},	{0xcc32,	0x2fd2},	{0xcc33,	0x3002},
	{0xcc34,	0x1002},	{0xcc35,	0x2a04},	{0xcc36,	0x3c74},	{0xcc37,	0x6435},
	{0xcc38,	0x2fa4},	{0xcc39,	0x3cd4},	{0xcc3a,	0x6624},	{0xcc3b,	0x5563},
	{0xcc3c,	0x2d42},	{0xcc3d,	0x3002},	{0xcc3e,	0x13d2},	{0xcc3f,	0x464d},
	{0xcc40,	0x2802},	{0xcc41,	0x3012},	{0xcc42,	0x1002},	{0xcc43,	0x2fd2},
	{0xcc44,	0x3002},	{0xcc45,	0x1002},	{0xcc46,	0x2fb4},	{0xcc47,	0x3cd4},
	{0xcc48,	0x6624},	{0xcc49,	0x5563},	{0xcc4a,	0x2d42},	{0xcc4b,	0x3002},
	{0xcc4c,	0x13d2},	{0xcc4d,	0x2e72},	{0xcc4e,	0x3002},	{0xcc4f,	0x1002},
	{0xcc50,	0x2f72},	{0xcc51,	0x3002},	{0xcc52,	0x1002},	{0xcc53,	0x0004},
	{0xcc54,	0x2942},	{0xcc55,	0x3002},	{0xcc56,	0x1002},	{0xcc57,	0x2032},
	{0xcc58,	0x3012},	{0xcc59,	0x1002},	{0xcc5a,	0x5cc3},	{0xcc5b,	0x0317},
	{0xcc5c,	0x2f12},	{0xcc5d,	0x3002},	{0xcc5e,	0x1002},	{0xcc5f,	0x2942},
	{0xcc60,	0x3002},	{0xcc61,	0x1002},	{0xcc62,	0x22cd},	{0xcc63,	0x301d},
	{0xcc64,	0x2802},	{0xcc65,	0x3012},	{0xcc66,	0x1002},	{0xcc67,	0x20b2},
	{0xcc68,	0x3012},	{0xcc69,	0x1002},	{0xcc6a,	0x5aa3},	{0xcc6b,	0x2dc2},
	{0xcc6c,	0x3002},	{0xcc6d,	0x1312},	{0xcc6e,	0x2d02},	{0xcc6f,	0x3002},
	{0xcc70,	0x1002},	{0xcc71,	0x2807},	{0xcc72,	0x31a7},	{0xcc73,	0x20c4},
	{0xcc74,	0x3c24},	{0xcc75,	0x6724},	{0xcc76,	0x1002},	{0xcc77,	0x2807},
	{0xcc78,	0x3187},	{0xcc79,	0x20c4},	{0xcc7a,	0x3c24},	{0xcc7b,	0x6724},
	{0xcc7c,	0x1002},	{0xcc7d,	0x2514},	{0xcc7e,	0x3c64},	{0xcc7f,	0x6436},
	{0xcc80,	0xdff4},	{0xcc81,	0x6436},	{0xcc82,	0x1002},	{0xcc83,	0x40a4},
	{0xcc84,	0x643c},	{0xcc85,	0x4016},	{0xcc86,	0x8c6c},	{0xcc87,	0x2b24},
	{0xcc88,	0x3c24},	{0xcc89,	0x6435},	{0xcc8a,	0x1002},	{0xcc8b,	0x2b24},
	{0xcc8c,	0x3c24},	{0xcc8d,	0x643a},	{0xcc8e,	0x4025},	{0xcc8f,	0x8a5a},
	{0xcc90,	0x1002},	{0xcc91,	0x26d1},	{0xcc92,	0x3011},	{0xcc93,	0x1001},
	{0xcc94,	0xc7a0},	{0xcc95,	0x0100},	{0xcc96,	0xc502},	{0xcc97,	0x53ac},
	{0xcc98,	0xc503},	{0xcc99,	0xd5d5},	{0xcc9a,	0xc600},	{0xcc9b,	0x2a6d},
	{0xcc9c,	0xc601},	{0xcc9d,	0x2a4c},	{0xcc9e,	0xc602},	{0xcc9f,	0x0111},
	{0xcca0,	0xc60c},	{0xcca1,	0x5900},	{0xcca2,	0xc710},	{0xcca3,	0x0700},
	{0xcca4,	0xc718},	{0xcca5,	0x0700},	{0xcca6,	0xc720},	{0xcca7,	0x4700},
	{0xcca8,	0xc801},	{0xcca9,	0x7f50},	{0xccaa,	0xc802},	{0xccab,	0x7760},
	{0xccac,	0xc803},	{0xccad,	0x7fce},	{0xccae,	0xc804},	{0xccaf,	0x5700},
	{0xccb0,	0xc805},	{0xccb1,	0x5f11},	{0xccb2,	0xc806},	{0xccb3,	0x4751},
	{0xccb4,	0xc807},	{0xccb5,	0x57e1},	{0xccb6,	0xc808},	{0xccb7,	0x2700},
	{0xccb8,	0xc809},	{0xccb9,	0x0000},	{0xccba,	0xc821},	{0xccbb,	0x0002},
	{0xccbc,	0xc822},	{0xccbd,	0x0014},	{0xccbe,	0xc832},	{0xccbf,	0x1186},
	{0xccc0,	0xc847},	{0xccc1,	0x1e02},	{0xccc2,	0xc013},	{0xccc3,	0xf341},
	{0xccc4,	0xc01a},	{0xccc5,	0x0446},	{0xccc6,	0xc024},	{0xccc7,	0x1000},
	{0xccc8,	0xc025},	{0xccc9,	0x0a00},	{0xccca,	0xc026},	{0xcccb,	0x0c0c},
	{0xcccc,	0xc027},	{0xcccd,	0x0c0c},	{0xccce,	0xc029},	{0xcccf,	0x00a0},
	{0xccd0,	0xc030},	{0xccd1,	0x0a00},	{0xccd2,	0xc03c},	{0xccd3,	0x001c},
	{0xccd4,	0xc005},	{0xccd5,	0x7a06},	{0xccd6,	0x0000},	{0xccd7,	0x26d1},
	{0xccd8,	0x3011},	{0xccd9,	0x1001},	{0xccda,	0xc620},	{0xccdb,	0x0000},
	{0xccdc,	0xc621},	{0xccdd,	0x003f},	{0xccde,	0xc622},	{0xccdf,	0x0000},
	{0xcce0,	0xc623},	{0xcce1,	0x0000},	{0xcce2,	0xc624},	{0xcce3,	0x0000},
	{0xcce4,	0xc625},	{0xcce5,	0x0000},	{0xcce6,	0xc627},	{0xcce7,	0x0000},
	{0xcce8,	0xc628},	{0xcce9,	0x0000},	{0xccea,	0xc62c},	{0xcceb,	0x0000},
	{0xccec,	0x0000},	{0xcced,	0x2806},	{0xccee,	0x3cb6},	{0xccef,	0xc161},
	{0xccf0,	0x6134},	{0xccf1,	0x6135},	{0xccf2,	0x5443},	{0xccf3,	0x0303},
	{0xccf4,	0x6524},	{0xccf5,	0x000b},	{0xccf6,	0x1002},	{0xccf7,	0x2104},
	{0xccf8,	0x3c24},	{0xccf9,	0x2105},	{0xccfa,	0x3805},	{0xccfb,	0x6524},
	{0xccfc,	0xdff4},	{0xccfd,	0x4005},	{0xccfe,	0x6524},	{0xccff,	0x1002},
	{0xcd00,	0x5dd3},	{0xcd01,	0x0306},	{0xcd02,	0x2ff7},	{0xcd03,	0x38f7},
	{0xcd04,	0x60b7},	{0xcd05,	0xdffd},	{0xcd06,	0x000a},	{0xcd07,	0x1002},
	{0xcd08,	0x0000},
	// end of code block

	// Unpause the microcontroller to start program
	{0xca00,	0x0080},
	{0xca12,	0x0000},
	{0x0000,	0x000A},	// wait 10ms just to be safe

	// Configure the LED's
	{0xc214,	0x0099},	// configure the LED drivers (for Sahara rev B)
	{0xc216,	0x0400},	// configure the one LED
	{0xc217,	0x0000},	// don't drive the 2nd LED (if it exists)

	{0xffff,	0xffff}		// table terminator
};
