Summary: Multicore Application Runtime System
Name: mars
Version: 1.1.5
Release: 1
License: MIT plus and MIT
Group: System Environment/Libraries
URL: ftp://ftp.infradead.org/pub/Sony-PS3/mars/
Source0: ftp://ftp.infradead.org/pub/Sony-PS3/mars/%{version}/mars-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root

Requires: libspe2, numactl
BuildRequires: ppu-gcc, spu-gcc, libspe2-devel, numactl-devel, doxygen, librsvg2

%define __os_install_post	/usr/lib/rpm/brp-compress

%description
MARS (Multicore Application Runtime System) is a set of libraries that
provides an API to easily manage and create user programs that will be
scheduled to run on various microprocessing units of a multicore
environment.

%package devel
Summary: Multicore Application Runtime System
Group: Development/Libraries
Requires: %{name} = %{version}, libspe2-devel

%description devel
Headers and static libraries for MARS (Multicore Application Runtime
System).

%package doc
Summary: Multicore Application Runtime System
Group: Documentation
Requires: %{name} = %{version}

%description doc
Documentation of MARS (Multicore Application Runtime System).

%package samples
Summary: Multicore Application Runtime System
Group: Development/Libraries
Requires: %{name} = %{version}

%description samples
Samples of MARS (Multicore Application Runtime System).

%prep
%setup -q -n mars-%{version}

%build

PPU_CC='ppu-gcc'
%ifarch ppc
PPU_CFLAGS='-m32'
%endif
%ifarch ppc64
PPU_CFLAGS='-m64'
%endif

%define mars_configure_opts \\\
	PPU_CC="$PPU_CC" \\\
	PPU_CFLAGS="$PPU_CFLAGS -g -O2" \\\
	PPU_LDFLAGS="-Wl,--build-id" \\\
	--host=%{_host} \\\
	--build=%{_build} \\\
	--prefix=%{_prefix} \\\
	--libdir=%{_libdir} \\\
	--with-mars-platform=cell

./configure %{mars_configure_opts}
make

%install
rm -rf %{buildroot}

make install DESTDIR=%{buildroot}

cd doxygen
make install DESTDIR=%{buildroot} VERSION=%{version}
cd ..

cd samples
make install DESTDIR=%{buildroot} VERSION=%{version}
cd ..

%clean
rm -rf %{buildroot}

%files
%defattr(-,root,root,-)
%{_libdir}/*.so*

%files devel
%defattr(-,root,root,-)
%{_libdir}/*.a
%{_libdir}/*.la
%{_includedir}/*
%{_prefix}/spu/*

%files doc
%defattr(-,root,root,-)
%{_docdir}/*

%files samples
%defattr(-,root,root,-)
%{_datadir}/%{name}-%{version}/samples/*

%changelog
* Thu Jan 29 2009 Kazunori Asayama <asayama@sm.sony.co.jp> - 1.1.1-1
- Add --build-id linker option.

* Thu Dec 25 2008 Kazunori Asayama <asayama@sm.sony.co.jp> - 1.1.0-2
- Support top level Makefile and configure.

* Thu Dec 11 2008 Kazunori Asayama <asayama@sm.sony.co.jp> - 1.1.0-1
- Add task module to the package.

* Mon Oct 27 2008 Kazunori Asayama <asayama@sm.sony.co.jp> - 1.0.1-1
- Initial build.
