/*
 * tools/lib/liblvm.h
 *
 * Copyright (C) 1997 - 2000  Heinz Mauelshagen, Germany
 *
 * March-June 1997
 * January 1998
 * January,February,July 1999
 *
 *
 * This LVM library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This LVM library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this LVM library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA 
 *
 */

/*
 * Changelog
 *
 *   03/01/1999 - port to libc6
 *   07/02/1999 - conditional data conversion macros
 *   05/07/1999 - rearanged includes due to 2.3.x changes
 *
 */

/* lvm_lib_version "LVM 0.8 by Heinz Mauelshagen   04/11/1999\n" */

#ifndef _LIBLVM_H_INCLUDE
#define _LIBLVM_H_INCLUDE

#include <features.h>
#if 0
#include <linux/autoconf.h>

#ifndef LINUX_VERSION_CODE
#  include <linux/version.h>
   /* for 2.0.x series */
#  ifndef KERNEL_VERSION
#    define KERNEL_VERSION(a,b,c) (((a) << 16) + ((b) << 8) + (c))
#  endif
#endif
#endif

#if __GLIBC__ > 1
#  ifndef uint8_t
#    define uint8_t	u_int8_t
#  endif
#  ifndef uint16_t
#    define uint16_t	u_int16_t
#  endif
#  ifndef uint32_t
#    define uint32_t	u_int32_t
#  endif
#  define	SECTOR_SIZE	512
#  define	BLKGETSIZE	_IO(0x12,96)	/* return device size */ 
#  define	BLKRASET	_IO(0x12,98)	/* Set read ahead */
#  define	BLOCK_SIZE	1024
#  define	EXT2_SUPER_MAGIC	0xEF53
#  include <sys/types.h>
#  include <sys/stat.h>
#  include <errno.h>
#  include <stdio.h>
#  include <fcntl.h>
#  include <unistd.h>
#  include <stdlib.h>
#  include <dirent.h>
#  include <string.h>
#  include <stdarg.h>
#  include <malloc.h>
#  include <ctype.h>
#  include <time.h>
int llseek ( unsigned int, unsigned long long, unsigned int);

#else /* __GLIBC__ < 2 */

#if 0
#if LINUX_VERSION_CODE >= KERNEL_VERSION ( 2, 1, 0)
#endif
#  define _I386_STAT_H
#endif
#  include <sys/stat.h>
#  include <unistd.h>
#  include <fcntl.h>
#  include <dirent.h>
#  include <time.h>
#  include <stdlib.h>
#  include <ctype.h>
#  include <string.h>
#  include <linux/msdos_fs.h>
#  include <malloc.h>
#  include <stdio.h>
#endif /* __GLIBC__ > 1 */

#include "kernel_lvm.h"
#include <sys/ioctl.h>
#include <linux/genhd.h>
#include <linux/major.h>

#define	LVM_LIB_IOP_VERSION	6

#define	LVM_ID		"HM"      /* Identifier PV (id in pv_t) */
#define	EXPORTED	"PV_EXP"  /* Identifier exported PV (system_id in pv_t) */
#define	IMPORTED	"PV_IMP"  /* Identifier imported PV (        "        ) */
#define	LVMTAB                  "/etc/lvmtab"	/* LVM table of VGs */
#define	LVMTAB_DIR              "/etc/lvmtab.d"	/* storage dir VG data */
#define	LVMTAB_MINSIZE   ( sizeof ( vg_t) + sizeof ( lv_t) + sizeof ( pv_t))
#define	LVM_DEV                 "/dev/lvm"
#define	VG_BACKUP_DIR           "/etc/lvmconf"
#define	DISK_NAME_LEN		8
#define	LV_MIN_NAME_LEN		5
#define	LV_MAX_NAME_LEN		7
#define	MIN_PART		1
#define	MAX_PART	 	15
#define	LVM_DIR_PREFIX	"/dev/"
#define	LVM_DIR_CACHE_GET_FROM_PROC	TRUE

#define	VGCFG_WRITE( handle, what, size, file_name) ( { \
      if ( write ( handle, what, size) != size) { \
         fprintf ( stderr, "%s -- ERROR %d writing volume group backup " \
                           "file %s in %s [line %d]\n", \
                           cmd, errno, file_name, __FILE__, __LINE__); \
         close ( handle); \
         unlink ( file_name); \
         ret = -LVM_EVG_CFGBACKUP_WRITE; \
         goto vg_cfgbackup_end; \
      }; \
} )

#define	VGCFG_READ( handle, what, size, file_name) ( { \
      if ( read ( handle, what, size) != size) { \
         fprintf ( stderr, "%s -- ERROR %d reading volume group backup " \
                           "file %s in %s [ line %d]\n",\
                           cmd, errno, file_name, __FILE__, __LINE__); \
         close ( handle); \
         ret = -LVM_EVG_CFGRESTORE_READ; \
         goto vg_cfgrestore_end; \
      }; \
} )


/* to disk and to core data conversion macros */
#if __BYTE_ORDER == __BIG_ENDIAN

#define LVM_TO_CORE16( a) ( \
   ( ( uint8_t*) &a)[0] + \
   ( ( uint8_t*) &a)[1] * 256 \
)

#define LVM_TO_DISK16( dest, src) ( \
   { \
      int _i; \
      uint16_t _tmp = src; \
      for ( _i = 0; _i < 2; _i++) { \
         ( ( uint8_t*) &dest)[_i] = _tmp % 256; \
         _tmp /= 256; \
      } \
   } \
)

#define LVM_TO_CORE32( a) ( \
   ( ( uint8_t*) &a)[0] + \
   ( ( uint8_t*) &a)[1] * 256 + \
   ( ( uint8_t*) &a)[2] * 256 * 256 + \
   ( ( uint8_t*) &a)[3] * 256 * 256 * 256 \
)

#define LVM_TO_DISK32( dest, src) ( \
   { \
      int _i; \
      uint32_t _tmp = src; \
      for ( _i = 0; _i < 4; _i++) { \
         ( ( uint8_t*) &dest)[_i] = _tmp % 256; \
         _tmp /= 256; \
      } \
   } \
)

#else /* #if __BYTE_ORDER == __BIG_ENDIAN */

#define LVM_TO_CORE16( a) a
#define LVM_TO_DISK16( dest, src) dest = src
#define LVM_TO_CORE32( a) a
#define LVM_TO_DISK32( dest, src) dest = src

#endif /* #if __BYTE_ORDER == __BIG_ENDIAN */


extern int errno;
extern char *cmd;

#ifdef DEBUG
extern int opt_d;
#endif

/* for lvm_show_size () */
typedef	enum { SHORT, LONG} size_len_t;

/* for future use, maybe in pv_check_free () */
typedef	enum {
   NEXT_FREE,
   LINEAR,
   LINEAR_CONTIGUOUS,
   STRIPED,
   STRIPED_CONTIGUOUS}
alloc_t;

/* for lvm_dir_cache () */
typedef struct {
   char *dev_name;
   dev_t st_rdev;
   short st_mode;
} dir_cache_t;

/* PE type data layer functions */
disk_pe_t *pe_copy_from_disk ( disk_pe_t*, int);
disk_pe_t *pe_copy_to_disk   ( disk_pe_t*, int);

/* VG functions */
int  vg_cfgbackup ( char *, char *, int, vg_t *);
int  vg_cfgrestore ( char *, char *, int, vg_t *);
int  vg_check_active ( char *);
int  vg_check_exist ( char *);
char ** vg_check_exist_all_vg ( void);
int  vg_check_dir ( char *);
int  vg_check_name ( char *);
int  vg_check_consistency ( vg_t *);
int  vg_check_consistency_with_pv_and_lv ( vg_t *);
int  vg_check_online_all_pv ( vg_t*, pv_t***, pv_t***);
int  vg_check_pe_size ( ulong);
char ** vg_check_active_all_vg ( void);
vg_t      *vg_copy_from_disk ( vg_disk_t *);
vg_disk_t *vg_copy_to_disk ( vg_t *);
int  vg_create ( char *, vg_t *);
int  vg_create_dir_and_group ( vg_t *);
int  vg_create_dir_and_group_and_nodes ( vg_t *, int);
void vg_deactivate ( char *);
inline int vg_extend ( char *, pv_t *, vg_t *);
int  vg_free ( vg_t *, int);
char *vg_name_of_lv ( char *);
int  vg_remove ( char *);
int  vg_read ( char *, vg_t **);
int  vg_read_from_pv ( char *, vg_t **);
int  vg_read_with_pv_and_lv ( char *, vg_t **);
inline int vg_reduce ( char *, pv_t *, vg_t *);
int  vg_remove_dir_and_group_and_nodes ( char *);
int  vg_set_extendable ( char*);
int  vg_clear_extendable ( char*);
int  vg_setup_for_create ( char *, vg_t *, pv_t **, int, ulong, ulong);
int  vg_setup_for_extend ( char **, int, pv_t **, vg_t *, char **);
int  vg_setup_for_merge ( vg_t *, vg_t *);
int  vg_setup_for_reduce ( char **, int, vg_t *, pv_t ***, char **);
int  vg_setup_for_split ( vg_t *, char *, vg_t **, char **, char ***, char **);
void vg_show ( vg_t *);
void vg_show_colon ( vg_t *);
void vg_show_with_pv_and_lv ( vg_t *);
int  vg_write ( char*, pv_t *, vg_t *);
int  vg_write_with_pv_and_lv ( vg_t *);
int  vg_status ( char *, vg_t **);
int  vg_status_get_count ( void);
int  vg_status_get_namelist ( char *);
int  vg_status_with_pv_and_lv ( char *, vg_t **);


/* PV functions */
int    pe_lock ( char *, kdev_t, ulong, ushort, ushort, kdev_t);
int    pe_unlock ( char *);
int    pv_change ( char *, pv_t *);
int    pv_change_all_pv_of_vg ( char *, vg_t *);
int    pv_change_all_pv_for_lv_of_vg ( char *, char *, vg_t *);
int    pv_check_active ( char *, char *);
int    pv_check_active_in_all_vg ( char *);
int    pv_check_free ( pv_t *, ulong, ulong *);
int    pv_check_free_contiguous ( pv_t *, ulong, ulong *);
int    pv_check_in_vg ( vg_t *, char *);
int    pv_check_new ( pv_t *);
int    pv_check_consistency ( pv_t *);
int    pv_check_consistency_all_pv ( vg_t *);
int    pv_check_name ( char *);
int    pv_check_number ( pv_t **, int);
int    pv_check_part ( char *);
int    pv_check_volume ( char *, pv_t *);
pv_t   *pv_copy_from_disk ( pv_disk_t *);
pv_disk_t *pv_copy_to_disk ( pv_t *);
char   **pv_find_all_pv_names ( void);
kdev_t pv_create_kdev_t ( char *);
char   *pv_create_name_from_kdev_t ( kdev_t);
int    pv_find_vg ( char *, char **);
int    pv_flush ( char *);
int    pv_get_index_by_kdev_t ( vg_t *, kdev_t);
int    pv_get_index_by_name ( vg_t *, char *);
int    pv_get_size ( char *, struct partition *);
int    pv_move_pes ( vg_t*, char*, char**, int, int,
                     int*, int*, int*, int, int);
int    pv_move_pe ( vg_t*, char*, long, long, long, long,
                    int, int, int, int);
int    pv_read ( char *, pv_t **, int *);
int    pv_read_already_red ( char *);
int    pv_read_pe ( pv_t *, disk_pe_t **);
int    pv_read_all_pv ( pv_t ***, int);
int    pv_read_all_pv_of_vg ( char *, pv_t ***, int);
int    pv_read_all_pe_of_vg ( char *, disk_pe_t ***, int);
int    pv_read_namelist ( char *, vg_t *, char **);
int    pv_release_pe ( vg_t *, disk_pe_t *, uint *, uint);
int    pv_reserve_pe ( pv_t *, disk_pe_t *, uint *, pe_t *, uint, int);
int    pv_setup_for_create ( char *, pv_t *, uint);
void   pv_show ( pv_t *);
void   pv_show_colon ( pv_t *);
void   pv_show_short ( pv_t *);
void   pv_show_all_pv_of_vg ( vg_t *);
void   pv_show_all_pv_of_vg_short ( vg_t *);
void   pv_show_pe ( pv_t *, disk_pe_t *, int);
int    pv_show_pe_text ( pv_t *, disk_pe_t *, int);
int    pv_status ( char *, char *, pv_t **);
int    pv_status_all_pv_of_vg ( char *, pv_t ***);
int    pv_write ( char*, pv_t *);
int    pv_write_all_pv_of_vg ( vg_t *);
int    pv_write_namelist ( char *, vg_t *);
int    pv_write_pe ( char*, pv_t *);
int    pv_write_with_pe ( char*, pv_t *);


/* LV functions */
char   *lv_change_vgname ( char *, char *);
int    lv_change_read_ahead ( char *, int);
int    lv_check_active ( char *, char *);
int    lv_check_on_pv ( pv_t *, int);
int    lv_check_contiguous ( vg_t *, int);
int    lv_check_consistency ( lv_t *);
int    lv_check_consistency_all_lv ( vg_t *);
int    lv_check_exist ( char *);
int    lv_check_name ( char *);
int    lv_check_stripesize ( int);
lv_t      *lv_copy_from_disk ( lv_disk_t *);
lv_disk_t *lv_copy_to_disk ( lv_t *);
int    lv_count_pe ( pv_t *, int);
inline int lv_create ( vg_t *, lv_t *, char *);
int    lv_create_name ( char *, char *, int);
int    lv_create_node ( lv_t *);
inline int lv_extend ( vg_t *, lv_t *, char *);
int    lv_get_index_by_kdev_t ( vg_t *, kdev_t);
int    lv_get_index_by_name ( vg_t *, char *);
int    lv_get_le_on_pv ( pv_t *, int);
char   *lv_get_name ( vg_t*, int);
int    lv_number_from_name_in_vg ( char *, vg_t *);
int    lv_le_remap ( vg_t*, le_remap_req_t*);
int    lv_read ( char *, char *, lv_t **);
int    lv_read_byindex ( char *vg_name, ulong lv_index, lv_t **lv);
int    lv_read_with_pe ( char *, char *, lv_t **);
int    lv_read_all_lv_of_vg ( char *, lv_t ***, int);
inline int lv_reduce ( vg_t *, lv_t *, char *);
int    lv_release ( vg_t *, char *);
inline int lv_remove ( vg_t *, lv_t *, char *);
int    lv_setup_for_create ( char *, vg_t **, char *, int *,
                             uint, uint, uint, uint, uint, uint, char **);
int    lv_setup_for_extend ( char *, vg_t *, char *, uint, char **);
int    lv_setup_for_reduce ( char *, vg_t *, char *, uint);
void   lv_show ( lv_t *);
void   lv_show_colon ( lv_t *);
void   lv_show_all_lv_of_vg ( vg_t *);
void   lv_show_current_pe ( lv_t *);
int    lv_show_current_pe_text ( lv_t *);
int    lv_status_byname ( char *, char *, lv_t **);
int    lv_status_byindex ( char *, ulong, lv_t **);
int    lv_status_all_lv_of_vg ( char *, vg_t *, lv_t ***);
int    lv_write ( char *, vg_t *, lv_t *, int);
int    lv_write_all_pv ( vg_t *, int);
int    lv_write_all_lv_of_vg ( char*, vg_t *);


/* print debug info on stderr */
void debug ( const char *, ...);

/* generate nice KB/MB/... strings */
char *lvm_show_size ( unsigned long long, size_len_t);

/* get the basename (no slashes) of a path */
#if __GLIBC__ < 2
char *basename ( char *);
#endif

/* system identifier handling */
int system_id_set ( char *);
int system_id_set_exported ( char *);
int system_id_set_imported ( char *);
int system_id_check_exported ( char *);
int system_id_check_imported ( char *);

/* LVM locking / interrupt masking etc. */
int    lvm_check_dev ( struct stat*, int);
int    lvm_check_extended_partition ( dev_t);
int    lvm_check_kernel_lvmtab_consistency ( void);
int    lvm_check_partitioned_dev ( dev_t);
int    lvm_check_whole_disk_dev ( dev_t);
int    lvm_partition_count ( dev_t);
void   lvm_check_special ( void);
int    lvm_check_number ( char *, int);
int    lvm_dir_cache ( dir_cache_t **);
dir_cache_t *lvm_dir_cache_find ( char *);
int    lvm_show_filetype ( ushort, char *);
int    lvm_lock ( void);
int    lvm_unlock ( void);
void   lvm_interrupt ( void);
void   lvm_dont_interrupt ( int);
int    lvm_get_col_numbers ( char *, int **);
int    lvm_get_iop_version ( void);
int    lvm_check_chars ( char*);

/* LVMTAB based functions */
int  lvm_tab_read ( char **, int *);
int  lvm_tab_write ( char *, int);
int  lvm_tab_create ( void);
int  lvm_tab_get_free_vg_number ( void);
int  lvm_tab_lv_check_exist ( char *);
int  lvm_tab_lv_read_by_name ( char *, char*, lv_t **);
int  lvm_tab_vg_insert ( char *);
int  lvm_tab_vg_read_with_pv_and_lv ( char *, vg_t **);
int  lvm_tab_vg_read ( char *, vg_t **);
int  lvm_tab_vg_remove ( char *);
int  lvm_tab_vg_check_exist ( char *, vg_t **);
int  lvm_tab_get_free_blk_dev ( kdev_t **);
char **lvm_tab_vg_check_exist_all_vg ( void);


/* return codes */
#define LVM_VG_CFGBACKUP_NO_DIFF                                           100


/* error return codes */
#define LVM_EPARAM                                                          99

#define LVM_ELVM_CHECK_CHARS                                               100
#define LVM_ELVM_FIND_VG_REALLOC                                           101
#define LVM_ELVM_IOP_VERSION_OPEN                                          102
#define LVM_ELVM_LOCK_YET_LOCKED                                           103
#define LVM_ELVM_READ_DEV_MAJOR                                            104
#define LVM_ELVM_READ_DEV_OPEN                                             105
#define LVM_ELVM_READ_DEV_RDEV                                             106
#define LVM_ELVM_READ_DEV_READ                                             107
#define LVM_ELVM_READ_DEV_STAT                                             108
#define LVM_ELVM_TAB_CREATE_LVMTAB                                         109
#define LVM_ELVM_TAB_CREATE_LVMTAB_DIR                                     110
#define LVM_ELVM_TAB_GET_FREE_BLK_DEV_LVM_TAB_VG_CHECK_EXIST               111
#define LVM_ELVM_TAB_GET_FREE_BLK_DEV_NO_DEV                               112
#define LVM_ELVM_TAB_GET_FREE_BLK_DEV_REALLOC                              113
#define LVM_ELVM_TAB_GET_FREE_VG_NUMBER_MALLOC                             114
#define LVM_ELVM_TAB_LV_READ_BY_NAME_LVM_TAB_VG_READ_WITH_PV_AND_LV        115
#define LVM_ELVM_TAB_LV_READ_BY_NAME_LV_GET_INDEX_BY_NAME                  116
#define LVM_ELVM_TAB_READ_FSTAT                                            117
#define LVM_ELVM_TAB_READ_MALLOC                                           118
#define LVM_ELVM_TAB_READ_OPEN                                             119
#define LVM_ELVM_TAB_READ_PV_CHECK_NAME                                    120
#define LVM_ELVM_TAB_READ_READ                                             121
#define LVM_ELVM_TAB_READ_SIZE                                             122
#define LVM_ELVM_TAB_READ_VG_CHECK_NAME                                    123
#define LVM_ELVM_TAB_VG_CHECK_EXIST_ALL_VG_REALLOC                         124
#define LVM_ELVM_TAB_VG_INSERT_REALLOC                                     125
#define LVM_ELVM_TAB_VG_INSERT_VG_EXISTS                                   126
#define LVM_ELVM_TAB_VG_REMOVE_NOT_EXISTS                                  127
#define LVM_ELVM_TAB_WRITE_FCHMOD                                          128
#define LVM_ELVM_TAB_WRITE_OPEN                                            129
#define LVM_ELVM_TAB_WRITE_WRITE                                           130
#define LVM_ELVM_UNLOCK                                                    131
#define LVM_ELV_ACCESS                                                     132
#define LVM_ELV_ALLOCATED_LE                                               133
#define LVM_ELV_ALLOCATION                                                 134
#define LVM_ELV_BADBLOCK                                                   135
#define LVM_ELV_CHECK_NAME_LV_NAME                                         136
#define LVM_ELV_CHECK_NAME_LV_NUM                                          137
#define LVM_ELV_CHECK_NAME_VG_NAME                                         138
#define LVM_ELV_CHECK_STRIPE_SIZE                                          139
#define LVM_ELV_CREATE_MODE_CHMOD                                          140
#define LVM_ELV_CREATE_MODE_MKNOD                                          141
#define LVM_ELV_CREATE_NODE_UNLINK                                         142
#define LVM_ELV_CREATE_REMOVE_OPEN                                         143
#define LVM_ELV_CURRENT_LE                                                 144
#define LVM_ELV_DEV                                                        145
#define LVM_ELV_EXTEND_REDUCE_OPEN                                         146
#define LVM_ELV_LE_REMAP_OPEN                                              147
#define LVM_ELV_LVNAME                                                     148
#define LVM_ELV_MIRROR_COPIES                                              149
#define LVM_ELV_NUMBER                                                     150
#define LVM_ELV_OPEN                                                       151
#define LVM_ELV_READ_ALL_LV_OF_VG_LSEEK                                    152
#define LVM_ELV_READ_ALL_LV_OF_VG_MALLOC                                   153
#define LVM_ELV_READ_ALL_LV_OF_VG_NL                                       154
#define LVM_ELV_READ_ALL_LV_OF_VG_OPEN                                     155
#define LVM_ELV_READ_ALL_LV_OF_VG_READ                                     156
#define LVM_ELV_READ_ALL_LV_OF_VG_VGREAD                                   157
#define LVM_ELV_READ_BYINDEX_LV_READ_ALL_LV_OF_VG                          158
#define LVM_ELV_READ_BYINDEX_VGREAD                                        159
#define LVM_ELV_READ_BYINDEX_VG_NAME                                       160
#define LVM_ELV_READ_LV                                                    161
#define LVM_ELV_READ_LV_NAME                                               162
#define LVM_ELV_READ_LV_READ_ALL_LV_OF_VG                                  163
#define LVM_ELV_READ_VGREAD                                                164
#define LVM_ELV_READ_VG_NAME                                               165
#define LVM_ELV_RECOVERY                                                   166
#define LVM_ELV_RELEASE_LV_NUM                                             167
#define LVM_ELV_SCHEDULE                                                   168
#define LVM_ELV_SETUP_FOR_CREATE_LVM_TAB_GET_FREE_BLK_DEV                  169
#define LVM_ELV_SETUP_FOR_CREATE_LV_MAX                                    170
#define LVM_ELV_SETUP_FOR_CREATE_MALLOC                                    171
#define LVM_ELV_SETUP_FOR_CREATE_PE                                        172
#define LVM_ELV_SETUP_FOR_CREATE_STRIPES                                   173
#define LVM_ELV_SETUP_FOR_CREATE_STRIPESIZE                                174
#define LVM_ELV_SETUP_FOR_EXTEND_LV_INDEX                                  175
#define LVM_ELV_SETUP_FOR_EXTEND_REALLOC                                   176
#define LVM_ELV_SETUP_FOR_EXTEND_STRIPES                                   177
#define LVM_ELV_SETUP_FOR_REDUCE_LV_INDEX                                  178
#define LVM_ELV_SETUP_FOR_REDUCE_MALLOC                                    179
#define LVM_ELV_SHOW_CURRENT_PE_TEXT_LV_INDEX                              180
#define LVM_ELV_SHOW_VG_READ_WITH_PV_AND_LV                                181
#define LVM_ELV_SIZE                                                       182
#define LVM_ELV_STATUS                                                     183
#define LVM_ELV_STATUS_ALL_LV_OF_VG_MALLOC                                 184
#define LVM_ELV_STATUS_BYINDEX_MALLOC                                      185
#define LVM_ELV_STATUS_BYNAME_MALLOC                                       186
#define LVM_ELV_STATUS_INTERNAL_OPEN                                       187
#define LVM_ELV_STATUS_NL                                                  188
#define LVM_ELV_STRIPES                                                    189
#define LVM_ELV_STRIPESIZE                                                 190
#define LVM_ELV_TIMEOUT                                                    191
#define LVM_ELV_VGNAME                                                     192
#define LVM_ELV_WRITE_ALL_LV_OF_VG_LSEEK                                   193
#define LVM_ELV_WRITE_ALL_LV_OF_VG_MALLOC                                  194
#define LVM_ELV_WRITE_ALL_LV_OF_VG_OPEN                                    195
#define LVM_ELV_WRITE_ALL_LV_OF_VG_WRITE                                   196
#define LVM_ELV_WRITE_LSEEK                                                197
#define LVM_ELV_WRITE_OPEN                                                 198
#define LVM_ELV_WRITE_WRITE                                                199
#define LVM_EPE_LOCK                                                       200
#define LVM_EPE_MOVE_LV_LE_REMAP                                           201
#define LVM_EPE_MOVE_PE_LLSEEK_IN                                          202
#define LVM_EPE_MOVE_PE_LLSEEK_OUT                                         203
#define LVM_EPE_MOVE_PE_LOCK                                               204
#define LVM_EPE_MOVE_PE_LV_GET_NAME                                        205
#define LVM_EPE_MOVE_PE_OPEN                                               206
#define LVM_EPE_MOVE_PE_OPEN_IN                                            207
#define LVM_EPE_MOVE_PE_READ_IN                                            208
#define LVM_EPE_MOVE_PE_UNLOCK                                             209
#define LVM_EPE_MOVE_PE_WRITE_OUT                                          210
#define LVM_EPE_MOVE_PV_CHANGE_DEST                                        211
#define LVM_EPE_MOVE_PV_CHANGE_SRC                                         212
#define LVM_EPE_MOVE_PV_PV_WRITE_WITH_PE_DEST                              213
#define LVM_EPE_MOVE_PV_PV_WRITE_WITH_PE_SRC                               214
#define LVM_EPV_CHANGE_ALL_PV_FOR_LV_OF_VG_LV_NUM                          215
#define LVM_EPV_CHANGE_OPEN                                                216
#define LVM_EPV_CHECK_CONSISTENCY_ALL_PV_PE                                217
#define LVM_EPV_CHECK_CONSISTENCY_LVM_ID                                   218
#define LVM_EPV_CHECK_CONSISTENCY_LV_CUR                                   219
#define LVM_EPV_CHECK_CONSISTENCY_MAJOR                                    220
#define LVM_EPV_CHECK_CONSISTENCY_PE_ALLOCATED                             221
#define LVM_EPV_CHECK_CONSISTENCY_PE_SIZE                                  222
#define LVM_EPV_CHECK_CONSISTENCY_PE_STALE                                 223
#define LVM_EPV_CHECK_CONSISTENCY_PE_TOTAL                                 224
#define LVM_EPV_CHECK_CONSISTENCY_PV_ALLOCATABLE                           225
#define LVM_EPV_CHECK_CONSISTENCY_PV_NAME                                  226
#define LVM_EPV_CHECK_CONSISTENCY_PV_SIZE                                  227
#define LVM_EPV_CHECK_CONSISTENCY_PV_STATUS                                228
#define LVM_EPV_CHECK_CONSISTENCY_VG_NAME                                  229
#define LVM_EPV_CHECK_DEV_NAME                                             230
#define LVM_EPV_CHECK_NAME                                                 231
#define LVM_EPV_CHECK_NAME_STAT                                            232
#define LVM_EPV_CHECK_NUMBER_MALLOC                                        233
#define LVM_EPV_CHECK_NUMBER_MAX_NUMBER                                    234
#define LVM_EPV_CHECK_NUMBER_PV_NUMBER                                     235
#define LVM_EPV_CHECK_PART                                                 236
#define LVM_EPV_FIND_ALL_PV_PV_READ                                        237
#define LVM_EPV_FLUSH_OPEN                                                 238
#define LVM_EPV_GET_SIZE_IOCTL                                             239
#define LVM_EPV_GET_SIZE_LLSEEK                                            240
#define LVM_EPV_GET_SIZE_LVM_DIR_CACHE                                     241
#define LVM_EPV_GET_SIZE_NO_EXTENDED                                       242
#define LVM_EPV_GET_SIZE_NO_PRIMARY                                        243
#define LVM_EPV_GET_SIZE_OPEN                                              244
#define LVM_EPV_GET_SIZE_PART                                              245
#define LVM_EPV_GET_SIZE_READ                                              246
#define LVM_EPV_MOVE_PES_ALLOC_STRIPES                                     247
#define LVM_EPV_MOVE_PES_NO_PES                                            248
#define LVM_EPV_MOVE_PES_NO_SPACE                                          249
#define LVM_EPV_MOVE_PES_REALLOC                                           250
#define LVM_EPV_READ_ALL_PE_OF_VG_MALLOC                                   251
#define LVM_EPV_READ_ALL_PE_OF_VG_PV_NUMBER                                252
#define LVM_EPV_READ_ALL_PV_LVM_DIR_CACHE                                  253
#define LVM_EPV_READ_ALL_PV_MALLOC                                         254
#define LVM_EPV_READ_ALL_PV_OF_VG_MALLOC                                   255
#define LVM_EPV_READ_ALL_PV_OF_VG_NP                                       256
#define LVM_EPV_READ_ALL_PV_OF_VG_NP_SORT                                  257
#define LVM_EPV_READ_ALL_PV_OF_VG_PV_NUMBER                                258
#define LVM_EPV_READ_ID_INVALID                                            259
#define LVM_EPV_READ_LVM_STRUCT_VERSION                                    260
#define LVM_EPV_READ_MAJOR                                                 261
#define LVM_EPV_READ_MD_DEVICE                                             262
#define LVM_EPV_READ_NAMELIST_LSEEK                                        263
#define LVM_EPV_READ_NAMELIST_MALLOC                                       264
#define LVM_EPV_READ_NAMELIST_OPEN                                         265
#define LVM_EPV_READ_NAMELIST_READ                                         266
#define LVM_EPV_READ_OPEN                                                  267
#define LVM_EPV_READ_PE_LSEEK                                              268
#define LVM_EPV_READ_PE_MALLOC                                             269
#define LVM_EPV_READ_PE_OPEN                                               270
#define LVM_EPV_READ_PE_READ                                               271
#define LVM_EPV_READ_PE_SIZE                                               272
#define LVM_EPV_READ_PV_EXPORTED                                           273
#define LVM_EPV_READ_PV_FLUSH                                              274
#define LVM_EPV_READ_RDEV                                                  275
#define LVM_EPV_READ_READ                                                  276
#define LVM_EPV_READ_STAT                                                  277
#define LVM_EPV_READ_VG_LSEEK                                              278
#define LVM_EPV_READ_VG_MAJOR                                              279
#define LVM_EPV_READ_VG_OPEN                                               280
#define LVM_EPV_READ_VG_RDEV                                               281
#define LVM_EPV_READ_VG_READ                                               282
#define LVM_EPV_READ_VG_STAT                                               283
#define LVM_EPV_RELEASE_PE_NO_PV                                           284
#define LVM_EPV_RELEASE_PE_REALLOC                                         285
#define LVM_EPV_SHOW_PE_TEXT_MALLOC                                        286
#define LVM_EPV_SHOW_PE_TEXT_REALLOC                                       287
#define LVM_EPV_SHOW_PE_TEXT_VG_READ_WITH_PV_AND_LV                        288
#define LVM_EPV_STATUS_ALL_PV_LVM_DIR_CACHE                                289
#define LVM_EPV_STATUS_ALL_PV_OF_VG_MALLOC                                 290
#define LVM_EPV_STATUS_ALL_PV_OF_VG_NP                                     291
#define LVM_EPV_STATUS_OPEN                                                292
#define LVM_EPV_TIME_CHECK                                                 293
#define LVM_EPV_WRITE_LSEEK                                                294
#define LVM_EPV_WRITE_NAMELIST_LSEEK                                       295
#define LVM_EPV_WRITE_NAMELIST_MALLOC                                      296
#define LVM_EPV_WRITE_NAMELIST_OPEN                                        297
#define LVM_EPV_WRITE_NAMELIST_WRITE                                       298
#define LVM_EPV_WRITE_OPEN                                                 299
#define LVM_EPV_WRITE_PE_LSEEK                                             300
#define LVM_EPV_WRITE_PE_OPEN                                              301
#define LVM_EPV_WRITE_PE_SIZE                                              302
#define LVM_EPV_WRITE_PE_WRITE                                             303
#define LVM_EPV_WRITE_WRITE                                                304
#define LVM_ESIZE                                                          305
#define LVM_ESYSTEM_ID_SET_UNAME                                           306
#define LVM_EVG_CFGBACKUP_FILE_EXISTS                                      307
#define LVM_EVG_CFGBACKUP_MALLOC                                           308
#define LVM_EVG_CFGBACKUP_OPEN                                             309
#define LVM_EVG_CFGBACKUP_READ                                             310
#define LVM_EVG_CFGBACKUP_RENAME                                           311
#define LVM_EVG_CFGBACKUP_TMP_FILE                                         312
#define LVM_EVG_CFGBACKUP_UNLINK                                           313
#define LVM_EVG_CFGBACKUP_VG_CHECK_EXIST                                   314
#define LVM_EVG_CFGBACKUP_VG_READ_WITH_PV_AND_LV                           315
#define LVM_EVG_CFGBACKUP_WRITE                                            316
#define LVM_EVG_CFGRESTORE_FILE_EXISTS                                     317
#define LVM_EVG_CFGRESTORE_LV_CHECK_CONSISTENCY                            318
#define LVM_EVG_CFGRESTORE_MALLOC                                          319
#define LVM_EVG_CFGRESTORE_OPEN                                            320
#define LVM_EVG_CFGRESTORE_PV_CHECK_CONSISTENCY                            321
#define LVM_EVG_CFGRESTORE_READ                                            322
#define LVM_EVG_CFGRESTORE_VG_CHECK_CONSISTENCY                            323
#define LVM_EVG_CFGRESTORE_VG_CHECK_CONSISTENCY_WITH_PV_AND_LV             324
#define LVM_EVG_CHECK_ACTIVE_ALL_VG_COUNT                                  325
#define LVM_EVG_CHECK_ACTIVE_ALL_VG_MALLOC                                 326
#define LVM_EVG_CHECK_ACTIVE_ALL_VG_NAMELIST                               327
#define LVM_EVG_CHECK_CONSISTENCY                                          328
#define LVM_EVG_CHECK_CONSISTENCY_LV_CUR                                   329
#define LVM_EVG_CHECK_CONSISTENCY_MAX_PE_PER_PV                            330
#define LVM_EVG_CHECK_CONSISTENCY_PE_ALLOCATED                             331
#define LVM_EVG_CHECK_CONSISTENCY_PE_TOTAL                                 332
#define LVM_EVG_CHECK_CONSISTENCY_PVG_TOTAL                                333
#define LVM_EVG_CHECK_CONSISTENCY_PV_ACT                                   334
#define LVM_EVG_CHECK_CONSISTENCY_PV_CUR                                   335
#define LVM_EVG_CHECK_CONSISTENCY_SIZE                                     336
#define LVM_EVG_CHECK_CONSISTENCY_VGDA                                     337
#define LVM_EVG_CHECK_CONSISTENCY_VG_ACCESS                                338
#define LVM_EVG_CHECK_CONSISTENCY_VG_NAME                                  339
#define LVM_EVG_CHECK_CONSISTENCY_VG_STATUS                                340
#define LVM_EVG_CHECK_EXIST_PV_COUNT                                       341
#define LVM_EVG_CHECK_NAME                                                 342
#define LVM_EVG_CHECK_ONLINE_ALL_PV                                        343
#define LVM_EVG_CHECK_ONLINE_ALL_PV_MALLOC                                 344
#define LVM_EVG_CHECK_PE_SIZE                                              345
#define LVM_EVG_CREATE_DIR_AND_GROUP_CHMOD_DIR                             346
#define LVM_EVG_CREATE_DIR_AND_GROUP_CHMOD_GROUP                           347
#define LVM_EVG_CREATE_DIR_AND_GROUP_MKDIR                                 348
#define LVM_EVG_CREATE_DIR_AND_GROUP_MKNOD                                 349
#define LVM_EVG_CREATE_REMOVE_OPEN                                         350
#define LVM_EVG_EXTEND_REDUCE_OPEN                                         351
#define LVM_EVG_READ_FROM_PV_CHECK_CONSISTENCY                             352
#define LVM_EVG_READ_FROM_PV_LSEEK                                         353
#define LVM_EVG_READ_FROM_PV_LVM_STRUCT_VERSION                            354
#define LVM_EVG_READ_FROM_PV_OPEN                                          355
#define LVM_EVG_READ_FROM_PV_PV_READ                                       356
#define LVM_EVG_READ_FROM_PV_READ                                          357
#define LVM_EVG_READ_LSEEK                                                 358
#define LVM_EVG_READ_LVM_STRUCT_VERSION                                    359
#define LVM_EVG_READ_OPEN                                                  360
#define LVM_EVG_READ_PV                                                    361
#define LVM_EVG_READ_READ                                                  362
#define LVM_EVG_READ_VG_EXPORTED                                           363
#define LVM_EVG_READ_WITH_PV_AND_LV_LV_ALLOCATED_LE                        364
#define LVM_EVG_READ_WITH_PV_AND_LV_MALLOC                                 365
#define LVM_EVG_READ_WITH_PV_AND_LV_PV_CUR                                 366
#define LVM_EVG_SETUP_FOR_CREATE_MALLOC                                    367
#define LVM_EVG_SETUP_FOR_CREATE_PV_SIZE                                   368
#define LVM_EVG_SETUP_FOR_CREATE_VG_NUMBER                                 369
#define LVM_EVG_SETUP_FOR_EXTEND_MALLOC                                    370
#define LVM_EVG_SETUP_FOR_EXTEND_MAX_PV                                    371
#define LVM_EVG_SETUP_FOR_EXTEND_NO_PV                                     372
#define LVM_EVG_SETUP_FOR_EXTEND_PV_ALLREADY                               373
#define LVM_EVG_SETUP_FOR_EXTEND_PV_CHECK_NAME                             374
#define LVM_EVG_SETUP_FOR_EXTEND_PV_CHECK_NEW                              375
#define LVM_EVG_SETUP_FOR_EXTEND_PV_GET_SIZE                               376
#define LVM_EVG_SETUP_FOR_EXTEND_PV_SIZE                                   377
#define LVM_EVG_SETUP_FOR_EXTEND_PV_SIZE_REL                               378
#define LVM_EVG_SETUP_FOR_MERGE_BLK_DEV                                    379
#define LVM_EVG_SETUP_FOR_MERGE_LV_MAX                                     380
#define LVM_EVG_SETUP_FOR_MERGE_PE_SIZE                                    381
#define LVM_EVG_SETUP_FOR_MERGE_PV_MAX                                     382
#define LVM_EVG_SETUP_FOR_MERGE_VG_CHECK_CONSISTENCY_WITH_PV_AND_LV        383
#define LVM_EVG_SETUP_FOR_REDUCE_LAST_PV                                   384
#define LVM_EVG_SETUP_FOR_REDUCE_LAST_PV_NOT_IN_VG                         385
#define LVM_EVG_SETUP_FOR_REDUCE_LV                                        386
#define LVM_EVG_SETUP_FOR_REDUCE_NO_PV_TO_REDUCE                           387
#define LVM_EVG_SETUP_FOR_REDUCE_PV_INVALID                                388
#define LVM_EVG_SETUP_FOR_REDUCE_REALLOC                                   389
#define LVM_EVG_SETUP_FOR_SPLIT_LV_ON_PV                                   390
#define LVM_EVG_SETUP_FOR_SPLIT_MALLOC                                     391
#define LVM_EVG_SETUP_FOR_SPLIT_PV                                         392
#define LVM_EVG_SETUP_FOR_SPLIT_PV_COUNT                                   393
#define LVM_EVG_SETUP_FOR_SPLIT_VG_NUMBER                                  394
#define LVM_EVG_SET_CLEAR_EXTENDABLE_OPEN                                  395
#define LVM_EVG_STATUS_GET_COUNT_OPEN                                      396
#define LVM_EVG_STATUS_GET_NAMELIST_OPEN                                   397
#define LVM_EVG_STATUS_MALLOC                                              398
#define LVM_EVG_STATUS_OPEN                                                399
#define LVM_EVG_WRITE_LSEEK                                                400
#define LVM_EVG_WRITE_OPEN                                                 401
#define LVM_EVG_WRITE_WRITE                                                402
#define LVM_EPV_READ_PV_CREATE_NAME_FROM_KDEV_T                            403

#endif /* #ifndef _LIBLVM_H_INCLUDE */
