%define nspr_name	nspr
%define nss_name	nss
%define mozldap_name	mozldap

Summary: LDAP Perl module that wraps the Mozilla C SDK
Name: perl-Mozilla-LDAP
Version: 1.5.3
Release: 1%{?dist}
License: GPL/LGPL/MPL
Group: Development/Libraries
URL: http://www.mozilla.org/directory/perldap.html
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
Requires: perl >= 2:5.8.0
BuildRequires: perl >= 2:5.8.0
BuildRequires: %{nspr_name}-devel >= 4.6
BuildRequires: %{nss_name}-devel >= 3.11
BuildRequires: %{mozldap_name}-devel >= 6.0
Source0: ftp://ftp.mozilla.org/pub/mozilla.org/directory/perldap/releases/1.5/perl-mozldap-%{version}.tar.gz
Source1: ftp://ftp.mozilla.org/pub/mozilla.org/directory/perldap/releases/1.5/Makefile.PL.rpm

%description
%{summary}.

%prep
%setup -q -n perl-mozldap-%{version}
# Filter unwanted Provides:
cat << \EOF > %{name}-prov
#!/bin/sh
%{__perl_provides} $* |\
  sed -e '/perl(Mozilla::LDAP::Entry)$/d'
EOF

%define __perl_provides %{_builddir}/perl-mozldap-%{version}/%{name}-prov
chmod +x %{__perl_provides}

# Filter unwanted Requires:
cat << \EOF > %{name}-req
#!/bin/sh
%{__perl_requires} $* |\
  sed -e '/perl(Mozilla::LDAP::Entry)/d'
EOF

%define __perl_requires %{_builddir}/perl-mozldap-%{version}/%{name}-req
chmod +x %{__perl_requires}

%build

LDAPPKGNAME=%{mozldap_name} CFLAGS="$RPM_OPT_FLAGS" perl %{SOURCE1} PREFIX=$RPM_BUILD_ROOT%{_prefix} INSTALLDIRS=vendor < /dev/null
make OPTIMIZE="$RPM_OPT_FLAGS" CFLAGS="$RPM_OPT_FLAGS" 
make test

%install
rm -rf $RPM_BUILD_ROOT
eval `perl '-V:installarchlib'`

%makeinstall

# remove files we don't want to package
rm -f `find $RPM_BUILD_ROOT -type f -name perllocal.pod -o -name .packlist`
find $RPM_BUILD_ROOT -name API.bs -a -size 0 -exec rm -f {} \;

# make sure shared lib is correct mode
find $RPM_BUILD_ROOT -name API.so -exec chmod 755 {} \;


# find and run the correct version of brp-compress
if [ -x /usr/lib/rpm/brp-compress ] ; then
    /usr/lib/rpm/brp-compress
elif [ -x %{_libdir}/rpm/brp-compress ] ; then
    %{_libdir}/rpm/brp-compress
fi

# make sure files refer to %{_prefix} instead of buildroot/%prefix
find $RPM_BUILD_ROOT%{_prefix} -type f -print | \
	sed "s@^$RPM_BUILD_ROOT@@g" > %{name}-%{version}-%{release}-filelist
if [ "$(cat %{name}-%{version}-%{release}-filelist)X" = "X" ] ; then
    echo "ERROR: EMPTY FILE LIST"
    exit 1
fi

%clean
rm -rf $RPM_BUILD_ROOT

%files -f %{name}-%{version}-%{release}-filelist
%defattr(-,root,root,-)
%doc CREDITS ChangeLog README MPL-1.1.txt

%changelog
* Tue Aug  3 2010 Nathan Kinder <nkinder@redhat.com> - 1.5.3-1
- avoid using deprecated functions in the underlying LDAP library.

* Fri Jul 27 2007 Rich Megginson <richm@stanfordalumni.org> - 1.5.2-1
- Fix bugzilla 389731 - crash when a bad URL is passed

* Wed Jun 20 2007 Rich Megginson <richm@stanfordalumni.org> - 1.5.1-1
- all files have been GPL/LGPL/MPL tri-licensed

* Wed Jan 10 2007 Rich Megginson <richm@stanfordalumni.org> - 1.5-9
- remove only perl(Mozilla::LDAP::Entry) from Provides, leave in 
- perl(Mozilla::LDAP::Entry) = 1.5

* Wed Jan 10 2007 Rich Megginson <richm@stanfordalumni.org> - 1.5-8
- add perl_requires filter for the Entry module
- add the MPL-1.1.txt file to the DOCs

* Wed Jan 10 2007 Rich Megginson <richm@stanfordalumni.org> - 1.5-7
- Incorporate comments from Fedora Extras review - https://bugzilla.redhat.com/bugzilla/show_bug.cgi?id=219869
- Remove all Requires except perl - use autogenerated ones
- Remove ExclusiveArch
- Remove files that don't need to be packaged
- add full URL to sources
- set API.so to mode 755

* Tue Oct 17 2006 Rich Megginson <richm@stanfordalumni.org> - 1.5-6
- look for brp-compress first in /usr/lib then _libdir

* Tue Oct 17 2006 Rich Megginson <richm@stanfordalumni.org> - 1.5-5
- there is no TODO file; use custom Makefile.PL

* Mon Oct 16 2006 Rich Megginson <richm@stanfordalumni.org> - 1.5-4
- use pkg-config --variable=xxx instead of --cflags e.g.

* Mon Oct 16 2006 Rich Megginson <richm@stanfordalumni.org> - 1.5-3
- this is not a noarch package

* Mon Oct 16 2006 Rich Megginson <richm@stanfordalumni.org> - 1.5-2
- Use new mozldap6, dirsec versions of nspr, nss

* Tue Feb  7 2006 Rich Megginson <richm@stanfordalumni.org> - 1.5-1
- Based on the perl-LDAP.spec file

