<?php
require_once 'System.php';
require_once 'PHPUnit.php';
require_once 'File/Passwd/Unix.php';


$GLOBALS['tmpfile'] = System::mktemp();
$GLOBALS['users']   = array(
            'bug3348' => array(
                'pass' =>   'wxLaOdcajuKoI',
                'uid' =>    '500',
                'gid' =>    '501',
                'gecos' =>  'having # in gecos',
                'home' =>   '/nonexistent',
                'shell' =>  '/bin/false',
            ),
            'mike' => array(
                'pass' =>   'q4M4mpfilkNnU',
                'uid' =>    '501',
                'gid' =>    '502',
                'gecos' =>  'User1',
                'home' =>   '/home/mike',
                'shell' =>  '/bin/bash'
            ),
            'pete' => array(
                'pass' =>   'dS80VTLQHZ6VM',
                'uid' =>    '502',
                'gid' =>    '503',
                'gecos' =>  'User2',
                'home' =>   '/home/pete',
                'shell' =>  '/bin/sh'
            ),
            'mary' => array(
                'pass' =>   'jHSiqFjaEiKPM',
                'uid' =>    '503',
                'gid' =>    '504',
                'gecos' =>  'User3',
                'home' =>   '/home/mary',
                'shell' =>  '/bin/ksh'
            ),
        );

/**
 * TestCase for File_Passwd_UnixTest class
 * Generated by PHPEdit.XUnit Plugin
 * 
 */
class File_Passwd_UnixTest extends PHPUnit_TestCase{

    var $pwd;
    
    /**
     * Constructor
     * @param string $name The name of the test.
     * @access protected
     */
    function File_Passwd_UnixTest($name){
        $this->PHPUnit_TestCase($name);
    }
    
    /**
     * Called before the test functions will be executed this function is defined in PHPUnit_TestCase and overwritten here
     * @access protected
     */
    function setUp(){
        $this->pwd = &new File_Passwd_Unix();
    }
    
    /**
     * Called after the test functions are executed this function is defined in PHPUnit_TestCase and overwritten here
     * @access protected
     */
    function tearDown(){
        $this->pwd = null;
    }
    
    /**
     * Regression test for File_Passwd_Unix.File_Passwd_Unix method
     * @access public
     */
    function testFile_Passwd_Unix(){
        $this->assertTrue(is_a($this->pwd, 'File_Passwd_Unix'));
    }
    
    /**
     * Regression test for File_Passwd_Unix.save method
     * @access public
     */
    function testsave(){
        $this->pwd->setFile($GLOBALS['tmpfile']);
        $this->pwd->_users = $GLOBALS['users'];
        $e = $this->pwd->save();
        if (PEAR::isError($e)) {
            echo $e->getMessage();
        }
        $this->assertTrue(!PEAR::isError($e));
        $t = file($GLOBALS['tmpfile']);
        $u = file('passwd.unix.txt');
        $this->assertEquals($t,$u);
    }
    
    /**
     * Regression test for File_Passwd_Unix.parse method
     * @access public
     */
    function testparse(){
        $this->pwd->setFile('passwd.unix.txt');
        $this->assertTrue($this->pwd->load());
        $this->assertEquals($this->pwd->_users, $GLOBALS['users']);
    }
    
    /**
     * Regression test for File_Passwd_Unix.setMode method
     * @access public
     */
    function testsetMode(){
        $this->assertTrue($this->pwd->setMode('md5'));
        $this->assertTrue($this->pwd->getMode() === 'md5');
        $this->assertTrue(PEAR::isError($this->pwd->setMode('no')));
        $this->assertTrue($this->pwd->setMode('des'));
        $this->assertTrue($this->pwd->getMode() === 'des');
    }
    
    /**
     * Regression test for File_Passwd_Unix.listModes method
     * @access public
     */
    function testlistModes(){
        $this->assertTrue($this->pwd->listModes() == array('des' => 'des', 'md5' => 'md5'));
    }
    
    /**
     * Regression test for File_Passwd_Unix.getMode method
     * @access public
     */
    function testgetMode(){
        $this->assertTrue($this->pwd->setMode('md5'));
        $this->assertTrue($this->pwd->getMode() === 'md5');
        $this->assertTrue(PEAR::isError($this->pwd->setMode('no')));
        $this->assertTrue($this->pwd->setMode('des'));
        $this->assertTrue($this->pwd->getMode() === 'des');
    }
    
    /**
     * Regression test for File_Passwd_Unix.useMap method
     * @access public
     */
    function testuseMap(){
        $this->assertTrue($this->pwd->useMap());
        $this->assertTrue($this->pwd->useMap(false));
        $this->assertFalse($this->pwd->useMap());
        $this->assertTrue($this->pwd->useMap(true));
    }
    
    /**
     * Regression test for File_Passwd_Unix.setMap method
     * @access public
     */
    function testsetMap(){
        $array = array('uid','gid','gecos','home','shell');
        $new = array('none');
        $this->assertTrue($this->pwd->setMap($new));
        $this->assertTrue($this->pwd->getMap() == $new);
        $this->assertTrue($this->pwd->setMap($array));
        $this->assertTrue($this->pwd->getMap() == $array);
    }
    
    /**
     * Regression test for File_Passwd_Unix.getMap method
     * @access public
     */
    function testgetMap(){
        $array = array('uid','gid','gecos','home','shell');
        $this->assertTrue($array == $this->pwd->getMap());
    }
    
    /**
     * Regression test for File_Passwd_Unix.isShadowed method
     * @access public
     */
    function testisShadowed(){
        $this->assertFalse($this->pwd->isShadowed());
    }
    
    /**
     * Regression test for File_Passwd_Unix.addUser method
     * @access public
     */
    function testaddUser(){
        $this->assertTrue($this->pwd->addUser('add', 'pass'));
        $user = $this->pwd->listUser('add');
        $array = array(
            'pass' => $this->pwd->_genPass('pass', $user['pass']),
            'uid' =>'',
            'gid' =>'',
            'gecos' =>'',
            'home' =>'',
            'shell' =>''
        );
        $this->assertTrue($array == $user);
    }
    
    /**
     * Regression test for File_Passwd_Unix.modUser method
     * @access public
     */
    function testmodUser(){
        $this->assertTrue($this->pwd->addUser('mod', 'pass', array('uid' => 555)));
        $this->assertTrue($this->pwd->modUser('mod', array('uid' => 600)));
        $user = $this->pwd->listUser('mod');
        $this->assertTrue(600 == $user['uid']);
    }
    
    /**
     * Regression test for File_Passwd_Unix.changePasswd method
     * @access public
     */
    function testchangePasswd(){
        $this->pwd->addUser('change', 'pass');
        $this->assertTrue($this->pwd->changePasswd('change', 'new'));
        $this->assertTrue($this->pwd->verifyPasswd('change', 'new'));
    }
    
    /**
     * Regression test for File_Passwd_Unix.verifyPasswd method
     * @access public
     */
    function testverifyPasswd(){
        $this->pwd->addUser('verify', 'pass');
        $this->assertTrue($this->pwd->verifyPasswd('verify', 'pass'));
        $this->assertFalse($this->pwd->verifyPasswd('verify', 'other'));
    }
    
    /**
     * Regression test for File_Passwd_Unix._genPass method
     * @access public
     */
    function test_genPass(){
        $this->pwd->setMode('des');
        $this->assertTrue('12wGUVd8lAOJY' === $this->pwd->_genPass('12','12'));
        $this->pwd->setMode('md5');
        $this->assertTrue('$1$45678901$8Dc8D8vusJXlDQUC7akws/' === $this->pwd->_genPass('12', '$1$456789012'));
    }
    
    function teststaticAuth(){
        $this->assertTrue(true === File_Passwd::staticAuth('Unix', 'passwd.unix.txt', 'mike', 123, 'des'));
        $this->assertTrue(false === File_Passwd::staticAuth('Unix', 'passwd.unix.txt', 'mike', 'abc', 'des'));
        $this->assertFalse((File_Passwd::staticAuth('Unix', 'passwd.unix.txt', 'nonexist', 'asd', 'des')));
    }
}

?>