#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "eggx.h"
#include "cyan4ppm.h"
#include "red6ppm.h"
#include "e_ctrls.h"

// begin{3D 4-th Runge-Kutta} 
typedef struct {
  double f[6];
} vec6;

void rk4fixv6(vec6 f(), 
              double t, double *r, double h)
{
  int i, n;
  double ts, rs[6], k[4][6];
  double c[4] = { 1, 0.5, 0.5, 1 };
  vec6 diff;

  for (n = 0; n < 6; n++) rs[n] = r[n];

  ts = t;
  for (i = 0; i < 4; i++) {
    if (i > 0) {
      for (n = 0; n < 6; n++)rs[n] = r[n] + k[i - 1][n] * c[i];
      ts = t + c[i]*h;
    }
    diff = f(ts, rs);
    for (n = 0; n < 6; n++) k[i][n] = h * diff.f[n];
  }

  for (n = 0; n < 6; n++) {
    for (i = 0; i < 4; i++) {
      r[n] += k[i][n] / c[i] / 6;
    }
  }
}
// end{3D 4th Runge-Kutta}


#define WD 300
#define HT 320
#define SC 150

const double  G = 9.8;
const double  L = 0.5;
const double  X0 = WD/2;
const double  Y0 = 2*HT/3;
int win, win2, cwin, button, type, iscwin;
double r[6] = {0,0,0,0,0,0}, t = 0;
double Th = 60;   // ѽ 
double h = 0.01;  // ƥå    
double Eta = 5;   //  m1/m2
double run = 0, quit = 0, set = 0; // ե饰
float wx = -1, wy = -100;

vec6 mov(double t, double r[6])
{
  vec6 ret;
  double C, S, D, GG;
  double Df = r[0] - r[1];

  C = cos(Df);
  S = sin(Df);
  D = Eta - C*C;
  GG = S*(r[3]-C*r[4])/D*(Eta*r[4]-C*r[3])/D;

  ret.f[0] = (r[3]-C*r[4])/D;
  ret.f[1] = (Eta*r[4]-C*r[3])/D;
  ret.f[3] = -Eta*G*sin(r[0]) + GG;
  ret.f[4] = -G*sin(r[1]) - GG;
  return ret;
}

void draw(){
  double x1, y1, x2, y2;
  rk4fixv6(mov, t, r, h);
  t += h;
  x1 = X0 + sin(r[0])*L*SC;
  y1 = Y0 - cos(r[0])*L*SC;
  x2 = x1 + sin(r[1])*L*SC;
  y2 = y1 - cos(r[1])*L*SC;
  gclr(win);
  putimg24(win, x1-6, y1-6, 12, 12, red6);
  putimg24(win, x2-4, y2-4, 8, 8, cyan4);
  moveto(win, X0, Y0);
  lineto(win, x1, y1);
  lineto(win, x2, y2);
  pset(win2, x2, y2);
  copylayer(win,1,0);
  copylayer(win2,1,0);
}

void init(){
  r[1]=r[2]=r[3]=r[4]=r[5]=0.0;
  r[0]=Th/180*M_PI;
  t = 0; 
  winname(win2, "ph0 = %.1f, h = %.4f", Th, h);
  winname(cwin, "Control Box");
  winname(win, "Double pendulum");
  gclr(win2);
  draw();
  run = 0;
}

int main(int argc, char **argv)
{
  _CTRL ctrls[] = { // 
    {"Initial Angle", &Th, 1, init},
    {"Ratio:m1/m2", &Eta, 1, init},
    {"Step", &h, 0.01, draw},  
    {"_Run", &run, 0, },
    {"_Set", &set, 0, init},
    {"_Quit", &quit, 0, exit}
  };
  init_ctrls(&cwin, 6);   // ν

  gsetinitialbgcolor("white");
  win = gopen(WD, HT);
  window(win, 0,0, WD, HT);
  win2 = gopen(WD, HT);
  window(win2, 0,0, WD, HT);
  newpen(win, 13);
  newpen(win2, 13);
  layer(win,0,1);
  layer(win2, 0, 1);
  gsetnonblock(ENABLE);
  init();
  run = 1;
  while (!quit) {
    // Υ٥Ȥƻ뤷ƾѲȿ
    iscwin = ggetxpress(&type, &button, &wx, &wy);
    display_ctrls(cwin, ctrls, 6, wx, wy, iscwin, type, button);
    ///////////////////////////////////////////
    if (run) draw(); 
    if (set) { run = 0; init(); set = 0;}
    msleep(33);
  } 
  return 0;
}
